/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.spatial.rdf.server.BasicGraphPattern;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.Hint;
import oracle.spatial.rdf.server.HintEngine;
import oracle.spatial.rdf.server.HintEngineAdapter;
import oracle.spatial.rdf.server.HintGenerator;
import oracle.spatial.rdf.server.HintZeroHintGenerator;
import oracle.spatial.rdf.server.PPIRINode;
import oracle.spatial.rdf.server.PPModNode;
import oracle.spatial.rdf.server.PPNode;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLBGP;
import oracle.spatial.rdf.server.SPARQLTriplesBlock;
import oracle.spatial.rdf.server.SPMComponents;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SimplePPSQLTransVisitor;
import oracle.spatial.rdf.server.TriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;

public class SimpleBGP
implements SPARQLBGP {
    private static final String WITH_ALIAS = "BASIC_TRIPLES";
    private static final String PUSHED_BGP_ALIAS = "PBGP";
    private static final String GRAPH_ALIAS = "VG";
    private static final String NO_INDEX_HINT = "NO_INDEX";
    private static final String BLOOM_FILTER_HINT = "PX_JOIN_FILTER";
    private static final String LAT_PP_TAB_FUNC = "mdsys.sdo_rdf.sdo_rdf_pp";
    private BasicGraphPattern bgp;
    private Map<String, String> varset;
    private Set<String> mandatoryVars;
    private Set<String> optionalVars;
    private List<SPARQLTriplesBlock> myTrips;
    private List<SPARQLTriplesBlock> myOptionalTrips;
    private Set<String> variablesToBeJoined;
    private Set<ASTTripleAtom.BindVar> bindVarsToJoin;
    private List<Filter> filters;
    private Map<String, Integer> hint0leadPosMap;
    private SQLGenContext ctx = null;
    private String userHint = "";
    private Set<String> projectVars;
    private Set<String> leftJoinVars;
    private Map<String, String> varAliases;
    private Map<String, String> varIDs;
    private Map<String, String> withMap;
    private Map<String, String> optVarProjCondMap;
    private int id;
    private boolean m_bLog = false;
    private HintGenerator hintG;
    private String sqlHint;
    private Set<String> lexVars;
    private Set<ASTTripleAtom.BindVar> bindVars;
    private Set<String> lobVars;
    private Set<String> objVars;
    private Set<String> subPredGraphVars;
    private Map<Hint.QueryOption, String> queryOptions;
    private String link_tab = "BASIC_TRIPLES";
    private String subjectCol = "START_NODE_ID";
    private String predicateCol = "P_VALUE_ID";
    private String canonObjCol = "CANON_END_NODE_ID";
    private String exactObjCol = "END_NODE_ID";
    private String gidCol = "G_ID";
    private String values_tab;
    private String vname_col = "VALUE_NAME";
    private String vid_col = "VALUE_ID";
    private String vtype_col = "VALUE_TYPE";
    private String prefix_col = "VNAME_PREFIX";
    private String suffix_col = "VNAME_SUFFIX";
    private String litType_col = "LITERAL_TYPE";
    private String langType_col = "LANGUAGE_TYPE";
    private String longLit_col = "LONG_VALUE";
    private String vid_alias = "$RDFVID";
    private String vtype_alias = "$RDFVTYP";
    private String prefix_alias = "$_PREFIX";
    private String suffix_alias = "$_SUFFIX";
    private String litType_alias = "$RDFLTYP";
    private String langType_alias = "$RDFLANG";
    private String longLit_alias = "$RDFCLOB";
    private String term_alias = "$RDFTERM";
    private SPARQLBGP pushedBGP = null;
    private String pushedBGPAlias = "";
    private boolean hasPushedBGP = false;
    private boolean graphQuery = false;
    private ASTTripleAtom activeGraph = null;
    private String graphVar = null;
    private boolean disconnected = false;
    private List<String> optLinkAliasList;
    private boolean distinctCLOB = false;
    private Set<String> needCLOBVars = null;
    private List<List<SPMColDesc>> svpClusterList = null;
    private List<String> svpBestTabNameList = null;
    private Map<String, String> svpColMap = null;
    private Set<String> svpAliasSet = null;
    private int minClusterSize = 1;
    private SPMComponents spmComps = null;
    private List<List<SPMColDesc>> pcnChainList = null;
    private Map<String, String> pcnColMap = null;
    private Set<String> pcnAliasSet = null;
    private List<SPMColDesc> mvpPredList = null;
    private Map<String, String> mvpColMap = null;
    private Set<String> mvpAliasSet = null;
    private Map<String, String> spmValColMap = null;
    private Set<String> auxValueVars = null;
    private Map<String, String> auxVarMappedAliases = null;
    private Set<Integer> spmCoveredTripleIds = null;
    private Set<String> excludedTripleTabs = null;
    private Set<String> excludedValueTabs = null;
    private int localSelectivity = 0;
    private int globalSelectivity = 0;

    private static void log(String string) {
        System.out.print("\n");
        System.out.print(string);
    }

    private static String getNonExistingTermCondition(String string) {
        return " IN (SELECT NULL FROM " + QueryUtils.getLocalNamespaceDollarName(string) + " where rownum < 1)";
    }

    private static String buildOptNonExistingTermJoin(String string, String string2) {
        return string + "(+) = NULL AND NOT EXISTS(SELECT 1 FROM " + QueryUtils.getLocalNamespaceDollarName(string2) + " WHERE ROWNUM < 1)";
    }

    public SimpleBGP(int n, SQLGenContext sQLGenContext) {
        this.id = n;
        this.ctx = sQLGenContext;
        this.bgp = new BasicGraphPattern();
        this.varset = new HashMap<String, String>();
        this.mandatoryVars = new HashSet<String>();
        this.optionalVars = new HashSet<String>();
        this.myTrips = new ArrayList<SPARQLTriplesBlock>();
        this.myOptionalTrips = new ArrayList<SPARQLTriplesBlock>();
        this.variablesToBeJoined = new HashSet<String>();
        this.bindVarsToJoin = new HashSet<ASTTripleAtom.BindVar>();
        this.leftJoinVars = new HashSet<String>();
        this.filters = new ArrayList<Filter>();
        this.hint0leadPosMap = new HashMap<String, Integer>();
        this.projectVars = new HashSet<String>();
        this.varAliases = new HashMap<String, String>();
        this.varIDs = new HashMap<String, String>();
        this.optVarProjCondMap = new HashMap<String, String>();
        this.withMap = new HashMap<String, String>();
        this.queryOptions = new HashMap<Hint.QueryOption, String>();
        this.userHint = null;
        this.hintG = sQLGenContext.useOldHintGenerator ? new HintZeroHintGenerator(sQLGenContext, true) : new HintEngineAdapter(HintEngine.getDefaultInstance(), sQLGenContext);
        this.hintG.setSPARQLBGP(this);
        this.sqlHint = "";
        this.graphQuery = false;
        this.activeGraph = null;
        this.disconnected = false;
        this.optLinkAliasList = null;
        this.lexVars = new HashSet<String>();
        this.bindVars = new HashSet<ASTTripleAtom.BindVar>();
        this.objVars = new HashSet<String>();
        this.subPredGraphVars = new HashSet<String>();
        this.distinctCLOB = false;
        this.needCLOBVars = new HashSet<String>();
        this.spmComps = new SPMComponents();
        this.svpClusterList = null;
        this.svpColMap = null;
        this.svpAliasSet = null;
        this.minClusterSize = 1;
        this.pcnChainList = null;
        this.pcnColMap = null;
        this.pcnAliasSet = null;
        this.spmCoveredTripleIds = null;
        this.mvpPredList = null;
        this.mvpColMap = null;
        this.mvpAliasSet = null;
        this.excludedTripleTabs = null;
        this.spmValColMap = null;
        this.excludedValueTabs = null;
        this.auxValueVars = null;
        this.auxVarMappedAliases = null;
        this.localSelectivity = 0;
        this.globalSelectivity = 0;
        this.values_tab = QueryUtils.getLocalValueDollarName(sQLGenContext.clnPfxForRdfObjName);
        if (sQLGenContext.localValues != null) {
            this.values_tab = sQLGenContext.localValues;
        }
        this.initLinkTab();
    }

    @Override
    public SPARQLBGP shallowClone() throws RDFException {
        SimpleBGP simpleBGP = new SimpleBGP(this.id, this.ctx);
        for (SPARQLTriplesBlock sPARQLTriplesBlock : this.myTrips) {
            simpleBGP.addTriplesBlock(sPARQLTriplesBlock);
        }
        for (SPARQLTriplesBlock sPARQLTriplesBlock : this.myOptionalTrips) {
            simpleBGP.addOptionalTriplesBlock(sPARQLTriplesBlock);
        }
        if (this.hasPushedBGP) {
            SPARQLBGP sPARQLBGP = this.pushedBGP.shallowClone();
            simpleBGP.pushBGP(sPARQLBGP, this.pushedBGPAlias);
        }
        return simpleBGP;
    }

    @Override
    public void setIsGraphQuery(boolean bl) {
        this.graphQuery = bl;
        this.initLinkTab();
    }

    @Override
    public boolean isGraphQuery() {
        return this.graphQuery;
    }

    @Override
    public void setActiveGraph(ASTTripleAtom aSTTripleAtom) {
        this.activeGraph = aSTTripleAtom;
        if (this.activeGraph.type == 0) {
            this.graphVar = this.activeGraph.name.toUpperCase();
        } else if (this.activeGraph.type == 9) {
            ASTTripleAtom.BindVar bindVar = new ASTTripleAtom.BindVar(aSTTripleAtom.bindId, aSTTripleAtom.name);
            this.bindVars.add(bindVar);
            this.graphVar = bindVar.bvName;
        }
    }

    @Override
    public void addUserHint(String string) {
        this.userHint = string;
        this.hintG.setUserHint(string);
    }

    @Override
    public String getJoinHint(String string, String string2) {
        return this.hintG.generateJoinHint(string, string2);
    }

    @Override
    public String getAntiJoinHint() {
        return this.hintG.generateAntiJoinHint();
    }

    @Override
    public String getValueJoinHint(Collection<String> collection, String string) {
        return this.hintG.generateValueJoinHint(collection, string);
    }

    @Override
    public void addTriplesBlock(SPARQLTriplesBlock sPARQLTriplesBlock) {
        this.myTrips.add(sPARQLTriplesBlock);
        this.bgp.addTriplesBlock(sPARQLTriplesBlock, this.ctx);
        this.populateFromTBs();
    }

    @Override
    public void addOptionalTriplesBlock(SPARQLTriplesBlock sPARQLTriplesBlock) {
        this.myOptionalTrips.add(sPARQLTriplesBlock);
        this.bgp.addOptionalTriplesBlock(sPARQLTriplesBlock, this.ctx);
        this.populateFromTBs();
    }

    @Override
    public List<SPARQLTriplesBlock> getTriplesBlocks() {
        ArrayList<SPARQLTriplesBlock> arrayList = new ArrayList<SPARQLTriplesBlock>(this.myTrips.size() + this.myOptionalTrips.size());
        arrayList.addAll(this.myTrips);
        arrayList.addAll(this.myOptionalTrips);
        return arrayList;
    }

    @Override
    public List<SPARQLTriplesBlock> getMandatoryTriplesBlocks() {
        return this.myTrips;
    }

    @Override
    public List<SPARQLTriplesBlock> getOptionalTriplesBlocks() {
        return this.myOptionalTrips;
    }

    @Override
    public int getNumTriples() {
        return this.bgp.numTriples();
    }

    @Override
    public boolean addFilter(Filter filter) {
        boolean bl = true;
        if (this.ctx.allRejectFilter) {
            bl = false;
        } else {
            Set<String> set = filter.getVars();
            for (String string : set) {
                if (!this.shouldRejectVar(string)) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.filters.add(filter);
            }
        }
        return bl;
    }

    @Override
    public Set<String> addProjectVars(Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (this.shouldRejectVar(string)) {
                hashSet.add(string);
                continue;
            }
            this.projectVars.add(string);
        }
        return hashSet;
    }

    @Override
    public boolean addProjectVar(String string) {
        boolean bl = true;
        if (this.shouldRejectVar(string)) {
            bl = false;
        } else {
            this.projectVars.add(string);
        }
        return bl;
    }

    @Override
    public Set<String> getAllLexVars() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.lexVars);
        hashSet.addAll(this.getRequiredLexVars());
        if (this.hasPushedBGP) {
            hashSet.addAll(this.pushedBGP.getAllLexVars());
        }
        return hashSet;
    }

    @Override
    public Set<String> getRequiredLexVars() {
        HashSet<String> hashSet = new HashSet<String>();
        if ((this.ctx.lexJoinFlags & 1) == 1) {
            hashSet.addAll(this.getBGPVars());
            if (this.hasPushedBGP) {
                hashSet.addAll(this.pushedBGP.getRequiredLexVars());
            }
        }
        return hashSet;
    }

    @Override
    public boolean addLexVar(String string) {
        boolean bl = true;
        if (this.shouldRejectVar(string)) {
            bl = false;
        } else {
            this.lexVars.add(string);
        }
        return bl;
    }

    @Override
    public Set<String> addLexVars(Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (!this.shouldRejectVar(string)) {
                this.lexVars.add(string);
                continue;
            }
            hashSet.add(string);
        }
        return hashSet;
    }

    @Override
    public void pushBGP(SPARQLBGP sPARQLBGP, String string) {
        this.hasPushedBGP = true;
        this.pushedBGP = sPARQLBGP;
        this.pushedBGPAlias = string;
    }

    @Override
    public boolean needsParentBGPPushDown() {
        return this.hintG.specifiesBGPPushDown();
    }

    @Override
    public boolean verifyPushedBGP() {
        boolean bl = true;
        if ((this.ctx.contextFlags & 4) == 4 && this.graphVar != null && this.getAllLexVars().contains(this.graphVar)) {
            this.hasPushedBGP = false;
            this.pushedBGP = null;
            this.pushedBGPAlias = "";
            bl = false;
        }
        return bl;
    }

    @Override
    public void setLocalSelectivity() {
        this.setDisconnected();
        this.localSelectivity = this.isSelective(this.bgp.TBList, null) ? 1 : 0;
    }

    @Override
    public int getLocalSelectivity() {
        return this.localSelectivity;
    }

    @Override
    public void setGlobalSelectivity(int n) {
        this.globalSelectivity = QueryUtils.combineSelectivity(this.localSelectivity, n);
    }

    @Override
    public void addJoinVarsForHint(Set<String> set) {
        this.leftJoinVars.addAll(set);
    }

    @Override
    public Set<String> getJoinVarsForHint() {
        return Collections.unmodifiableSet(this.leftJoinVars);
    }

    @Override
    public Set<String> getBindVars() {
        HashSet<String> hashSet = new HashSet<String>();
        for (ASTTripleAtom.BindVar bindVar : this.bindVars) {
            hashSet.add(bindVar.bvName);
        }
        return hashSet;
    }

    @Override
    public void popSPMAuxTabsInfo() {
        this.processSPMInfo();
    }

    @Override
    public Set<String> getSPMAuxValueVars() {
        return this.auxValueVars;
    }

    private boolean useInlineClobSubQ() {
        if (this.ctx.srid > 0L || this.ctx.clobAggSupport || this.ctx.clobExpSupport) {
            return false;
        }
        return this.ctx.inlineClobSubQ;
    }

    @Override
    public void genOuterSelectComponents(Set<String> set, Set<String> set2, Map<String, List<String>> map, String[] stringArray, String[] stringArray2, Map<String, String> map2, Set<String> set3) throws SQLException {
        QueryUtils.genOuterSelectComponents(set, set2, map, stringArray, stringArray2, map2, this.values_tab, set3, this.useInlineClobSubQ(), this.ctx.clnNetworkName);
    }

    private String buildOptClobColRef(String string, String string2, String string3, String string4) throws SQLException {
        if (this.subPredGraphVars.contains(string)) {
            return "TO_CLOB(NULL)";
        }
        if (this.useInlineClobSubQ()) {
            return this.buildSubQForCLOB(string, string2, string3);
        }
        return string4;
    }

    @Override
    public String buildSubQForCLOB(String string, String string2, String string3) throws SQLException {
        return this.buildSubQForCLOB(string, string2, string3, this.getLobVars());
    }

    @Override
    public String buildSubQForCLOB(String string, String string2, String string3, Set<String> set) throws SQLException {
        if (set.contains(string)) {
            return QueryUtils.buildSubQForCLOB(string, string2, string3, this.values_tab, this.ctx.clnNetworkName);
        }
        return "TO_CLOB(NULL)";
    }

    @Override
    public String distinctGraphsQuery(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.ctx.optDistinctGQuery != null && !this.ctx.disableGMVOpt) {
            stringBuffer.append("SELECT " + this.gidCol);
            stringBuffer.append(" AS ").append(string).append(this.vid_alias).append("\n");
            stringBuffer.append("FROM (").append(this.ctx.optDistinctGQuery).append(")");
        } else {
            stringBuffer.append("SELECT DISTINCT ").append(this.gidCol);
            stringBuffer.append(" AS ").append(string).append(this.vid_alias).append("\n");
            stringBuffer.append("FROM ").append(this.link_tab).append("\n");
            stringBuffer.append("WHERE ").append(this.gidCol).append(" IS NOT NULL");
        }
        if (bl) {
            String string2 = "VG." + this.prefix_col + " || " + GRAPH_ALIAS + "." + this.suffix_col;
            String string3 = "R." + string + this.vid_alias;
            String string4 = "VG." + this.vtype_col;
            String string5 = "VG." + this.prefix_col;
            String string6 = "VG." + this.suffix_col;
            String string7 = "VG." + this.litType_col;
            String string8 = "VG." + this.langType_col;
            String string9 = "VG." + this.longLit_col;
            String string10 = this.buildRDFTerm(string2, string4, string7, string8);
            String string11 = "SELECT " + string2 + " AS " + string + ", " + string3 + " AS " + string + this.vid_alias + ", " + string4 + " AS " + string + this.vtype_alias + ", " + string5 + " AS " + string + this.prefix_alias + ", " + string6 + " AS " + string + this.suffix_alias + ", " + string7 + " AS " + string + this.litType_alias + ", " + string8 + " AS " + string + this.langType_alias + ", " + string9 + " AS " + string + this.longLit_alias + "," + string10 + " AS " + string + this.term_alias + "\nFROM (";
            stringBuffer.insert(0, string11);
            stringBuffer.append(") R,\n").append(this.values_tab).append(" ").append(GRAPH_ALIAS).append("\n");
            stringBuffer.append("WHERE R.").append(string).append(this.vid_alias);
            stringBuffer.append("=").append(GRAPH_ALIAS).append(".").append(this.vid_col);
        }
        return stringBuffer.toString();
    }

    @Override
    public List<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public Set<String> getBGPVars() {
        Set<String> set = this.getTriplePatternVars(false);
        if (this.graphQuery && this.activeGraph != null && (this.activeGraph.type == 0 || this.activeGraph.type == 9)) {
            set.add(this.activeGraph.name.toUpperCase());
        }
        return set;
    }

    @Override
    public Set<String> getMandatoryBGPVars() {
        return Collections.unmodifiableSet(this.mandatoryVars);
    }

    @Override
    public Set<String> getOptionalBGPVars() {
        return Collections.unmodifiableSet(this.optionalVars);
    }

    @Override
    public Set<String> getBGPAndPushedVars() {
        Set<String> set = this.getBGPVars();
        if (this.hasPushedBGP) {
            set.addAll(this.pushedBGP.getBGPAndPushedVars());
        }
        return set;
    }

    @Override
    public Set<String> getDefiniteBoundVars() {
        Set<String> set = this.getMandatoryTriplePatternVars(false);
        if (this.graphVar != null && (this.ctx.contextFlags & 4) == 0) {
            set.add(this.graphVar);
        }
        return set;
    }

    @Override
    public Set<String> getDefiniteBoundAndPushedVars() {
        Set<String> set = this.getDefiniteBoundVars();
        if (this.hasPushedBGP) {
            set.addAll(this.pushedBGP.getDefiniteBoundAndPushedVars());
        }
        return set;
    }

    @Override
    public Set<String> getProjectVars() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.projectVars);
        for (String string : this.getAllLexVars()) {
            if (this.shouldRejectVar(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    @Override
    public Set<String> getHintVars() {
        return this.hintG.getHintVars();
    }

    @Override
    public Set<String> getLobVars() {
        if (this.lobVars == null) {
            this.lobVars = QueryUtils.getDistinctVars(this.objVars, this.subPredGraphVars);
        }
        return Collections.unmodifiableSet(this.lobVars);
    }

    @Override
    public Set<String> getVcVars() {
        return Collections.unmodifiableSet(this.subPredGraphVars);
    }

    @Override
    public boolean refsNonExistingTerm() {
        for (int i = 0; i < this.bgp.optionalTbStartIdx; ++i) {
            TriplesBlock triplesBlock = this.bgp.TBList.get(i);
            if (triplesBlock.getSubject().exists() && triplesBlock.getPredicate().exists() && triplesBlock.getObject().exists()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toSQL() throws RDFException {
        if (!this.ctx.disableLocalLexFilterOpt) {
            this.clearLexVarsFromFilters();
        }
        this.popVarsToJoin();
        this.extractVarAliases();
        this.updateVarAliasesForAuxValues();
        this.addAutoOptimizerHints();
        this.hintG.setSPMInfo(this.excludedTripleTabs, this.excludedValueTabs, this.svpAliasSet, this.mvpAliasSet, this.pcnAliasSet);
        this.sqlHint = this.hintG.generateHint();
        if (this.ctx.useBloomFilter) {
            int n = 0;
            boolean bl = false;
            for (TriplesBlock object2 : this.bgp.TBList) {
                if (object2.getPredicate().getName().equalsIgnoreCase("http://www.w3.org/2002/07/owl#sameAs")) {
                    if (!bl) {
                        this.sqlHint = this.sqlHint.length() == 0 ? "/*+ " : this.sqlHint.replace("*/", "");
                    }
                    bl = true;
                    this.sqlHint = this.sqlHint.concat("NO_INDEX(T" + n + ") ");
                    this.sqlHint = this.sqlHint.concat("PX_JOIN_FILTER(T" + n + ") ");
                }
                ++n;
            }
            if (bl) {
                this.sqlHint = this.sqlHint.concat("*/ ");
            }
        }
        this.queryOptions = this.hintG.getQueryOptions();
        this.initLinkTab();
        if (!this.queryOptions.containsKey((Object)Hint.QueryOption.NO_OPT_TRANS_FOR_LEADING)) {
            this.hint0leadPosMap = this.hintG.getTransOrderMap();
        }
        this.genOptGIDJoinList();
        this.extractVarIDs();
        if (this.ctx.startPPOpt) {
            this.optimizePPStartEndNodes();
        }
        List<Filter> list = this.getSecondaryFilters();
        List<String[]> list2 = this.getAncillaryOps();
        String string = this.buildWhere();
        String string2 = this.buildWithClause();
        String string3 = "";
        try {
            string3 = this.buildSelect(list.size() > 0, this.isGraphQuery() && this.getNumTriples() == 0 && (this.ctx.optDistinctGQuery == null || this.ctx.disableGMVOpt), false, list2);
        }
        catch (SQLException string32) {
            throw new RDFException(string32.getMessage(), string32);
        }
        String string4 = this.buildFrom();
        String string5 = string2 + string3 + "\n" + string4 + "\n" + (String)string;
        String string6 = this.applyFilters(string5, this.getBGPAndPushedVars(), this.getProjectVars(), this.getAllLexVars(), this.getBGPVars());
        String string7 = "";
        if (this.isGraphQuery() && this.getNumTriples() == 0 && this.graphVar == null) {
            string7 = " AND ROWNUM < 2";
        }
        string5 = string5 + string6 + string7;
        if (this.distinctCLOB) {
            try {
                string5 = this.wrapForClobs(string5);
            }
            catch (SQLException sQLException) {
                throw new RDFException(sQLException.getMessage(), sQLException);
            }
        }
        if (list.size() > 0) {
            string5 = this.wrapForSecondaryFilters(list, string5);
        }
        return string5;
    }

    private void clearLexVarsFromFilters() {
        for (Filter filter : this.filters) {
            if (filter.containsExists()) continue;
            filter.clearLexVars();
        }
    }

    private List<Filter> getSecondaryFilters() throws RDFException {
        ArrayList<Filter> arrayList = new ArrayList<Filter>();
        for (Filter filter : this.filters) {
            Filter filter2 = filter.extractSecondaryFilter();
            if (filter2 == null) continue;
            arrayList.add(filter2);
        }
        return arrayList;
    }

    private List<String[]> getAncillaryOps() throws RDFException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (Filter filter : this.filters) {
            arrayList.addAll(filter.extractAncInfoForPrim());
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isDisconnected() {
        TriplesBlock triplesBlock = null;
        for (TriplesBlock object2 : this.bgp.TBList) {
            if (!object2.getSubject().isVariable() && !object2.getSubject().isBindVariable() && !object2.getPredicate().isVariable() && !object2.getPredicate().isBindVariable() && !object2.getObject().isVariable() && !object2.getObject().isBindVariable()) continue;
            triplesBlock = object2;
            break;
        }
        if (triplesBlock == null) {
            return false;
        }
        HashSet hashSet = new HashSet();
        Stack<TriplesBlock> stack = new Stack<TriplesBlock>();
        HashSet<TriplesBlock> hashSet2 = new HashSet<TriplesBlock>();
        TriplesBlock triplesBlock2 = null;
        Object var6_7 = null;
        Object var7_8 = null;
        stack.push(triplesBlock);
        hashSet2.add(triplesBlock);
        while (!stack.isEmpty()) {
            triplesBlock2 = (TriplesBlock)stack.pop();
            for (TriplesBlock.Element element : new TriplesBlock.Element[]{triplesBlock2.getSubject(), triplesBlock2.getPredicate(), triplesBlock2.getObject()}) {
                String string = element.getName();
                if (element.isVariable() || element.isBindVariable()) {
                    hashSet.add(string);
                }
                for (TriplesBlock triplesBlock3 : this.bgp.TBList) {
                    if ((!triplesBlock3.getSubject().isVariable() && !triplesBlock3.getSubject().isBindVariable() && triplesBlock3.getSubject().getCanonicalID() == null || !triplesBlock3.getSubject().getName().equals(string)) && (!triplesBlock3.getPredicate().isVariable() && !triplesBlock3.getPredicate().isBindVariable() || !triplesBlock3.getPredicate().getName().equals(string)) && (!triplesBlock3.getObject().isVariable() && !triplesBlock3.getObject().isBindVariable() && triplesBlock3.getObject().getCanonicalID() == null || !triplesBlock3.getObject().getName().equals(string)) || hashSet2.contains(triplesBlock3)) continue;
                    hashSet2.add(triplesBlock3);
                    stack.push(triplesBlock3);
                }
            }
        }
        TriplesBlock.Element[] elementArray = this.getTriplePatternVars(true);
        for (String string : elementArray) {
            void var10_16;
            if (this.isBindVar(string)) {
                String string2 = this.getBindVar(string).getBVStr();
            }
            if (hashSet.contains(var10_16)) continue;
            return true;
        }
        return false;
    }

    private void setDisconnected() {
        this.disconnected = this.isDisconnected();
    }

    private boolean shouldRejectVar(String string) {
        boolean bl = false;
        if ((this.ctx.contextFlags & 4) > 0 && !this.getDefiniteBoundVars().contains(string) && this.getBGPVars().contains(string)) {
            bl = true;
        }
        return bl;
    }

    private void initLinkTab() {
        String string = "(" + this.ctx.defaultGraph + ")";
        if (this.graphQuery) {
            string = "(" + this.ctx.namedGraphs + ")";
        }
        if (this.ctx.vmViewName != null) {
            this.link_tab = this.ctx.vmDefault;
            if (this.graphQuery) {
                this.link_tab = this.ctx.vmNamed;
            }
        } else if (this.queryOptions.containsKey((Object)Hint.QueryOption.USE_WITH)) {
            this.link_tab = WITH_ALIAS;
            this.withMap.put(this.link_tab, string);
        } else {
            this.link_tab = string;
        }
    }

    private void genOptGIDJoinList() {
        this.optLinkAliasList = new ArrayList<String>(this.bgp.TBList.size());
        boolean bl = false;
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        if (!this.hint0leadPosMap.isEmpty()) {
            for (Map.Entry<String, Integer> entry : this.hint0leadPosMap.entrySet()) {
                if (!treeMap.containsKey(entry.getValue())) {
                    if (!this.isValidTabAlias(entry.getKey().toUpperCase())) continue;
                    treeMap.put(entry.getValue(), entry.getKey().toUpperCase());
                    continue;
                }
                bl = true;
                break;
            }
        }
        if (!bl && !this.hint0leadPosMap.isEmpty() && (this.ctx.ngJoinFlags & 4) == 0) {
            for (Map.Entry<String, Integer> entry : treeMap.entrySet()) {
                this.optLinkAliasList.add((String)((Object)entry.getValue()));
            }
        }
        for (int i = 0; i < this.bgp.TBList.size(); ++i) {
            if (this.optLinkAliasList.contains("T" + i)) continue;
            this.optLinkAliasList.add("T" + i);
        }
    }

    private boolean isValidTabAlias(String string) {
        try {
            if (!string.startsWith("T")) {
                return false;
            }
            int n = Integer.parseInt(string.substring(1));
            if (n < 0 || n >= this.bgp.TBList.size()) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private boolean wantGIDCoalesce() {
        boolean bl = (this.ctx.ngJoinFlags & 1) == 0 && (!this.disconnected || (this.ctx.ngJoinFlags & 2) > 0);
        return bl;
    }

    private String buildGidExpr(boolean bl) {
        Object object;
        String string = "##";
        String string2 = null;
        if (this.graphVar != null) {
            string = this.graphVar;
        } else if (this.isGraphQuery() && this.activeGraph.type == 1) {
            string2 = this.ctx.URImap.get(this.activeGraph.name);
        } else if (this.isGraphQuery() && this.activeGraph.type == 9) {
            object = this.getBindVar(string);
            string2 = ((ASTTripleAtom.BindVar)object).getIdCol();
        } else if (this.isGraphQuery() && this.activeGraph.type == 10) {
            string2 = this.activeGraph.name + "." + this.vid_col;
        }
        object = new HashSet();
        if (this.hasPushedBGP) {
            object = this.pushedBGP.getBGPAndPushedVars();
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        n += this.bgp.TBList.size();
        if (object.contains(string)) {
            ++n;
        }
        if ((this.ctx.contextFlags & 4) > 0) {
            ++n;
        }
        if (((this.ctx.contextFlags & 4) > 0 || this.wantGIDCoalesce() && bl) && n > 1) {
            stringBuffer.append("COALESCE(");
            for (int i = 0; i < this.bgp.TBList.size(); ++i) {
                QueryUtils.appendToList(stringBuffer, this.getSPMOptimizedCol("T" + i + "." + this.gidCol), ", ", "COALESCE(");
            }
            if (object.contains(string)) {
                QueryUtils.appendToList(stringBuffer, "PBGP." + string + this.vid_alias, ", ", "COALESCE(");
            } else if (string2 != null) {
                QueryUtils.appendToList(stringBuffer, string2, ", ", "COALESCE(");
            }
            if ((this.ctx.contextFlags & 4) > 0) {
                if (bl) {
                    QueryUtils.appendToList(stringBuffer, "0", ", ", "COALESCE(");
                } else {
                    QueryUtils.appendToList(stringBuffer, "NULL", ", ", "COALESCE(");
                }
            }
            stringBuffer.append(")");
        } else if (this.optLinkAliasList != null && !this.optLinkAliasList.isEmpty()) {
            stringBuffer.append(this.getSPMOptimizedCol(this.optLinkAliasList.get(0) + "." + this.gidCol));
        } else {
            stringBuffer.append(this.getSPMOptimizedCol("T0." + this.gidCol));
        }
        return stringBuffer.toString();
    }

    private String buildGidNVL(String string, String string2) {
        String string3 = this.getSPMOptimizedCol(string);
        if ((this.ctx.contextFlags & 4) > 0) {
            string3 = "NVL(" + string3 + "," + string2 + ")";
        }
        return string3;
    }

    private Set<String> getTriplePatternVars(boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.varset.keySet()) {
            if (!bl && string.startsWith("PP$S$")) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private Set<String> getMandatoryTriplePatternVars(boolean bl) {
        Set<String> set = this.getOptionalBGPVars();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.varset.keySet()) {
            if (!bl && string.startsWith("PP$S$") || set.contains(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public String buildWithClause() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.withMap != null && !this.withMap.isEmpty()) {
            stringBuffer.append("WITH ");
            boolean bl = false;
            for (Map.Entry<String, String> entry : this.withMap.entrySet()) {
                if (bl) {
                    stringBuffer.append(",\n");
                }
                bl = true;
                stringBuffer.append(entry.getKey()).append(" AS (").append(entry.getValue()).append(")");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String wrapForClobs(String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("SELECT R.*");
        String string2 = "";
        for (String string3 : this.needCLOBVars) {
            string2 = this.lexVars.contains(string3) ? "TO_CLOB(NULL)" : this.buildSubQForCLOB(string3, "R." + string3 + this.vid_alias, "R." + string3 + this.prefix_alias);
            QueryUtils.appendToList(stringBuffer, string2 + " AS " + string3 + this.longLit_alias, "\n, ", "");
        }
        return stringBuffer + "\nFROM (" + string + ") R";
    }

    private String wrapForSecondaryFilters(List<Filter> list, String string) throws RDFException {
        HashSet<String> hashSet = new HashSet<String>();
        for (Filter object2 : list) {
            hashSet.addAll(object2.getSecondaryJoinVars());
        }
        HashMap hashMap = new HashMap();
        Map<String, String> map = Collections.emptyMap();
        int n = 0;
        for (String string2 : hashSet) {
            hashMap.put(string2, "V" + n);
            ++n;
        }
        for (String string3 : this.getBGPAndPushedVars()) {
            if (hashMap.containsKey(string3)) continue;
            hashMap.put(string3, "R." + string3);
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("SELECT R.*\n");
        stringBuffer.append("FROM\n");
        stringBuffer.append("(").append(string).append(") R\n");
        for (String string4 : hashSet) {
            stringBuffer.append(", ").append(this.values_tab).append(" ").append((String)hashMap.get(string4)).append("\n");
        }
        stringBuffer.append("WHERE (1=1)");
        for (String string5 : hashSet) {
            stringBuffer.append("\nAND ").append("R." + string5 + "$RDFVID = " + (String)hashMap.get(string5) + ".VALUE_ID");
        }
        for (Filter filter : list) {
            filter.setSpmValueColMapping(this.spmValColMap);
            stringBuffer.append("\nAND ").append(filter.toSQL(hashMap, map, this.ctx.funcTypeMap, this.ctx.funcHandMap));
        }
        return stringBuffer.toString();
    }

    private String buildSelect(boolean bl, boolean bl2, boolean bl3, List<String[]> list) throws SQLException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("");
        HashSet<String> hashSet = new HashSet<String>();
        if (this.hasPushedBGP) {
            hashSet.addAll(this.pushedBGP.getBGPAndPushedVars());
        }
        for (String string : this.getBGPAndPushedVars()) {
            QueryUtils.appendToList(stringBuffer, this.buildSelectListForVar(string, hashSet, bl2, bl3), ",\n", "");
        }
        if ((this.ctx.contextFlags & 1) > 0) {
            if (this.bgp.TBList.size() > 0) {
                QueryUtils.appendToList(stringBuffer, " T0.CTXT2 as T0_CTXT2 ", ",\n", "");
            } else {
                QueryUtils.appendToList(stringBuffer, " NULL as T0_CTXT2 ", ",\n", "");
            }
        } else if ((this.ctx.contextFlags & 2) > 0) {
            object = new StringBuffer();
            if (this.bgp.TBList.size() > 1) {
                ((StringBuffer)object).append(" COALESCE(T0.CTXT2");
                for (int i = 1; i < this.bgp.TBList.size(); ++i) {
                    ((StringBuffer)object).append(", T" + i + ".CTXT2");
                }
                ((StringBuffer)object).append(") ");
            } else if (this.bgp.TBList.size() == 1) {
                ((StringBuffer)object).append(" T0.CTXT2 ");
            } else {
                ((StringBuffer)object).append(" NULL ");
            }
            QueryUtils.appendToList(stringBuffer, ((StringBuffer)object).toString() + " as T0_CTXT2 ", ",\n", "");
        }
        for (String[] stringArray : list) {
            QueryUtils.appendToList(stringBuffer, stringArray[0] + "(" + stringArray[1] + ") as " + "ANC$" + stringArray[1], ",\n", "");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append(" 1\n");
        }
        if (this.ctx.topDownOpt) {
            if (this.bgp.TBList.size() > 0) {
                QueryUtils.appendToList(stringBuffer, this.getSPMOptimizedCol("T0." + this.subjectCol) + " AS BGP$" + this.getId(), ",\n", "");
            } else {
                QueryUtils.appendToList(stringBuffer, "1 AS BGP$" + this.getId(), ",\n", "");
            }
        }
        object = "";
        if (bl) {
            object = "/*+ NO_MERGE */ ";
        }
        String string = "";
        if (bl2) {
            string = "DISTINCT ";
        }
        return "SELECT " + (String)object + string + this.sqlHint + stringBuffer.toString();
    }

    private String buildVTYPCaseForVar(String string) {
        return QueryUtils.buildVTYPCaseForVar(string);
    }

    private String wrapForOptProjCondition(String string, String string2) {
        if (string != null) {
            return "(CASE WHEN (" + string + ") THEN " + string2 + " ELSE NULL END)";
        }
        return string2;
    }

    private String buildSelectListForVar(String string, Set<String> set, boolean bl, boolean bl2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = this.varAliases.get(string);
        String string3 = "PBGP." + string;
        String string4 = "R." + string;
        String string5 = this.optVarProjCondMap.get(string);
        String string6 = " (CASE WHEN " + this.getSPMOptimizedValCol(string2 + "." + "VALUE_TYPE") + " IS NULL THEN NULL WHEN " + this.getSPMOptimizedValCol(string2 + "." + "VALUE_TYPE") + " IN ('UR','" + "URI" + "') THEN '" + "URI" + "'\n WHEN " + this.getSPMOptimizedValCol(string2 + "." + "VALUE_TYPE") + " IN ('BN', '" + "BLN" + "') THEN '" + "BLN" + "'\n ELSE '" + "LIT" + "'\nEND) ";
        int n = 8;
        if (bl || bl2) {
            n = 7;
        }
        String[][] stringArray = new String[n][2];
        String string7 = "";
        if (bl2) {
            stringArray[0][0] = string4;
            stringArray[1][0] = string4 + this.vtype_alias;
            stringArray[2][0] = string4 + this.vid_alias;
            stringArray[3][0] = string4 + this.prefix_alias;
            stringArray[4][0] = string4 + this.suffix_alias;
            stringArray[5][0] = string4 + this.litType_alias;
            stringArray[6][0] = string4 + this.langType_alias;
            string7 = string4;
        } else if (string2 != null) {
            stringArray[0][0] = this.getSPMOptimizedValCol(string2 + "." + this.prefix_col) + " || " + this.getSPMOptimizedValCol(string2 + "." + this.suffix_col);
            stringArray[1][0] = string6;
            stringArray[2][0] = this.getSPMOptimizedCol(this.getLocalVIDCol(string, set));
            stringArray[3][0] = this.getSPMOptimizedValCol(string2 + "." + this.prefix_col);
            stringArray[4][0] = this.getSPMOptimizedValCol(string2 + "." + this.suffix_col);
            stringArray[5][0] = this.getSPMOptimizedValCol(string2 + "." + this.litType_col);
            stringArray[6][0] = this.getSPMOptimizedValCol(string2 + "." + this.langType_col);
            if (!bl) {
                stringArray[7][0] = this.buildOptClobColRef(string, stringArray[2][0], stringArray[3][0], this.getSPMOptimizedValCol(string2 + "." + this.longLit_col));
            }
            string7 = QueryUtils.genVNameSubstr(this.getSPMOptimizedValCol(string2 + "." + this.prefix_col) + " || " + this.getSPMOptimizedValCol(string2 + "." + this.suffix_col), this.getSPMOptimizedValCol(string2 + "." + this.longLit_col), this.getSPMOptimizedValCol(string2 + "." + this.langType_col), this.getSPMOptimizedValCol(string2 + "." + this.litType_col));
        } else {
            stringArray[0][0] = string3;
            stringArray[1][0] = string3 + this.vtype_alias;
            stringArray[2][0] = this.getSPMOptimizedCol(this.getLocalVIDCol(string, set));
            stringArray[3][0] = string3 + this.prefix_alias;
            stringArray[4][0] = string3 + this.suffix_alias;
            stringArray[5][0] = string3 + this.litType_alias;
            stringArray[6][0] = string3 + this.langType_alias;
            if (!bl) {
                stringArray[7][0] = string3 + this.longLit_alias;
            }
            string7 = QueryUtils.genVNameSubstr(string3, string3 + this.longLit_alias, string3 + this.langType_alias, string3 + this.litType_alias);
        }
        stringArray[0][1] = "";
        stringArray[1][1] = this.vtype_alias;
        stringArray[2][1] = this.vid_alias;
        stringArray[3][1] = this.prefix_alias;
        stringArray[4][1] = this.suffix_alias;
        stringArray[5][1] = this.litType_alias;
        stringArray[6][1] = this.langType_alias;
        if (!bl && !bl2) {
            stringArray[7][1] = this.longLit_alias;
        }
        if (this.getProjectVars().contains(string)) {
            if (bl) {
                this.distinctCLOB = true;
                this.needCLOBVars.add(string);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                QueryUtils.appendToList(stringBuffer, this.wrapForOptProjCondition(string5, stringArray[i][0]) + " AS " + string + stringArray[i][1], ", ", "");
            }
            if (this.getAllLexVars().contains(string)) {
                if (string2 != null) {
                    if (bl2) {
                        QueryUtils.appendToList(stringBuffer, this.wrapForOptProjCondition(string5, string4 + this.term_alias) + " AS " + string + this.term_alias, ", ", "");
                    } else {
                        String string8 = this.buildRDFTerm(string7, stringArray[1][0], stringArray[5][0], stringArray[6][0]);
                        QueryUtils.appendToList(stringBuffer, this.wrapForOptProjCondition(string5, string8) + " AS " + string + this.term_alias, ", ", "");
                    }
                } else {
                    QueryUtils.appendToList(stringBuffer, this.wrapForOptProjCondition(string5, string3 + this.term_alias) + " AS " + string + this.term_alias, ", ", "");
                }
            }
        } else {
            QueryUtils.appendToList(stringBuffer, this.wrapForOptProjCondition(string5, stringArray[2][0]) + " AS " + string + stringArray[2][1], ", ", "");
        }
        return stringBuffer.toString();
    }

    private String buildRDFTermForVar(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        if (this.isBindVar(string)) {
            ASTTripleAtom.BindVar bindVar = this.getBindVar(string);
            String string7 = bindVar.getTermCol();
            string2 = string7 + "." + this.vname_col;
            string3 = string7 + "." + this.vtype_col;
            string4 = string7 + "." + this.litType_col;
            string5 = string7 + "." + this.langType_col;
            string6 = string7 + "." + this.longLit_col;
        } else {
            String string8 = this.varAliases.get(string);
            string2 = this.getSPMOptimizedValCol(string8 + "." + this.prefix_col) + " || " + this.getSPMOptimizedValCol(string8 + "." + this.suffix_col);
            string3 = this.getSPMOptimizedValCol(string8 + "." + this.vtype_col);
            string4 = this.getSPMOptimizedValCol(string8 + "." + this.litType_col);
            string5 = this.getSPMOptimizedValCol(string8 + "." + this.langType_col);
            string6 = this.getSPMOptimizedValCol(string8 + "." + this.longLit_col);
        }
        string2 = QueryUtils.genVNameSubstr(string2, string6, string5, string4);
        return this.buildRDFTerm(string2, string3, string4, string5);
    }

    private String buildRDFTerm(String string, String string2, String string3, String string4) {
        String string5 = "SEM_APIS.COMPOSE_RDF_TERM(" + string + "," + string2 + "," + string3 + "," + string4 + ")";
        return string5;
    }

    private String getLocalVIDCol(String string, Set<String> set) {
        String string2 = "";
        if (this.isBindVar(string)) {
            ASTTripleAtom.BindVar bindVar = this.getBindVar(string);
            string2 = bindVar.getIdCol();
        } else if (this.graphQuery && this.graphVar != null && this.graphVar.equalsIgnoreCase(string)) {
            string2 = this.buildGidExpr(false);
        } else if (this.varset.containsKey(string)) {
            if (this.varset.get(string).equalsIgnoreCase("Subject")) {
                string2 = this.extractFirstOutgoingEdge(string) + "." + this.subjectCol;
            } else if (this.varset.get(string).equalsIgnoreCase("Predicate")) {
                string2 = this.extractFirstTableAlias(string) + "." + this.predicateCol;
            } else {
                String string3 = this.canonObjCol;
                if (this.ctx.useExactValue) {
                    string3 = this.exactObjCol;
                }
                string2 = this.extractFirstIncomingEdge(string) + "." + string3;
            }
        } else if (set.contains(string)) {
            string2 = "PBGP." + string + this.vid_alias;
        }
        return string2;
    }

    private String buildFrom() throws RDFException {
        int n;
        Object object;
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.hasPushedBGP) {
            QueryUtils.appendToList(stringBuffer, this.pushedBGPAlias + " " + PUSHED_BGP_ALIAS, ", ", "");
        }
        TreeSet<LateralPPDesc> treeSet = new TreeSet<LateralPPDesc>();
        int n2 = 0;
        PPNode pPNode = null;
        String string = "";
        String string2 = "";
        for (TriplesBlock object22 : this.bgp.TBList) {
            if (object22.hasPropertyPath()) {
                boolean bl = false;
                object = null;
                if ((this.localSelectivity == 1 || this.ctx.forceLatPPOpt) && this.lateralPPEnabled()) {
                    object = new LateralPPDesc[1];
                    bl = this.isLateralOptimizable(object22, n2, (LateralPPDesc[])object);
                }
                if (bl && !this.createsLateralCycle(object[0], treeSet)) {
                    treeSet.add(object[0]);
                } else {
                    SimplePPSQLTransVisitor simplePPSQLTransVisitor = new SimplePPSQLTransVisitor(this.activeGraph, this.ctx, this.queryOptions, this.link_tab);
                    pPNode = object22.getPath();
                    string = pPNode.accept(simplePPSQLTransVisitor);
                    string2 = simplePPSQLTransVisitor.getWITHClauses();
                    string = string2 + "\n" + string;
                    QueryUtils.appendToList(stringBuffer, "\n(/*PP[*/" + string + "/*]PP*/) T" + n2, ", ", "");
                }
            } else if (!this.excludedTripleTabs.contains("T" + n2)) {
                QueryUtils.appendToList(stringBuffer, this.link_tab + " T" + n2, ", ", "");
            }
            ++n2;
        }
        for (n = 0; n < this.svpClusterList.size(); ++n) {
            String string3;
            Object var8_11 = null;
            try {
                string3 = this.ctx.clnNetworkOwner + "." + QueryUtils.enquoteNameSQLName(this.svpBestTabNameList.get(n));
            }
            catch (SQLException sQLException) {
                throw new RDFException(sQLException.getMessage(), sQLException);
            }
            QueryUtils.appendToList(stringBuffer, this.addSPMTabDatasetConstraints(string3) + " SVP" + n, ",\n", "");
            this.ctx.spmUsedInQuery = true;
        }
        for (n = 0; n < this.pcnChainList.size(); ++n) {
            String string4;
            Object var8_14 = null;
            try {
                String string5 = this.getPcnTabNameForChainId(n);
                string4 = this.ctx.clnNetworkOwner + "." + QueryUtils.enquoteNameSQLName(string5);
            }
            catch (SQLException sQLException) {
                throw new RDFException(sQLException.getMessage(), sQLException);
            }
            QueryUtils.appendToList(stringBuffer, this.addSPMTabDatasetConstraints(string4) + " PCN" + n, ",\n", "");
            this.ctx.spmUsedInQuery = true;
        }
        n = 0;
        for (SPMColDesc sPMColDesc : this.mvpPredList) {
            object = null;
            try {
                object = QueryUtils.enquoteNameSQLName(this.ctx.clnNetworkOwner) + "." + QueryUtils.enquoteNameSQLName(this.ctx.qualifiedMvpTabPrefix + sPMColDesc.predId);
            }
            catch (SQLException sQLException) {
                throw new RDFException(sQLException.getMessage(), sQLException);
            }
            QueryUtils.appendToList(stringBuffer, this.addSPMTabDatasetConstraints((String)object) + " MVP" + n, ",\n", "");
            ++n;
            this.ctx.spmUsedInQuery = true;
        }
        try {
            this.addLateralPropertyPaths(stringBuffer, treeSet);
        }
        catch (SQLException sQLException) {
            throw new RDFException(sQLException.getMessage(), sQLException);
        }
        if (this.isGraphQuery() && this.bgp.TBList.size() == 0) {
            if (this.ctx.optDistinctGQuery == null || this.ctx.disableGMVOpt) {
                QueryUtils.appendToList(stringBuffer, this.link_tab + " T0", ", ", "");
            } else {
                QueryUtils.appendToList(stringBuffer, "(" + this.ctx.optDistinctGQuery + ") T0", ", ", "");
            }
        }
        for (String string6 : this.variablesToBeJoined) {
            if (this.isBindVar(string6) || this.excludedValueTabs.contains(object = this.varAliases.get(string6))) continue;
            QueryUtils.appendToList(stringBuffer, this.values_tab + " " + this.varAliases.get(string6), ", ", "");
        }
        for (ASTTripleAtom.BindVar bindVar : this.bindVarsToJoin) {
            QueryUtils.appendToList(stringBuffer, bindVar.getAlias() + " " + bindVar.getAlias(), ", ", "");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("DUAL");
        }
        return "FROM " + stringBuffer.toString();
    }

    private void addLateralPropertyPaths(StringBuffer stringBuffer, SortedSet<LateralPPDesc> sortedSet) throws SQLException {
        for (LateralPPDesc lateralPPDesc : sortedSet) {
            String string = "null";
            String string2 = "0";
            if (this.isGraphQuery()) {
                string = "T" + lateralPPDesc.depAlias + "." + this.gidCol + "";
                string2 = "1";
            }
            StringBuffer stringBuffer2 = new StringBuffer("");
            stringBuffer2.append(QueryUtils.enquoteLiteral(SimpleBGP.nullToEmptyString(this.ctx.queryOptions))).append("\n");
            stringBuffer2.append(",").append(this.ctx.optionsFlag).append("\n");
            stringBuffer2.append(",").append(QueryUtils.buildSQLCollectionStr("MDSYS.RDF_MODELS", this.ctx.models));
            stringBuffer2.append(",").append(QueryUtils.enquoteLiteral(SimpleBGP.nullToEmptyString(this.ctx.precompIdxName))).append("\n");
            stringBuffer2.append(",").append(this.ctx.precompIdxID).append("\n");
            stringBuffer2.append(",").append(QueryUtils.enquoteLiteral(SimpleBGP.nullToEmptyString(this.ctx.idxStatus))).append("\n");
            stringBuffer2.append(",").append(QueryUtils.enquoteLiteral(SimpleBGP.nullToEmptyString(this.ctx.vmViewName))).append("\n");
            stringBuffer2.append(",").append(QueryUtils.buildSQLCollectionStr("SYS.ODCINumberList", this.ctx.defaultGIDs, this.ctx));
            stringBuffer2.append(",").append(QueryUtils.buildSQLCollectionStr("SYS.ODCINumberList", this.ctx.namedGIDs, this.ctx));
            stringBuffer2.append(",").append(QueryUtils.buildSQLCollectionStr("SYS.ODCINumberList", this.ctx.defaultMIDs, this.ctx));
            stringBuffer2.append(",").append(QueryUtils.buildSQLCollectionStr("MDSYS.RDF_MODELS", this.ctx.defaultModels));
            stringBuffer2.append(",").append(QueryUtils.enquoteLiteral(SimpleBGP.nullToEmptyString(this.ctx.clnNetworkOwner))).append("\n");
            stringBuffer2.append(",").append(QueryUtils.enquoteLiteral(SimpleBGP.nullToEmptyString(this.ctx.clnNetworkName))).append("\n");
            int n = QueryUtils.getMaxPPDepth(this.queryOptions);
            if (lateralPPDesc.ppType != LateralPPDesc.PPTypes.RANGE_FORWARD && lateralPPDesc.ppType != LateralPPDesc.PPTypes.RANGE_REVERSE && QueryUtils.isSchemaProperty(lateralPPDesc.ppPred) && !this.ctx.disableSPPOpt) {
                n = 0;
            }
            String string3 = "null";
            String string4 = lateralPPDesc.ppPredId;
            String string5 = "null";
            String string6 = "0";
            String string7 = "null";
            String string8 = "null";
            String string9 = "0";
            if (lateralPPDesc.ppType == LateralPPDesc.PPTypes.PLUS_FORWARD) {
                if (lateralPPDesc.ppJoinPos == LateralPPDesc.PPJoinPositions.SUBJ) {
                    string3 = lateralPPDesc.ppJoinCol;
                } else {
                    string5 = lateralPPDesc.ppJoinCol;
                }
            } else if (lateralPPDesc.ppType == LateralPPDesc.PPTypes.PLUS_REVERSE) {
                if (lateralPPDesc.ppJoinPos == LateralPPDesc.PPJoinPositions.SUBJ) {
                    string5 = lateralPPDesc.ppJoinCol;
                } else {
                    string3 = lateralPPDesc.ppJoinCol;
                }
            } else if (lateralPPDesc.ppType == LateralPPDesc.PPTypes.STAR_FORWARD) {
                string6 = "1";
                if (lateralPPDesc.ppJoinPos == LateralPPDesc.PPJoinPositions.SUBJ) {
                    string3 = lateralPPDesc.ppJoinCol;
                } else {
                    string5 = lateralPPDesc.ppJoinCol;
                }
            } else if (lateralPPDesc.ppType == LateralPPDesc.PPTypes.STAR_REVERSE) {
                string6 = "1";
                if (lateralPPDesc.ppJoinPos == LateralPPDesc.PPJoinPositions.SUBJ) {
                    string5 = lateralPPDesc.ppJoinCol;
                } else {
                    string3 = lateralPPDesc.ppJoinCol;
                }
            } else if (lateralPPDesc.ppType == LateralPPDesc.PPTypes.RANGE_FORWARD) {
                string7 = String.valueOf(lateralPPDesc.minOcc);
                string8 = String.valueOf(lateralPPDesc.maxOcc);
                String string10 = string9 = lateralPPDesc.exact ? "1" : "0";
                if (lateralPPDesc.ppJoinPos == LateralPPDesc.PPJoinPositions.SUBJ) {
                    string3 = lateralPPDesc.ppJoinCol;
                } else {
                    string5 = lateralPPDesc.ppJoinCol;
                }
            } else if (lateralPPDesc.ppType == LateralPPDesc.PPTypes.RANGE_REVERSE) {
                string7 = String.valueOf(lateralPPDesc.minOcc);
                string8 = String.valueOf(lateralPPDesc.maxOcc);
                String string11 = string9 = lateralPPDesc.exact ? "1" : "0";
                if (lateralPPDesc.ppJoinPos == LateralPPDesc.PPJoinPositions.SUBJ) {
                    string5 = lateralPPDesc.ppJoinCol;
                } else {
                    string3 = lateralPPDesc.ppJoinCol;
                }
            }
            string3 = this.getSPMOptimizedCol(string3);
            string5 = this.getSPMOptimizedCol(string5);
            string = this.getSPMOptimizedCol(string);
            String string12 = "mdsys.sdo_rdf.sdo_rdf_pp(" + string3 + "," + string4 + "," + string5 + "," + string + "," + string2 + "," + string6 + "," + n + "," + stringBuffer2.toString();
            if (this.lateralPPRangeEnabled()) {
                string12 = string12 + "," + string7 + "," + string8 + "," + string9;
            }
            string12 = string12 + ")";
            String string13 = "DISTINCT";
            if (this.ctx.allowPPDup) {
                string13 = "";
            }
            if (lateralPPDesc.ppType == LateralPPDesc.PPTypes.PLUS_REVERSE || lateralPPDesc.ppType == LateralPPDesc.PPTypes.STAR_REVERSE || lateralPPDesc.ppType == LateralPPDesc.PPTypes.RANGE_REVERSE) {
                QueryUtils.appendToList(stringBuffer, "\nLATERAL (/*PP[*/SELECT " + string13 + " " + this.subjectCol + " AS " + this.canonObjCol + ", " + this.canonObjCol + " AS " + this.subjectCol + ", " + this.gidCol + " FROM TABLE(" + string12 + ")/*]PP*/) T" + lateralPPDesc.alias, ", ", "");
                continue;
            }
            QueryUtils.appendToList(stringBuffer, "\nLATERAL (/*PP[*/SELECT " + string13 + " " + this.subjectCol + ", " + this.canonObjCol + ", " + this.gidCol + " FROM TABLE(" + string12 + ")/*]PP*/) T" + lateralPPDesc.alias, ", ", "");
        }
    }

    private boolean isOptionalTidx(int n) {
        return n >= this.bgp.optionalTbStartIdx;
    }

    private boolean isOptionalLinkAlias(String string) {
        if (string.startsWith("T")) {
            String string2 = string.substring(1);
            int n = Integer.parseInt(string2);
            return this.isOptionalTidx(n);
        }
        return false;
    }

    private boolean isOptionalLinkRef(String string) {
        String[] stringArray = string.split("\\.");
        return this.isOptionalLinkAlias(stringArray[0]);
    }

    private boolean isFullOuterJoin(String string, String string2) {
        return this.isOptionalLinkAlias(string) && this.isOptionalLinkAlias(string2);
    }

    /*
     * WARNING - void declaration
     */
    private String buildWhere() throws RDFException {
        void var13_40;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        StringBuffer stringBuffer = new StringBuffer("");
        Set<String> set = this.getTriplePatternVars(true);
        Set<String> set2 = this.getOptionalBGPVars();
        HashSet<String> hashSet = new HashSet<String>();
        if (this.hasPushedBGP) {
            hashSet.addAll(this.pushedBGP.getDefiniteBoundAndPushedVars());
        }
        String string = "##";
        if (this.graphVar != null) {
            string = this.graphVar;
        }
        String string2 = this.buildGidExpr(true);
        String string3 = this.canonObjCol;
        if (this.ctx.useExactValue) {
            string3 = this.exactObjCol;
        }
        Set<String> set3 = this.getAllLexVars();
        if (this.hasPushedBGP) {
            Set<String> set4 = QueryUtils.getCommonVars(this.getMandatoryTriplePatternVars(false), hashSet);
            for (String object7 : set4) {
                if (object7.equals(string)) continue;
                if (set3.contains(object7)) {
                    String string4 = this.buildRDFTermForVar(object7);
                    QueryUtils.appendToList(stringBuffer, "PBGP." + object7 + this.term_alias + " = " + string4, " AND\n", "");
                    continue;
                }
                QueryUtils.appendToList(stringBuffer, "PBGP." + object7 + this.vid_alias + " = " + this.getSPMOptimizedCol(this.getLocalVIDCol(object7, hashSet)), " AND\n", "");
            }
        }
        boolean bl = false;
        for (String string5 : this.variablesToBeJoined) {
            if (this.isBindVar(string5) || !set.contains(string5)) continue;
            String string6 = this.varAliases.get(string5);
            if (this.excludedValueTabs.contains(string6)) {
                QueryUtils.appendToList(stringBuffer, "1=1", " AND\n", "");
                continue;
            }
            String string7 = this.varset.get(string5);
            boolean bl2 = set2.contains(string5);
            object4 = null;
            object3 = null;
            if (string7.equalsIgnoreCase("Subject")) {
                object4 = this.extractFirstOutgoingEdge(string5);
                object3 = this.subjectCol;
            }
            if (string7.equalsIgnoreCase("Object")) {
                object4 = this.extractFirstIncomingEdge(string5);
                object3 = string3;
            }
            if (string7.equalsIgnoreCase("Predicate")) {
                object4 = this.extractFirstTableAlias(string5);
                object3 = this.predicateCol;
            }
            if (this.graphVar != null && this.graphVar.equals(string5) && this.isOptionalLinkAlias((String)object4)) {
                bl = true;
                continue;
            }
            QueryUtils.appendToList(stringBuffer, string6 + "." + this.vid_col + (bl2 ? "(+)" : "") + " = " + this.getSPMOptimizedCol((String)object4 + "." + (String)object3), " AND\n", "");
        }
        int n = 0;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            TriplesBlock.Element element = triplesBlock.getSubject();
            TriplesBlock.Element element2 = triplesBlock.getPredicate();
            object4 = triplesBlock.getObject();
            object3 = null;
            object2 = "";
            object = null;
            String string8 = "";
            Long l = null;
            String string9 = "";
            String string10 = "";
            if (!element.isVariable()) {
                object3 = element.getCanonicalID();
                if (object3 != null) {
                    object2 = ((Long)object3).toString();
                }
                if (element.isBindVariable()) {
                    string10 = new ASTTripleAtom.BindVar((String)element.getName()).bvName;
                    object2 = this.getBindVar(string10).getIdCol();
                }
                if (element.isOraBindVariable()) {
                    object2 = element.getName() + "." + this.vid_col;
                }
                if (element.exists()) {
                    QueryUtils.appendToList(stringBuffer, this.getSPMOptimizedCol("T" + n + "." + this.subjectCol) + (this.isOptionalTidx(n) ? "(+)" : "") + " = " + (String)object2, " AND\n", "");
                } else if (!this.isOptionalTidx(n)) {
                    QueryUtils.appendToList(stringBuffer, this.getSPMOptimizedCol("T" + n + "." + this.subjectCol) + SimpleBGP.getNonExistingTermCondition(this.ctx.clnPfxForRdfObjName), " AND\n", "");
                } else {
                    QueryUtils.appendToList(stringBuffer, SimpleBGP.buildOptNonExistingTermJoin("T" + n + "." + this.subjectCol, this.ctx.clnPfxForRdfObjName), " AND\n", "");
                }
            }
            if (!element2.isVariable() && element2.getType() != 8) {
                object = element2.getCanonicalID();
                if (object != null) {
                    string8 = ((Long)object).toString();
                }
                if (element2.isBindVariable()) {
                    string10 = new ASTTripleAtom.BindVar((String)element2.getName()).bvName;
                    string8 = this.getBindVar(string10).getIdCol();
                }
                if (element2.isOraBindVariable()) {
                    string8 = element2.getName() + "." + this.vid_col;
                }
                if (element2.exists()) {
                    String string11 = "T" + n + "." + this.predicateCol;
                    String string12 = this.getSPMOptimizedCol(string11);
                    if (!string12.equals(string11)) {
                        if (!this.isOptionalTidx(n) && string12.startsWith("SVP")) {
                            QueryUtils.appendToList(stringBuffer, string12 + " IS NOT NULL", " AND\n", "");
                        }
                    } else {
                        QueryUtils.appendToList(stringBuffer, string11 + (this.isOptionalTidx(n) ? "(+)" : "") + " = " + string8, " AND\n", "");
                    }
                } else if (!this.isOptionalTidx(n)) {
                    QueryUtils.appendToList(stringBuffer, "T" + n + "." + this.predicateCol + SimpleBGP.getNonExistingTermCondition(this.ctx.clnPfxForRdfObjName), " AND\n", "");
                } else {
                    QueryUtils.appendToList(stringBuffer, SimpleBGP.buildOptNonExistingTermJoin("T" + n + "." + this.predicateCol, this.ctx.clnPfxForRdfObjName), " AND\n", "");
                }
            }
            if (!((TriplesBlock.Element)object4).isVariable()) {
                l = ((TriplesBlock.Element)object4).getCanonicalID();
                if (l != null) {
                    string9 = l.toString();
                }
                if (((TriplesBlock.Element)object4).isSysCtxFunction()) {
                    string9 = ((TriplesBlock.Element)object4).getName();
                }
                if (((TriplesBlock.Element)object4).isBindVariable()) {
                    string10 = new ASTTripleAtom.BindVar((String)((TriplesBlock.Element)object4).getName()).bvName;
                    string9 = this.getBindVar(string10).getIdCol();
                }
                if (((TriplesBlock.Element)object4).isOraBindVariable()) {
                    string9 = ((TriplesBlock.Element)object4).getName() + "." + this.vid_col;
                }
                if (((TriplesBlock.Element)object4).exists()) {
                    QueryUtils.appendToList(stringBuffer, this.getSPMOptimizedCol("T" + n + "." + string3) + (this.isOptionalTidx(n) ? "(+)" : "") + " = " + string9, " AND\n", "");
                } else if (!this.isOptionalTidx(n)) {
                    QueryUtils.appendToList(stringBuffer, this.getSPMOptimizedCol("T" + n + "." + string3) + SimpleBGP.getNonExistingTermCondition(this.ctx.clnPfxForRdfObjName), " AND\n", "");
                } else {
                    QueryUtils.appendToList(stringBuffer, SimpleBGP.buildOptNonExistingTermJoin("T" + n + "." + string3, this.ctx.clnPfxForRdfObjName), " AND\n", "");
                }
            }
            ++n;
        }
        boolean bl3 = false;
        for (String string13 : set) {
            Object object5;
            boolean bl4 = false;
            if (this.isBindVar(string13)) continue;
            if (this.bgp.BGPelements.containsKey(string13 + ",2") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string13).append((String)",2").toString()).position.equalsIgnoreCase("Object") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string13).append((String)",2").toString()).in_degree > 1) {
                object5 = this.extractIncomingEdges(string13);
                object4 = this.extractFirstIncomingEdge(string13);
                object3 = object5.iterator();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    if (((String)object2).equals(object4)) continue;
                    if (this.isFullOuterJoin((String)object4, (String)object2)) {
                        bl4 = true;
                        continue;
                    }
                    QueryUtils.appendToList(stringBuffer, this.buildOptimizedTpJoin((String)object4 + "." + string3, (String)object2 + "." + string3), " AND\n", "");
                }
            }
            if (this.bgp.BGPelements.containsKey(string13 + ",0") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string13).append((String)",0").toString()).position.equalsIgnoreCase("Subject") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string13).append((String)",0").toString()).out_degree > 1) {
                object5 = this.extractOutgoingEdges(string13);
                object4 = this.extractFirstOutgoingEdge(string13);
                object3 = object5.iterator();
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    if (((String)object2).equals(object4)) continue;
                    if (this.isFullOuterJoin((String)object4, (String)object2)) {
                        bl4 = true;
                        continue;
                    }
                    QueryUtils.appendToList(stringBuffer, this.buildOptimizedTpJoin((String)object4 + "." + this.subjectCol, (String)object2 + "." + this.subjectCol), " AND\n", "");
                }
            }
            if (!this.bgp.BGPelements.containsKey(string13 + ",2") || !this.bgp.BGPelements.containsKey(string13 + ",0") || this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string13).append((String)",2").toString()).in_degree <= 0 || this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string13).append((String)",0").toString()).out_degree <= 0) continue;
            object5 = this.extractFirstIncomingEdge(string13);
            if (!bl4) {
                object4 = this.extractFirstOutgoingEdge(string13);
                if (!this.isFullOuterJoin((String)object4, (String)object5)) {
                    QueryUtils.appendToList(stringBuffer, this.buildOptimizedTpJoin((String)object5 + "." + string3, object4 + "." + this.subjectCol), " AND\n", "");
                } else {
                    bl4 = true;
                }
            }
            if (!bl4) continue;
            object4 = this.extractOutgoingEdges(string13);
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                if (this.isFullOuterJoin((String)object5, (String)object2)) continue;
                QueryUtils.appendToList(stringBuffer, this.buildOptimizedTpJoin((String)object5 + "." + string3, (String)object2 + "." + this.subjectCol), " AND\n", "");
            }
        }
        boolean bl5 = false;
        for (String string14 : set) {
            boolean bl6 = false;
            if (this.isBindVar(string14)) continue;
            if (this.bgp.BGPelements.containsKey(string14 + ",1") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string14).append((String)",1").toString()).position.equalsIgnoreCase("Predicate") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string14).append((String)",1").toString()).occurences > 1) {
                object4 = this.extractAllTableAliases(string14);
                object3 = this.extractFirstTableAlias(string14);
                object2 = object4.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    if (((String)object).equalsIgnoreCase((String)object3)) continue;
                    if (this.isFullOuterJoin((String)object3, (String)object)) {
                        bl6 = true;
                        continue;
                    }
                    QueryUtils.appendToList(stringBuffer, object3 + "." + this.predicateCol + (this.isOptionalLinkAlias((String)object3) ? "(+)" : "") + " = " + object + "." + this.predicateCol + (this.isOptionalLinkAlias((String)object) ? "(+)" : ""), " AND\n", "");
                }
            }
            if (this.bgp.BGPelements.containsKey(string14 + ",1") && this.bgp.BGPelements.containsKey(string14 + ",0")) {
                object4 = this.extractFirstOutgoingEdge(string14);
                if (!bl6) {
                    object3 = this.extractFirstTableAlias(string14);
                    if (!this.isFullOuterJoin((String)object3, (String)object4)) {
                        QueryUtils.appendToList(stringBuffer, (String)object3 + "." + this.predicateCol + (this.isOptionalLinkAlias((String)object3) ? "(+)" : "") + " = " + this.getSPMOptimizedCol((String)object4 + "." + this.subjectCol) + (this.isOptionalLinkAlias((String)object4) ? "(+)" : ""), " AND\n", "");
                    } else {
                        bl6 = true;
                    }
                }
                if (bl6) {
                    object3 = this.extractAllTableAliases(string14);
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = (String)object2.next();
                        if (this.isFullOuterJoin((String)object4, (String)object)) continue;
                        QueryUtils.appendToList(stringBuffer, (String)object + "." + this.predicateCol + (this.isOptionalLinkAlias((String)object) ? "(+)" : "") + " = " + this.getSPMOptimizedCol(object4 + "." + this.subjectCol) + (this.isOptionalLinkAlias((String)object4) ? "(+)" : ""), " AND\n", "");
                    }
                }
            }
            if (!this.bgp.BGPelements.containsKey(string14 + ",1") || !this.bgp.BGPelements.containsKey(string14 + ",2")) continue;
            object4 = this.extractFirstIncomingEdge(string14);
            if (!bl6) {
                object3 = this.extractFirstTableAlias(string14);
                if (!this.isFullOuterJoin((String)object3, (String)object4)) {
                    QueryUtils.appendToList(stringBuffer, object3 + "." + this.predicateCol + (this.isOptionalLinkAlias((String)object3) ? "(+)" : "") + " = " + this.getSPMOptimizedCol(object4 + "." + string3) + (this.isOptionalLinkAlias((String)object4) ? "(+)" : ""), " AND\n", "");
                } else {
                    bl6 = true;
                }
            }
            if (!bl6) continue;
            object3 = this.extractAllTableAliases(string14);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (this.isFullOuterJoin((String)object4, (String)object)) continue;
                QueryUtils.appendToList(stringBuffer, object + "." + this.predicateCol + (this.isOptionalLinkAlias((String)object) ? "(+)" : "") + " = " + this.getSPMOptimizedCol(object4 + "." + string3) + (this.isOptionalLinkAlias((String)object4) ? "(+)" : ""), " AND\n", "");
            }
        }
        if (this.graphQuery) {
            void var13_35;
            boolean bl7 = true;
            String string15 = "";
            if ((this.ctx.contextFlags & 4) > 0 || this.wantGIDCoalesce()) {
                boolean bl8 = false;
            }
            while (var13_35 < this.bgp.TBList.size()) {
                string15 = this.optLinkAliasList.get((int)var13_35);
                QueryUtils.appendToList(stringBuffer, this.buildOptimizedNgJoin(string2, string15 + "." + this.gidCol, this.isOptionalLinkAlias(string15)), " AND\n", "");
                ++var13_35;
            }
            if (this.activeGraph.type == 0) {
                if (hashSet.contains(string)) {
                    if (set3.contains(string)) {
                        object4 = this.buildRDFTermForVar(string);
                        object3 = "PBGP." + string + this.term_alias;
                        QueryUtils.appendToList(stringBuffer, (String)object4 + " = " + object3, " AND\n", "");
                    } else {
                        QueryUtils.appendToList(stringBuffer, this.buildGidNVL("PBGP." + string + this.vid_alias, string2) + " = " + string2, " AND\n", "");
                    }
                }
                object4 = null;
                boolean bl9 = false;
                boolean bl10 = false;
                if (this.bgp.BGPelements.containsKey(string + ",2") && !this.isOptionalLinkAlias(this.extractFirstIncomingEdge(string))) {
                    object4 = this.extractFirstIncomingEdge(string) + "." + string3;
                } else if (this.bgp.BGPelements.containsKey(string + ",0") && !this.isOptionalLinkAlias(this.extractFirstOutgoingEdge(string))) {
                    object4 = this.extractFirstOutgoingEdge(string) + "." + this.subjectCol;
                } else if (this.bgp.BGPelements.containsKey(string + ",1") && !this.isOptionalLinkAlias(this.extractFirstTableAlias(string))) {
                    object4 = this.extractFirstTableAlias(string) + "." + this.predicateCol;
                }
                if (object4 != null) {
                    QueryUtils.appendToList(stringBuffer, this.buildOptimizedNgJoin(string2, (String)object4, false), " AND\n", "");
                }
                if (this.bgp.BGPelements.containsKey(string + ",2")) {
                    for (String string8 : this.extractIncomingEdges(string)) {
                        if (!this.isOptionalLinkAlias(string8)) continue;
                        QueryUtils.appendToList(stringBuffer, this.buildOptimizedNgJoin(string2, string8 + "." + string3, true), " AND\n", "");
                    }
                }
                if (this.bgp.BGPelements.containsKey(string + ",0")) {
                    for (String string8 : this.extractOutgoingEdges(string)) {
                        if (!this.isOptionalLinkAlias(string8)) continue;
                        QueryUtils.appendToList(stringBuffer, this.buildOptimizedNgJoin(string2, string8 + "." + this.subjectCol, true), " AND\n", "");
                    }
                }
                if (this.bgp.BGPelements.containsKey(string + ",1")) {
                    for (String string8 : this.extractAllTableAliases(string)) {
                        if (!this.isOptionalLinkAlias(string8)) continue;
                        QueryUtils.appendToList(stringBuffer, this.buildOptimizedNgJoin(string2, string8 + "." + this.predicateCol, true), " AND\n", "");
                    }
                }
                if (this.variablesToBeJoined.contains(string) && (!set.contains(string) || bl)) {
                    if ((this.ctx.contextFlags & 4) > 0) {
                        QueryUtils.appendToList(stringBuffer, "VG." + this.vid_col + "(+) = " + string2, " AND\n", "");
                    } else {
                        QueryUtils.appendToList(stringBuffer, "VG." + this.vid_col + " = " + string2, " AND\n", "");
                    }
                }
            }
            if (this.activeGraph.type == 1 || this.activeGraph.type == 9 || this.activeGraph.type == 10) {
                object4 = null;
                if (this.activeGraph.type == 1) {
                    object4 = this.ctx.URImap.get(this.activeGraph.name);
                } else if (this.activeGraph.type == 9) {
                    ASTTripleAtom.BindVar bindVar = this.getBindVar(string);
                    object4 = bindVar.getIdCol();
                } else if (this.activeGraph.type == 10) {
                    object4 = this.activeGraph.name + "." + this.vid_col;
                }
                if (object4 != null) {
                    QueryUtils.appendToList(stringBuffer, this.buildGidNVL((String)object4, string2) + " = " + string2, " AND\n", "");
                } else {
                    QueryUtils.appendToList(stringBuffer, this.getSPMOptimizedCol("T0." + this.gidCol) + SimpleBGP.getNonExistingTermCondition(this.ctx.clnPfxForRdfObjName), " AND\n", "");
                }
            }
        }
        if ((this.ctx.contextFlags & 1) > 0 && this.bgp.TBList.size() > 1) {
            void var13_37;
            boolean bl11 = true;
            while (var13_37 < this.bgp.TBList.size()) {
                QueryUtils.appendToList(stringBuffer, "T0.CTXT2 = T" + (int)var13_37 + ".CTXT2 ", " AND\n", "");
                ++var13_37;
            }
        } else if ((this.ctx.contextFlags & 2) > 0 && this.bgp.TBList.size() > 1) {
            int n2;
            StringBuffer stringBuffer2 = new StringBuffer(" COALESCE(");
            for (n2 = 0; n2 < this.bgp.TBList.size(); ++n2) {
                stringBuffer2.append("T" + n2 + ".CTXT2,");
            }
            stringBuffer2.append("'RDFCTX$NULLCTX')");
            for (n2 = 1; n2 < this.bgp.TBList.size(); ++n2) {
                QueryUtils.appendToList(stringBuffer, stringBuffer2.toString() + " = NVL(T" + n2 + ".CTXT2, " + stringBuffer2.toString() + ") ", " AND\n", "");
            }
        }
        boolean bl12 = false;
        while (var13_40 < this.bgp.TBList.size()) {
            TriplesBlock triplesBlock = this.bgp.TBList.get((int)var13_40);
            object4 = triplesBlock.getPredicate();
            if (!((TriplesBlock.Element)object4).isVariable() && ((TriplesBlock.Element)object4).getType() != 8 && !((TriplesBlock.Element)object4).isBindVariable() && !((TriplesBlock.Element)object4).isOraBindVariable() && ((TriplesBlock.Element)object4).exists()) {
                this.addSPMDatasetConstraints(stringBuffer, (TriplesBlock.Element)object4, (int)var13_40);
            }
            ++var13_40;
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("(1=1)");
        }
        return "WHERE " + stringBuffer.toString();
    }

    private String applyFilters(String string, Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        for (Filter filter : this.filters) {
            filter.setCurrSQL(string, set, set2, set3, set4);
            filter.setSpmValueColMapping(this.spmValColMap);
            QueryUtils.appendToList(stringBuffer, filter.toSQL(this.varAliases, this.varIDs, this.ctx.funcTypeMap, this.ctx.funcHandMap), " AND\n", "dummy");
        }
        return stringBuffer.toString();
    }

    private void popVarsToJoin() {
        this.variablesToBeJoined = new HashSet<String>();
        this.variablesToBeJoined.addAll(QueryUtils.getCommonVars(this.getProjectVars(), this.getBGPVars()));
        this.bindVarsToJoin = new HashSet<ASTTripleAtom.BindVar>();
        this.bindVarsToJoin.addAll(this.bindVars);
        for (Filter filter : this.filters) {
            this.variablesToBeJoined.addAll(filter.getfJoinVars());
            this.bindVarsToJoin.addAll(filter.getBindVarObjs());
        }
    }

    private void populateFromTBs() {
        this.varset = new HashMap<String, String>();
        this.extractVariables();
    }

    private void extractVariables() {
        this.mandatoryVars.clear();
        this.optionalVars.clear();
        this.lobVars = null;
        this.objVars.clear();
        this.subPredGraphVars.clear();
        if (this.graphQuery && this.activeGraph != null && (this.activeGraph.type == 0 || this.activeGraph.type == 9)) {
            String string = this.activeGraph.name.toUpperCase();
            this.mandatoryVars.add(string);
            this.subPredGraphVars.add(string);
        }
        int n = 0;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            boolean bl = false;
            if (triplesBlock.hasPropertyPath()) {
                bl = QueryUtils.pathContainsReverse(triplesBlock.getPath());
            }
            int n2 = 0;
            for (TriplesBlock.Element element : new TriplesBlock.Element[]{triplesBlock.getSubject(), triplesBlock.getPredicate(), triplesBlock.getObject()}) {
                String string = element.getName();
                if (element.isVariable() && !this.varset.containsKey(string)) {
                    this.varset.put(string, this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string).append((String)",").append((int)n2).toString()).position);
                } else if (element.isBindVariable()) {
                    ASTTripleAtom.BindVar bindVar = new ASTTripleAtom.BindVar(string);
                    this.bindVars.add(bindVar);
                    if (!this.varset.containsKey(bindVar.bvName)) {
                        this.varset.put(bindVar.bvName, this.bgp.BGPelements.get((Object)new StringBuilder().append((String)bindVar.bvName).append((String)",").append((int)n2).toString()).position);
                    }
                }
                if (element.isVariable() || element.isBindVariable()) {
                    switch (n2) {
                        case 0: {
                            if (bl) {
                                this.objVars.add(string);
                                break;
                            }
                            this.subPredGraphVars.add(string);
                            break;
                        }
                        case 1: {
                            this.subPredGraphVars.add(string);
                            break;
                        }
                        case 2: {
                            this.objVars.add(string);
                        }
                    }
                    if (this.isOptionalTidx(n)) {
                        if (!this.mandatoryVars.contains(string)) {
                            this.optionalVars.add(string);
                        }
                    } else {
                        this.mandatoryVars.add(string);
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    private void extractVarAliases() {
        this.varAliases = new HashMap<String, String>();
        Set<Map.Entry<String, String>> set = this.varset.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String string;
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            boolean bl = false;
            if (this.graphVar != null && this.graphVar.equals(string2)) {
                string = null;
                string = string3.equalsIgnoreCase("Subject") ? this.extractFirstOutgoingEdge(string2) : (string3.equalsIgnoreCase("Object") ? this.extractFirstIncomingEdge(string2) : this.extractFirstTableAlias(string2));
                if (this.isOptionalLinkAlias(string)) {
                    bl = true;
                }
            }
            if (bl) continue;
            string = "";
            if (this.isBindVar(string2)) {
                ASTTripleAtom.BindVar bindVar = this.getBindVar(string2);
                string = bindVar.getTermCol();
                this.varAliases.put(string2, string);
            } else {
                string3 = string3.equalsIgnoreCase("Subject") ? "0" : (string3.equalsIgnoreCase("Predicate") ? "1" : "2");
                string = "V" + this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string2).append((String)",").append((String)string3).toString()).uniqueId;
                this.varAliases.put(string2, string);
            }
            if (this.hintG == null || !this.variablesToBeJoined.contains(string2.toUpperCase())) continue;
            this.hintG.addVarAlias(string2, string);
        }
        if (this.graphVar != null && !this.varAliases.containsKey(this.graphVar)) {
            Object object = GRAPH_ALIAS;
            if (this.isBindVar(this.graphVar)) {
                object = this.getBindVar(this.graphVar).getTermCol();
            }
            this.varAliases.put(this.graphVar, (String)object);
            if (this.hintG != null && this.variablesToBeJoined.contains(this.graphVar)) {
                this.hintG.addVarAlias(this.graphVar, (String)object);
            }
        }
    }

    private void updateVarAliasesForAuxValues() {
        for (Map.Entry<String, String> entry : this.varAliases.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            String string3 = this.auxVarMappedAliases.get(string);
            if (string3 == null || string3.equals(string2)) continue;
            entry.setValue(string3);
        }
    }

    private String addSPMTabDatasetConstraints(String string) {
        String string2 = "(SELECT * FROM " + string + " WHERE 1=0)";
        if (this.graphQuery && this.ctx.defaultGIDs != null && this.ctx.defaultGIDs.length > 0 && (this.ctx.namedGIDs == null || this.ctx.namedGIDs.length == 0)) {
            return string2;
        }
        if (!(this.graphQuery || this.ctx.namedGIDs == null || this.ctx.namedGIDs.length <= 0 || this.ctx.defaultGIDs != null && this.ctx.defaultGIDs.length != 0)) {
            return string2;
        }
        return string;
    }

    private void addSPMDatasetConstraints(StringBuffer stringBuffer, TriplesBlock.Element element, int n) {
        boolean bl;
        boolean bl2 = this.isOptionalTidx(n);
        String string = "T" + n + "." + this.predicateCol;
        String string2 = this.getSPMOptimizedCol(string);
        boolean bl3 = bl = (this.ctx.contextFlags & 4) > 0;
        if (!string2.equals(string)) {
            String string3 = this.getSPMOptimizedCol("T" + n + "." + this.gidCol);
            List<Object> list = Collections.emptyList();
            if (bl2) {
                list = this.findOptVarsForLinkRef(string);
            }
            if (this.graphQuery) {
                String string4;
                String string5;
                if (!bl) {
                    string5 = string3 + " IS NOT NULL ";
                    if (bl2) {
                        for (String string6 : list) {
                            string4 = this.optVarProjCondMap.get(string6);
                            string4 = string4 != null ? string4 + " AND " + string5 : string5;
                            this.optVarProjCondMap.put(string6, string4);
                        }
                    } else {
                        QueryUtils.appendToList(stringBuffer, string5, " AND\n", "");
                    }
                }
                if (this.ctx.namedGIDs != null && this.ctx.namedGIDs.length > 0) {
                    string5 = QueryUtils.buildGidInList(string3, this.ctx.namedGIDs, this.ctx);
                    if (bl) {
                        string5 = "(" + string5 + " OR " + string3 + " IS NULL) ";
                    }
                    if (bl2) {
                        for (String string6 : list) {
                            string4 = this.optVarProjCondMap.get(string6);
                            string4 = string4 != null ? string4 + " AND " + string5 : string5;
                            this.optVarProjCondMap.put(string6, string4);
                        }
                    } else {
                        QueryUtils.appendToList(stringBuffer, string5, " AND\n", "");
                    }
                }
            } else {
                String string7;
                String string8;
                if (!this.ctx.allGraphsDefault) {
                    string8 = string3 + " IS NULL ";
                    if (bl2) {
                        for (String string9 : list) {
                            string7 = this.optVarProjCondMap.get(string9);
                            string7 = string7 != null ? string7 + " AND " + string8 : string8;
                            this.optVarProjCondMap.put(string9, string7);
                        }
                    } else {
                        QueryUtils.appendToList(stringBuffer, string8, " AND\n", "");
                    }
                }
                if (this.ctx.defaultGIDs != null && this.ctx.defaultGIDs.length > 0) {
                    string8 = QueryUtils.buildGidInList(string3, this.ctx.defaultGIDs, this.ctx);
                    if (bl2) {
                        for (String string10 : list) {
                            string7 = this.optVarProjCondMap.get(string10);
                            string7 = string7 != null ? string7 + " AND " + string8 : string8;
                            this.optVarProjCondMap.put(string10, string7);
                        }
                    } else {
                        QueryUtils.appendToList(stringBuffer, string8, " AND\n", "");
                    }
                }
            }
        }
    }

    private void extractVarIDs() {
        this.varIDs = new HashMap<String, String>();
        Set<String> set = this.getBGPVars();
        for (String string : set) {
            this.varIDs.put(string, this.getSPMOptimizedCol(this.getLocalVIDCol(string, new HashSet<String>())));
        }
    }

    private List<String> extractIncomingEdges(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            if (triplesBlock.getObject().isVariable() && triplesBlock.getObject().getName().equalsIgnoreCase(string)) {
                arrayList.add("T" + n);
            }
            ++n;
        }
        return arrayList;
    }

    private String extractFirstIncomingEdge(String string) {
        String string2;
        List<String> list = this.extractIncomingEdges(string);
        int n = -1;
        String string3 = string2 = list.get(0);
        if (!this.hint0leadPosMap.isEmpty()) {
            for (String string4 : list) {
                Integer n2 = this.hint0leadPosMap.get(string4.toUpperCase());
                if (n2 == null) continue;
                if (n < 0) {
                    n = n2;
                    string3 = string4;
                    continue;
                }
                if (n2 >= n) continue;
                n = n2;
                string3 = string4;
            }
        }
        if (!this.isOptionalLinkAlias(string2) && this.isOptionalLinkAlias(string3)) {
            string3 = string2;
        }
        return string3;
    }

    private List<String> extractOutgoingEdges(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            if (triplesBlock.getSubject().isVariable() && triplesBlock.getSubject().getName().equalsIgnoreCase(string)) {
                arrayList.add("T" + n);
            }
            ++n;
        }
        return arrayList;
    }

    private String extractFirstOutgoingEdge(String string) {
        String string2;
        List<String> list = this.extractOutgoingEdges(string);
        int n = -1;
        String string3 = string2 = list.get(0);
        if (!this.hint0leadPosMap.isEmpty()) {
            for (String string4 : list) {
                Integer n2 = this.hint0leadPosMap.get(string4.toUpperCase());
                if (n2 == null) continue;
                if (n < 0) {
                    n = n2;
                    string3 = string4;
                    continue;
                }
                if (n2 >= n) continue;
                n = n2;
                string3 = string4;
            }
        }
        if (!this.isOptionalLinkAlias(string2) && this.isOptionalLinkAlias(string3)) {
            string3 = string2;
        }
        return string3;
    }

    private String extractFirstTableAlias(String string) {
        String string2;
        List<String> list = this.extractAllTableAliases(string);
        int n = -1;
        String string3 = string2 = list.get(0);
        if (!this.hint0leadPosMap.isEmpty()) {
            for (String string4 : list) {
                Integer n2 = this.hint0leadPosMap.get(string4.toUpperCase());
                if (n2 == null) continue;
                if (n < 0) {
                    n = n2;
                    string3 = string4;
                    continue;
                }
                if (n2 >= n) continue;
                n = n2;
                string3 = string4;
            }
        }
        if (!this.isOptionalLinkAlias(string2) && this.isOptionalLinkAlias(string3)) {
            string3 = string2;
        }
        return string3;
    }

    private List<String> extractAllTableAliases(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            if (triplesBlock.getPredicate().isVariable() && triplesBlock.getPredicate().getName().equalsIgnoreCase(string)) {
                arrayList.add("T" + n);
            }
            ++n;
        }
        return arrayList;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String toString(String string) {
        String string2 = "";
        if (this.isGraphQuery()) {
            string2 = string2 + string + "BGP [" + this.id + "] GRAPH: [" + this.activeGraph.name + "]\n";
        }
        string2 = string2 + this.bgp.toString(string);
        string2 = string2 + "\n";
        string2 = string2 + string + "ID [" + this.getId() + "]\n";
        string2 = string2 + string + "User Hint [" + this.userHint + "]\n";
        string2 = string2 + string + "Required Lex Vars: [";
        for (String iterator2 : this.getRequiredLexVars()) {
            string2 = string2 + iterator2 + " ";
        }
        string2 = string2 + "]\n";
        string2 = string2 + string + "Lex Vars: [";
        for (String string3 : this.getAllLexVars()) {
            string2 = string2 + string3 + " ";
        }
        string2 = string2 + "]\n";
        string2 = string2 + string + "OPTIONAL Triple Patterns: [";
        for (SPARQLTriplesBlock sPARQLTriplesBlock : this.myOptionalTrips) {
            string2 = string2 + sPARQLTriplesBlock.toString();
        }
        string2 = string2 + "]\n";
        string2 = string2 + string + "OPTIONAL Vars: [";
        Set<String> set = this.getOptionalBGPVars();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            string2 = string2 + string4 + " ";
        }
        string2 = string2 + "]\n";
        return string2;
    }

    private boolean isMultiTriplePatternVar(String string) {
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.extractOutgoingEdges(string));
        hashSet.addAll(this.extractIncomingEdges(string));
        hashSet.addAll(this.extractAllTableAliases(string));
        if (hashSet.size() > 1) {
            bl = true;
        }
        if (!bl && this.graphVar != null && this.graphVar.equals(string)) {
            bl = true;
        }
        return bl;
    }

    private boolean isBindVar(String string) {
        for (ASTTripleAtom.BindVar bindVar : this.bindVars) {
            if (!bindVar.bvName.equals(string)) continue;
            return true;
        }
        return false;
    }

    private ASTTripleAtom.BindVar getBindVar(String string) {
        for (ASTTripleAtom.BindVar bindVar : this.bindVars) {
            if (!bindVar.bvName.equals(string)) continue;
            return bindVar;
        }
        return null;
    }

    private void optimizePPStartEndNodes() throws RDFException {
        HashMap<String, Set<ASTTripleAtom>> hashMap = new HashMap<String, Set<ASTTripleAtom>>();
        for (Filter object : this.filters) {
            object.updateSubMap(hashMap, this.varAliases, this.varIDs);
        }
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            Object object;
            if (!triplesBlock.hasPropertyPath()) continue;
            String string = triplesBlock.getSubject().toString();
            if (hashMap.containsKey(string)) {
                object = triplesBlock.getPath();
                object.setStartNodes((Set)hashMap.get(string));
            }
            if (!hashMap.containsKey(object = triplesBlock.getObject().toString())) continue;
            PPNode pPNode = triplesBlock.getPath();
            pPNode.setEndNodes((Set)hashMap.get(object));
        }
    }

    private boolean isLateralOptimizable(TriplesBlock triplesBlock, int n, LateralPPDesc[] lateralPPDescArray) {
        LateralPPDesc.PPTypes pPTypes;
        PPNode pPNode;
        if (triplesBlock.hasPropertyPath() && this.isUnconstrainedPP(pPNode = triplesBlock.getPath()) && ((pPTypes = this.getPPType(pPNode)) == LateralPPDesc.PPTypes.STAR_FORWARD || pPTypes == LateralPPDesc.PPTypes.STAR_REVERSE || pPTypes == LateralPPDesc.PPTypes.PLUS_FORWARD || pPTypes == LateralPPDesc.PPTypes.PLUS_REVERSE || (pPTypes == LateralPPDesc.PPTypes.RANGE_FORWARD || pPTypes == LateralPPDesc.PPTypes.RANGE_REVERSE) && this.lateralPPRangeEnabled())) {
            String string;
            String string2 = ((PPIRINode)pPNode.getChild((int)0)).getPredAtom().name;
            String string3 = this.ctx.URImap.get(string2);
            PPModNode pPModNode = (PPModNode)pPNode;
            int n2 = pPModNode.getMinOcc();
            int n3 = pPModNode.getMaxOcc();
            boolean bl = pPModNode.isExactRange();
            String string4 = triplesBlock.getSubject().toString();
            List<TriplesBlockLocPair> list = this.extractTBsForLateralJoin(string4, string = triplesBlock.getObject().toString(), n);
            if (list != null) {
                for (TriplesBlockLocPair triplesBlockLocPair : list) {
                    TriplesBlock triplesBlock2 = triplesBlockLocPair.tb;
                    int n4 = triplesBlockLocPair.tbPos;
                    String string5 = triplesBlock2.getSubject().toString();
                    String string6 = triplesBlock2.getObject().toString();
                    if (string5.equals(string4) && !string6.equals(string)) {
                        lateralPPDescArray[0] = new LateralPPDesc(n, n4, LateralPPDesc.PPJoinPositions.SUBJ, "T" + n4 + "." + this.subjectCol, pPTypes, string3, string2, n2, n3, bl);
                        return true;
                    }
                    if (string5.equals(string) && !string6.equals(string4)) {
                        lateralPPDescArray[0] = new LateralPPDesc(n, n4, LateralPPDesc.PPJoinPositions.OBJ, "T" + n4 + "." + this.subjectCol, pPTypes, string3, string2, n2, n3, bl);
                        return true;
                    }
                    if (string6.equals(string4) && !string5.equals(string)) {
                        lateralPPDescArray[0] = new LateralPPDesc(n, n4, LateralPPDesc.PPJoinPositions.SUBJ, "T" + n4 + "." + this.canonObjCol, pPTypes, string3, string2, n2, n3, bl);
                        return true;
                    }
                    if (!string6.equals(string) || string5.equals(string4)) continue;
                    lateralPPDescArray[0] = new LateralPPDesc(n, n4, LateralPPDesc.PPJoinPositions.OBJ, "T" + n4 + "." + this.canonObjCol, pPTypes, string3, string2, n2, n3, bl);
                    return true;
                }
            }
        }
        return false;
    }

    private List<TriplesBlockLocPair> extractTBsForLateralJoin(String string, String string2, int n) {
        List<TriplesBlockLocPair> list = null;
        List<TriplesBlockLocPair> list2 = null;
        List<TriplesBlockLocPair> list3 = null;
        list2 = this.getConnectedComponent(string, n);
        if (this.isSelective(TriplesBlockLocPair.extractTBList(list2), string)) {
            list = list2;
        } else {
            list3 = this.getConnectedComponent(string2, n);
            if (this.isSelective(TriplesBlockLocPair.extractTBList(list3), string2)) {
                list = list3;
            }
        }
        if (list == null && this.ctx.forceLatPPOpt) {
            list = new ArrayList<TriplesBlockLocPair>();
            if (list2 != null) {
                list.addAll(list2);
            }
            if (list3 != null) {
                list.addAll(list3);
            }
        }
        return list;
    }

    private boolean isUnconstrainedPP(PPNode pPNode) {
        TriplesBlock.Element element;
        if (pPNode.hasConstrainedStart()) {
            for (ASTTripleAtom aSTTripleAtom : pPNode.getStartNodes()) {
                element = null;
                element = TriplesBlock.getElementForNode(aSTTripleAtom, this.ctx);
                if (element.getCanonicalID() == null) continue;
                return false;
            }
        }
        if (pPNode.hasConstrainedEnd()) {
            for (ASTTripleAtom aSTTripleAtom : pPNode.getEndNodes()) {
                element = null;
                element = TriplesBlock.getElementForNode(aSTTripleAtom, this.ctx);
                if (element.getCanonicalID() == null) continue;
                return false;
            }
        }
        return true;
    }

    private LateralPPDesc.PPTypes getPPType(PPNode pPNode) {
        PPModNode pPModNode;
        if (pPNode instanceof PPModNode && ((pPModNode = (PPModNode)pPNode).getModifier() == 1 || pPModNode.getModifier() == 2 || pPModNode.getModifier() == 3) && pPModNode.getNumChildren() == 1 && pPModNode.getChild(0) instanceof PPIRINode) {
            PPIRINode pPIRINode = (PPIRINode)pPModNode.getChild(0);
            if (pPModNode.getDirection() == pPIRINode.getDirection()) {
                if (pPModNode.getModifier() == 1) {
                    return LateralPPDesc.PPTypes.STAR_FORWARD;
                }
                if (pPModNode.getModifier() == 3) {
                    return LateralPPDesc.PPTypes.RANGE_FORWARD;
                }
                return LateralPPDesc.PPTypes.PLUS_FORWARD;
            }
            if (pPModNode.getModifier() == 1) {
                return LateralPPDesc.PPTypes.STAR_REVERSE;
            }
            if (pPModNode.getModifier() == 3) {
                return LateralPPDesc.PPTypes.RANGE_REVERSE;
            }
            return LateralPPDesc.PPTypes.PLUS_REVERSE;
        }
        return LateralPPDesc.PPTypes.OTHER;
    }

    private boolean isSelective(List<TriplesBlock> list, String string) {
        if (this.disconnected) {
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (TriplesBlock object : list) {
            boolean bl;
            TriplesBlock.Element element = object.getSubject();
            TriplesBlock.Element element2 = object.getPredicate();
            TriplesBlock.Element element3 = object.getObject();
            boolean bl2 = bl = element2.getType() == 1 && QueryUtils.isUnselectiveProperty(element2.getValueName());
            if (element.getType() != 0) {
                return true;
            }
            hashSet.add(element.getName());
            if (bl) continue;
            if (element3.getType() != 0) {
                return true;
            }
            hashSet.add(element3.getName());
        }
        if (string != null) {
            hashSet.remove(string);
        }
        for (Filter filter : this.filters) {
            if (!filter.isSelective(hashSet)) continue;
            return true;
        }
        return false;
    }

    private boolean lateralPPEnabled() {
        return !this.ctx.disableLatPPOpt && this.ctx.minLabel.length() == 0 && this.ctx.asOfClause == null && this.ctx.lateralPPOptEnabled;
    }

    private boolean lateralPPRangeEnabled() {
        return this.ctx.lateralPPRangeOptEnabled;
    }

    private List<TriplesBlockLocPair> getConnectedComponent(String string, int n) {
        ArrayList<TriplesBlockLocPair> arrayList = new ArrayList<TriplesBlockLocPair>();
        boolean[] blArray = new boolean[this.bgp.TBList.size()];
        Arrays.fill(blArray, false);
        blArray[n] = true;
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        boolean bl = true;
        while (bl) {
            int n2 = 0;
            bl = false;
            for (TriplesBlock triplesBlock : this.bgp.TBList) {
                if (!blArray[n2]) {
                    String string2 = triplesBlock.getSubject().toString();
                    String string3 = triplesBlock.getObject().toString();
                    if (hashSet.contains(string2)) {
                        arrayList.add(new TriplesBlockLocPair(triplesBlock, n2));
                        hashSet.add(string3);
                        blArray[n2] = true;
                        bl = true;
                    } else if (hashSet.contains(string3)) {
                        arrayList.add(new TriplesBlockLocPair(triplesBlock, n2));
                        hashSet.add(string2);
                        blArray[n2] = true;
                        bl = true;
                    }
                }
                ++n2;
            }
        }
        return arrayList;
    }

    private boolean createsLateralCycle(LateralPPDesc lateralPPDesc, SortedSet<LateralPPDesc> sortedSet) {
        if (sortedSet.isEmpty()) {
            return false;
        }
        sortedSet.add(lateralPPDesc);
        Stack<Integer> stack = new Stack<Integer>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Integer n = -1;
        boolean bl = false;
        while (n != null && !bl) {
            n = this.getNextStartAlias(sortedSet, hashSet);
            if (n == null) continue;
            stack.push(n);
            hashSet.add(n);
            bl = this.dfsFindCycle(sortedSet, stack, hashSet);
        }
        sortedSet.remove(lateralPPDesc);
        return bl;
    }

    private Integer getNextStartAlias(SortedSet<LateralPPDesc> sortedSet, Set<Integer> set) {
        for (LateralPPDesc lateralPPDesc : sortedSet) {
            Integer n = lateralPPDesc.depAlias;
            if (set.contains(n)) continue;
            return n;
        }
        return null;
    }

    private boolean dfsFindCycle(SortedSet<LateralPPDesc> sortedSet, Stack<Integer> stack, Set<Integer> set) {
        Integer n = stack.peek();
        List<Integer> list = this.getOutgoingAliases(n, sortedSet);
        boolean bl = false;
        Iterator<Integer> iterator = list.iterator();
        while (!bl && iterator.hasNext()) {
            Integer n2 = iterator.next();
            set.add(n2);
            if (stack.contains(n2)) {
                bl = true;
            }
            if (bl) continue;
            stack.push(n2);
            bl = this.dfsFindCycle(sortedSet, stack, set);
            stack.pop();
        }
        return bl;
    }

    private List<Integer> getOutgoingAliases(Integer n, SortedSet<LateralPPDesc> sortedSet) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (LateralPPDesc lateralPPDesc : sortedSet) {
            if (!n.equals(lateralPPDesc.depAlias)) continue;
            arrayList.add(lateralPPDesc.alias);
        }
        return arrayList;
    }

    private void addAutoOptimizerHints() {
        if (this.ctx.useAutoHints) {
            String string = this.userHint;
            boolean bl = false;
            if (this.globalSelectivity == 0) {
                bl = true;
                if (this.ctx.useAutoValueHints) {
                    string = QueryUtils.updateValueHintForAllHash(string);
                }
                if (this.bgp.numTriples() > 1 && this.ctx.useAutoLinkHints) {
                    string = QueryUtils.updateLinkHintForAllHash(string);
                }
            }
            if (bl) {
                this.addUserHint(string);
            }
        }
    }

    private static String nullToEmptyString(String string) {
        return string != null ? string : "";
    }

    private List<String> findOptVarsForLinkRef(String string) {
        String[] stringArray = string.split("\\.");
        int n = Integer.parseInt(stringArray[0].substring(1));
        List<String> list = this.getOptVarsForTpIdx(n);
        return list;
    }

    private List<String> getOptVarsForTpIdx(int n) {
        Set<String> set = this.getOptionalBGPVars();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : set) {
            String string2 = this.getLocalVIDCol(string, Collections.emptySet());
            String[] stringArray = string2.split("\\.");
            int n2 = Integer.parseInt(stringArray[0].substring(1));
            if (n2 != n) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private String buildOptimizedNgJoin(String string, String string2, boolean bl) {
        String[] stringArray;
        String[] stringArray2;
        String string3 = this.getSPMOptimizedCol(string2);
        if (!string.contains("COALESCE(") && (stringArray2 = string.split("\\."))[0].equals((stringArray = string3.split("\\."))[0]) && bl) {
            String string4 = this.buildGidNVL(string3, string) + " = " + string;
            List<String> list = this.findOptVarsForLinkRef(string2);
            for (String string5 : list) {
                String string6 = this.optVarProjCondMap.get(string5);
                string6 = string6 != null ? string6 + " AND " + string4 : string4;
                this.optVarProjCondMap.put(string5, string6);
            }
            return "1=1";
        }
        return string + " = " + this.buildGidNVL(string3, string) + (bl ? "(+)" : "");
    }

    private String buildOptimizedTpJoin(String string, String string2) {
        String string3;
        boolean bl = this.isOptionalLinkRef(string);
        boolean bl2 = this.isOptionalLinkRef(string2);
        String string4 = this.getSPMOptimizedCol(string);
        String string5 = this.getSPMOptimizedCol(string2);
        String[] stringArray = string4.split("\\.");
        String[] stringArray2 = string5.split("\\.");
        boolean bl3 = false;
        boolean bl4 = false;
        List<Object> list = Collections.emptyList();
        if (stringArray[0].equals(stringArray2[0])) {
            if (stringArray[0].startsWith("SVP")) {
                bl4 = true;
            }
            if (stringArray[0].startsWith("SVP") && stringArray[1].equals(this.subjectCol) && stringArray2[1].equals(this.subjectCol)) {
                bl3 = true;
            }
            if (stringArray[0].startsWith("PCN") && stringArray[1].equals(stringArray2[1])) {
                bl3 = true;
            }
            if (!bl3 && bl4) {
                if (bl && bl2) {
                    throw new RuntimeException("Self full outer join not allowed");
                }
                if (bl) {
                    list = this.findOptVarsForLinkRef(string);
                } else if (bl2) {
                    list = this.findOptVarsForLinkRef(string2);
                }
            }
        }
        String string6 = bl && list.isEmpty() ? "(+)" : "";
        String string7 = bl2 && list.isEmpty() ? "(+)" : "";
        String string8 = string3 = bl3 ? "1=1" : string4 + string6 + " = " + string5 + string7;
        if (bl4 && (bl || bl2)) {
            for (String string9 : list) {
                String string10 = this.optVarProjCondMap.get(string9);
                string10 = string10 != null ? string10 + " AND " + string3 : string3;
                this.optVarProjCondMap.put(string9, string10);
            }
            return "1=1";
        }
        return string3;
    }

    private String getSPMOptimizedCol(String string) {
        String string2 = this.svpColMap.get(string);
        if (string2 == null && (string2 = this.pcnColMap.get(string)) == null) {
            string2 = this.mvpColMap.get(string);
        }
        return string2 != null ? string2 : string;
    }

    private String getSPMOptimizedValCol(String string) {
        String string2 = this.spmValColMap.get(string);
        return string2 != null ? string2 : string;
    }

    private void processSPMInfo() {
        this.minClusterSize = this.ctx.minSvpClusterSize;
        this.spmCoveredTripleIds = new HashSet<Integer>();
        if (this.ctx.preferPcn) {
            this.buildPCNChainList();
            this.buildPCNColMapping();
        }
        this.buildSVPClusterList();
        if (this.ctx.dmpSQL) {
            this.dumpSVPClusterList();
        }
        this.filterSVPClusterList();
        this.buildSVPColMapping();
        if (!this.ctx.preferPcn) {
            this.buildPCNChainList();
            this.buildPCNColMapping();
        }
        this.buildMVPPredList();
        this.buildMVPColMapping();
        this.buildExcludedTripleTabsSet();
        this.popSPMAuxValInfo();
        if (this.ctx.dmpSQL) {
            this.dumpSVPClusterList();
            this.dumpSVPColMap();
            this.dumpSVPAliasSet();
            this.dumpPCNChainList();
            this.dumpPCNColMap();
            this.dumpPCNAliasSet();
            this.dumpMVPPredList();
            this.dumpMVPColMap();
            this.dumpMVPAliasSet();
            this.dumpExcludedTabs();
            this.dumpSPMValColMap();
            this.dumpExcludedValTabs();
            this.dumpAuxValueVars();
        }
    }

    private void buildSVPClusterList() {
        Object object;
        HashMap<TriplesBlock.Element, ArrayList<SPMColDesc>> hashMap = new HashMap<TriplesBlock.Element, ArrayList<SPMColDesc>>();
        ArrayList<SPMColDesc> arrayList = null;
        int n = 0;
        for (TriplesBlock object2 : this.bgp.TBList) {
            object = object2.getPredicate();
            if (((TriplesBlock.Element)object).getType() == 1 && ((TriplesBlock.Element)object).exists() && !this.spmCoveredTripleIds.contains(n)) {
                Long l = ((TriplesBlock.Element)object).getCanonicalID();
                arrayList = (ArrayList<SPMColDesc>)hashMap.get(object2.getSubject());
                if (arrayList == null) {
                    arrayList = new ArrayList<SPMColDesc>();
                    hashMap.put(object2.getSubject(), arrayList);
                }
                arrayList.add(new SPMColDesc(n, l.toString(), ((TriplesBlock.Element)object).getValueName()));
            }
            ++n;
        }
        this.svpClusterList = new ArrayList<List<SPMColDesc>>();
        this.svpBestTabNameList = new ArrayList<String>();
        for (Map.Entry entry : hashMap.entrySet()) {
            this.svpClusterList.add((List<SPMColDesc>)entry.getValue());
            this.svpBestTabNameList.add(null);
            object = new ArrayList();
            for (SPMColDesc sPMColDesc : (List)entry.getValue()) {
                object.add(sPMColDesc.predUri);
            }
            this.spmComps.addSvpCluster((List<String>)object);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void filterSVPClusterList() {
        Iterator<List<SPMColDesc>> iterator = this.svpClusterList.iterator();
        ListIterator<String> listIterator = this.svpBestTabNameList.listIterator();
        while (iterator.hasNext()) {
            Object object;
            List<SPMColDesc> list = iterator.next();
            listIterator.next();
            Iterator<SPMColDesc> iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                for (String string : this.ctx.svpPropSetMap.keySet()) {
                    Set<String> set = this.ctx.svpPropSetMap.get(string);
                    if (!set.contains(((SPMColDesc)object).predId)) continue;
                    ((SPMColDesc)object).svpTabNameSet.add(string);
                }
                if (((SPMColDesc)object).svpTabNameSet.size() != 0) continue;
                iterator2.remove();
            }
            if (list.size() >= this.minClusterSize) {
                iterator2 = list.iterator();
                object = new HashMap();
                int n = 0;
                while (iterator2.hasNext()) {
                    SPMColDesc sPMColDesc = iterator2.next();
                    for (String string : sPMColDesc.svpTabNameSet) {
                        int n2 = !object.containsKey(string) ? 0 : (Integer)object.get(string);
                        object.put(string, n2 + 1);
                        if (n >= n2 + 1) continue;
                        n = n2 + 1;
                    }
                }
                if (n >= this.minClusterSize) {
                    void var7_12;
                    Object var7_11 = null;
                    int n3 = Integer.MAX_VALUE;
                    for (Map.Entry entry : object.entrySet()) {
                        int n4;
                        String string = (String)entry.getKey();
                        if ((Integer)entry.getValue() != n || (n4 = this.ctx.svpPropSetMap.get(string).size()) >= n3) continue;
                        n3 = n4;
                        String string2 = string;
                    }
                    if (n < list.size()) {
                        iterator2 = list.iterator();
                        while (iterator2.hasNext()) {
                            SPMColDesc sPMColDesc = iterator2.next();
                            if (sPMColDesc.svpTabNameSet.contains(var7_12)) continue;
                            iterator2.remove();
                        }
                    }
                    listIterator.set((String)var7_12);
                }
            }
            if (list.size() >= this.minClusterSize) continue;
            iterator.remove();
            listIterator.remove();
        }
    }

    private void buildSVPColMapping() {
        this.svpColMap = new HashMap<String, String>();
        this.svpAliasSet = new HashSet<String>();
        int n = 0;
        for (List<SPMColDesc> list : this.svpClusterList) {
            String string = "SVP" + n;
            this.svpAliasSet.add(string);
            for (SPMColDesc sPMColDesc : list) {
                String string2 = "T" + sPMColDesc.tripleId;
                this.spmCoveredTripleIds.add(sPMColDesc.tripleId);
                this.svpColMap.put(string2 + "." + this.subjectCol, string + "." + this.subjectCol);
                this.svpColMap.put(string2 + "." + this.predicateCol, string + ".P" + sPMColDesc.predId);
                this.svpColMap.put(string2 + "." + this.canonObjCol, string + ".P" + sPMColDesc.predId);
                this.svpColMap.put(string2 + "." + this.gidCol, string + ".G" + sPMColDesc.predId);
            }
            ++n;
        }
    }

    private void buildPCNChainList() {
        this.pcnChainList = new ArrayList<List<SPMColDesc>>();
        for (Map.Entry<String, List<String>> entry : this.ctx.sortedPcnPropList) {
            String string = entry.getKey();
            List<String> list = entry.getValue();
            boolean bl = true;
            while (bl) {
                List<SPMColDesc> list2 = this.matchChain(string, list);
                if (list2 != null) {
                    for (SPMColDesc sPMColDesc : list2) {
                        this.spmCoveredTripleIds.add(sPMColDesc.tripleId);
                    }
                    this.pcnChainList.add(list2);
                    continue;
                }
                bl = false;
            }
        }
    }

    private List<SPMColDesc> matchChain(String string, List<String> list) {
        ArrayList<SPMColDesc> arrayList = new ArrayList<SPMColDesc>();
        boolean bl = this.matchChain(string, list, 0, null, null, arrayList);
        if (!bl) {
            arrayList = null;
        }
        return arrayList;
    }

    private boolean matchChain(String string, List<String> list, int n, TriplesBlock.Element element, TriplesBlock.Element element2, List<SPMColDesc> list2) {
        if (n >= list.size()) {
            return true;
        }
        TriplesBlock[] triplesBlockArray = new TriplesBlock[1];
        int[] nArray = new int[1];
        String string2 = list.get(n);
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.bgp.TBList.size() && n2 < this.bgp.optionalTbStartIdx) {
            if (this.findMatch(element, string2, element2, n2, triplesBlockArray, nArray, list2)) {
                SPMColDesc sPMColDesc = new SPMColDesc(nArray[0], string2);
                sPMColDesc.svpTabNameSet.add(string);
                list2.add(sPMColDesc);
                TriplesBlock.Element element3 = QueryUtils.isForwardPred(string2) ? triplesBlockArray[0].getObject() : triplesBlockArray[0].getSubject();
                bl = this.matchChain(string, list, n + 1, element3, null, list2);
                if (bl) {
                    return true;
                }
                n2 = nArray[0] + 1;
                list2.remove(list2.size() - 1);
                continue;
            }
            return false;
        }
        return false;
    }

    private boolean findMatch(TriplesBlock.Element element, String string, TriplesBlock.Element element2, int n, TriplesBlock[] triplesBlockArray, int[] nArray, List<SPMColDesc> list) {
        boolean bl = false;
        for (int i = n; i < this.bgp.TBList.size() && i < this.bgp.optionalTbStartIdx && !bl; ++i) {
            TriplesBlock.Element element3;
            boolean bl2 = false;
            for (SPMColDesc sPMColDesc : list) {
                if (sPMColDesc.tripleId != i) continue;
                bl2 = true;
                break;
            }
            TriplesBlock triplesBlock = this.bgp.TBList.get(i);
            if (this.spmCoveredTripleIds.contains(i) || bl2 || (element3 = triplesBlock.getPredicate()).getType() != 1 || !element3.exists() || !this.predMatchesSpmPid(element3.getCanonicalID().toString(), string)) continue;
            bl = true;
            TriplesBlock.Element element4 = element;
            TriplesBlock.Element element5 = element2;
            if (QueryUtils.isReversePred(string)) {
                TriplesBlock.Element element6 = element4;
                element4 = element5;
                element5 = element6;
            }
            if (element4 != null && !triplesBlock.getSubject().equals(element4) || element5 != null && !triplesBlock.getObject().equals(element5)) {
                bl = false;
            }
            if (!bl) continue;
            triplesBlockArray[0] = triplesBlock;
            nArray[0] = i;
        }
        return bl;
    }

    private boolean predMatchesSpmPid(String string, String string2) {
        String string3 = QueryUtils.isForwardPred(string2) || QueryUtils.isReversePred(string2) ? string2.substring(1) : string2;
        int n = string3.indexOf("#");
        if (n >= 0) {
            string3 = string3.substring(0, n);
        }
        return string3.equals(string);
    }

    private void buildPCNColMapping() {
        this.pcnColMap = new HashMap<String, String>();
        this.pcnAliasSet = new HashSet<String>();
        int n = 0;
        for (List<SPMColDesc> list : this.pcnChainList) {
            String string = "PCN" + n;
            this.pcnAliasSet.add(string);
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                SPMColDesc sPMColDesc = list.get(i);
                String string2 = "T" + sPMColDesc.tripleId;
                String string3 = this.subjectCol;
                String string4 = this.canonObjCol;
                if (QueryUtils.isReversePred(sPMColDesc.predId)) {
                    object = string3;
                    string3 = string4;
                    string4 = object;
                }
                if (i == 0) {
                    object = string + (QueryUtils.isReversePred(sPMColDesc.predId) ? "." + sPMColDesc.predId : "." + this.subjectCol);
                    this.pcnColMap.put(string2 + "." + this.subjectCol, (String)object);
                    String string5 = string + (QueryUtils.isReversePred(sPMColDesc.predId) ? "." + this.subjectCol : "." + sPMColDesc.predId);
                    this.pcnColMap.put(string2 + "." + this.canonObjCol, string5);
                } else {
                    object = list.get(i - 1);
                    this.pcnColMap.put(string2 + "." + string3, string + "." + ((SPMColDesc)object).predId);
                    this.pcnColMap.put(string2 + "." + string4, string + "." + sPMColDesc.predId);
                }
                this.pcnColMap.put(string2 + "." + this.predicateCol, string + "." + sPMColDesc.predId);
                this.pcnColMap.put(string2 + "." + this.gidCol, string + ".G" + sPMColDesc.predId.substring(1));
            }
            ++n;
        }
    }

    private void buildMVPPredList() {
        this.mvpPredList = new ArrayList<SPMColDesc>();
        int n = 0;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            String string;
            TriplesBlock.Element element;
            if (!this.spmCoveredTripleIds.contains(n) && (element = triplesBlock.getPredicate()).getType() == 1 && element.exists() && this.ctx.mvpPropSet.contains(string = element.getCanonicalID().toString())) {
                this.mvpPredList.add(new SPMColDesc(n, string));
                this.spmCoveredTripleIds.add(n);
            }
            ++n;
        }
    }

    private void buildMVPColMapping() {
        this.mvpColMap = new HashMap<String, String>();
        this.mvpAliasSet = new HashSet<String>();
        int n = 0;
        for (SPMColDesc sPMColDesc : this.mvpPredList) {
            String string = "MVP" + n;
            this.mvpAliasSet.add(string);
            String string2 = "T" + sPMColDesc.tripleId;
            this.mvpColMap.put(string2 + "." + this.subjectCol, string + "." + this.subjectCol);
            this.mvpColMap.put(string2 + "." + this.predicateCol, string + ".P" + sPMColDesc.predId);
            this.mvpColMap.put(string2 + "." + this.canonObjCol, string + ".P" + sPMColDesc.predId);
            this.mvpColMap.put(string2 + "." + this.gidCol, string + ".G" + sPMColDesc.predId);
            ++n;
        }
    }

    private void popSPMAuxValInfo() {
        this.spmValColMap = new HashMap<String, String>();
        this.excludedValueTabs = new HashSet<String>();
        this.auxValueVars = new HashSet<String>();
        this.auxVarMappedAliases = new HashMap<String, String>();
        if (this.isValidForSPMValuesOpt()) {
            int n = 0;
            HashSet<String> hashSet = new HashSet<String>();
            for (TriplesBlock triplesBlock : this.bgp.TBList) {
                TriplesBlock.Element element = triplesBlock.getSubject();
                TriplesBlock.Element element2 = triplesBlock.getPredicate();
                TriplesBlock.Element element3 = triplesBlock.getObject();
                if (element2.getType() == 1 && element2.exists()) {
                    String string = element2.getCanonicalID().toString();
                    if (element.isVariable()) {
                        this.popSPMAuxValInfoForSubj(n, string, element, hashSet);
                    }
                    if (element3.isVariable()) {
                        this.popSPMAuxValInfoForObj(n, string, element3, hashSet);
                    }
                }
                ++n;
            }
        }
    }

    private void popSPMAuxValInfoForSubj(int n, String string, TriplesBlock.Element element, Set<String> set) {
        String string2 = element.getName();
        if (!(set.contains(string2) || this.isOptionalTidx(n) && this.isMultiTriplePatternVar(string2))) {
            int n2;
            String string3;
            String string4;
            String string5;
            boolean bl = false;
            SPMTabRefDesc sPMTabRefDesc = this.getSPMTabRefDesc(n, string, this.svpClusterList);
            String string6 = null;
            if (sPMTabRefDesc != null) {
                string6 = this.svpBestTabNameList.get(sPMTabRefDesc.spmTabId);
            }
            if (sPMTabRefDesc != null && this.ctx.svpSubjValTabs.contains(string6)) {
                bl = true;
                string5 = "V" + this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string2).append((String)",0").toString()).uniqueId;
                string4 = "SVP" + sPMTabRefDesc.spmTabId + ".S_";
                this.addVarMapping(string5, string4, string2);
                set.add(string2);
            }
            if (!bl && ((sPMTabRefDesc = this.getSPMTabRefDesc(n, string, this.pcnChainList)) != null && this.isFirstPredInChain(sPMTabRefDesc) && QueryUtils.isForwardPred(sPMTabRefDesc.predId) && this.ctx.pcnSubjValTabs.contains(this.getPcnTabNameForChainId(sPMTabRefDesc.spmTabId)) || sPMTabRefDesc != null && QueryUtils.isReversePred(sPMTabRefDesc.predId) && this.ctx.pcnValuePropSetMap.get(this.getPcnTabNameForChainId(sPMTabRefDesc.spmTabId)).contains(sPMTabRefDesc.predId))) {
                bl = true;
                string5 = QueryUtils.isForwardPred(sPMTabRefDesc.predId) ? "S_" : sPMTabRefDesc.predId + "_";
                string4 = "V" + this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string2).append((String)",0").toString()).uniqueId;
                string3 = "PCN" + sPMTabRefDesc.spmTabId + "." + string5;
                this.addVarMapping(string4, string3, string2);
                set.add(string2);
            }
            if (!bl && this.ctx.mvpSubjValTabs.contains(this.ctx.qualifiedMvpTabPrefix + string) && (n2 = this.getMVPAliasIdForPred(n, string)) >= 0) {
                string4 = "V" + this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string2).append((String)",0").toString()).uniqueId;
                string3 = "MVP" + n2 + ".S_";
                this.addVarMapping(string4, string3, string2);
                set.add(string2);
            }
        }
    }

    private void popSPMAuxValInfoForObj(int n, String string, TriplesBlock.Element element, Set<String> set) {
        String string2 = element.getName();
        if (!(set.contains(string2) || this.isOptionalTidx(n) && this.isMultiTriplePatternVar(string2))) {
            int n2;
            String string3;
            String string4;
            String string5;
            boolean bl = false;
            SPMTabRefDesc sPMTabRefDesc = this.getSPMTabRefDesc(n, string, this.svpClusterList);
            String string6 = null;
            if (sPMTabRefDesc != null) {
                string6 = this.svpBestTabNameList.get(sPMTabRefDesc.spmTabId);
            }
            if (sPMTabRefDesc != null && this.ctx.svpValuePropSetMap.get(string6).contains(sPMTabRefDesc.predId)) {
                bl = true;
                string5 = "V" + this.bgp.BGPelements.get((Object)new StringBuilder().append((String)element.getName()).append((String)",2").toString()).uniqueId;
                string4 = "SVP" + sPMTabRefDesc.spmTabId + ".P" + sPMTabRefDesc.predId + "_";
                this.addVarMapping(string5, string4, string2);
                set.add(string2);
            }
            if (!bl && ((sPMTabRefDesc = this.getSPMTabRefDesc(n, string, this.pcnChainList)) != null && !QueryUtils.isReversePred(sPMTabRefDesc.predId) && this.ctx.pcnValuePropSetMap.get(this.getPcnTabNameForChainId(sPMTabRefDesc.spmTabId)).contains(sPMTabRefDesc.predId) || sPMTabRefDesc != null && this.isFirstPredInChain(sPMTabRefDesc) && QueryUtils.isReversePred(sPMTabRefDesc.predId) && this.ctx.pcnSubjValTabs.contains(this.getPcnTabNameForChainId(sPMTabRefDesc.spmTabId)))) {
                bl = true;
                string5 = !QueryUtils.isReversePred(sPMTabRefDesc.predId) ? sPMTabRefDesc.predId + "_" : "S_";
                string4 = "V" + this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string2).append((String)",2").toString()).uniqueId;
                string3 = "PCN" + sPMTabRefDesc.spmTabId + "." + string5;
                this.addVarMapping(string4, string3, string2);
                set.add(string2);
            }
            if (!bl && this.ctx.mvpValuePropSet.contains(string) && (n2 = this.getMVPAliasIdForPred(n, string)) >= 0) {
                string4 = "V" + this.bgp.BGPelements.get((Object)new StringBuilder().append((String)element.getName()).append((String)",2").toString()).uniqueId;
                string3 = "MVP" + n2 + ".P" + string + "_";
                this.addVarMapping(string4, string3, string2);
                set.add(string2);
            }
        }
    }

    private boolean isFirstPredInChain(SPMTabRefDesc sPMTabRefDesc) {
        if (sPMTabRefDesc != null) {
            int n = sPMTabRefDesc.spmTabId;
            String string = sPMTabRefDesc.predId;
            List<SPMColDesc> list = this.pcnChainList.get(n);
            if (string.equals(list.get((int)0).predId)) {
                return true;
            }
        }
        return false;
    }

    private void addVarMapping(String string, String string2, String string3) {
        this.addValColMapping(this.spmValColMap, string3, string, string2);
        this.excludedValueTabs.add(string);
        if (this.ctx.spmValueProjEnabled) {
            this.auxValueVars.add(string3);
        }
    }

    private void addValColMapping(Map<String, String> map, String string, String string2, String string3) {
        String[] stringArray = new String[]{"VNAME_PREFIX", "VNAME_SUFFIX", "VALUE_TYPE", "LONG_VALUE", "LITERAL_TYPE", "LANGUAGE_TYPE", "ORDER_NUM", "ORDER_DATE", "ORDER_TYPE"};
        if (!map.containsKey(string2 + stringArray[0])) {
            for (int i = 0; i < stringArray.length; ++i) {
                map.put(string2 + "." + stringArray[i], string3 + stringArray[i]);
            }
            this.auxVarMappedAliases.put(string, string2);
        }
    }

    private String getPcnTabNameForChainId(int n) {
        return this.pcnChainList.get((int)n).get((int)0).svpTabNameSet.iterator().next();
    }

    private SPMTabRefDesc getSPMTabRefDesc(int n, String string, List<List<SPMColDesc>> list) {
        int n2 = 0;
        for (List<SPMColDesc> list2 : list) {
            for (SPMColDesc sPMColDesc : list2) {
                if (sPMColDesc.tripleId != n || !this.predMatchesSpmPid(string, sPMColDesc.predId)) continue;
                return new SPMTabRefDesc(n2, sPMColDesc.predId);
            }
            ++n2;
        }
        return null;
    }

    private int getMVPAliasIdForPred(int n, String string) {
        int n2 = 0;
        for (SPMColDesc sPMColDesc : this.mvpPredList) {
            if (sPMColDesc.tripleId == n && sPMColDesc.predId.equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private void buildExcludedTripleTabsSet() {
        this.excludedTripleTabs = new HashSet<String>();
        for (List<SPMColDesc> object : this.svpClusterList) {
            for (SPMColDesc sPMColDesc : object) {
                this.excludedTripleTabs.add("T" + sPMColDesc.tripleId);
            }
        }
        for (List<SPMColDesc> list : this.pcnChainList) {
            for (SPMColDesc sPMColDesc : list) {
                this.excludedTripleTabs.add("T" + sPMColDesc.tripleId);
            }
        }
        for (SPMColDesc sPMColDesc : this.mvpPredList) {
            this.excludedTripleTabs.add("T" + sPMColDesc.tripleId);
        }
    }

    private boolean isValidForSPMValuesOpt() {
        if (!this.ctx.spmValuesEnabled) {
            return false;
        }
        if (this.ctx.clobExpSupport) {
            return false;
        }
        for (Filter filter : this.filters) {
            if (!filter.hasSpatialFunction() && !filter.hasOracleTextFunction()) continue;
            return false;
        }
        return true;
    }

    private void dumpSVPClusterList() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=============== svpClusterArray ===============\n");
        int n = 0;
        for (List<SPMColDesc> list : this.svpClusterList) {
            stringBuffer.append("[" + n + "]->").append(list);
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpSVPColMap() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=============== svpColMap =====================\n");
        for (Map.Entry<String, String> entry : this.svpColMap.entrySet()) {
            stringBuffer.append(entry.getKey()).append("->").append(entry.getValue());
            stringBuffer.append("\n");
        }
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpSVPAliasSet() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=============== svpAliasSet ===================\n");
        stringBuffer.append(this.svpAliasSet.toString());
        stringBuffer.append("\n");
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpPCNChainList() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=============== pcnChainList ==================\n");
        int n = 0;
        for (List<SPMColDesc> list : this.pcnChainList) {
            stringBuffer.append("[" + n + "]->").append(list);
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpPCNColMap() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=============== pcnColMap =====================\n");
        for (Map.Entry<String, String> entry : this.pcnColMap.entrySet()) {
            stringBuffer.append(entry.getKey()).append("->").append(entry.getValue());
            stringBuffer.append("\n");
        }
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpPCNAliasSet() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=============== pcnAliasSet ===================\n");
        stringBuffer.append(this.pcnAliasSet.toString());
        stringBuffer.append("\n");
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpMVPPredList() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=============== mvpPredList ==================\n");
        for (SPMColDesc sPMColDesc : this.mvpPredList) {
            stringBuffer.append(sPMColDesc.toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpMVPColMap() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=============== mvpColMap =====================\n");
        for (Map.Entry<String, String> entry : this.mvpColMap.entrySet()) {
            stringBuffer.append(entry.getKey()).append("->").append(entry.getValue());
            stringBuffer.append("\n");
        }
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpMVPAliasSet() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=============== mvpAliasSet ===================\n");
        stringBuffer.append(this.mvpAliasSet.toString());
        stringBuffer.append("\n");
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpExcludedTabs() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=========== excludedTripleTabs ================\n");
        stringBuffer.append(this.excludedTripleTabs.toString());
        stringBuffer.append("\n");
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpSPMValColMap() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("============= spmValColMap ====================\n");
        for (Map.Entry<String, String> entry : this.spmValColMap.entrySet()) {
            stringBuffer.append(entry.getKey()).append("->").append(entry.getValue());
            stringBuffer.append("\n");
        }
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpExcludedValTabs() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("=========== excludedValueTabs =================\n");
        stringBuffer.append(this.excludedValueTabs.toString());
        stringBuffer.append("\n");
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    private void dumpAuxValueVars() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("============= auxValueVars ====================\n");
        stringBuffer.append(this.auxValueVars.toString());
        stringBuffer.append("\n");
        stringBuffer.append("===============================================\n");
        SimpleBGP.log(stringBuffer.toString());
    }

    @Override
    public SPMComponents extractSPMComponents() {
        this.extractAllPcnLists();
        return this.spmComps;
    }

    private void extractAllPcnLists() {
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<SPARQLTriplesBlock, Integer> hashMap = new HashMap<SPARQLTriplesBlock, Integer>();
        for (SPARQLTriplesBlock iterator : this.myTrips) {
            if (!hashSet.contains(iterator.getSubject().name) && iterator.getSubject().type == 0) {
                hashSet.add(iterator.getSubject().name);
            }
            if (!hashMap.containsKey(iterator)) {
                hashMap.put(iterator, 1);
                continue;
            }
            int sPARQLTriplesBlock = (Integer)hashMap.get(iterator) + 1;
            hashMap.replace(iterator, sPARQLTriplesBlock);
        }
        if (hashSet.size() > 1) {
            Object object;
            HashMap hashMap2 = new HashMap();
            for (String sPARQLTriplesBlockArray : hashSet) {
                hashMap2.put(sPARQLTriplesBlockArray, new ArrayList());
            }
            for (SPARQLTriplesBlock sPARQLTriplesBlock : this.myTrips) {
                object = sPARQLTriplesBlock.getSubject().name;
                if (!hashSet.contains(object) || sPARQLTriplesBlock.containsPropertyPath() || sPARQLTriplesBlock.getSubject().type != 0 || sPARQLTriplesBlock.getPredicate().type != 1) continue;
                ((List)hashMap2.get(object)).add(sPARQLTriplesBlock);
            }
            int n = this.myTrips.size();
            SPARQLTriplesBlock[] sPARQLTriplesBlockArray = new SPARQLTriplesBlock[n];
            object = new ArrayList();
            for (SPARQLTriplesBlock sPARQLTriplesBlock : this.myTrips) {
                if (!hashSet.contains(sPARQLTriplesBlock.getObject().name) || sPARQLTriplesBlock.containsPropertyPath() || sPARQLTriplesBlock.getObject().type != 0 || sPARQLTriplesBlock.getPredicate().type != 1) continue;
                int n2 = (Integer)hashMap.get(sPARQLTriplesBlock);
                hashMap.replace(sPARQLTriplesBlock, n2 - 1);
                sPARQLTriplesBlockArray[0] = sPARQLTriplesBlock;
                this.extractAllPcnListsDFS(sPARQLTriplesBlock, hashMap2, hashMap, hashSet, sPARQLTriplesBlockArray, (List<List<String>>)object, n, 1);
                hashMap.replace(sPARQLTriplesBlock, n2);
            }
            Iterator<SPARQLTriplesBlock> iterator = object.iterator();
            while (iterator.hasNext()) {
                List list = (List)((Object)iterator.next());
                this.spmComps.addPcnSequence(list);
            }
        }
    }

    private void extractAllPcnListsDFS(SPARQLTriplesBlock sPARQLTriplesBlock, Map<String, List<SPARQLTriplesBlock>> map, Map<SPARQLTriplesBlock, Integer> map2, Set<String> set, SPARQLTriplesBlock[] sPARQLTriplesBlockArray, List<List<String>> list, int n, int n2) {
        Object object;
        if (n2 >= 2) {
            object = new ArrayList();
            for (int i = 0; i < n2; ++i) {
                object.add(sPARQLTriplesBlockArray[i].getPredicate().name);
            }
            list.add((List<String>)object);
            if (n2 >= n || sPARQLTriplesBlock.getObject().type != 0 || !set.contains(sPARQLTriplesBlock.getObject().name)) {
                return;
            }
        }
        object = sPARQLTriplesBlock.getObject().name;
        for (SPARQLTriplesBlock sPARQLTriplesBlock2 : map.get(object)) {
            int n3 = map2.get(sPARQLTriplesBlock2);
            if (n3 <= 0) continue;
            sPARQLTriplesBlockArray[n2] = sPARQLTriplesBlock2;
            map2.replace(sPARQLTriplesBlock2, n3 - 1);
            this.extractAllPcnListsDFS(sPARQLTriplesBlock2, map, map2, set, sPARQLTriplesBlockArray, list, n, n2 + 1);
            map2.replace(sPARQLTriplesBlock2, n3);
        }
    }

    private static class LateralPPDesc
    implements Comparable<LateralPPDesc> {
        public final int alias;
        public final int depAlias;
        public final PPJoinPositions ppJoinPos;
        public final String ppJoinCol;
        public final PPTypes ppType;
        public final String ppPredId;
        public final String ppPred;
        public final int minOcc;
        public final int maxOcc;
        public final boolean exact;

        public LateralPPDesc(int n, int n2, PPJoinPositions pPJoinPositions, String string, PPTypes pPTypes, String string2, String string3, int n3, int n4, boolean bl) {
            this.alias = n;
            this.depAlias = n2;
            this.ppJoinPos = pPJoinPositions;
            this.ppJoinCol = string;
            this.ppType = pPTypes;
            this.ppPredId = string2;
            this.ppPred = string3;
            this.minOcc = n3;
            this.maxOcc = n4;
            this.exact = bl;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof LateralPPDesc) {
                LateralPPDesc lateralPPDesc = (LateralPPDesc)object;
                if (this.alias == lateralPPDesc.alias && this.depAlias == lateralPPDesc.depAlias && this.ppJoinPos.equals((Object)lateralPPDesc.ppJoinPos) && this.ppJoinCol.equals(lateralPPDesc.ppJoinCol) && this.ppType.equals((Object)lateralPPDesc.ppType) && this.ppPredId.equals(lateralPPDesc.ppPredId) && this.ppPred.equals(lateralPPDesc.ppPred) && this.minOcc == lateralPPDesc.minOcc && this.maxOcc == lateralPPDesc.maxOcc && this.exact == lateralPPDesc.exact) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compareTo(LateralPPDesc lateralPPDesc) {
            if (this.depAlias < lateralPPDesc.depAlias) {
                return -1;
            }
            if (this.depAlias > lateralPPDesc.depAlias) {
                return 1;
            }
            if (this.equals(lateralPPDesc)) {
                return 0;
            }
            if (this.alias < lateralPPDesc.alias) {
                return -1;
            }
            return 1;
        }

        public String toString() {
            return "[" + this.alias + "," + this.depAlias + "," + (Object)((Object)this.ppJoinPos) + "," + this.ppJoinCol + "," + (Object)((Object)this.ppType) + "," + this.ppPredId + "," + this.ppPred + "," + this.minOcc + "," + this.maxOcc + "," + this.exact + "]";
        }

        public static enum PPTypes {
            STAR_FORWARD,
            PLUS_FORWARD,
            RANGE_FORWARD,
            STAR_REVERSE,
            PLUS_REVERSE,
            RANGE_REVERSE,
            OTHER;

        }

        public static enum PPJoinPositions {
            SUBJ,
            OBJ;

        }
    }

    private static class TriplesBlockLocPair {
        public final TriplesBlock tb;
        public final int tbPos;

        public TriplesBlockLocPair(TriplesBlock triplesBlock, int n) {
            this.tb = triplesBlock;
            this.tbPos = n;
        }

        public static List<TriplesBlock> extractTBList(List<TriplesBlockLocPair> list) {
            ArrayList<TriplesBlock> arrayList = new ArrayList<TriplesBlock>(list.size());
            for (TriplesBlockLocPair triplesBlockLocPair : list) {
                arrayList.add(triplesBlockLocPair.tb);
            }
            return arrayList;
        }

        public String toString() {
            return "(pos=" + this.tbPos + ",tb=" + this.tb.toString() + ")";
        }
    }

    private static class SPMColDesc {
        public final int tripleId;
        public final String predId;
        public final String predUri;
        public Set<String> svpTabNameSet;

        public SPMColDesc(int n, String string) {
            this(n, string, null);
        }

        public SPMColDesc(int n, String string, String string2) {
            this.tripleId = n;
            this.predId = string;
            this.predUri = string2;
            this.svpTabNameSet = new HashSet<String>();
        }

        public String toString() {
            return "(T" + this.tripleId + ", pred=" + this.predId + ", uri=" + this.predUri + ", tables=" + this.svpTabNameSet + ")";
        }
    }

    private static class SPMTabRefDesc {
        public final int spmTabId;
        public final String predId;

        public SPMTabRefDesc(int n, String string) {
            this.spmTabId = n;
            this.predId = string;
        }
    }
}

