/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.HashSet;
import java.util.Set;
import oracle.spatial.rdf.server.AbstractSPARQLTreeNode;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLBGP;
import oracle.spatial.rdf.server.SPARQLTreeNode;
import oracle.spatial.rdf.server.SQLGenContext;

public class ServiceSPARQLTreeNode
extends AbstractSPARQLTreeNode
implements SPARQLTreeNode {
    public static final int VIA_GET = 1;
    public static final int VIA_POST_PAR = 2;
    public static final int VIA_POST_DIR = 3;
    private boolean silent;
    private String endpoint;
    private String graphPattern;
    private String comment;

    public ServiceSPARQLTreeNode(int n, SQLGenContext sQLGenContext, int n2, String string, String string2, boolean bl, String string3) {
        super(n, sQLGenContext, n2);
        this.endpoint = string;
        this.graphPattern = string2;
        this.silent = bl;
        this.comment = string3;
    }

    public String toSQL(Set<String> set, String string) throws RDFException {
        HashSet<String> hashSet;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("select * from table (sparql_service('");
        stringBuffer.append(this.getJenaPrefixes());
        stringBuffer.append("\nselect * where ");
        stringBuffer.append(QueryUtils.escapeSingleQuotes(this.graphPattern));
        stringBuffer.append(" ','");
        stringBuffer.append(this.endpoint);
        stringBuffer.append("','");
        Set<String> set2 = this.getCumulativeAndPushedVars();
        int n = 0;
        for (String object : set2) {
            stringBuffer.append(object);
            if (n < set2.size() - 1) {
                stringBuffer.append(" ");
            }
            ++n;
        }
        try {
            hashSet = QueryUtils.getCommonVars(set, set2);
        }
        catch (NullPointerException nullPointerException) {
            hashSet = new HashSet<String>();
        }
        if (hashSet.size() > 0) {
            stringBuffer.append("',cursor(");
            stringBuffer.append(QueryUtils.buildUnpivot(hashSet, string, false));
            stringBuffer.append("),'");
            n = 0;
            for (String string2 : hashSet) {
                if (++n > 1) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string2);
            }
            stringBuffer.append("'");
        } else {
            stringBuffer.append("',null,null");
        }
        stringBuffer.append(",' ");
        if (this.ctx.serviceProxy != "") {
            stringBuffer.append("SERVICE_PROXY=");
            stringBuffer.append(QueryUtils.escapeSingleQuotes(this.ctx.serviceProxy));
            stringBuffer.append(" ");
        }
        if (this.ctx.serviceURLCharset != "") {
            stringBuffer.append("SERVICE_URL_CHARSET=");
            stringBuffer.append(QueryUtils.escapeSingleQuotes(this.ctx.serviceURLCharset));
            stringBuffer.append(" ");
        }
        if (this.silent) {
            stringBuffer.append("SILENT=T ");
        }
        if (!this.ctx.escapeService) {
            stringBuffer.append("SERVICE_ESCAPE=F ");
        }
        if (this.ctx.httpMethod != 1) {
            stringBuffer.append("HTTP_METHOD=");
            stringBuffer.append(this.ctx.httpMethod);
            stringBuffer.append(" ");
        }
        if (this.ctx.useXMLParser) {
            stringBuffer.append("USE_XMLPARSER=T ");
        }
        if (this.ctx.nullServiceCLOB) {
            stringBuffer.append("SERVICE_CLOB=F ");
        }
        if (this.ctx.serviceNRows != "0") {
            stringBuffer.append("SERVICE_NROWS=");
            stringBuffer.append(Integer.parseInt(this.ctx.serviceNRows));
            stringBuffer.append(" ");
        }
        if (this.ctx.networkStorageForm.equals("UNESC")) {
            stringBuffer.append("STORAGE_FORM=UNESC");
            stringBuffer.append(" ");
        }
        stringBuffer.append("'))");
        return stringBuffer.toString();
    }

    private String getJenaPrefixes() {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = "";
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("HT_NS");
        hashSet.add("FS_NS");
        hashSet.add("UEAP_NS");
        hashSet.add("UEPJ_NS");
        hashSet.add("UEBV_NS");
        hashSet.add("AP_NS");
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        while (bl) {
            n2 = this.comment.indexOf("ORACLE_SEM_", n);
            if (n2 >= 0) {
                n = this.comment.indexOf("_NS", n2 += 11);
                if (n >= 0 && n - n2 <= 4) {
                    int n3;
                    string = this.comment.substring(n2, n += 3);
                    if (!hashSet.contains(string) || (n3 = this.comment.indexOf("=", n)) < 0 || (n2 = this.comment.indexOf("<", n)) < 0 || n3 >= n2) continue;
                    n = this.comment.indexOf(">", n3) + 1;
                    if (n >= 1 && n2 < n) {
                        stringBuffer.append("\nPREFIX ORACLE_SEM_");
                        stringBuffer.append(string);
                        stringBuffer.append(":");
                        stringBuffer.append(QueryUtils.escapeSingleQuotes(this.comment.substring(n2, n)));
                        continue;
                    }
                    n = n3 + 1;
                    continue;
                }
                n = n2;
                continue;
            }
            bl = false;
        }
        return stringBuffer.toString();
    }

    @Override
    public String toSQL() throws RDFException {
        return this.toSQL(null, null);
    }

    @Override
    public void setProjections() throws RDFException {
    }

    @Override
    public Set<String> getAllLexVars() {
        return this.getCumulativeAndPushedVars();
    }

    @Override
    public Set<String> getRequiredLexVars() {
        return this.getCumulativeAndPushedVars();
    }

    @Override
    public Set<String> getProjectVars() {
        return this.getCumulativeAndPushedVars();
    }

    @Override
    public void pushBGP(SPARQLBGP sPARQLBGP, String string) {
    }

    @Override
    public boolean needsParentBGPPushDown() {
        return false;
    }

    @Override
    public void propagateLexVars() throws RDFException {
    }
}

