/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.FilterException;
import oracle.spatial.rdf.server.Hint;
import oracle.spatial.rdf.server.HintGenerator;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.OracleDatabaseVersion;
import oracle.spatial.rdf.server.PPNode;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.UnDefVarFilterOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.util.Util;

public final class QueryUtils {
    static final String NO_SRID_MSG = "Unable to retrieve SRID value for semantic network";
    static final String NO_DIM_MSG = "Unable to retrieve Dimension value for semantic network";
    protected static final int DEFAULT_MASK_THRESHOLD = 4;
    private static final Pattern HINT0PATTERN = Pattern.compile("(^|\\G|\\s+)HINT0\\s*=\\s*\\{\\s*([^\\}]*)\\s*\\}(\\s+|$)", 2);
    private static final Pattern TIMESTAMP = Pattern.compile("[0-9]{4}/[0-9]{2}/[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{0,9})?");
    private static final Pattern PID_COLUMN_PATTERN = Pattern.compile("^(P|R)[\\p{Digit}]+(#[\\p{Digit}]+)?$");
    private static final Pattern PID_VALUE_COLUMN_PATTERN = Pattern.compile("^(P|R)[\\p{Digit}]+(#[\\p{Digit}]+)?_VALUE_TYPE$");
    private static final String S_VALUE_TYPE = "S_VALUE_TYPE";
    private static final Set<String> SCHEMA_PROPERTIES = new HashSet<String>();
    private static final Set<String> UNSELECTIVE_PROPERTIES;
    private static final String[] SPATIAL_FUNCTIONS;
    private static final String[] ORACLE_TEXT_FUNCTIONS;
    private static final int[] UNBOUND_PROPERTY_PATH_NODES;
    public static final int DEFAULT_PP_DEPTH = 10;
    private static final int NET_NAME_MAX_LEN = 25;

    protected static void log(String string) {
        System.out.print("\n");
        System.out.print(string);
    }

    protected static void log(String string, String string2) {
        System.out.print("\n");
        System.out.print(string);
        System.out.print(string2);
    }

    protected static boolean isEnterpriseEditionDB(Connection connection) throws SQLException {
        boolean bl = false;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = databaseMetaData.getDatabaseProductVersion().toUpperCase();
        if (string.indexOf("ENTERPRISE EDITION") > 0 || string.indexOf("EE") > 0) {
            bl = true;
        }
        return bl;
    }

    private static String extractNameFromVmView(String string, String string2) {
        String string3 = null;
        if (string != null) {
            int n = string.lastIndexOf(".");
            String string4 = string.substring(n + 1);
            if (string2 != null && string2.length() > 0) {
                string4 = string4.substring(string2.length() + 1);
            }
            n = string4.indexOf("_");
            string3 = string4.substring(n + 1);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean virtualModelUsesIMVC(SQLGenContext sQLGenContext) throws SQLException {
        boolean bl = false;
        if (sQLGenContext.vmViewName != null) {
            String string = QueryUtils.extractNameFromVmView(sQLGenContext.vmViewName, sQLGenContext.clnNetworkName);
            if (sQLGenContext.dbVersion.isCompatible(OracleDatabaseVersion.V_18c)) {
                ResultSet resultSet = null;
                Statement statement = null;
                try {
                    statement = sQLGenContext.conn.prepareStatement("SELECT /*+ RESULT_CACHE dynamic_sampling(0) */ count(*) FROM " + sQLGenContext.clnPfxForRdfObjName + "RDF_MODEL$ t WHERE model_name = ?   AND inmemory = ?");
                    statement.setString(1, string);
                    statement.setString(2, "T");
                    resultSet = statement.executeQuery();
                    if (resultSet.next() && resultSet.getInt(1) > 0) {
                        bl = true;
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean matViewsPresentForModel(Connection connection, String string, String[] stringArray, String string2, String string3) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        String string4 = null;
        if (string != null) {
            string4 = QueryUtils.getNetworkNamePfx(string3) + "SEMV_" + QueryUtils.extractNameFromVmView(string, string3);
        }
        if (string4 == null && stringArray != null && stringArray.length == 1) {
            string4 = QueryUtils.getNetworkNamePfx(string3) + "RDFM_" + stringArray[0];
        }
        if (string4 != null) {
            try {
                preparedStatement = connection.prepareStatement("SELECT /*+ RESULT_CACHE dynamic_sampling(0) */ count(*) FROM SYS.ALL_MVIEW_DETAIL_RELATIONS WHERE DETAILOBJ_NAME = ? AND OWNER=?");
                preparedStatement.setString(1, string4);
                preparedStatement.setString(2, QueryUtils.checkRemoveEnclosingQuotes(string2));
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next() && resultSet.getInt(1) > 0) {
                    bl = true;
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        return bl;
    }

    public static String getNetworkStorageForm(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string2 = "ESC";
        String string3 = "SELECT value FROM " + string + "RDF_PARAMETER WHERE namespace='NETWORK' and attribute='STORAGE_FORM'";
        try {
            preparedStatement = connection.prepareStatement(string3.toString());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string2 = resultSet.getString("VALUE");
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return string2;
    }

    public static void getSdoRdfPPFuncInfo(Connection connection, boolean[] blArray, boolean[] blArray2) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "SELECT /*+ result_cache dynamic_sampling(0) parallel(1) */ argument_name FROM SYS.ALL_ARGUMENTS WHERE OWNER='MDSYS' AND OBJECT_NAME='SDO_RDF_PP' AND PACKAGE_NAME='SDO_RDF'";
        try {
            preparedStatement = connection.prepareStatement(string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                bl = true;
                string = resultSet.getString(1);
                if (!"MIN_OCC".equals(string)) continue;
                bl2 = true;
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        blArray[0] = bl;
        blArray2[0] = bl2;
    }

    public static void getNetworkSpatialInfo(Connection connection, boolean[] blArray, long[] lArray, String[] stringArray, String[] stringArray2, String[] stringArray3, boolean bl, String string, String string2) throws RDFException, SQLException {
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        String string3 = string;
        if (string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"') {
            string3 = string3.substring(1, string3.length() - 1);
        }
        String string4 = QueryUtils.getNetworkNamePfx(string2) + "RDF_VALUE$";
        String string5 = "SELECT /*+ dynamic_sampling(0) result_cache */  md.srid as srid, md.column_name as col FROM   all_sdo_geom_metadata md WHERE  md.owner = ? AND        md.table_name = ? AND        (md.column_name = ? OR         md.column_name like ?)";
        try {
            preparedStatement = connection.prepareStatement(string5);
            preparedStatement.setString(1, string3);
            preparedStatement.setString(2, string4);
            preparedStatement.setString(3, "GEOM");
            preparedStatement.setString(4, "MDSYS.SDO_RDF.GETV$GEOMETRYVAL(VALUE_TYPE,VNAME_PREFIX,VNAME_SUFFIX,LITERAL_TYPE,LANGUAGE_TYPE,LONG_VALUE,%");
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                lArray[0] = resultSet.getLong(1);
                stringArray[0] = resultSet.getString(2);
                blArray[0] = stringArray[0].equals("GEOM");
            } else if (bl) {
                throw new RDFException(NO_SRID_MSG);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RDFException(NO_SRID_MSG);
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        if (stringArray[0] != null) {
            resultSet = null;
            preparedStatement = null;
            string5 = "select /*+ dynamic_sampling(0) result_cache */  'sdo_dim_element('''||  d.sdo_dimname ||''',''' ||  d.sdo_lb || ''',''' ||  d.sdo_ub || ''',''' ||  d.sdo_tolerance ||''')' as dim,  d.sdo_tolerance as tol from table  (SELECT md.diminfo   FROM all_sdo_geom_metadata md   WHERE md.owner = ?   AND   md.table_name = ?   AND   md.column_name = ?) d";
            try {
                preparedStatement = connection.prepareStatement(string5);
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string4);
                preparedStatement.setString(3, stringArray[0]);
                resultSet = preparedStatement.executeQuery();
                StringBuffer stringBuffer = new StringBuffer("sdo_dim_array(");
                boolean bl2 = true;
                while (resultSet.next()) {
                    if (!bl2) {
                        stringBuffer.append(",");
                    } else {
                        stringArray2[0] = resultSet.getString(2);
                    }
                    stringBuffer.append(resultSet.getString(1));
                    bl2 = false;
                }
                if (bl2) {
                    throw new RDFException(NO_DIM_MSG);
                }
                stringBuffer.append(")");
                stringArray3[0] = stringBuffer.toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RDFException(NO_DIM_MSG);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    protected static boolean isValidForSPMOpt(SQLGenContext sQLGenContext) {
        boolean bl = true;
        if (!sQLGenContext.spmEnabled) {
            bl = false;
        } else if (sQLGenContext.useExactValue) {
            bl = false;
        } else if (sQLGenContext.models != null && sQLGenContext.models.length > 1 || sQLGenContext.vmViewName != null && sQLGenContext.vmViewName.length() > 0) {
            bl = false;
        } else if (sQLGenContext.precompIdxName != null && sQLGenContext.precompIdxName.length() > 0 || sQLGenContext.precompIdxID != 0L) {
            bl = false;
        } else if (sQLGenContext.policyName != null && sQLGenContext.policyName.length() > 0 || sQLGenContext.minLabel != null && sQLGenContext.minLabel.length() > 0) {
            bl = false;
        } else if (sQLGenContext.asOfClause != null && sQLGenContext.asOfClause.length() > 0) {
            bl = false;
        } else if (sQLGenContext.defaultMIDs != null && sQLGenContext.defaultMIDs.length > 0 || sQLGenContext.defaultModels != null && sQLGenContext.defaultModels.length > 0 || sQLGenContext.allUnnamedTrips || sQLGenContext.entUnnamedTrips || sQLGenContext.nonEmptyNamed) {
            bl = false;
        }
        return bl;
    }

    public static String convertToPre23cSPMPrefix(String string) {
        return string.replace("+", "");
    }

    public static Map<String, List<String>> getSPMTabsInfo(Connection connection, String string, String string2, String string3, String string4) throws SQLException {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        String string5 = QueryUtils.checkRemoveEnclosingQuotes(string);
        String string6 = "SELECT /*+ DYNAMIC_SAMPLING(0) RESULT_CACHE */   table_name, column_name FROM ( (SELECT a.table_name table_name, a.column_name column_name, a.column_id column_id   FROM sys.all_tab_columns a   WHERE a.table_name like ? AND a.owner = ?)  UNION ALL  (SELECT a.table_name table_name, a.column_name column_name, a.column_id column_id   FROM sys.all_tab_columns a   WHERE a.table_name like ? AND a.owner = ?)  UNION ALL  (SELECT a.table_name table_name, a.column_name column_name, a.column_id column_id   FROM sys.all_tab_columns a   WHERE a.table_name like ? AND a.owner = ?) ) ORDER BY table_name, column_id ASC";
        String[] stringArray = new String[]{string2 + "%", string5, string3 + "%", string5, string4 + "%", string5};
        QueryUtils.popSPMTabsInfo(connection, hashMap, string6, stringArray);
        if (hashMap.isEmpty()) {
            String string7 = "SELECT /*+ DYNAMIC_SAMPLING(0) RESULT_CACHE */   table_name, column_name FROM ( (SELECT a.table_name table_name, a.column_name column_name, a.column_id column_id   FROM sys.all_tab_columns a   WHERE a.table_name like ? AND a.owner = ? AND INSTR(a.table_name, ?) = 0)  UNION ALL  (SELECT a.table_name table_name, a.column_name column_name, a.column_id column_id   FROM sys.all_tab_columns a   WHERE a.table_name like ? AND a.owner = ? AND INSTR(a.table_name, ?) = 0)  UNION ALL  (SELECT a.table_name table_name, a.column_name column_name, a.column_id column_id   FROM sys.all_tab_columns a   WHERE a.table_name like ? AND a.owner = ? AND INSTR(a.table_name, ?) = 0) ) ORDER BY table_name, column_id ASC";
            String[] stringArray2 = new String[]{QueryUtils.convertToPre23cSPMPrefix(string2) + "%", string5, "+", QueryUtils.convertToPre23cSPMPrefix(string3) + "%", string5, "+", QueryUtils.convertToPre23cSPMPrefix(string4) + "%", string5, "+"};
            QueryUtils.popSPMTabsInfo(connection, hashMap, string7, stringArray2);
        }
        return hashMap;
    }

    private static void popSPMTabsInfo(Connection connection, Map<String, List<String>> map, String string, String[] stringArray) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string2 = null;
        String string3 = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            for (int i = 0; i < stringArray.length; ++i) {
                preparedStatement.setString(i + 1, stringArray[i]);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
                string3 = resultSet.getString(2);
                List<String> list = map.get(string2);
                if (list == null) {
                    list = new ArrayList<String>();
                    map.put(string2, list);
                }
                list.add(string3);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    protected static Map<String, Set<String>> getSvpProperties(String string, Map<String, List<String>> map) {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        for (String string2 : map.keySet()) {
            if (!string2.startsWith(string)) continue;
            HashSet<String> hashSet = new HashSet<String>();
            List<String> list = map.get(string2);
            for (String string3 : list) {
                if (!PID_COLUMN_PATTERN.matcher(string3).matches()) continue;
                hashSet.add(string3.substring(1));
            }
            hashMap.put(string2, hashSet);
        }
        return hashMap;
    }

    protected static Set<String> getMvpProperties(String string, Map<String, List<String>> map) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : map.keySet()) {
            if (!string2.startsWith(string)) continue;
            hashSet.add(string2.substring(string.length()));
        }
        return hashSet;
    }

    protected static List<Map.Entry<String, List<String>>> getSortedPcnPropList(String string, Map<String, List<String>> map) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (String string2 : map.keySet()) {
            if (!string2.startsWith(string)) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            List<String> list = map.get(string2);
            for (String string3 : list) {
                if (!PID_COLUMN_PATTERN.matcher(string3).matches()) continue;
                arrayList.add(string3);
            }
            hashMap.put(string2, arrayList);
        }
        return QueryUtils.sortPcnPropListMap(hashMap);
    }

    private static List<Map.Entry<String, List<String>>> sortPcnPropListMap(Map<String, List<String>> map) {
        ArrayList<Map.Entry<String, List<String>>> arrayList = new ArrayList<Map.Entry<String, List<String>>>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            QueryUtils.addToSortedPcnList(arrayList, entry);
        }
        return arrayList;
    }

    private static void addToSortedPcnList(List<Map.Entry<String, List<String>>> list, Map.Entry<String, List<String>> entry) {
        boolean bl = false;
        for (int i = 0; i < list.size() && !bl; ++i) {
            Map.Entry<String, List<String>> entry2 = list.get(i);
            if (entry2.getValue().size() >= entry.getValue().size()) continue;
            list.add(i, entry);
            bl = true;
        }
        if (!bl) {
            list.add(entry);
        }
    }

    protected static Set<String> getSpmSubjValTabs(String string, Map<String, List<String>> map) {
        HashSet<String> hashSet = new HashSet<String>();
        block0: for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            for (String string2 : entry.getValue()) {
                String string3 = entry.getKey();
                if (!string3.startsWith(string) || !string2.equals(S_VALUE_TYPE)) continue;
                hashSet.add(string3);
                continue block0;
            }
        }
        return hashSet;
    }

    protected static Map<String, Set<String>> getSvpValueProperties(String string, Map<String, List<String>> map) {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        for (String string2 : map.keySet()) {
            if (!string2.startsWith(string)) continue;
            Set<String> set = QueryUtils.getValueProperties(map.get(string2), 1);
            hashMap.put(string2, set);
        }
        return hashMap;
    }

    protected static Map<String, Set<String>> getPcnValueProperties(String string, Map<String, List<String>> map) {
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        for (String string2 : map.keySet()) {
            if (!string2.startsWith(string)) continue;
            Set<String> set = QueryUtils.getValueProperties(map.get(string2), 0);
            hashMap.put(string2, set);
        }
        return hashMap;
    }

    protected static Set<String> getMvpValueProperties(String string, Map<String, List<String>> map) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if (!entry.getKey().startsWith(string)) continue;
            hashSet.addAll(QueryUtils.getValueProperties(entry.getValue(), 1));
        }
        return hashSet;
    }

    protected static Set<String> getValueProperties(List<String> list, int n) {
        HashSet<String> hashSet = new HashSet<String>();
        if (list != null) {
            for (String string : list) {
                if (!PID_VALUE_COLUMN_PATTERN.matcher(string).matches()) continue;
                hashSet.add(string.substring(n, string.indexOf("_")));
            }
        }
        return hashSet;
    }

    public static String checkRemoveEnclosingQuotes(String string) {
        if (string != null && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String getSvpTabPrefix(String string, String string2) {
        String string3 = QueryUtils.getNetworkNamePfx(string2);
        return string3 + "RDF_XT$SVP_" + string + "+";
    }

    public static String getMvpTabPrefix(String string, String string2) {
        String string3 = QueryUtils.getNetworkNamePfx(string2);
        return string3 + "RDF_XT$MVP_" + string + "+" + "_P";
    }

    public static String getPcnTabPrefix(String string, String string2) {
        String string3 = QueryUtils.getNetworkNamePfx(string2);
        return string3 + "RDF_XT$PCN_" + string + "+";
    }

    public static boolean isSvpOrPcnPossible(SQLGenContext sQLGenContext) {
        boolean bl = false;
        if (sQLGenContext.spmEnabled && (sQLGenContext.svpEnabled || sQLGenContext.pcnEnabled)) {
            if (sQLGenContext.svpEnabled && sQLGenContext.svpPropSetMap != null && !sQLGenContext.svpPropSetMap.isEmpty()) {
                bl = true;
            } else if (sQLGenContext.pcnEnabled && sQLGenContext.sortedPcnPropList != null && !sQLGenContext.sortedPcnPropList.isEmpty()) {
                bl = true;
            }
        }
        return bl;
    }

    public static int combineSelectivity(int n, int n2) {
        int n3 = 0;
        if (n == 1 || n2 == 1) {
            n3 = 1;
        }
        return n3;
    }

    public static String updateLinkHintForAllHash(String string) {
        int n;
        String string2 = string;
        if (string2 == null) {
            string2 = new String("");
        }
        String string3 = string2.toUpperCase();
        boolean bl = false;
        boolean bl2 = false;
        if (HintGenerator.LINK_JOIN_REGEX_PATTERN.matcher(string3).matches()) {
            bl = true;
            bl2 = true;
        }
        for (n = 0; n < HintGenerator.LINK_JOIN_HINTS.length && !bl; ++n) {
            if (string3.indexOf(HintGenerator.LINK_JOIN_HINTS[n]) < 0) continue;
            bl = true;
        }
        for (n = 0; n < HintGenerator.SPM_JOIN_HINTS.length && !bl2; ++n) {
            if (string3.indexOf(HintGenerator.SPM_JOIN_HINTS[n]) < 0) continue;
            bl2 = true;
        }
        if (!bl) {
            string2 = string2 + " " + Hint.QueryOption.ALL_LINK_HASH.getName() + " ";
        }
        if (!bl2) {
            string2 = string2 + " " + Hint.QueryOption.ALL_SPM_HASH.getName() + " ";
        }
        return string2;
    }

    public static String updateValueHintForAllHash(String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = new String("");
        }
        String string3 = string2.toUpperCase();
        boolean bl = false;
        if (HintGenerator.VALUE_JOIN_REGEX_PATTERN.matcher(string3).matches()) {
            bl = true;
        }
        for (int i = 0; i < HintGenerator.VALUE_JOIN_HINTS.length && !bl; ++i) {
            if (string3.indexOf(HintGenerator.VALUE_JOIN_HINTS[i]) < 0) continue;
            bl = true;
        }
        if (!bl) {
            string2 = string2 + " " + Hint.QueryOption.ALL_LOCAL_VALUE_HASH.getName() + " ";
            string2 = string2 + " " + Hint.QueryOption.ALL_NONLOCAL_VALUE_HASH.getName() + " ";
        }
        return string2;
    }

    public static OracleDatabaseVersion getDatabaseVersion(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = databaseMetaData.getDatabaseProductVersion();
        if (string.indexOf(" 10.2") >= 0) {
            return OracleDatabaseVersion.V_10_2;
        }
        if (string.indexOf(" 11.1") >= 0) {
            return OracleDatabaseVersion.V_11_1;
        }
        if (string.indexOf(" 11.2") >= 0) {
            return OracleDatabaseVersion.V_11_2;
        }
        if (string.indexOf(" 12.1") >= 0) {
            return OracleDatabaseVersion.V_12_1;
        }
        if (string.indexOf(" 12.2") >= 0) {
            return OracleDatabaseVersion.V_12_2;
        }
        if (string.indexOf(" 18.") >= 0) {
            return OracleDatabaseVersion.V_18c;
        }
        if (string.indexOf(" 19.") >= 0) {
            return OracleDatabaseVersion.V_19c;
        }
        if (string.indexOf(" 20.") >= 0) {
            return OracleDatabaseVersion.V_20c;
        }
        if (string.indexOf(" 21.") >= 0) {
            return OracleDatabaseVersion.V_21c;
        }
        return OracleDatabaseVersion.V_22c;
    }

    public static String qualifiedSQLName(Connection connection, String string) throws SQLException {
        return Util.qualifiedSQLName((Connection)connection, (String)string);
    }

    public static String enquoteNameSQLName(String string) throws SQLException {
        return Util.enquoteNameSQLName((String)string, (boolean)false);
    }

    public static String simpleSQLName(String string, int n) throws SQLException {
        return Util.checkSQLName((String)string, (int)n);
    }

    public static String enquoteLiteral(String string) throws SQLException {
        return "'" + string.replace("'", "''") + "'";
    }

    public static String validateAndGetPfxForRdfObjName(String string, String string2) throws SQLException {
        String string3 = QueryUtils.getNetworkOwnerOrMdsys(string);
        String string4 = QueryUtils.getNetworkNameOrEmptyString(string2);
        return QueryUtils.getPfxForRdfObjName(string3, string4);
    }

    public static String getPfxForRdfObjName(String string, String string2) {
        return string + "." + QueryUtils.getNetworkNamePfx(string2);
    }

    public static String getNetworkOwnerOrMdsys(String string) {
        String string2 = null;
        string2 = string == null || string.length() == 0 ? "MDSYS" : string;
        try {
            string2 = QueryUtils.enquoteNameSQLName(string2);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
        return string2;
    }

    public static String getNetworkNameOrEmptyString(String string) throws SQLException {
        String string2 = "";
        if (string != null && string.length() > 0) {
            string2 = string.toUpperCase();
            string2 = QueryUtils.simpleSQLName(string, 25);
        }
        return string2;
    }

    public static String getNetworkNamePfx(String string) {
        String string2 = null;
        string2 = string == null || string.length() == 0 ? "" : string.toUpperCase() + "#";
        return string2;
    }

    protected static String getLocalValueDollarName(String string) {
        return string + "RDF_VALUE$";
    }

    protected static String getLocalNamespaceDollarName(String string) {
        return string + "RDF_NAMESPACE$";
    }

    public static String valueNamePrefix(String string, String string2) {
        String string3 = string;
        String string4 = string.replace("/", ":").replace("#", ":");
        int n = string4.lastIndexOf(":");
        if (n >= 0 && (string2.equals("UR") || string2.equals("URI"))) {
            string3 = string.substring(0, n + 1);
            if (string.length() - string3.length() > 128) {
                string3 = string;
            }
        }
        return string3;
    }

    protected static boolean isSchemaProperty(String string) {
        return SCHEMA_PROPERTIES.contains(string);
    }

    public static boolean isUnselectiveProperty(String string) {
        return UNSELECTIVE_PROPERTIES.contains(string);
    }

    protected static boolean hasSpatialFunction(Node node) {
        return OptimizerUtils.containsFunction(node, SPATIAL_FUNCTIONS, null);
    }

    protected static boolean hasOracleTextFunction(Node node) {
        return OptimizerUtils.containsFunction(node, ORACLE_TEXT_FUNCTIONS, null);
    }

    protected static boolean hasUnboundPropertyPath(Node node) {
        return OptimizerUtils.containsNodeType(node, UNBOUND_PROPERTY_PATH_NODES);
    }

    protected static int getMaxPPDepth(Map<Hint.QueryOption, String> map) {
        String string;
        int n = 10;
        if (map != null && (string = map.get((Object)Hint.QueryOption.MAX_PP_DEPTH)) != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                QueryUtils.log("Error reading MAX_PP_DEPTH for\n" + string + "\n" + exception.getMessage());
            }
        }
        return n;
    }

    protected static String buildSQLCollectionStr(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(string).append("(");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("'").append(stringArray[i]).append("'");
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected static String buildSQLCollectionStr(String string, long[] lArray, SQLGenContext sQLGenContext) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(string).append("(");
        if (lArray != null) {
            for (int i = 0; i < lArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(lArray[i] == 0L ? QueryUtils.getNonExistingGidQ(sQLGenContext) : Long.toString(lArray[i]));
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected static String extractParenValue(String string, int n, String string2) {
        String string3 = null;
        String string4 = "Error extracting value for " + string2;
        int n2 = string.indexOf("(", n);
        if (n2 >= 0) {
            int n3 = string.indexOf(")", n2);
            if (n3 > n2 + 1) {
                string3 = string.substring(n2 + 1, n3).trim();
            } else {
                QueryUtils.log(string4);
            }
        } else {
            QueryUtils.log(string4);
        }
        return string3;
    }

    protected static String wrapSQLforNumeric(String string) {
        String string2 = "";
        string2 = "to_number(" + string + ")";
        return string2;
    }

    protected static String buildVidHash(String string) {
        return "round(sys_op_combined_hash(" + string + ")/2)";
    }

    protected static String buildSubQForCLOB(String string, String string2, String string3, String string4, String string5) throws SQLException {
        String string6 = QueryUtils.simpleSQLName(QueryUtils.getNetworkNamePfx(string5) + "C_PK_VID", 128);
        String string7 = "(CASE WHEN " + string3 + " LIKE 'ORALL%' THEN (SELECT /*+ INDEX(V " + string6 + ") */ V." + "LONG_VALUE" + " FROM " + string4 + " V WHERE V." + "VALUE_ID" + "=" + string2 + ") ELSE NULL END)";
        return string7;
    }

    protected static String buildInLineRDFT(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string5 = string;
        if (bl) {
            string5 = "(CASE WHEN (" + string4 + "='" + "http://www.w3.org/2001/XMLSchema#time" + "' AND SUBSTR(" + string5 + ",1,1) IN ('@','+','-')) THEN SUBSTR(" + string5 + ",2) ELSE " + string5 + " END)";
        }
        string5 = "REPLACE(" + string5 + ",chr(0))";
        String string6 = string3;
        if (bl2) {
            string6 = "LOWER(" + string3 + ")";
        }
        stringBuffer.append("CASE WHEN " + string2 + " IS NULL\n");
        stringBuffer.append("THEN NULL\n");
        stringBuffer.append("WHEN " + string2 + " IN " + "('UR','URI')" + "\n");
        stringBuffer.append("THEN '<' || " + string + " || '>'\n");
        stringBuffer.append("WHEN " + string2 + " IN " + "('BL','BLN','BN')" + "\n");
        stringBuffer.append("THEN " + string + "\n");
        stringBuffer.append("ELSE\n");
        stringBuffer.append("'\"' || " + string5 + " || '\"' || ");
        stringBuffer.append("NVL2(" + string3 + ",'@' || " + string6 + ",'') || ");
        stringBuffer.append("NVL2(" + string4 + ",'^^<' || " + string4 + " || '>', '')");
        stringBuffer.append("END");
        return stringBuffer.toString();
    }

    protected static void genOuterSelectComponents(Set<String> set, Set<String> set2, Map<String, List<String>> map, String[] stringArray, String[] stringArray2, Map<String, String> map2, String string, Set<String> set3, boolean bl, String string2) throws SQLException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        for (String string3 : set) {
            map2.put(string3.toUpperCase(), "V" + n);
            String string4 = QueryUtils.buildVTYPCaseForVar("V" + n);
            ArrayList<String> arrayList = new ArrayList<String>(8);
            arrayList.add("V" + n + "." + "VNAME_PREFIX" + " || V" + n + "." + "VNAME_SUFFIX");
            arrayList.add("V" + n + "." + "VALUE_ID");
            arrayList.add("V" + n + "." + "VNAME_PREFIX");
            arrayList.add("V" + n + "." + "VNAME_SUFFIX");
            arrayList.add(string4);
            if (set3.contains(string3)) {
                if (bl) {
                    arrayList.add(QueryUtils.buildSubQForCLOB(string3, (String)arrayList.get(1), (String)arrayList.get(2), string, string2));
                } else {
                    arrayList.add("V" + n + "." + "LONG_VALUE");
                }
            } else {
                arrayList.add("TO_CLOB(NULL)");
            }
            arrayList.add("V" + n + "." + "LITERAL_TYPE");
            arrayList.add("V" + n + "." + "LANGUAGE_TYPE");
            map.put(string3.toUpperCase(), arrayList);
            stringBuffer.append(", " + string + " V" + n);
            if (set2.contains(string3)) {
                stringBuffer2.append(" AND (R." + string3 + "$RDFVID" + " = V" + n + "." + "VALUE_ID" + ")");
            } else {
                stringBuffer2.append(" AND (R." + string3 + "$RDFVID" + " = V" + n + "." + "VALUE_ID" + "(+))");
            }
            ++n;
        }
        stringArray[0] = stringBuffer.toString();
        stringArray2[0] = stringBuffer2.toString();
    }

    protected static void genOuterSelectComponents(Set<String> set, Set<String> set2, Map<String, List<String>> map, String[] stringArray, String[] stringArray2, Map<String, String> map2, String string, SQLGenContext sQLGenContext) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        String string2 = QueryUtils.enquoteLiteral(QueryUtils.getLocalValueDollarName(sQLGenContext.clnPfxForRdfObjName));
        String string3 = QueryUtils.enquoteLiteral(QueryUtils.getNetworkNamePfx(sQLGenContext.clnNetworkName));
        String string4 = QueryUtils.enquoteLiteral(sQLGenContext.clnNetworkName);
        String string5 = QueryUtils.enquoteLiteral(sQLGenContext.clnNetworkOwner);
        if ((sQLGenContext.contextFlags & 8) > 0) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string6 : set) {
                ArrayList<String> arrayList = new ArrayList<String>(8);
                String string7 = string6.toUpperCase();
                map2.put(string7, "R." + string7);
                hashSet.add(string6);
                arrayList.add("mdsys.sdo_rdf.GetPref(R." + string7 + "$RDFVID" + "," + string5 + "," + string4 + ") || mdsys.sdo_rdf.GetSuff(R." + string7 + "$RDFVID" + "," + string5 + "," + string4 + ")");
                arrayList.add("R." + string7 + "$RDFVID");
                arrayList.add("mdsys.sdo_rdf.GetPref(R." + string7 + "$RDFVID" + "," + string5 + "," + string4 + ")");
                arrayList.add("mdsys.sdo_rdf.GetSuff(R." + string7 + "$RDFVID" + "," + string5 + "," + string4 + ")");
                arrayList.add("mdsys.sdo_rdf.GetValTyp(R." + string7 + "$RDFVID" + "," + string5 + "," + string4 + ")");
                arrayList.add("TO_CLOB(NULL)");
                arrayList.add("mdsys.sdo_rdf.GetLitType(R." + string7 + "$RDFVID" + "," + string5 + "," + string4 + ")");
                arrayList.add("mdsys.sdo_rdf.GetLangType(R." + string7 + "$RDFVID" + "," + string5 + "," + string4 + ")");
                map.put(string7, arrayList);
            }
            sQLGenContext.vjoinVars = hashSet;
        }
        stringArray[0] = stringBuffer.toString();
        stringArray2[0] = stringBuffer2.toString();
    }

    protected static String buildVTYPCaseForVar(String string) {
        String string2 = " (CASE WHEN " + string + "." + "VALUE_TYPE" + " IS NULL THEN NULL WHEN " + string + "." + "VALUE_TYPE" + " IN ('UR','" + "URI" + "') THEN '" + "URI" + "'\n WHEN " + string + "." + "VALUE_TYPE" + " IN ('BN', '" + "BLN" + "') THEN '" + "BLN" + "'\n ELSE '" + "LIT" + "'\nEND) ";
        return string2;
    }

    protected static ASTTripleAtom maskVar(String string) {
        ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
        aSTTripleAtom.type = 0;
        aSTTripleAtom.name = string + "$";
        return aSTTripleAtom;
    }

    protected static boolean isMasked(ASTTripleAtom aSTTripleAtom) {
        boolean bl = false;
        if (aSTTripleAtom != null && aSTTripleAtom.type == 0 && aSTTripleAtom.name.endsWith("$")) {
            bl = true;
        }
        return bl;
    }

    protected static String unMaskVar(String string) {
        return string.substring(0, string.length() - 1);
    }

    protected static String buildAliasExpr(SQLGenContext sQLGenContext, String string, String string2) {
        if (!sQLGenContext.disableAliasOpt && string.endsWith(string2) && string.matches("^\\w+\\." + string2.replace("$", "\\$") + "$")) {
            return string;
        }
        return string + " AS " + string2;
    }

    protected static String buildFuncCall(String string, int[] nArray, List<String> list) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(string).append("(");
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(list.get(nArray[i]));
            bl = true;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected static boolean containsAny(Set<String> set, Set<String> set2) {
        if (set != null && !set.isEmpty()) {
            for (String string : set2) {
                if (!set.contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    protected static Set<String> getCommonVars(Set<String> set, Set<String> set2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (!set2.contains(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    protected static Set<String> getUnion(Set<String> set, Set<String> set2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(set);
        hashSet.addAll(set2);
        return hashSet;
    }

    protected static Set<String> getDistinctVars(Set<String> set, Set<String> set2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (set2.contains(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    protected static boolean isSafeTabName(String string) {
        if (string.contains("(") || string.contains(")") || string.contains(";") || string.contains("'") || string.contains("\"") || string.contains(",")) {
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("SELECT");
        hashSet.add("FROM");
        hashSet.add("WHERE");
        hashSet.add("UNION");
        hashSet.add("JOIN");
        StringTokenizer stringTokenizer = new StringTokenizer(string.toUpperCase());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!hashSet.contains(string2)) continue;
            return false;
        }
        return true;
    }

    protected static boolean isSafeTimestamp(String string) {
        return TIMESTAMP.matcher(string).matches();
    }

    protected static String extractBracketedOption(String string, String string2) {
        String string3 = null;
        int n = string.indexOf(string2 + "=[");
        if (n >= 0) {
            string3 = QueryUtils.extractUntil(string, n + string2.length() + 2, ']');
        }
        return string3;
    }

    protected static String extractPlainOption(String string, String string2) {
        String string3 = null;
        int n = string.indexOf(string2 + "=");
        if (n >= 0) {
            n = n + string2.length() + 1;
            int n2 = string.indexOf(" ", n);
            int n3 = string.indexOf("\t", n);
            int n4 = string.indexOf("\n", n);
            if (n2 > n3 && n3 != -1) {
                n2 = n3;
            }
            if (n2 > n4 && n4 != -1) {
                n2 = n4;
            }
            if (n2 == -1) {
                n2 = string.length();
            }
            string3 = string.substring(n, n2);
        }
        return string3;
    }

    protected static String extractUntil(String string, int n, char c) {
        String string2 = "";
        int n2 = n;
        if (n2 <= string.length()) {
            char c2 = ' ';
            boolean bl = false;
            while (!bl && n2 <= string.length()) {
                c2 = string.charAt(n2);
                if (c2 == c) {
                    bl = true;
                } else {
                    string2 = string2 + String.valueOf(c2);
                }
                ++n2;
            }
        }
        return string2;
    }

    protected static void appendToList(StringBuffer stringBuffer, String string, String string2, String string3) {
        if (stringBuffer.length() == string3.length() && stringBuffer.toString().equalsIgnoreCase(string3)) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(string2 + string);
        }
    }

    protected static String appendToList(String string, String string2, String string3, String string4) {
        String string5 = "";
        string5 = string.equalsIgnoreCase(string4) ? string + string2 : string + string3 + string2;
        return string5;
    }

    protected static boolean selectNeeded(boolean bl, boolean bl2, boolean bl3, int[] nArray, int[] nArray2, int[] nArray3) {
        boolean bl4 = false;
        if (nArray2[0] < nArray.length && nArray3[0] == nArray[nArray2[0]] || bl2) {
            bl4 = true;
        }
        if ((!bl3 || bl) && bl4 && nArray2[0] < nArray.length && nArray3[0] == nArray[nArray2[0]]) {
            nArray2[0] = nArray2[0] + 1;
        }
        if (!bl3 || bl) {
            nArray3[0] = nArray3[0] + 1;
        }
        return bl4;
    }

    protected static String buildMaskedInListClause(String[] stringArray, Set<String> set, Set<String> set2, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String string, String string2, String string3, String string4, boolean bl, String string5, SQLGenContext sQLGenContext) throws RDFException {
        int n;
        CharSequence charSequence;
        String[] stringArray6 = new String[stringArray.length];
        String[] stringArray7 = new String[stringArray.length];
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            charSequence = stringArray[i];
            string7 = stringArray2[i];
            string9 = stringArray3[i];
            if (!set.contains(charSequence)) {
                string7 = "NVL(" + stringArray2[i] + "," + stringArray4[i] + ")";
                arrayList.add(i);
                arrayList3.add(stringArray4[i]);
            }
            if (!set2.contains(charSequence)) {
                string9 = "NVL(" + stringArray3[i] + "," + stringArray5[i] + ")";
                arrayList2.add(i);
                arrayList4.add(stringArray5[i]);
            }
            stringArray6[i] = string7;
            stringArray7[i] = string9;
        }
        String[] stringArray8 = new String[stringArray.length];
        charSequence = new StringBuffer("");
        String string10 = "";
        String string11 = "";
        int n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            String string12 = stringArray[n];
            string10 = stringArray2[n];
            string11 = stringArray3[n];
            if (!set.contains(string12)) {
                string10 = !stringArray4[n].startsWith("'") ? "COALESCE(" + QueryUtils.wrapSQLforNumeric(stringArray2[n]) + "," + QueryUtils.wrapSQLforNumeric(stringArray3[n]) + "," + stringArray4[n] + ")" : "COALESCE(" + stringArray2[n] + "," + stringArray3[n] + "," + stringArray4[n] + ")";
            }
            if (!set2.contains(string12)) {
                string11 = !stringArray5[n].startsWith("'") ? "COALESCE(" + QueryUtils.wrapSQLforNumeric(stringArray3[n]) + "," + QueryUtils.wrapSQLforNumeric(stringArray2[n]) + "," + stringArray5[n] + ")" : "COALESCE(" + stringArray3[n] + "," + stringArray2[n] + "," + stringArray5[n] + ")";
                ++n2;
            }
            stringArray8[n] = string10 + " = " + string11;
        }
        n = 0;
        for (int i = 0; i < stringArray8.length; ++i) {
            if (n != 0) {
                ((StringBuffer)charSequence).append(" AND\n");
            }
            ((StringBuffer)charSequence).append(stringArray8[i]);
            n = 1;
        }
        if (!bl && n2 == stringArray.length) {
            String string13 = QueryUtils.buildAllColCoalesce(stringArray3, stringArray5);
            if (n != 0) {
                ((StringBuffer)charSequence).append(" AND\n");
            }
            ((StringBuffer)charSequence).append(string13 + " IS NOT NULL");
        }
        if (arrayList.size() > 32 || arrayList2.size() > 32) {
            throw new RDFException("Limit of 32 potentially unbound variables exceeded in negation pattern");
        }
        int n3 = arrayList.size() + arrayList2.size();
        Set<Integer> set3 = Collections.emptySet();
        string6 = QueryUtils.genColListForIn(stringArray6, set3, stringArray4, stringArray2, false, "1");
        string8 = bl ? QueryUtils.genColListForIn(stringArray7, set3, stringArray5, stringArray3, false, "1") : QueryUtils.genColListForIn(stringArray7, set3, stringArray5, stringArray3, true, "0");
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(QueryUtils.buildExistsCond(string6, string3, string8, string, string2, sQLGenContext, string5, ((StringBuffer)charSequence).toString(), n3));
        if (sQLGenContext.forceMaskForNE || sQLGenContext.disableNotExists || n3 <= sQLGenContext.neMaskThreshold && !sQLGenContext.disableMaskForNE) {
            List<Set<Integer>> list = QueryUtils.genMaskingSets(arrayList);
            for (Set<Integer> object2 : list) {
                string6 = QueryUtils.genColListForIn(stringArray6, set3, stringArray4, stringArray2, false, "1");
                string8 = bl ? QueryUtils.genColListForIn(stringArray7, object2, stringArray4, stringArray3, false, "1") : QueryUtils.genColListForIn(stringArray7, object2, stringArray4, stringArray3, true, "0");
                stringBuffer.append(string4 + "\n");
                stringBuffer.append(QueryUtils.buildExistsCond(string6, string3, string8, string, string2, sQLGenContext, string5, "", n3));
            }
            List<Set<Integer>> list2 = QueryUtils.genMaskingSets(arrayList2);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Set set4 = (Set)iterator.next();
                string6 = QueryUtils.genColListForIn(stringArray6, set4, stringArray5, stringArray2, false, "1");
                string8 = bl ? QueryUtils.genColListForIn(stringArray7, set3, stringArray5, stringArray3, false, "1") : QueryUtils.genColListForIn(stringArray7, set3, stringArray5, stringArray3, true, "0");
                stringBuffer.append(string4 + "\n");
                stringBuffer.append(QueryUtils.buildExistsCond(string6, string3, string8, string, string2, sQLGenContext, string5, "", n3));
            }
        }
        return stringBuffer.toString();
    }

    protected static String buildExistsCond(String string, String string2, String string3, String string4, String string5, SQLGenContext sQLGenContext, String string6, String string7, int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (sQLGenContext.disableNotExists) {
            stringBuffer.append("(" + string + ")\n");
            stringBuffer.append(string2 + "\n");
            stringBuffer.append("(SELECT " + string6 + "" + string3 + "\n");
            stringBuffer.append("FROM (" + string4 + ") " + string5 + ")");
        } else {
            stringBuffer.append("(" + string2 + "\n");
            stringBuffer.append("(SELECT " + string6 + " " + string3 + "\n");
            stringBuffer.append("FROM (" + string4 + ") " + string5 + "\n");
            if (sQLGenContext.forceMaskForNE || n <= sQLGenContext.neMaskThreshold && !sQLGenContext.disableMaskForNE) {
                stringBuffer.append("WHERE (" + string + ") IN ((" + string3 + "))))\n");
            } else {
                stringBuffer.append("WHERE " + string7 + "))\n");
            }
        }
        return stringBuffer.toString();
    }

    protected static String genColListForIn(String[] stringArray, Set<Integer> set, String[] stringArray2, String[] stringArray3, boolean bl, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < stringArray.length; ++i) {
            if (set.contains(i)) {
                QueryUtils.appendToList(stringBuffer, stringArray2[i], ", ", "");
                continue;
            }
            QueryUtils.appendToList(stringBuffer, stringArray[i], ", ", "");
        }
        if (bl) {
            String string2 = "";
            StringBuffer stringBuffer2 = new StringBuffer("");
            if (stringArray.length > 1) {
                stringBuffer2.append("COALESCE(");
                for (int i = 0; i < stringArray.length; ++i) {
                    string2 = stringArray2[i].startsWith("'") ? stringArray3[i] : QueryUtils.buildSafeToChar(stringArray3[i]);
                    QueryUtils.appendToList(stringBuffer2, string2, ",", "COALESCE(");
                }
                stringBuffer2.append(")");
            } else {
                stringBuffer2.append(stringArray3[0]);
            }
            QueryUtils.appendToList(stringBuffer, " NVL2(" + stringBuffer2.toString() + ",1," + string + ")", ", ", "");
        } else if (string != null) {
            QueryUtils.appendToList(stringBuffer, string, ", ", "");
        }
        return stringBuffer.toString();
    }

    protected static String buildAllColCoalesce(String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (stringArray.length > 1) {
            String string = "";
            stringBuffer.append("COALESCE(");
            for (int i = 0; i < stringArray.length; ++i) {
                string = stringArray2[i].startsWith("'") ? stringArray[i] : QueryUtils.buildSafeToChar(stringArray[i]);
                QueryUtils.appendToList(stringBuffer, string, ",", "COALESCE(");
            }
            stringBuffer.append(")");
        } else {
            stringBuffer.append(stringArray[0]);
        }
        return stringBuffer.toString();
    }

    protected static String buildSafeToChar(String string) {
        return "TO_CHAR(" + string + "," + "'TM9'" + "," + "'NLS_Numeric_Characters=''.,'''" + ")";
    }

    protected static int computeNonVnTermLen(String string, String string2) {
        int n = 0;
        int n2 = 0;
        if (string != null && string.length() > 0) {
            n = string.length() + 1;
        }
        if (string2 != null && string2.length() > 0) {
            n2 = string2.length() + 4;
        }
        return n + n2 + 2;
    }

    protected static int computeConstTermLen(String string, String string2, String string3) {
        return string.length() + QueryUtils.computeNonVnTermLen(string2, string3);
    }

    protected static String computeClobTermLen(String string, String string2, String string3) {
        return "(NVL(DBMS_LOB.GETLENGTH(TO_CLOB(" + string + ")),0)+NVL(LENGTH(" + string2 + ")+2,0)+NVL(LENGTH(" + string3 + ")+4,0)+2)";
    }

    protected static String shortenConstVNforTerm(String string, String string2, String string3) {
        int n = 4000 - QueryUtils.computeNonVnTermLen(string2, string3);
        if (string.length() > n) {
            return string.substring(0, n);
        }
        return string;
    }

    protected static String shortenVNforTerm(String string, String string2, String string3) {
        if (string2 == null) {
            string2 = "NULL";
        }
        if (string3 == null) {
            string3 = "NULL";
        }
        return "TO_CHAR(SUBSTR(" + string + ",1,(" + 4000 + "-(NVL(length(" + string3 + ")+4,0)+NVL(length(" + string2 + ")+1,0)+2))))";
    }

    protected static String shortenClobForTerm(String string, String string2, String string3) {
        if (string2 == null) {
            string2 = "NULL";
        }
        if (string3 == null) {
            string3 = "NULL";
        }
        return "TO_CHAR(DBMS_LOB.SUBSTR(TO_CLOB(" + string + "),(" + 4000 + "-(NVL(length(" + string3 + ")+4,0)+NVL(length(" + string2 + ")+1,0)+2)),1))";
    }

    protected static String escapeSingleQuotes(String string) {
        if (string == null) {
            return string;
        }
        return string.replace("'", "''");
    }

    public static String escapeSpecialChars(String string) {
        if (string == null) {
            return string;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        char c = ' ';
        block10: for (int i = 0; i < n; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block10;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block10;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block10;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block10;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block10;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block10;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String canonicalizeToEscaped(String string) {
        if (string == null) {
            return string;
        }
        if (!(string.contains("'") || string.contains("\"") || string.contains("\t") || string.contains("\n") || string.contains("\r") || string.contains("\b") || string.contains("\f"))) {
            return string;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\\') {
                stringBuffer.append(cArray[i]);
                if (i >= cArray.length - 1) continue;
                stringBuffer.append(cArray[i + 1]);
                ++i;
                continue;
            }
            if (cArray[i] == '\'') {
                stringBuffer.append('\\').append('\'');
                continue;
            }
            if (cArray[i] == '\"') {
                stringBuffer.append('\\').append('\"');
                continue;
            }
            if (cArray[i] == '\t') {
                stringBuffer.append('\\').append('t');
                continue;
            }
            if (cArray[i] == '\n') {
                stringBuffer.append('\\').append('n');
                continue;
            }
            if (cArray[i] == '\r') {
                stringBuffer.append('\\').append('r');
                continue;
            }
            if (cArray[i] == '\b') {
                stringBuffer.append('\\').append('b');
                continue;
            }
            if (cArray[i] == '\f') {
                stringBuffer.append('\\').append('f');
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String unescapeSpecialChars(String string) throws RDFException {
        if (string == null) {
            return string;
        }
        int n = string.indexOf(92);
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.substring(0, n));
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != '\\') {
                stringBuilder.append(c);
            } else {
                char c2;
                if (n >= string.length() - 1) {
                    throw new RDFException("Illegal escape at end of string: " + string);
                }
                char c3 = string.charAt(n + 1);
                ++n;
                switch (c3) {
                    case 'n': {
                        c2 = '\n';
                        break;
                    }
                    case 't': {
                        c2 = '\t';
                        break;
                    }
                    case 'r': {
                        c2 = '\r';
                        break;
                    }
                    case 'b': {
                        c2 = '\b';
                        break;
                    }
                    case 'f': {
                        c2 = '\f';
                        break;
                    }
                    case '\'': {
                        c2 = '\'';
                        break;
                    }
                    case '\"': {
                        c2 = '\"';
                        break;
                    }
                    case '\\': {
                        c2 = '\\';
                        break;
                    }
                    default: {
                        throw new RDFException("Invalid escape: \\" + c3 + " (at position: " + n + " of) token: [" + string + "]");
                    }
                }
                stringBuilder.append(c2);
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String unescapeUnicode(String string) throws RDFException {
        if (string == null) {
            return string;
        }
        int n = string.indexOf(92);
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.substring(0, n));
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != '\\') {
                stringBuilder.append(c);
            } else {
                String string2;
                int n2;
                if (n >= string.length() - 1) {
                    throw new RDFException("Illegal escape at end of string");
                }
                char c2 = string.charAt(n + 1);
                ++n;
                if (c2 == 'u') {
                    if (n + 4 >= string.length()) {
                        throw new RDFException("\\u escape too short");
                    }
                    n2 = 0;
                    string2 = string.substring(n + 1, n + 1 + 4);
                    try {
                        n2 = Integer.parseInt(string2, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new RDFException("Invalid escaped character: \\u" + string2);
                    }
                    stringBuilder.append((char)n2);
                    n += 4;
                } else if (c2 == 'U') {
                    if (n + 8 >= string.length()) {
                        throw new RDFException("\\U escape too short");
                    }
                    n2 = 0;
                    string2 = string.substring(n + 1, n + 1 + 8);
                    try {
                        n2 = Integer.parseInt(string2, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new RDFException("Invalid escaped character: \\U" + string2);
                    }
                    stringBuilder.append(Character.toChars(n2));
                    n += 8;
                } else {
                    stringBuilder.append('\\');
                    stringBuilder.append(c2);
                }
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    private static int utf16_to_unicode(String string) throws RDFException {
        String string2 = string.substring(0, 4);
        int n = Integer.parseInt(string2, 16);
        if (n < 55296 || n > 57343) {
            return n;
        }
        if (n >= 55296 && n <= 56319) {
            String string3 = string.substring(4, 8);
            int n2 = Integer.parseInt(string3, 16);
            if (n2 >= 56320 && n2 <= 57343) {
                int n3 = n % 1024;
                int n4 = n2 % 1024;
                int n5 = n3 * 1024 + n4 + 65536;
                return n5;
            }
            throw new RDFException("Invalid unicode value: " + string);
        }
        throw new RDFException("Invalid unicode value: " + string);
    }

    private static String buildHexString(int n, int n2) {
        String string = Integer.toHexString(n).toUpperCase();
        for (int i = n2 - string.length(); i > 0; --i) {
            string = "0" + string;
        }
        return string;
    }

    public static String escapeUnicode(String string) throws RDFException {
        if (string == null) {
            return null;
        }
        String string2 = QueryUtils.unescapeUnicode(string);
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        char c = ' ';
        String string3 = "";
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            c = string2.charAt(i);
            if (c == '\u0000' || c == '\b' || c == '\t' || c == '\n' || c == '\f' || c == '\r') {
                stringBuilder.append(c);
                continue;
            }
            if (c >= ' ' && c <= '~') {
                stringBuilder.append(c);
                continue;
            }
            if (c >= '\ud800' && c <= '\udbff') {
                String string4 = QueryUtils.buildHexString(c, 4);
                c = string2.charAt(++i);
                String string5 = QueryUtils.buildHexString(c, 4);
                int n2 = QueryUtils.utf16_to_unicode(string4 + string5);
                stringBuilder.append("\\U").append(QueryUtils.buildHexString(n2, 8));
                continue;
            }
            if (c >= 65536) continue;
            stringBuilder.append("\\u").append(QueryUtils.buildHexString(c, 4));
        }
        return stringBuilder.toString();
    }

    public static String splitClobInChunks(String string, int n) throws SQLException {
        String string2 = "(";
        int n2 = 0;
        while (n2 + n < string.length()) {
            String string3 = string.substring(n2, n2 + n);
            string3 = QueryUtils.enquoteLiteral(string3);
            string2 = string2 + "to_clob(" + string3 + ") ||";
            n2 += n;
        }
        string2 = string2 + "to_clob(" + QueryUtils.enquoteLiteral(string.substring(n2)) + "))";
        return string2;
    }

    public static String wrapFor4kVc(String string) {
        return "SUBSTRB(" + string + ",1," + 4000 + ")";
    }

    protected static boolean autolistSubPartitioned(SQLGenContext sQLGenContext) throws SQLException {
        boolean bl = false;
        String string = QueryUtils.getNetworkNamePfx(sQLGenContext.clnNetworkName) + "RDF_LINK$";
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = sQLGenContext.conn.prepareStatement("SELECT /*+ RESULT_CACHE dynamic_sampling(0) */ count(*) FROM SYS.ALL_PART_TABLES WHERE owner = ?   AND table_name = ? AND SUBPARTITIONING_TYPE = 'LIST'");
            preparedStatement.setString(1, QueryUtils.checkRemoveEnclosingQuotes(sQLGenContext.clnNetworkOwner));
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next() && resultSet.getInt(1) > 0) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return bl;
    }

    protected static boolean existAutolistSubP(SQLGenContext sQLGenContext, String string, long l) throws SQLException {
        boolean bl = false;
        String string2 = QueryUtils.getNetworkNamePfx(sQLGenContext.clnNetworkName) + "RDF_LINK$";
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        if (string == null) {
            return true;
        }
        preparedStatement = sQLGenContext.conn.prepareStatement("SELECT to_char(high_value_clob) FROM SYS.ALL_TAB_SUBPARTITIONS WHERE TABLE_OWNER = ? AND TABLE_NAME = ? AND PARTITION_NAME = ? ");
        try {
            preparedStatement.setString(1, QueryUtils.checkRemoveEnclosingQuotes(sQLGenContext.clnNetworkOwner));
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, "MODEL_" + l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                if (!resultSet.getString(1).equals(string)) continue;
                bl = true;
                break;
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return bl;
    }

    protected static List<Set<Integer>> genMaskingSets(List<Integer> list) {
        int n = Double.valueOf(Math.pow(2.0, list.size())).intValue();
        ArrayList<Set<Integer>> arrayList = new ArrayList<Set<Integer>>(n - 1);
        for (int i = 1; i < n; ++i) {
            char[] cArray = String.format("%1$" + list.size() + "s", Integer.toBinaryString(i)).replace(' ', '0').toCharArray();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int j = 0; j < cArray.length; ++j) {
                if (cArray[j] != '1') continue;
                hashSet.add(list.get(j));
            }
            arrayList.add(hashSet);
        }
        return arrayList;
    }

    protected static String genVNameSubstr(String string, String string2, String string3, String string4) {
        return "NVL2(" + string2 + ",to_char(" + QueryUtils.shortenClobForTerm(string2, string3, string4) + ")," + string + ")";
    }

    protected static String extractHint0Contents(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string == null) {
            return null;
        }
        Matcher matcher = HINT0PATTERN.matcher(string);
        boolean bl = false;
        while (matcher.find()) {
            if (matcher.groupCount() != 3) {
                QueryUtils.log("ERROR: HINT0 pattern needs to be fixed. Unable to search for HINT0 hints");
                continue;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(matcher.group(2));
            bl = true;
        }
        if (!bl) {
            return null;
        }
        return stringBuilder.toString();
    }

    protected static String getNonExistingGidQ(SQLGenContext sQLGenContext) {
        return "(SELECT 0 FROM SYS.DUAL WHERE NOT EXISTS (SELECT 1 FROM " + sQLGenContext.clnPfxForRdfObjName + "RDF_NAMESPACE$ WHERE (1=0)))";
    }

    protected static String buildGidInList(String string, long[] lArray, SQLGenContext sQLGenContext) {
        Function<Long, String> function = l -> l == 0L ? QueryUtils.getNonExistingGidQ(sQLGenContext) : l.toString();
        return QueryUtils.buildInList(string, lArray, function);
    }

    protected static String buildInList(String string, long[] lArray) {
        Function<Long, String> function = l -> l.toString();
        return QueryUtils.buildInList(string, lArray, function);
    }

    private static String buildInList(String string, long[] lArray, Function<Long, String> function) {
        String string2 = "";
        if (lArray != null && lArray.length > 0) {
            string2 = Arrays.stream(lArray).boxed().map(function).collect(Collectors.joining(","));
            string2 = " " + string + " IN (" + string2 + ") ";
        }
        return string2;
    }

    public static void processUnDefVars(Filter filter, Set<String> set, SQLGenContext sQLGenContext) throws RDFException {
        if (filter != null) {
            UnDefVarFilterOptimizer unDefVarFilterOptimizer = new UnDefVarFilterOptimizer(set, sQLGenContext);
            try {
                filter.applyFilterOptimizer(unDefVarFilterOptimizer);
            }
            catch (FilterException filterException) {
                throw new RDFException(filterException.getMessage());
            }
        }
    }

    protected static String buildUnpivot(Set<String> set, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = "$RDFTERM";
        if (bl) {
            string2 = "$RDFVID";
        }
        stringBuffer.append("SELECT TERM").append(string2).append("\nFROM (SELECT DISTINCT ");
        int n = 0;
        for (String string3 : set) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string3).append(string2).append(" AS TERM").append(n);
            ++n;
        }
        stringBuffer.append(" FROM(").append(string).append("))");
        stringBuffer.append("\nUNPIVOT INCLUDE NULLS\n");
        stringBuffer.append("((TERM").append(string2).append(")\n FOR (c) IN (");
        for (n = 0; n < set.size(); ++n) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("(TERM").append(n).append(")");
        }
        stringBuffer.append("))");
        return stringBuffer.toString();
    }

    protected static String buildOptTerm(String[] stringArray) {
        String string = "";
        string = Integer.parseInt(stringArray[7]) == 28 ? stringArray[9] : "sem_apis.compose_rdf_term(" + stringArray[0] + "," + stringArray[1] + "," + stringArray[4] + "," + stringArray[5] + ")";
        return string;
    }

    protected static String buildOptNumber(String[] stringArray) {
        String string = "";
        string = Integer.parseInt(stringArray[7]) == 3 || Integer.parseInt(stringArray[7]) == 29 ? stringArray[9] : "sem_apis.getV$NumericVal(" + stringArray[1] + "," + stringArray[2] + "," + stringArray[3] + "," + stringArray[4] + "," + stringArray[5] + ")";
        return string;
    }

    protected static boolean pathContainsReverse(PPNode pPNode) {
        boolean bl = false;
        Stack<PPNode> stack = new Stack<PPNode>();
        PPNode pPNode2 = pPNode;
        stack.push(pPNode2);
        while (!stack.isEmpty()) {
            pPNode2 = (PPNode)stack.pop();
            if (pPNode2.getDirection() == 1) {
                bl = true;
                continue;
            }
            for (int i = 0; i < pPNode2.getNumChildren(); ++i) {
                PPNode pPNode3 = pPNode2.getChild(i);
                stack.push(pPNode3);
            }
        }
        return bl;
    }

    public static String validateSQLName(String string, boolean bl, int n) throws SQLException {
        String string2 = string.trim();
        string = string2.charAt(0) == '\"' && !bl ? QueryUtils.enquoteNameSQLName(string) : QueryUtils.simpleSQLName(string.toUpperCase(), n);
        return string;
    }

    public static boolean isForwardPred(String string) {
        return string.charAt(0) == 'P';
    }

    public static boolean isReversePred(String string) {
        return string.charAt(0) == 'R';
    }

    static {
        SCHEMA_PROPERTIES.add("http://www.w3.org/2000/01/rdf-schema#subClassOf");
        SCHEMA_PROPERTIES.add("http://www.w3.org/2000/01/rdf-schema#subPropertyOf");
        SCHEMA_PROPERTIES.add("http://www.w3.org/2004/02/skos/core#broader");
        SCHEMA_PROPERTIES.add("http://www.w3.org/2004/02/skos/core#narrower");
        UNSELECTIVE_PROPERTIES = new HashSet<String>();
        UNSELECTIVE_PROPERTIES.add("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        SPATIAL_FUNCTIONS = new String[]{"http://www.opengis.net/def/function/geosparql/", "http://www.opengis.net/def/function/geosparql/relate", "http://www.opengis.net/def/function/geosparql/distance", "http://www.opengis.net/def/function/geosparql/buffer", "http://www.opengis.net/def/function/geosparql/envelope", "http://www.opengis.net/def/function/geosparql/convexHull", "http://www.opengis.net/def/function/geosparql/intersection", "http://www.opengis.net/def/function/geosparql/union", "http://www.opengis.net/def/function/geosparql/difference", "http://www.opengis.net/def/function/geosparql/symDifference", "http://www.opengis.net/def/function/geosparql/getSRID", "http://www.opengis.net/def/function/geosparql/boundary", "http://www.opengis.net/def/function/geosparql/sfEquals", "http://www.opengis.net/def/function/geosparql/sfDisjoint", "http://www.opengis.net/def/function/geosparql/sfIntersects", "http://www.opengis.net/def/function/geosparql/sfTouches", "http://www.opengis.net/def/function/geosparql/sfCrosses", "http://www.opengis.net/def/function/geosparql/sfWithin", "http://www.opengis.net/def/function/geosparql/sfContains", "http://www.opengis.net/def/function/geosparql/sfOverlaps", "http://www.opengis.net/def/function/geosparql/area", "http://www.opengis.net/def/function/geosparql/metricArea", "http://www.opengis.net/def/function/geosparql/boundingCircle", "http://www.opengis.net/def/function/geosparql/concaveHull", "http://www.opengis.net/def/function/geosparql/geometryN", "http://www.opengis.net/def/function/geosparql/length", "http://www.opengis.net/def/function/geosparql/metricLength", "http://www.opengis.net/def/function/geosparql/perimeter", "http://www.opengis.net/def/function/geosparql/metricPerimeter", "http://www.opengis.net/def/function/geosparql/maxX", "http://www.opengis.net/def/function/geosparql/maxY", "http://www.opengis.net/def/function/geosparql/maxZ", "http://www.opengis.net/def/function/geosparql/minX", "http://www.opengis.net/def/function/geosparql/minY", "http://www.opengis.net/def/function/geosparql/minZ", "http://www.opengis.net/def/function/geosparql/metricBuffer", "http://www.opengis.net/def/function/geosparql/metricDistance", "http://www.opengis.net/def/function/geosparql/numGeometries", "http://www.opengis.net/def/function/geosparql/transform", "http://www.opengis.net/def/function/geosparql/coordinateDimension", "http://www.opengis.net/def/function/geosparql/dimension", "http://www.opengis.net/def/function/geosparql/geometryType", "http://www.opengis.net/def/function/geosparql/is3D", "http://www.opengis.net/def/function/geosparql/isEmpty", "http://www.opengis.net/def/function/geosparql/isMeasured", "http://www.opengis.net/def/function/geosparql/isSimple", "http://www.opengis.net/def/function/geosparql/spatialDimension", "http://www.opengis.net/def/function/geosparql/aggBoundingBox", "http://www.opengis.net/def/function/geosparql/aggBoundingCircle", "http://www.opengis.net/def/function/geosparql/aggCentroid", "http://www.opengis.net/def/function/geosparql/aggConcaveHull", "http://www.opengis.net/def/function/geosparql/aggConvexHull", "http://www.opengis.net/def/function/geosparql/aggUnion", "http://www.opengis.net/def/function/geosparql/asWKT", "http://www.opengis.net/def/function/geosparql/asGML", "http://www.opengis.net/def/function/geosparql/asGeoJSON", "http://www.opengis.net/def/function/geosparql/asKML", "http://xmlns.oracle.com/rdf/geo/withinDistance", "http://xmlns.oracle.com/rdf/geo/idxWithinDistance", "http://xmlns.oracle.com/rdf/geo/funcWithinDistance", "http://xmlns.oracle.com/rdf/geo/relate", "http://xmlns.oracle.com/rdf/geo/idxRelate", "http://xmlns.oracle.com/rdf/geo/funcRelate", "http://xmlns.oracle.com/rdf/geo/nearestNeighbor", "http://xmlns.oracle.com/rdf/geo/area", "http://xmlns.oracle.com/rdf/geo/centroid", "http://xmlns.oracle.com/rdf/geo/length", "http://xmlns.oracle.com/rdf/geo/maxMbrOrdinate", "http://xmlns.oracle.com/rdf/geo/minMbrOrdinate", "http://xmlns.oracle.com/rdf/geo/distance", "http://xmlns.oracle.com/rdf/geo/buffer", "http://xmlns.oracle.com/rdf/geo/convexHull", "http://xmlns.oracle.com/rdf/geo/intersection", "http://xmlns.oracle.com/rdf/geo/union", "http://xmlns.oracle.com/rdf/geo/difference", "http://xmlns.oracle.com/rdf/geo/xor", "http://xmlns.oracle.com/rdf/geo/mbr", "http://xmlns.oracle.com/rdf/geo/sdoJoin", "http://xmlns.oracle.com/rdf/geo/sdoDistJoin", "http://xmlns.oracle.com/rdf/geo/getSRID", "http://xmlns.oracle.com/rdf/geo/aggrCentroid", "http://xmlns.oracle.com/rdf/geo/aggrConcatLines", "http://xmlns.oracle.com/rdf/geo/aggrConvexhull", "http://xmlns.oracle.com/rdf/geo/aggrMBR", "http://xmlns.oracle.com/rdf/geo/aggrUnion"};
        ORACLE_TEXT_FUNCTIONS = new String[]{"http://xmlns.oracle.com/rdf/textContains", "http://xmlns.oracle.com/rdf/textScore"};
        UNBOUND_PROPERTY_PATH_NODES = new int[]{69, 70};
    }
}

