/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.spatial.rdf.server.OraBindValue;
import oracle.spatial.rdf.server.OraBindValueInfo;
import oracle.spatial.rdf.server.RDFException;

public class OraBindValueProcessor {
    private static final String NOT_ALL_BIND_VALUES_SET_ERROR = "Not all bind values set";
    private static final String WRONG_TYPE_SET_ERROR = "Wrong type set for bind value %s";
    private static final String ORA_BV_PREFIX = "$$ORABV$";
    private Map<String, OraBindValue.BvType> bvTypeMap = new HashMap<String, OraBindValue.BvType>();
    private SortedMap<BvColumnKey, List<Integer>> bvSqlMap = new TreeMap<BvColumnKey, List<Integer>>();

    public void setBvTypeInfo(OraBindValueInfo oraBindValueInfo) {
        OraBindValue.BvType bvType = null;
        int n = 1;
        bvType = oraBindValueInfo.getBvType(n);
        while (bvType != null) {
            this.bvTypeMap.put(OraBindValueProcessor.buildBvKeyString(n), bvType);
            bvType = oraBindValueInfo.getBvType(++n);
        }
    }

    public static String buildBvKeyString(int n) {
        return ORA_BV_PREFIX + String.valueOf(n) + "$";
    }

    private void addBvSQLIndex(BvColumnKey bvColumnKey, int n) {
        List<Integer> list = this.getBvSQLIndexes(bvColumnKey);
        if (list == null) {
            list = new ArrayList<Integer>();
        }
        list.add(n);
        this.bvSqlMap.put(bvColumnKey, list);
    }

    private List<Integer> getBvSQLIndexes(BvColumnKey bvColumnKey) {
        return (List)this.bvSqlMap.get(bvColumnKey);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\n========== OraBindValueProcessor ===========");
        stringBuffer.append("\n---------- bvTypeMap -------------\n");
        stringBuffer.append(this.bvTypeMap.toString());
        stringBuffer.append("\n---------- bvSqlMap -------------\n");
        stringBuffer.append(this.bvSqlMap.toString());
        stringBuffer.append("\n============================================\n");
        return stringBuffer.toString();
    }

    public String processEncodedBindVars(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 1;
        int n2 = 0;
        int n3 = string.indexOf(ORA_BV_PREFIX, n2);
        while (n3 > 0) {
            int n4 = string.indexOf("$", n3 + 8);
            int n5 = Integer.parseInt(string.substring(n3 + 8, n4));
            String string2 = this.extractBvColName(string, n4 + 1);
            RDFTermComponent rDFTermComponent = OraBindValueProcessor.getTermCompForColRef(string2);
            BvColumnKey bvColumnKey = new BvColumnKey(n5, rDFTermComponent);
            this.addBvSQLIndex(bvColumnKey, n);
            ++n;
            stringBuffer.append(string.substring(n2, n3)).append("?");
            n2 = n4 + 1 + string2.length();
            n3 = string.indexOf(ORA_BV_PREFIX, n2);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public void validateBindValueInfo(OraBindValueInfo oraBindValueInfo) throws RDFException {
        this.checkTypeMapping(oraBindValueInfo);
    }

    private void checkTypeMapping(OraBindValueInfo oraBindValueInfo) throws RDFException {
        Map<String, OraBindValue.BvType> map = oraBindValueInfo.getBvTypeMap();
        if (this.bvTypeMap.size() != map.size()) {
            throw new RDFException(NOT_ALL_BIND_VALUES_SET_ERROR);
        }
        for (Map.Entry<String, OraBindValue.BvType> entry : map.entrySet()) {
            if (this.bvTypeMap.get(entry.getKey()) == entry.getValue()) continue;
            throw new RDFException(String.format(WRONG_TYPE_SET_ERROR, entry.getKey()));
        }
    }

    private String extractBvColName(String string, int n) {
        String[] stringArray = new String[]{".VALUE_ID", ".VALUE_TYPE", ".VNAME_PREFIX", ".VNAME_SUFFIX", ".LITERAL_TYPE", ".LANGUAGE_TYPE", ".LONG_VALUE", ".RAW_NUMBER"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.startsWith(stringArray[i], n)) continue;
            return stringArray[i];
        }
        return "not found";
    }

    private static RDFTermComponent getTermCompForColRef(String string) {
        if (string.equals(".VALUE_ID")) {
            return RDFTermComponent.VALUE_ID;
        }
        if (string.equals(".VALUE_TYPE")) {
            return RDFTermComponent.VALUE_TYPE;
        }
        if (string.equals(".VNAME_PREFIX")) {
            return RDFTermComponent.VNAME_PREFIX;
        }
        if (string.equals(".VNAME_SUFFIX")) {
            return RDFTermComponent.VNAME_SUFFIX;
        }
        if (string.equals(".LITERAL_TYPE")) {
            return RDFTermComponent.LIT_TYPE;
        }
        if (string.equals(".LANGUAGE_TYPE")) {
            return RDFTermComponent.LIT_LANG;
        }
        if (string.equals(".LONG_VALUE")) {
            return RDFTermComponent.LIT_LONG;
        }
        if (string.equals(".RAW_NUMBER")) {
            return RDFTermComponent.RAW_NUMBER;
        }
        return RDFTermComponent.VALUE_ID;
    }

    public void setSQLBindVals(Connection connection, PreparedStatement preparedStatement, OraBindValueInfo oraBindValueInfo, List<Clob> list) throws SQLException {
        Set<Map.Entry<BvColumnKey, List<Integer>>> set = this.bvSqlMap.entrySet();
        BvColumnKey bvColumnKey = null;
        OraBindValue oraBindValue = null;
        for (Map.Entry<BvColumnKey, List<Integer>> entry : set) {
            if (bvColumnKey == null || !bvColumnKey.equals(entry.getKey())) {
                bvColumnKey = entry.getKey();
                oraBindValue = oraBindValueInfo.getBvValue(bvColumnKey.getBvId());
            }
            for (Integer n : entry.getValue()) {
                Clob clob = this.setSqlBindVal(connection, preparedStatement, oraBindValue, bvColumnKey.getTermComponent(), n);
                if (clob == null) continue;
                list.add(clob);
            }
        }
    }

    private Clob setSqlBindVal(Connection connection, PreparedStatement preparedStatement, OraBindValue oraBindValue, RDFTermComponent rDFTermComponent, int n) throws SQLException {
        Clob clob = null;
        block0 : switch (rDFTermComponent) {
            case VALUE_ID: {
                if (oraBindValue.getValueId() != null) {
                    preparedStatement.setLong(n, oraBindValue.getValueId());
                    break;
                }
                preparedStatement.setNull(n, -5);
                break;
            }
            case VALUE_TYPE: {
                preparedStatement.setString(n, oraBindValue.getValueType());
                break;
            }
            case VNAME_PREFIX: {
                preparedStatement.setString(n, oraBindValue.getVnamePrefix());
                break;
            }
            case VNAME_SUFFIX: {
                preparedStatement.setString(n, oraBindValue.getVnameSuffix());
                break;
            }
            case LIT_TYPE: {
                preparedStatement.setString(n, oraBindValue.getLitType());
                break;
            }
            case LIT_LANG: {
                preparedStatement.setString(n, oraBindValue.getLitLang());
                break;
            }
            case LIT_LONG: {
                clob = connection.createClob();
                clob.setString(1L, oraBindValue.getLitLong());
                preparedStatement.setClob(n, clob);
                break;
            }
            case RAW_NUMBER: {
                switch (oraBindValue.getType()) {
                    case INTEGER: {
                        preparedStatement.setInt(n, oraBindValue.getIntVal());
                        break block0;
                    }
                    case LONG: {
                        preparedStatement.setLong(n, oraBindValue.getLongVal());
                        break block0;
                    }
                    case FLOAT: {
                        preparedStatement.setFloat(n, oraBindValue.getFloatVal().floatValue());
                        break block0;
                    }
                    case DOUBLE: {
                        preparedStatement.setDouble(n, oraBindValue.getDoubleVal());
                    }
                }
            }
        }
        return clob;
    }

    private static class BvColumnKey
    implements Comparable<BvColumnKey> {
        int bvId;
        RDFTermComponent termComponent;
        String encodedKey;

        BvColumnKey(int n, RDFTermComponent rDFTermComponent) {
            this.bvId = n;
            this.termComponent = rDFTermComponent;
            this.encodedKey = String.valueOf(n) + ":" + rDFTermComponent.toString();
        }

        int getBvId() {
            return this.bvId;
        }

        RDFTermComponent getTermComponent() {
            return this.termComponent;
        }

        String getEncodedKey() {
            return this.encodedKey;
        }

        public String toString() {
            return this.getEncodedKey();
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof BvColumnKey) {
                return this.getEncodedKey().equals(((BvColumnKey)object).getEncodedKey());
            }
            return false;
        }

        public int hashCode() {
            return this.getEncodedKey().hashCode();
        }

        @Override
        public int compareTo(BvColumnKey bvColumnKey) {
            if (this.getBvId() < bvColumnKey.getBvId()) {
                return -1;
            }
            if (this.getBvId() > bvColumnKey.getBvId()) {
                return 1;
            }
            return this.getTermComponent().compareTo(bvColumnKey.getTermComponent());
        }
    }

    public static enum RDFTermComponent {
        VALUE_ID,
        VALUE_TYPE,
        VNAME_PREFIX,
        VNAME_SUFFIX,
        LIT_TYPE,
        LIT_LANG,
        LIT_LONG,
        RAW_NUMBER;

    }
}

