/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.spatial.rdf.server.LiteralSet;
import oracle.spatial.rdf.server.OraBindValue;
import oracle.spatial.rdf.server.OraBindValueProcessor;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.URIset;

public class OraBindValueInfo {
    private static final String IMVC_NOT_SUPPORTED_ERROR = "Bind variables are not supported for in-memory virtual columns";
    private static final String RDFVIEW_NOT_SUPPORTED_ERROR = "Bind variables are not supported for RDF View queries";
    private static final String BIND_VALUE_TYPE_ERROR = "Bind value type %s at position %d does not match original type %s";
    private Map<String, OraBindValue.BvType> bvTypeMap = new HashMap<String, OraBindValue.BvType>();
    private Map<Integer, OraBindValue> bvValueMap = new HashMap<Integer, OraBindValue>();
    private URIset uriSet = new URIset();
    private LiteralSet literalSet = new LiteralSet();
    private String networkStorageForm;
    private String modelType;
    private boolean usesIMVC;

    public OraBindValueInfo(String string, String string2, boolean bl) {
        this.networkStorageForm = string;
        this.modelType = string2;
        this.usesIMVC = bl;
    }

    public OraBindValue.BvType getBvType(int n) {
        return this.bvTypeMap.get(OraBindValueProcessor.buildBvKeyString(n));
    }

    public Map<String, OraBindValue.BvType> getBvTypeMap() {
        return Collections.unmodifiableMap(this.bvTypeMap);
    }

    public OraBindValue getBvValue(int n) {
        return this.bvValueMap.get(n);
    }

    public void resolveValueIds(Connection connection, String string) throws SQLException {
        this.uriSet.resolve(connection, string);
        this.literalSet.resolve(connection, string);
        this.updateBvValueIds();
        this.uriSet.clear();
        this.literalSet.clear();
    }

    private void updateBvValueIds() {
        for (OraBindValue oraBindValue : this.bvValueMap.values()) {
            String string = null;
            string = oraBindValue.getType() == OraBindValue.BvType.URI ? this.uriSet.get(oraBindValue.getVnamePrefix() + oraBindValue.getVnameSuffix()) : this.literalSet.get(oraBindValue.toTripleAtom());
            if (string == null) continue;
            oraBindValue.setValueId(Long.parseLong(string));
        }
    }

    public boolean isEmpty() {
        return this.bvTypeMap.isEmpty();
    }

    public void setURI(int n, String string) throws RDFException {
        this.checkOraBindCompatibility();
        this.setBvType(n, OraBindValue.BvType.URI);
        OraBindValue oraBindValue = OraBindValue.createURI(this.encodeForStorageForm(string));
        this.setBvValue(n, oraBindValue);
    }

    public void setFloat(int n, float f) throws RDFException {
        this.checkOraBindCompatibility();
        this.setBvType(n, OraBindValue.BvType.FLOAT);
        OraBindValue oraBindValue = OraBindValue.createFloat(f);
        this.setBvValue(n, oraBindValue);
    }

    public void setDouble(int n, double d) throws RDFException {
        this.checkOraBindCompatibility();
        this.setBvType(n, OraBindValue.BvType.DOUBLE);
        OraBindValue oraBindValue = OraBindValue.createDouble(d);
        this.setBvValue(n, oraBindValue);
    }

    public void setInt(int n, int n2) throws RDFException {
        this.checkOraBindCompatibility();
        this.setBvType(n, OraBindValue.BvType.INTEGER);
        OraBindValue oraBindValue = OraBindValue.createInt(n2);
        this.setBvValue(n, oraBindValue);
    }

    public void setLong(int n, long l) throws RDFException {
        this.checkOraBindCompatibility();
        this.setBvType(n, OraBindValue.BvType.LONG);
        OraBindValue oraBindValue = OraBindValue.createLong(l);
        this.setBvValue(n, oraBindValue);
    }

    public void setPlainLiteral(int n, String string) throws RDFException {
        this.checkOraBindCompatibility();
        this.setBvType(n, OraBindValue.BvType.PLAIN_LIT);
        OraBindValue oraBindValue = OraBindValue.createPlainLiteral(this.encodeForStorageForm(string));
        this.setBvValue(n, oraBindValue);
    }

    public void setLangLiteral(int n, String string, String string2) throws RDFException {
        this.checkOraBindCompatibility();
        this.setBvType(n, OraBindValue.BvType.LANG_LIT);
        OraBindValue oraBindValue = OraBindValue.createLangLiteral(this.encodeForStorageForm(string), this.encodeForStorageForm(string2));
        this.setBvValue(n, oraBindValue);
    }

    public void setTypedLiteral(int n, String string, String string2) throws RDFException {
        this.checkOraBindCompatibility();
        this.setBvType(n, OraBindValue.BvType.TYPED_LIT);
        OraBindValue oraBindValue = OraBindValue.createTypedLiteral(this.encodeForStorageForm(string), this.encodeForStorageForm(string2));
        this.setBvValue(n, oraBindValue);
    }

    private void setBvType(int n, OraBindValue.BvType bvType) throws RDFException {
        OraBindValue.BvType bvType2 = this.getBvType(n);
        if (bvType2 != null && bvType2 != bvType) {
            throw new RDFException(String.format(BIND_VALUE_TYPE_ERROR, new Object[]{bvType, n, bvType2}));
        }
        this.bvTypeMap.put(OraBindValueProcessor.buildBvKeyString(n), bvType);
    }

    private void setBvValue(int n, OraBindValue oraBindValue) throws RDFException {
        if (oraBindValue.getType() != this.getBvType(n)) {
            throw new RDFException(String.format(BIND_VALUE_TYPE_ERROR, new Object[]{oraBindValue.getType(), n, this.getBvType(n)}));
        }
        this.bvValueMap.put(n, oraBindValue);
        if (oraBindValue.getType() == OraBindValue.BvType.URI) {
            this.uriSet.put(oraBindValue.getVnamePrefix() + oraBindValue.getVnameSuffix());
        } else {
            this.literalSet.put(oraBindValue.toTripleAtom());
        }
    }

    private String encodeForStorageForm(String string) throws RDFException {
        String string2 = string;
        if (this.networkStorageForm.equals("ESC")) {
            string2 = QueryUtils.escapeSpecialChars(string2);
            string2 = QueryUtils.escapeUnicode(string2);
        }
        return string2;
    }

    private void checkOraBindCompatibility() throws RDFException {
        if (this.usesIMVC) {
            throw new RDFException(IMVC_NOT_SUPPORTED_ERROR);
        }
        if (this.modelType.equals("D")) {
            throw new RDFException(RDFVIEW_NOT_SUPPORTED_ERROR);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\n========== OraBindValueProcessor ===========");
        stringBuffer.append("\n---------- bvTypeMap -------------\n");
        stringBuffer.append(this.bvTypeMap.toString());
        stringBuffer.append("\n---------- bvValueMap -------------\n");
        stringBuffer.append(this.bvValueMap.toString());
        stringBuffer.append("\n============================================\n");
        return stringBuffer.toString();
    }
}

