/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import oracle.spatial.rdf.server.parser.sparql.ASTBind;
import oracle.spatial.rdf.server.parser.sparql.ASTBuiltInCall;
import oracle.spatial.rdf.server.parser.sparql.ASTComparisonOperator;
import oracle.spatial.rdf.server.parser.sparql.ASTGraphPatternNotTriples;
import oracle.spatial.rdf.server.parser.sparql.ASTGroupGraphPattern;
import oracle.spatial.rdf.server.parser.sparql.ASTInlineData;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectClause;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectExpression;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectQuery;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.ASTTriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.ASTUnionGraphPattern;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class OptimizerUtils {
    public static final String PP_SEQ_VAR_PREFIX = "PP$S$";
    public static final String PP_ALT_VAR_PREFIX = "PP$A$";

    public static ASTSelectQuery genWrapperSelect(ASTSelectQuery aSTSelectQuery, List<Node> list) {
        ASTSelectQuery aSTSelectQuery2 = new ASTSelectQuery(7);
        List<String> list2 = aSTSelectQuery.getselDesc().getSelectList();
        ASTSelectClause aSTSelectClause = OptimizerUtils.genSelectClause(list2, null);
        aSTSelectQuery2.jjtAddChild(aSTSelectClause, 0);
        aSTSelectClause.jjtSetParent(aSTSelectQuery2);
        aSTSelectQuery2.getselDesc().populateSelDesc(aSTSelectQuery2, false);
        ASTGroupGraphPattern aSTGroupGraphPattern = new ASTGroupGraphPattern(48);
        aSTSelectQuery2.jjtAddChild(aSTGroupGraphPattern, 1);
        aSTGroupGraphPattern.jjtSetParent(aSTSelectQuery2);
        ASTGraphPatternNotTriples aSTGraphPatternNotTriples = new ASTGraphPatternNotTriples(49);
        aSTGroupGraphPattern.jjtAddChild(aSTGraphPatternNotTriples, 0);
        aSTGraphPatternNotTriples.jjtSetParent(aSTGroupGraphPattern);
        ASTGroupGraphPattern aSTGroupGraphPattern2 = new ASTGroupGraphPattern(48);
        aSTGraphPatternNotTriples.jjtAddChild(aSTGroupGraphPattern2, 0);
        aSTGroupGraphPattern2.jjtSetParent(aSTGraphPatternNotTriples);
        aSTGroupGraphPattern2.jjtAddChild(aSTSelectQuery, 0);
        aSTSelectQuery.jjtSetParent(aSTGroupGraphPattern2);
        aSTSelectQuery2.getselDesc().setIsTopSelect(aSTSelectQuery.getselDesc().getIsTopSelect());
        aSTSelectQuery.getselDesc().setIsTopSelect(false);
        if (list != null) {
            int n = 1;
            for (Node node : list) {
                aSTGroupGraphPattern.jjtAddChild(node, n);
                node.jjtSetParent(aSTGroupGraphPattern);
                ++n;
            }
        }
        return aSTSelectQuery2;
    }

    public static ASTSelectQuery genSelectQuery(List<Node> list, List<Node> list2) throws ParseException {
        return OptimizerUtils.genSelectQuery(list, list2, true, null);
    }

    /*
     * WARNING - void declaration
     */
    public static ASTSelectQuery genSelectQuery(List<Node> list, List<Node> list2, boolean bl, Set<String> set) throws ParseException {
        ASTSelectQuery aSTSelectQuery = new ASTSelectQuery(7);
        aSTSelectQuery.noGraphMask = true;
        HashSet<ASTTripleAtom> hashSet = new HashSet<ASTTripleAtom>();
        if (set == null) {
            for (Node object2 : list) {
                hashSet.addAll(OptimizerUtils.collectVisibleVars(object2));
            }
        } else {
            for (String string : set) {
                ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
                aSTTripleAtom.type = 0;
                aSTTripleAtom.name = string;
                hashSet.add(aSTTripleAtom);
            }
        }
        ASTSelectClause aSTSelectClause = OptimizerUtils.genSelectClause(hashSet, list2);
        aSTSelectQuery.jjtAddChild(aSTSelectClause, 0);
        aSTSelectClause.jjtSetParent(aSTSelectQuery);
        if (!list2.isEmpty()) {
            aSTSelectQuery.getselDesc().setHasExpression();
        }
        aSTSelectQuery.getselDesc().populateSelDesc(aSTSelectQuery, false);
        ASTSelectQuery aSTSelectQuery2 = aSTSelectQuery;
        int n = 1;
        if (bl) {
            ASTGroupGraphPattern aSTGroupGraphPattern = new ASTGroupGraphPattern(48);
            aSTGroupGraphPattern.jjtSetParent(aSTSelectQuery);
            aSTSelectQuery.jjtAddChild(aSTGroupGraphPattern, 1);
            aSTGroupGraphPattern.jjtSetInitCapacity(list.size());
            n = 0;
        }
        for (Node node : list) {
            void var7_12;
            var7_12.jjtAddChild(node, n);
            node.jjtSetParent((Node)var7_12);
            ++n;
        }
        return aSTSelectQuery;
    }

    public static ASTSelectClause genSelectClause(List<String> list, List<Node> list2) {
        ArrayList<ASTTripleAtom> arrayList = new ArrayList<ASTTripleAtom>(list.size());
        for (String string : list) {
            ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
            aSTTripleAtom.name = string.toUpperCase();
            aSTTripleAtom.type = 0;
            arrayList.add(aSTTripleAtom);
        }
        return OptimizerUtils.genSelectClause(arrayList, list2);
    }

    public static ASTSelectClause genSelectClause(Collection<ASTTripleAtom> collection, List<Node> list) {
        ASTSelectClause aSTSelectClause = new ASTSelectClause(8);
        int n = collection.size();
        if (list != null) {
            n += list.size();
        }
        aSTSelectClause.jjtSetInitCapacity(n);
        int n2 = 0;
        for (ASTTripleAtom node : collection) {
            node.jjtSetParent(aSTSelectClause);
            aSTSelectClause.jjtAddChild(node, n2);
            ++n2;
        }
        if (list != null) {
            for (Node node : list) {
                ASTSelectExpression aSTSelectExpression = new ASTSelectExpression(9);
                Node node2 = node.jjtGetChild(0);
                node2.jjtSetParent(aSTSelectExpression);
                Node node3 = node.jjtGetChild(1);
                node3.jjtSetParent(aSTSelectExpression);
                if (((SimpleNode)node).id == 53) {
                    aSTSelectExpression.setComment(((ASTBind)node).getComment());
                }
                aSTSelectExpression.jjtSetInitCapacity(2);
                aSTSelectExpression.jjtAddChild(node2, 0);
                aSTSelectExpression.jjtAddChild(node3, 1);
                aSTSelectExpression.jjtSetParent(aSTSelectClause);
                aSTSelectClause.jjtAddChild(aSTSelectExpression, n2);
                ++n2;
            }
        }
        return aSTSelectClause;
    }

    public static Set<ASTTripleAtom> collectVisibleVars(Node node) {
        HashSet<ASTTripleAtom> hashSet = new HashSet<ASTTripleAtom>();
        Stack<Node> stack = new Stack<Node>();
        stack.push(node);
        while (!stack.isEmpty()) {
            Node node2 = (Node)stack.pop();
            int n = ((SimpleNode)node2).id;
            if (n == 73) {
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)node2;
                if (aSTTripleAtom.type != 0 && aSTTripleAtom.type != 9) continue;
                hashSet.add((ASTTripleAtom)node2);
                continue;
            }
            if (n == 7) {
                ASTSelectQuery aSTSelectQuery = (ASTSelectQuery)node2;
                List<String> list = aSTSelectQuery.getselDesc().getSelectList();
                for (String string : list) {
                    ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
                    aSTTripleAtom.name = string.toUpperCase();
                    aSTTripleAtom.type = 0;
                    hashSet.add(aSTTripleAtom);
                }
                continue;
            }
            if (n == 54 || n == 56 || n == 13) continue;
            for (int i = node2.jjtGetNumChildren() - 1; i >= 0; --i) {
                stack.push(node2.jjtGetChild(i));
            }
        }
        return hashSet;
    }

    public static Set<String> collectVisibleVarNames(Node node) {
        Set<ASTTripleAtom> set = OptimizerUtils.collectVisibleVars(node);
        HashSet<String> hashSet = new HashSet<String>();
        for (ASTTripleAtom aSTTripleAtom : set) {
            hashSet.add(aSTTripleAtom.name.toUpperCase());
        }
        return hashSet;
    }

    public static boolean hasBNVar(Node node) {
        Stack<Node> stack = new Stack<Node>();
        stack.push(node);
        while (!stack.isEmpty()) {
            Node node2 = (Node)stack.pop();
            int n = ((SimpleNode)node2).id;
            if (n == 73) {
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)node2;
                if (aSTTripleAtom.type != 0 || !aSTTripleAtom.name.startsWith("B$")) continue;
                return true;
            }
            for (int i = node2.jjtGetNumChildren() - 1; i >= 0; --i) {
                stack.push(node2.jjtGetChild(i));
            }
        }
        return false;
    }

    public static List<String> collectBNVars(Node node) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Stack<Node> stack = new Stack<Node>();
        stack.push(node);
        while (!stack.isEmpty()) {
            Node node2 = (Node)stack.pop();
            int n = ((SimpleNode)node2).id;
            if (n == 73) {
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)node2;
                if (aSTTripleAtom.type != 0 || !aSTTripleAtom.name.startsWith("B$") || aSTTripleAtom.name.startsWith("B$$")) continue;
                aSTTripleAtom.name = aSTTripleAtom.name.replaceFirst("B\\$", "B\\$\\$");
                if (arrayList.contains(aSTTripleAtom.name)) continue;
                arrayList.add(aSTTripleAtom.name);
                continue;
            }
            for (int i = node2.jjtGetNumChildren() - 1; i >= 0; --i) {
                stack.push(node2.jjtGetChild(i));
            }
        }
        return arrayList;
    }

    public static List<Node> buildBNListFromBNVars(List<String> list) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (String string : list) {
            ASTBuiltInCall aSTBuiltInCall = new ASTBuiltInCall(88);
            aSTBuiltInCall.name = "BNODE";
            ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
            aSTTripleAtom.type = 0;
            aSTTripleAtom.name = string;
            ASTSelectExpression aSTSelectExpression = new ASTSelectExpression(9);
            aSTSelectExpression.jjtAddChild(aSTBuiltInCall, 0);
            aSTSelectExpression.jjtAddChild(aSTTripleAtom, 1);
            arrayList.add(aSTSelectExpression);
        }
        return arrayList;
    }

    public static void removeAliasedExpressions(Node node) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Node node2 = node.jjtGetChild(i);
            if (node2.jjtGetNumChildren() <= 1) continue;
            Node node3 = node2.jjtGetChild(1);
            node2.jjtSetInitCapacity(1);
            node2.jjtAddChild(node3, 0);
        }
    }

    public static boolean isGPNTBind(Node node) {
        boolean bl = false;
        int n = ((SimpleNode)node).id;
        if (((SimpleNode)node).id == 49 && node.jjtGetNumChildren() == 1 && ((SimpleNode)node.jjtGetChild((int)0)).id == 53) {
            bl = true;
        }
        return bl;
    }

    public static boolean isGPNTFilter(Node node) {
        boolean bl = false;
        int n = ((SimpleNode)node).id;
        if (((SimpleNode)node).id == 49 && node.jjtGetNumChildren() == 1 && ((SimpleNode)node.jjtGetChild((int)0)).id == 56) {
            bl = true;
        }
        return bl;
    }

    public static boolean isExistsNode(SimpleNode simpleNode) {
        String string;
        boolean bl = false;
        if (simpleNode.id == 88 && ((string = ((ASTBuiltInCall)simpleNode).name).equals("EXISTS") || string.equals("NOT EXISTS"))) {
            bl = true;
        }
        return bl;
    }

    public static boolean isAggregateNode(SimpleNode simpleNode) {
        int n = simpleNode.id;
        if (n == 89) {
            return true;
        }
        if ((n == 58 || n == 90) && simpleNode.jjtGetNumChildren() > 0) {
            ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode.jjtGetChild(0);
            String string = aSTTripleAtom.name;
            if (string.contains("http://xmlns.oracle.com/rdf/aggExtensions/")) {
                return true;
            }
        }
        return false;
    }

    public static ASTGraphPatternNotTriples buildUnionGGP(Node node) throws ParseException {
        Object object;
        int n;
        ASTGraphPatternNotTriples aSTGraphPatternNotTriples = new ASTGraphPatternNotTriples(49);
        ASTGroupGraphPattern aSTGroupGraphPattern = new ASTGroupGraphPattern(48);
        aSTGraphPatternNotTriples.jjtAddChild(aSTGroupGraphPattern, 0);
        aSTGroupGraphPattern.jjtSetParent(aSTGraphPatternNotTriples);
        ASTGraphPatternNotTriples aSTGraphPatternNotTriples2 = new ASTGraphPatternNotTriples(49);
        aSTGroupGraphPattern.jjtAddChild(aSTGraphPatternNotTriples2, 0);
        aSTGraphPatternNotTriples2.jjtSetParent(aSTGroupGraphPattern);
        ASTUnionGraphPattern aSTUnionGraphPattern = new ASTUnionGraphPattern(55);
        aSTGraphPatternNotTriples2.jjtAddChild(aSTUnionGraphPattern, 0);
        aSTUnionGraphPattern.jjtSetParent(aSTGraphPatternNotTriples2);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        boolean bl = false;
        int n2 = 0;
        for (n = 0; n < node.jjtGetNumChildren() && !bl; ++n) {
            object = node.jjtGetChild(n);
            if (((SimpleNode)object).id == 73 && ((ASTTripleAtom)object).type == 0) {
                arrayList.add((Node)object);
                continue;
            }
            bl = true;
            n2 = n;
        }
        if (node.jjtGetNumChildren() % n2 != 0) {
            throw new ParseException("Incorrect number of BINDINGS specified");
        }
        n = 0;
        object = new ArrayList(n2);
        for (int i = n2; i < node.jjtGetNumChildren(); ++i) {
            if (i % n2 == 0 && i != n2) {
                ASTGroupGraphPattern aSTGroupGraphPattern2 = OptimizerUtils.buildSingleSelect(arrayList, (List<Node>)object);
                aSTUnionGraphPattern.jjtAddChild(aSTGroupGraphPattern2, n);
                aSTGroupGraphPattern2.jjtSetParent(aSTUnionGraphPattern);
                ++n;
                object.clear();
            }
            object.add(node.jjtGetChild(i));
        }
        if (!object.isEmpty()) {
            ASTGroupGraphPattern aSTGroupGraphPattern3 = OptimizerUtils.buildSingleSelect(arrayList, (List<Node>)object);
            aSTUnionGraphPattern.jjtAddChild(aSTGroupGraphPattern3, n);
            aSTGroupGraphPattern3.jjtSetParent(aSTUnionGraphPattern);
            ++n;
        }
        return aSTGraphPatternNotTriples;
    }

    public static ASTGraphPatternNotTriples nestDataBlock(Node node) {
        ASTGraphPatternNotTriples aSTGraphPatternNotTriples = new ASTGraphPatternNotTriples(49);
        ASTInlineData aSTInlineData = new ASTInlineData(24);
        aSTGraphPatternNotTriples.jjtAddChild(aSTInlineData, 0);
        aSTInlineData.jjtSetParent(aSTGraphPatternNotTriples);
        aSTInlineData.jjtAddChild(node, 0);
        node.jjtSetParent(aSTInlineData);
        return aSTGraphPatternNotTriples;
    }

    public static ASTGroupGraphPattern buildSingleSelect(List<Node> list, List<Node> list2) {
        Node node2;
        int n = 0;
        for (Node node2 : list2) {
            if (((SimpleNode)node2).id != 91) continue;
            ++n;
        }
        ASTGroupGraphPattern aSTGroupGraphPattern = new ASTGroupGraphPattern(48);
        node2 = new ASTSelectQuery(7);
        ((SimpleNode)node2).jjtSetInitCapacity(2);
        ASTSelectClause aSTSelectClause = new ASTSelectClause(8);
        if (list2.size() - n > 0) {
            aSTSelectClause.jjtSetInitCapacity(list2.size() - n);
        }
        aSTSelectClause.jjtSetParent(node2);
        ((SimpleNode)node2).jjtAddChild(aSTSelectClause, 0);
        int n2 = 0;
        for (int i = 0; i < list2.size(); ++i) {
            Node node3 = list2.get(i);
            if (((SimpleNode)node3).id == 91) continue;
            ASTSelectExpression aSTSelectExpression = new ASTSelectExpression(9);
            Node node4 = node3.cloneNode();
            node4.jjtSetParent(aSTSelectExpression);
            Node node5 = list.get(i).cloneNode();
            node5.jjtSetParent(aSTSelectExpression);
            aSTSelectExpression.jjtSetInitCapacity(2);
            aSTSelectExpression.jjtAddChild(node4, 0);
            aSTSelectExpression.jjtAddChild(node5, 1);
            aSTSelectExpression.jjtSetParent(aSTSelectClause);
            aSTSelectClause.jjtAddChild(aSTSelectExpression, n2);
            ++n2;
        }
        if (n2 > 0) {
            ((ASTSelectQuery)node2).getselDesc().setHasExpression();
            ((ASTSelectQuery)node2).getselDesc().populateSelDesc(node2, false);
            ASTGroupGraphPattern aSTGroupGraphPattern2 = new ASTGroupGraphPattern(48);
            aSTGroupGraphPattern2.jjtSetParent(node2);
            ((SimpleNode)node2).jjtAddChild(aSTGroupGraphPattern2, 1);
            aSTGroupGraphPattern.jjtAddChild(node2, 0);
            ((SimpleNode)node2).jjtSetParent(aSTGroupGraphPattern);
        }
        return aSTGroupGraphPattern;
    }

    public static boolean containsAggregate(Node node) {
        return OptimizerUtils.containsNodeType(node, 89) || OptimizerUtils.containsUserDefinedOrSpatialAggregate(node);
    }

    public static boolean containsNodeType(Node node, int n) {
        return OptimizerUtils.containsNodeType(node, new int[]{n});
    }

    public static boolean containsNodeType(Node node, int[] nArray) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.offer(node);
        boolean bl = false;
        while (!bl && !linkedList.isEmpty()) {
            int n;
            SimpleNode simpleNode = (SimpleNode)linkedList.remove();
            for (n = 0; n < nArray.length && !bl; ++n) {
                if (simpleNode.id != nArray[n]) continue;
                bl = true;
            }
            if (bl) continue;
            for (n = 0; n < simpleNode.jjtGetNumChildren(); ++n) {
                linkedList.offer(simpleNode.jjtGetChild(n));
            }
        }
        return bl;
    }

    public static Set<ASTTripleAtom> collectAllVariables(Node node) {
        HashSet<ASTTripleAtom> hashSet = new HashSet<ASTTripleAtom>();
        List<SimpleNode> list = OptimizerUtils.collectNodesOfType(node, new int[]{73});
        for (SimpleNode simpleNode : list) {
            if (((ASTTripleAtom)simpleNode).type != 0 && ((ASTTripleAtom)simpleNode).type != 9) continue;
            hashSet.add((ASTTripleAtom)simpleNode);
        }
        return hashSet;
    }

    public static List<SimpleNode> collectNodesOfType(Node node, int[] nArray) {
        ArrayList<SimpleNode> arrayList = new ArrayList<SimpleNode>();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        linkedList.offer(node);
        while (!linkedList.isEmpty()) {
            int n;
            SimpleNode simpleNode = (SimpleNode)linkedList.remove();
            for (n = 0; n < nArray.length; ++n) {
                if (simpleNode.id != nArray[n]) continue;
                arrayList.add(simpleNode);
            }
            for (n = 0; n < simpleNode.jjtGetNumChildren(); ++n) {
                linkedList.offer(simpleNode.jjtGetChild(n));
            }
        }
        return arrayList;
    }

    public static boolean containsFunction(Node node, String[] stringArray, String[] stringArray2) {
        Stack<Node> stack = new Stack<Node>();
        stack.push(node);
        while (!stack.isEmpty()) {
            SimpleNode simpleNode = (SimpleNode)stack.pop();
            if (simpleNode.id == 90) {
                int n;
                String string = ((ASTTripleAtom)simpleNode.jjtGetChild((int)0)).name;
                if (stringArray != null) {
                    for (n = 0; n < stringArray.length; ++n) {
                        if (!string.equals(stringArray[n])) continue;
                        return true;
                    }
                }
                if (stringArray2 != null) {
                    for (n = 0; n < stringArray2.length; ++n) {
                        if (!string.contains(stringArray2[n])) continue;
                        return true;
                    }
                }
            }
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                stack.push(simpleNode.jjtGetChild(i));
            }
        }
        return false;
    }

    public static boolean containsBuiltIn(Node node, String[] stringArray) {
        Stack<Node> stack = new Stack<Node>();
        stack.push(node);
        while (!stack.isEmpty()) {
            SimpleNode simpleNode = (SimpleNode)stack.pop();
            if (simpleNode.id == 88) {
                String string = ((ASTBuiltInCall)simpleNode).name;
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!string.equals(stringArray[i])) continue;
                        return true;
                    }
                }
            }
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                stack.push(simpleNode.jjtGetChild(i));
            }
        }
        return false;
    }

    public static boolean containsTextFilter(Node node) {
        String[] stringArray = new String[]{"http://xmlns.oracle.com/rdf/textContains", "http://xmlns.oracle.com/rdf/textScore", "http://xmlns.oracle.com/rdf/like"};
        return OptimizerUtils.containsFunction(node, stringArray, null);
    }

    public static boolean containsUserDefinedOrSpatialAggregate(Node node) {
        String[] stringArray = new String[]{"http://xmlns.oracle.com/rdf/geo/aggrCentroid", "http://xmlns.oracle.com/rdf/geo/aggrConcatLines", "http://xmlns.oracle.com/rdf/geo/aggrConvexhull", "http://xmlns.oracle.com/rdf/geo/aggrMBR", "http://xmlns.oracle.com/rdf/geo/aggrUnion", "http://www.opengis.net/def/function/geosparql/aggBoundingBox", "http://www.opengis.net/def/function/geosparql/aggBoundingCircle", "http://www.opengis.net/def/function/geosparql/aggCentroid", "http://www.opengis.net/def/function/geosparql/aggConcaveHull", "http://www.opengis.net/def/function/geosparql/aggConvexHull", "http://www.opengis.net/def/function/geosparql/aggUnion"};
        String[] stringArray2 = new String[]{"http://xmlns.oracle.com/rdf/aggExtensions/"};
        return OptimizerUtils.containsFunction(node, stringArray, stringArray2);
    }

    public static boolean containsNonBooleanConstant(Node node) {
        boolean bl = false;
        if (node != null) {
            Stack<Node> stack = new Stack<Node>();
            stack.push(node);
            while (!stack.empty() && !bl) {
                SimpleNode simpleNode = (SimpleNode)stack.pop();
                if (simpleNode.id == 73) {
                    ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode;
                    if (aSTTripleAtom.type == 0 || aSTTripleAtom.litType != null && aSTTripleAtom.litType.equals("http://www.w3.org/2001/XMLSchema#boolean")) continue;
                    bl = true;
                    continue;
                }
                for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                    stack.push(simpleNode.jjtGetChild(i));
                }
            }
        }
        return bl;
    }

    public static boolean containsNegatedComparison(Node node) {
        boolean bl = false;
        if (node != null) {
            Stack<Node> stack = new Stack<Node>();
            stack.push(node);
            while (!stack.empty() && !bl) {
                SimpleNode simpleNode = (SimpleNode)stack.pop();
                if (simpleNode.id == 81) {
                    ASTComparisonOperator aSTComparisonOperator = (ASTComparisonOperator)simpleNode;
                    if (aSTComparisonOperator.name.equals("!=") || aSTComparisonOperator.name.equals("NOT IN")) {
                        bl = true;
                    }
                }
                if (bl) continue;
                for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                    stack.push(simpleNode.jjtGetChild(i));
                }
            }
        }
        return bl;
    }

    public static boolean isRewritableEFilterTB(Node node) {
        ASTTriplesBlock aSTTriplesBlock;
        if (((SimpleNode)node).id == 47 && (aSTTriplesBlock = (ASTTriplesBlock)node).jjtGetNumChildren() >= 3) {
            SimpleNode simpleNode = (SimpleNode)aSTTriplesBlock.jjtGetChild(1);
            if ((simpleNode.id == 67 || simpleNode.id == 64) && simpleNode.jjtGetNumChildren() == 2 && ((SimpleNode)simpleNode.jjtGetChild((int)1)).id == 57) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasAncestorType(Node node, int n) {
        for (Node node2 = node.jjtGetParent(); node2 != null; node2 = node2.jjtGetParent()) {
            if (((SimpleNode)node2).id != n) continue;
            return true;
        }
        return false;
    }
}

