/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import oracle.spatial.rdf.server.BasicGraphPattern;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.Hint;
import oracle.spatial.rdf.server.HintEngine;
import oracle.spatial.rdf.server.HintEngineAdapter;
import oracle.spatial.rdf.server.HintGenerator;
import oracle.spatial.rdf.server.HintZeroHintGenerator;
import oracle.spatial.rdf.server.PPNode;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLBGP;
import oracle.spatial.rdf.server.SPARQLTriplesBlock;
import oracle.spatial.rdf.server.SPMComponents;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SimplePPSQLTransVisitor;
import oracle.spatial.rdf.server.TriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;

public class InmemoryVMBGP
implements SPARQLBGP {
    private static final String BAD_CONST_QUERY = " IN (SELECT NULL FROM mdsys.rdf_namespace$ where rownum < 1)";
    private static final String WITH_ALIAS = "BASIC_TRIPLES";
    private static final String PUSHED_BGP_ALIAS = "PBGP";
    private static final String GRAPH_ALIAS = "VG";
    private static final String NO_INDEX_HINT = "NO_INDEX";
    private static final String BLOOM_FILTER_HINT = "PX_JOIN_FILTER";
    private BasicGraphPattern bgp;
    private Map<String, String> varset;
    private List<SPARQLTriplesBlock> myTrips;
    private Set<String> variablesToBeJoined;
    private Set<ASTTripleAtom.BindVar> bindVarsToJoin;
    private List<Filter> filters;
    private Map<String, Integer> hint0leadPosMap;
    private SQLGenContext ctx = null;
    private String userHint = "";
    private Set<String> projectVars;
    private Set<String> leftJoinVars;
    private Map<String, String> varAliases;
    private Map<String, String> varIDs;
    private Map<String, String> varTabs;
    private Map<String, String> varBGPIDs;
    private Map<String, String> withMap;
    private int id;
    private boolean m_bLog = false;
    private HintGenerator hintG;
    private String sqlHint;
    private Set<String> lexVars;
    private Set<ASTTripleAtom.BindVar> bindVars;
    private Map<Hint.QueryOption, String> queryOptions;
    private String link_tab = "BASIC_TRIPLES";
    private String subjectCol = "START_NODE_ID";
    private String predicateCol = "P_VALUE_ID";
    private String canonObjCol = "CANON_END_NODE_ID";
    private String exactObjCol = "END_NODE_ID";
    private String gidCol = "G_ID";
    private String gnameCol = "G_NAME";
    private String values_tab;
    private String netName;
    private String netOwner;
    private String vname_col = "VALUE_NAME";
    private String vid_col = "VALUE_ID";
    private String vtype_col = "VALUE_TYPE";
    private String prefix_col = "VNAME_PREFIX";
    private String suffix_col = "VNAME_SUFFIX";
    private String litType_col = "LITERAL_TYPE";
    private String langType_col = "LANGUAGE_TYPE";
    private String longLit_col = "LONG_VALUE";
    private String term_col = "RDFTERM";
    private String ordNum_col = "ORDER_NUM";
    private String ordDate_col = "ORDER_DATE";
    private String ordType_col = "ORDER_TYPE";
    private String subjSuffix = "_S";
    private String predSuffix = "_P";
    private String objSuffix = "_O";
    private String vid_alias = "$RDFVID";
    private String vtype_alias = "$RDFVTYP";
    private String prefix_alias = "$_PREFIX";
    private String suffix_alias = "$_SUFFIX";
    private String litType_alias = "$RDFLTYP";
    private String langType_alias = "$RDFLANG";
    private String longLit_alias = "$RDFCLOB";
    private String term_alias = "$RDFTERM";
    private String onum_alias = "$RDFONUM";
    private String odate_alias = "$RDFODATE";
    private String otype_alias = "$RDFOTYP";
    private SPARQLBGP pushedBGP = null;
    private String pushedBGPAlias = "";
    private boolean hasPushedBGP = false;
    private boolean graphQuery = false;
    private ASTTripleAtom activeGraph = null;
    private String graphVar = null;
    private boolean disconnected = false;
    private List<String> optLinkAliasList;
    private boolean distinctCLOB = false;
    private Set<String> needCLOBVars = null;

    private static void log(String string) {
        System.out.print("\n");
        System.out.print(string);
    }

    public InmemoryVMBGP(int n, SQLGenContext sQLGenContext) {
        this.id = n;
        this.ctx = sQLGenContext;
        this.bgp = new BasicGraphPattern();
        this.varset = new HashMap<String, String>();
        this.myTrips = new ArrayList<SPARQLTriplesBlock>();
        this.variablesToBeJoined = new HashSet<String>();
        this.bindVarsToJoin = new HashSet<ASTTripleAtom.BindVar>();
        this.leftJoinVars = new HashSet<String>();
        this.filters = new ArrayList<Filter>();
        this.hint0leadPosMap = new HashMap<String, Integer>();
        this.projectVars = new HashSet<String>();
        this.varAliases = new HashMap<String, String>();
        this.varIDs = new HashMap<String, String>();
        this.varTabs = new HashMap<String, String>();
        this.varBGPIDs = new HashMap<String, String>();
        this.withMap = new HashMap<String, String>();
        this.queryOptions = new HashMap<Hint.QueryOption, String>();
        this.userHint = null;
        this.hintG = sQLGenContext.useOldHintGenerator ? new HintZeroHintGenerator(sQLGenContext, true) : new HintEngineAdapter(HintEngine.getDefaultInstance(), sQLGenContext);
        this.hintG.setSPARQLBGP(this);
        this.sqlHint = "";
        this.graphQuery = false;
        this.activeGraph = null;
        this.disconnected = false;
        this.optLinkAliasList = null;
        this.lexVars = new HashSet<String>();
        this.bindVars = new HashSet<ASTTripleAtom.BindVar>();
        this.distinctCLOB = false;
        this.needCLOBVars = new HashSet<String>();
        this.values_tab = QueryUtils.escapeSingleQuotes(QueryUtils.getLocalValueDollarName(sQLGenContext.clnPfxForRdfObjName));
        this.netName = QueryUtils.escapeSingleQuotes(sQLGenContext.clnNetworkName);
        this.netOwner = QueryUtils.escapeSingleQuotes(sQLGenContext.clnNetworkOwner);
        this.initLinkTab();
    }

    @Override
    public SPARQLBGP shallowClone() throws RDFException {
        InmemoryVMBGP inmemoryVMBGP = new InmemoryVMBGP(this.id, this.ctx);
        for (SPARQLTriplesBlock sPARQLTriplesBlock : this.myTrips) {
            inmemoryVMBGP.addTriplesBlock(sPARQLTriplesBlock);
        }
        if (this.hasPushedBGP) {
            SPARQLBGP sPARQLBGP = this.pushedBGP.shallowClone();
            inmemoryVMBGP.pushBGP(sPARQLBGP, this.pushedBGPAlias);
        }
        return inmemoryVMBGP;
    }

    @Override
    public void setIsGraphQuery(boolean bl) {
        this.graphQuery = bl;
        this.initLinkTab();
    }

    @Override
    public boolean isGraphQuery() {
        return this.graphQuery;
    }

    @Override
    public void setActiveGraph(ASTTripleAtom aSTTripleAtom) {
        this.activeGraph = aSTTripleAtom;
        if (this.activeGraph.type == 0) {
            this.graphVar = this.activeGraph.name.toUpperCase();
        } else if (this.activeGraph.type == 9) {
            ASTTripleAtom.BindVar bindVar = new ASTTripleAtom.BindVar(aSTTripleAtom.bindId, aSTTripleAtom.name);
            this.bindVars.add(bindVar);
            this.graphVar = bindVar.bvName;
        }
    }

    @Override
    public void addUserHint(String string) {
        this.userHint = string;
        this.hintG.setUserHint(string);
    }

    @Override
    public String getJoinHint(String string, String string2) {
        return this.hintG.generateJoinHint(string, string2);
    }

    @Override
    public String getAntiJoinHint() {
        return this.hintG.generateAntiJoinHint();
    }

    @Override
    public String getValueJoinHint(Collection<String> collection, String string) {
        return this.hintG.generateValueJoinHint(collection, string);
    }

    @Override
    public void addTriplesBlock(SPARQLTriplesBlock sPARQLTriplesBlock) {
        ASTTripleAtom[] aSTTripleAtomArray = new ASTTripleAtom[]{sPARQLTriplesBlock.getSubject(), sPARQLTriplesBlock.getPredicate(), sPARQLTriplesBlock.getObject()};
        this.myTrips.add(sPARQLTriplesBlock);
        this.bgp.addTriplesBlock(sPARQLTriplesBlock, this.ctx);
        this.populateFromTBs();
        aSTTripleAtomArray[0].flags += 16;
        aSTTripleAtomArray[1].flags += 32;
        aSTTripleAtomArray[2].flags += 64;
    }

    @Override
    public void addOptionalTriplesBlock(SPARQLTriplesBlock sPARQLTriplesBlock) throws RDFException {
        throw new RDFException("OPTIONAL inlining not supported for In-memory Virtual Column");
    }

    @Override
    public List<SPARQLTriplesBlock> getTriplesBlocks() {
        return this.myTrips;
    }

    @Override
    public List<SPARQLTriplesBlock> getMandatoryTriplesBlocks() {
        return this.myTrips;
    }

    @Override
    public List<SPARQLTriplesBlock> getOptionalTriplesBlocks() {
        return Collections.emptyList();
    }

    @Override
    public int getNumTriples() {
        return this.bgp.numTriples();
    }

    @Override
    public boolean addFilter(Filter filter) {
        boolean bl = true;
        if (this.ctx.allRejectFilter) {
            bl = false;
        } else {
            Set<String> set = filter.getVars();
            for (String string : set) {
                if (!this.shouldRejectVar(string)) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.filters.add(filter);
            }
        }
        return bl;
    }

    @Override
    public Set<String> addProjectVars(Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (this.shouldRejectVar(string)) {
                hashSet.add(string);
                continue;
            }
            this.projectVars.add(string);
        }
        return hashSet;
    }

    @Override
    public boolean addProjectVar(String string) {
        boolean bl = true;
        if (this.shouldRejectVar(string)) {
            bl = false;
        } else {
            this.projectVars.add(string);
        }
        return bl;
    }

    @Override
    public Set<String> getAllLexVars() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.lexVars);
        hashSet.addAll(this.getRequiredLexVars());
        if (this.hasPushedBGP) {
            hashSet.addAll(this.pushedBGP.getAllLexVars());
        }
        return hashSet;
    }

    @Override
    public Set<String> getRequiredLexVars() {
        HashSet<String> hashSet = new HashSet<String>();
        if ((this.ctx.lexJoinFlags & 1) == 1) {
            hashSet.addAll(this.getBGPVars());
            if (this.hasPushedBGP) {
                hashSet.addAll(this.pushedBGP.getRequiredLexVars());
            }
        }
        return hashSet;
    }

    @Override
    public boolean addLexVar(String string) {
        boolean bl = true;
        if (this.shouldRejectVar(string)) {
            bl = false;
        } else {
            this.lexVars.add(string);
        }
        return bl;
    }

    @Override
    public Set<String> addLexVars(Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (!this.shouldRejectVar(string)) {
                this.lexVars.add(string);
                continue;
            }
            hashSet.add(string);
        }
        return hashSet;
    }

    @Override
    public void pushBGP(SPARQLBGP sPARQLBGP, String string) {
        this.hasPushedBGP = true;
        this.pushedBGP = sPARQLBGP;
        this.pushedBGPAlias = string;
    }

    @Override
    public boolean needsParentBGPPushDown() {
        return this.hintG.specifiesBGPPushDown();
    }

    @Override
    public boolean verifyPushedBGP() {
        boolean bl = true;
        if ((this.ctx.contextFlags & 4) == 4 && this.graphVar != null && this.getAllLexVars().contains(this.graphVar)) {
            this.hasPushedBGP = false;
            this.pushedBGP = null;
            this.pushedBGPAlias = "";
            bl = false;
        }
        return bl;
    }

    @Override
    public void addJoinVarsForHint(Set<String> set) {
        this.leftJoinVars.addAll(set);
    }

    @Override
    public Set<String> getJoinVarsForHint() {
        return Collections.unmodifiableSet(this.leftJoinVars);
    }

    @Override
    public Set<String> getBindVars() {
        HashSet<String> hashSet = new HashSet<String>();
        for (ASTTripleAtom.BindVar bindVar : this.bindVars) {
            hashSet.add(bindVar.bvName);
        }
        return hashSet;
    }

    @Override
    public void popSPMAuxTabsInfo() {
    }

    @Override
    public Set<String> getSPMAuxValueVars() {
        Set<String> set = Collections.emptySet();
        return set;
    }

    @Override
    public void genOuterSelectComponents(Set<String> set, Set<String> set2, Map<String, List<String>> map, String[] stringArray, String[] stringArray2, Map<String, String> map2, Set<String> set3) throws SQLException {
        if ((this.ctx.contextFlags & 8) > 0) {
            QueryUtils.genOuterSelectComponents(set, set2, map, stringArray, stringArray2, map2, this.values_tab, this.ctx);
        } else {
            QueryUtils.genOuterSelectComponents(set, set2, map, stringArray, stringArray2, map2, this.values_tab, set3, false, this.ctx.clnNetworkName);
        }
    }

    @Override
    public String buildSubQForCLOB(String string, String string2, String string3) throws SQLException {
        return QueryUtils.buildSubQForCLOB(string, string2, string3, this.values_tab, this.ctx.clnNetworkName);
    }

    @Override
    public String buildSubQForCLOB(String string, String string2, String string3, Set<String> set) throws SQLException {
        return this.buildSubQForCLOB(string, string2, string3);
    }

    @Override
    public String distinctGraphsQuery(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.ctx.optDistinctGQuery != null && !this.ctx.disableGMVOpt) {
            stringBuffer.append("SELECT " + this.gidCol);
            stringBuffer.append(" AS ").append(string).append(this.vid_alias).append("\n");
            stringBuffer.append("FROM (").append(this.ctx.optDistinctGQuery).append(")");
        } else {
            stringBuffer.append("SELECT DISTINCT ").append(this.gidCol);
            stringBuffer.append(" AS ").append(string).append(this.vid_alias).append("\n");
            stringBuffer.append("FROM ").append(this.link_tab).append("\n");
            stringBuffer.append("WHERE ").append(this.gidCol).append(" IS NOT NULL");
        }
        if (bl) {
            String string2 = "VG." + this.prefix_col + " || " + GRAPH_ALIAS + "." + this.suffix_col;
            String string3 = "R." + string + this.vid_alias;
            String string4 = "VG." + this.vtype_col;
            String string5 = "VG." + this.prefix_col;
            String string6 = "VG." + this.suffix_col;
            String string7 = "VG." + this.litType_col;
            String string8 = "VG." + this.langType_col;
            String string9 = "VG." + this.longLit_col;
            String string10 = this.buildRDFTerm(string2, string4, string7, string8);
            String string11 = "SELECT " + string2 + " AS " + string + ", " + string3 + " AS " + string + this.vid_alias + ", " + string4 + " AS " + string + this.vtype_alias + ", " + string5 + " AS " + string + this.prefix_alias + ", " + string6 + " AS " + string + this.suffix_alias + ", " + string7 + " AS " + string + this.litType_alias + ", " + string8 + " AS " + string + this.langType_alias + ", " + string9 + " AS " + string + this.longLit_alias + "," + string10 + " AS " + string + this.term_alias + "\nFROM (";
            stringBuffer.insert(0, string11);
            stringBuffer.append(") R,\n").append(this.values_tab).append(" ").append(GRAPH_ALIAS).append("\n");
            stringBuffer.append("WHERE R.").append(string).append(this.vid_alias);
            stringBuffer.append("=").append(GRAPH_ALIAS).append(".").append(this.vid_col);
        }
        return stringBuffer.toString();
    }

    @Override
    public List<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public Set<String> getBGPVars() {
        Set<String> set = this.getTriplePatternVars();
        if (this.graphQuery && this.activeGraph != null && (this.activeGraph.type == 0 || this.activeGraph.type == 9)) {
            set.add(this.activeGraph.name.toUpperCase());
        }
        return set;
    }

    @Override
    public Set<String> getMandatoryBGPVars() {
        return this.getBGPVars();
    }

    @Override
    public Set<String> getOptionalBGPVars() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getBGPAndPushedVars() {
        Set<String> set = this.getBGPVars();
        if (this.hasPushedBGP) {
            set.addAll(this.pushedBGP.getBGPAndPushedVars());
        }
        return set;
    }

    @Override
    public Set<String> getDefiniteBoundVars() {
        Set<String> set = this.getTriplePatternVars();
        if (this.graphVar != null && (this.ctx.contextFlags & 4) == 0) {
            set.add(this.graphVar);
        }
        return set;
    }

    @Override
    public Set<String> getDefiniteBoundAndPushedVars() {
        Set<String> set = this.getDefiniteBoundVars();
        if (this.hasPushedBGP) {
            set.addAll(this.pushedBGP.getDefiniteBoundAndPushedVars());
        }
        return set;
    }

    @Override
    public Set<String> getProjectVars() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.projectVars);
        for (String string : this.getAllLexVars()) {
            if (this.shouldRejectVar(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    @Override
    public Set<String> getHintVars() {
        return this.hintG.getHintVars();
    }

    @Override
    public Set<String> getLobVars() {
        Set<String> set = Collections.emptySet();
        return set;
    }

    @Override
    public Set<String> getVcVars() {
        return this.getBGPVars();
    }

    @Override
    public boolean refsNonExistingTerm() {
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            if (triplesBlock.getSubject().exists() && triplesBlock.getPredicate().exists() && triplesBlock.getObject().exists()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setLocalSelectivity() {
    }

    @Override
    public int getLocalSelectivity() {
        return 0;
    }

    @Override
    public void setGlobalSelectivity(int n) {
    }

    @Override
    public String toSQL() throws RDFException {
        if (!this.ctx.disableLocalLexFilterOpt) {
            this.clearLexVarsFromFilters();
        }
        this.popVarsToJoin();
        this.extractVarAliases();
        this.setDisconnected();
        this.sqlHint = this.hintG.generateHint();
        if (this.ctx.useBloomFilter) {
            int n = 0;
            boolean bl = false;
            for (TriplesBlock object2 : this.bgp.TBList) {
                if (object2.getPredicate().getName().equalsIgnoreCase("http://www.w3.org/2002/07/owl#sameAs")) {
                    if (!bl) {
                        this.sqlHint = this.sqlHint.length() == 0 ? "/*+ " : this.sqlHint.replace("*/", "");
                    }
                    bl = true;
                    this.sqlHint = this.sqlHint.concat("NO_INDEX(T" + n + ") ");
                    this.sqlHint = this.sqlHint.concat("PX_JOIN_FILTER(T" + n + ") ");
                }
                ++n;
            }
            if (bl) {
                this.sqlHint = this.sqlHint.concat("*/ ");
            }
        }
        this.queryOptions = this.hintG.getQueryOptions();
        this.initLinkTab();
        if (!this.queryOptions.containsKey((Object)Hint.QueryOption.NO_OPT_TRANS_FOR_LEADING)) {
            this.hint0leadPosMap = this.hintG.getTransOrderMap();
        }
        this.genOptGIDJoinList();
        this.extractVarIDs();
        this.extractVarTabs();
        this.extractVarBGPIDs();
        this.ctx.varBGPIDs = this.varBGPIDs;
        if (this.ctx.startPPOpt) {
            this.optimizePPStartEndNodes();
        }
        List<Filter> list = this.getSecondaryFilters();
        List<String[]> list2 = this.getAncillaryOps();
        String string = this.buildWithClause();
        String string2 = this.buildSelect(list.size() > 0, this.isGraphQuery() && this.getNumTriples() == 0 && (this.ctx.optDistinctGQuery == null || this.ctx.disableGMVOpt), false, list2);
        String string3 = this.buildFrom();
        String string4 = this.buildWhere();
        String string5 = (String)string + string2 + "\n" + string3 + "\n" + string4;
        String string6 = this.applyFilters(string5, this.getBGPAndPushedVars(), this.getProjectVars(), this.getAllLexVars(), this.getBGPVars());
        String string7 = "";
        if (this.isGraphQuery() && this.getNumTriples() == 0 && this.graphVar == null) {
            string7 = " AND ROWNUM < 2";
        }
        string5 = string5 + string6 + string7;
        if (this.distinctCLOB) {
            try {
                string5 = this.wrapForClobs(string5);
            }
            catch (SQLException sQLException) {
                throw new RDFException(sQLException.getMessage(), sQLException);
            }
        }
        if (list.size() > 0) {
            string5 = this.wrapForSecondaryFilters(list, string5);
        }
        return string5;
    }

    private void clearLexVarsFromFilters() {
        for (Filter filter : this.filters) {
            if (filter.containsExists()) continue;
            filter.clearLexVars();
        }
    }

    private List<Filter> getSecondaryFilters() throws RDFException {
        ArrayList<Filter> arrayList = new ArrayList<Filter>();
        for (Filter filter : this.filters) {
            Filter filter2 = filter.extractSecondaryFilter();
            if (filter2 == null) continue;
            arrayList.add(filter2);
        }
        return arrayList;
    }

    private List<String[]> getAncillaryOps() throws RDFException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (Filter filter : this.filters) {
            arrayList.addAll(filter.extractAncInfoForPrim());
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isDisconnected() {
        TriplesBlock triplesBlock = null;
        for (TriplesBlock object2 : this.bgp.TBList) {
            if (!object2.getSubject().isVariable() && !object2.getSubject().isBindVariable() && !object2.getPredicate().isVariable() && !object2.getPredicate().isBindVariable() && !object2.getObject().isVariable() && !object2.getObject().isBindVariable()) continue;
            triplesBlock = object2;
            break;
        }
        if (triplesBlock == null) {
            return false;
        }
        HashSet hashSet = new HashSet();
        Stack<TriplesBlock> stack = new Stack<TriplesBlock>();
        HashSet<TriplesBlock> hashSet2 = new HashSet<TriplesBlock>();
        TriplesBlock triplesBlock2 = null;
        Object var6_7 = null;
        String string = null;
        stack.push(triplesBlock);
        hashSet2.add(triplesBlock);
        while (!stack.isEmpty()) {
            triplesBlock2 = (TriplesBlock)stack.pop();
            for (TriplesBlock.Element element : new TriplesBlock.Element[]{triplesBlock2.getSubject(), triplesBlock2.getPredicate(), triplesBlock2.getObject()}) {
                if (!element.isVariable() && !element.isBindVariable()) continue;
                string = element.getName();
                hashSet.add(string);
                for (TriplesBlock triplesBlock3 : this.bgp.TBList) {
                    if ((!triplesBlock3.getSubject().isVariable() && !triplesBlock3.getSubject().isBindVariable() || !triplesBlock3.getSubject().getName().equals(string)) && (!triplesBlock3.getPredicate().isVariable() && !triplesBlock3.getPredicate().isBindVariable() || !triplesBlock3.getPredicate().getName().equals(string)) && (!triplesBlock3.getObject().isVariable() && !triplesBlock3.getObject().isBindVariable() || !triplesBlock3.getObject().getName().equals(string)) || hashSet2.contains(triplesBlock3)) continue;
                    hashSet2.add(triplesBlock3);
                    stack.push(triplesBlock3);
                }
            }
        }
        TriplesBlock.Element[] elementArray = this.getTriplePatternVars();
        for (String string2 : elementArray) {
            void var10_16;
            if (this.isBindVar(string2)) {
                String string3 = this.getBindVar(string2).getBVStr();
            }
            if (hashSet.contains(var10_16)) continue;
            return true;
        }
        return false;
    }

    private void setDisconnected() {
        this.disconnected = this.isDisconnected();
    }

    private boolean shouldRejectVar(String string) {
        boolean bl = false;
        if (!this.getDefiniteBoundVars().contains(string) && this.getBGPVars().contains(string)) {
            bl = true;
        }
        return bl;
    }

    private void initLinkTab() {
        String string = "(" + this.ctx.defaultGraph + ")";
        if (this.graphQuery) {
            string = "(" + this.ctx.namedGraphs + ")";
        }
        if (this.ctx.vmViewName != null) {
            this.link_tab = this.ctx.vmDefault;
            if (this.graphQuery) {
                this.link_tab = this.ctx.vmNamed;
            }
        } else if (this.queryOptions.containsKey((Object)Hint.QueryOption.USE_WITH)) {
            this.link_tab = WITH_ALIAS;
            this.withMap.put(this.link_tab, string);
        } else {
            this.link_tab = string;
        }
    }

    private void genOptGIDJoinList() {
        this.optLinkAliasList = new ArrayList<String>(this.bgp.TBList.size());
        boolean bl = false;
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        if (!this.hint0leadPosMap.isEmpty()) {
            for (Map.Entry<String, Integer> entry : this.hint0leadPosMap.entrySet()) {
                if (!treeMap.containsKey(entry.getValue())) {
                    if (!this.isValidTabAlias(entry.getKey().toUpperCase())) continue;
                    treeMap.put(entry.getValue(), entry.getKey().toUpperCase());
                    continue;
                }
                bl = true;
                break;
            }
        }
        if (!bl && !this.hint0leadPosMap.isEmpty() && (this.ctx.ngJoinFlags & 4) == 0) {
            for (Map.Entry<String, Integer> entry : treeMap.entrySet()) {
                this.optLinkAliasList.add((String)((Object)entry.getValue()));
            }
        }
        for (int i = 0; i < this.bgp.TBList.size(); ++i) {
            if (this.optLinkAliasList.contains("T" + i)) continue;
            this.optLinkAliasList.add("T" + i);
        }
    }

    private boolean isValidTabAlias(String string) {
        try {
            if (!string.startsWith("T")) {
                return false;
            }
            int n = Integer.parseInt(string.substring(1));
            if (n < 0 || n >= this.bgp.TBList.size()) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private boolean wantGIDCoalesce() {
        boolean bl = (this.ctx.ngJoinFlags & 1) == 0 && (!this.disconnected || (this.ctx.ngJoinFlags & 2) > 0);
        return bl;
    }

    private String buildGidExpr(boolean bl) {
        Object object;
        String string = "##";
        String string2 = null;
        if (this.graphVar != null) {
            string = this.graphVar;
        } else if (this.isGraphQuery() && this.activeGraph.type == 1) {
            string2 = this.ctx.URImap.get(this.activeGraph.name);
        } else if (this.isGraphQuery() && this.activeGraph.type == 9) {
            object = this.getBindVar(string);
            string2 = ((ASTTripleAtom.BindVar)object).getIdCol();
        }
        object = new HashSet();
        if (this.hasPushedBGP) {
            object = this.pushedBGP.getBGPAndPushedVars();
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        n += this.bgp.TBList.size();
        if (object.contains(string)) {
            ++n;
        }
        if ((this.ctx.contextFlags & 4) > 0) {
            ++n;
        }
        if (((this.ctx.contextFlags & 4) > 0 || this.wantGIDCoalesce() && bl) && n > 1) {
            stringBuffer.append("COALESCE(");
            for (int i = 0; i < this.bgp.TBList.size(); ++i) {
                QueryUtils.appendToList(stringBuffer, "T" + i + "." + this.gidCol, ", ", "COALESCE(");
            }
            if (object.contains(string)) {
                QueryUtils.appendToList(stringBuffer, "PBGP." + string + this.vid_alias, ", ", "COALESCE(");
            } else if (string2 != null) {
                QueryUtils.appendToList(stringBuffer, string2, ", ", "COALESCE(");
            }
            if ((this.ctx.contextFlags & 4) > 0) {
                if (bl) {
                    QueryUtils.appendToList(stringBuffer, "0", ", ", "COALESCE(");
                } else {
                    QueryUtils.appendToList(stringBuffer, "NULL", ", ", "COALESCE(");
                }
            }
            stringBuffer.append(")");
        } else if (this.optLinkAliasList != null && !this.optLinkAliasList.isEmpty()) {
            stringBuffer.append(this.optLinkAliasList.get(0) + "." + this.gidCol);
        } else {
            stringBuffer.append("T0." + this.gidCol);
        }
        return stringBuffer.toString();
    }

    private String buildGNameExpr(boolean bl) {
        Object object;
        String string = "##";
        String string2 = null;
        if (this.graphVar != null) {
            string = this.graphVar;
        } else if (this.isGraphQuery() && this.activeGraph.type == 1) {
            string2 = this.ctx.URImap.get(this.activeGraph.name);
        } else if (this.isGraphQuery() && this.activeGraph.type == 9) {
            object = this.getBindVar(string);
            string2 = ((ASTTripleAtom.BindVar)object).bvName;
        }
        object = new HashSet();
        if (this.hasPushedBGP) {
            object = this.pushedBGP.getBGPAndPushedVars();
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        n += this.bgp.TBList.size();
        if (object.contains(string)) {
            ++n;
        }
        if ((this.ctx.contextFlags & 4) > 0) {
            ++n;
        }
        if (((this.ctx.contextFlags & 4) > 0 || this.wantGIDCoalesce() && bl) && n > 1) {
            stringBuffer.append("COALESCE(");
            for (int i = 0; i < this.bgp.TBList.size(); ++i) {
                QueryUtils.appendToList(stringBuffer, "T" + i + "." + this.gnameCol, ", ", "COALESCE(");
            }
            if (object.contains(string)) {
                QueryUtils.appendToList(stringBuffer, "PBGP." + string, ", ", "COALESCE(");
            } else if (string2 != null) {
                QueryUtils.appendToList(stringBuffer, string2, ", ", "COALESCE(");
            }
            if ((this.ctx.contextFlags & 4) > 0) {
                if (bl) {
                    QueryUtils.appendToList(stringBuffer, "0", ", ", "COALESCE(");
                } else {
                    QueryUtils.appendToList(stringBuffer, "NULL", ", ", "COALESCE(");
                }
            }
            stringBuffer.append(")");
        } else if (this.optLinkAliasList != null && !this.optLinkAliasList.isEmpty()) {
            stringBuffer.append(this.optLinkAliasList.get(0) + ".G_NAME");
        } else {
            stringBuffer.append("T0.G_NAME");
        }
        return stringBuffer.toString();
    }

    private String buildGidNVL(String string, String string2) {
        String string3 = string;
        if ((this.ctx.contextFlags & 4) > 0) {
            string3 = "NVL(" + string3 + "," + string2 + ")";
        }
        return string3;
    }

    private Set<String> getTriplePatternVars() {
        return new HashSet<String>(this.varset.keySet());
    }

    public String buildWithClause() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.withMap != null && !this.withMap.isEmpty()) {
            stringBuffer.append("WITH ");
            boolean bl = false;
            for (Map.Entry<String, String> entry : this.withMap.entrySet()) {
                if (bl) {
                    stringBuffer.append(",\n");
                }
                bl = true;
                stringBuffer.append(entry.getKey()).append(" AS (").append(entry.getValue()).append(")");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String wrapForClobs(String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("SELECT R.*");
        String string2 = "";
        for (String string3 : this.needCLOBVars) {
            string2 = this.lexVars.contains(string3) ? "TO_CLOB(NULL)" : this.buildSubQForCLOB(string3, "R." + string3 + this.vid_alias, "R." + string3 + this.prefix_alias);
            QueryUtils.appendToList(stringBuffer, string2 + " AS " + string3 + this.longLit_alias, "\n, ", "");
        }
        return stringBuffer + "\nFROM (" + string + ") R";
    }

    private String wrapForSecondaryFilters(List<Filter> list, String string) throws RDFException {
        HashSet<String> hashSet = new HashSet<String>();
        for (Filter object2 : list) {
            hashSet.addAll(object2.getSecondaryJoinVars());
        }
        HashMap hashMap = new HashMap();
        Map<String, String> map = Collections.emptyMap();
        int n = 0;
        for (String string2 : hashSet) {
            hashMap.put(string2, "V" + n);
            ++n;
        }
        for (String string3 : this.getBGPAndPushedVars()) {
            if (hashMap.containsKey(string3)) continue;
            hashMap.put(string3, "R." + string3);
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("SELECT R.*\n");
        stringBuffer.append("FROM\n");
        stringBuffer.append("(").append(string).append(") R\n");
        for (String string4 : hashSet) {
            stringBuffer.append(", MDSYS.RDF_VALUE$ ").append((String)hashMap.get(string4)).append("\n");
        }
        stringBuffer.append("WHERE (1=1)");
        for (String string5 : hashSet) {
            stringBuffer.append("\nAND ").append("R." + string5 + "$RDFVID = " + (String)hashMap.get(string5) + ".VALUE_ID");
        }
        for (Filter filter : list) {
            stringBuffer.append("\nAND ").append(filter.toSQL(hashMap, map, this.ctx.funcTypeMap, this.ctx.funcHandMap));
        }
        return stringBuffer.toString();
    }

    private String buildSelect(boolean bl, boolean bl2, boolean bl3, List<String[]> list) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("");
        HashSet<String> hashSet = new HashSet<String>();
        if (this.hasPushedBGP) {
            hashSet.addAll(this.pushedBGP.getBGPAndPushedVars());
        }
        for (String string : this.getBGPAndPushedVars()) {
            QueryUtils.appendToList(stringBuffer, this.buildSelectListForVar(string, hashSet, bl2, bl3, this.varIDs), ",\n", "");
        }
        if ((this.ctx.contextFlags & 1) > 0) {
            if (this.bgp.TBList.size() > 0) {
                QueryUtils.appendToList(stringBuffer, " T0.CTXT2 as T0_CTXT2 ", ",\n", "");
            } else {
                QueryUtils.appendToList(stringBuffer, " NULL as T0_CTXT2 ", ",\n", "");
            }
        } else if ((this.ctx.contextFlags & 2) > 0) {
            object = new StringBuffer();
            if (this.bgp.TBList.size() > 1) {
                ((StringBuffer)object).append(" COALESCE(T0.CTXT2");
                for (int i = 1; i < this.bgp.TBList.size(); ++i) {
                    ((StringBuffer)object).append(", T" + i + ".CTXT2");
                }
                ((StringBuffer)object).append(") ");
            } else if (this.bgp.TBList.size() == 1) {
                ((StringBuffer)object).append(" T0.CTXT2 ");
            } else {
                ((StringBuffer)object).append(" NULL ");
            }
            QueryUtils.appendToList(stringBuffer, ((StringBuffer)object).toString() + " as T0_CTXT2 ", ",\n", "");
        }
        for (String[] stringArray : list) {
            QueryUtils.appendToList(stringBuffer, stringArray[0] + "(" + stringArray[1] + ") as " + "ANC$" + stringArray[1], ",\n", "");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append(" 1\n");
        }
        if (this.ctx.topDownOpt) {
            if (this.bgp.TBList.size() > 0) {
                QueryUtils.appendToList(stringBuffer, "T0." + this.subjectCol + " AS BGP$" + this.getId(), ",\n", "");
            } else {
                QueryUtils.appendToList(stringBuffer, "1 AS BGP$" + this.getId(), ",\n", "");
            }
        }
        object = "";
        object = bl ? "/*+ NO_MERGE */ " : "/*+ MERGE */ ";
        String string = "";
        if (bl2) {
            string = "DISTINCT ";
        }
        return "SELECT " + (String)object + string + this.sqlHint + stringBuffer.toString();
    }

    private String buildVTYPCaseForVar(String string) {
        return QueryUtils.buildVTYPCaseForVar(string);
    }

    private String buildSelectListForVar(String string, Set<String> set, boolean bl, boolean bl2, Map<String, String> map) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = this.varAliases.get(string);
        String string3 = "PBGP." + string;
        String string4 = "R." + string;
        String string5 = this.buildVTYPCaseForVar(string2);
        int n = 8;
        if (bl || bl2) {
            n = 7;
        }
        String[][] stringArray = new String[n][2];
        String string6 = "";
        if (bl2) {
            stringArray[0][0] = string4;
            stringArray[1][0] = string4 + this.vtype_alias;
            stringArray[2][0] = string4 + this.vid_alias;
            stringArray[3][0] = string4 + this.prefix_alias;
            stringArray[4][0] = string4 + this.suffix_alias;
            stringArray[5][0] = string4 + this.litType_alias;
            stringArray[6][0] = string4 + this.langType_alias;
            string6 = string4;
        } else if (string2 != null) {
            stringArray[0][0] = this.getLocalVPreCol(string, set) + " || " + this.getLocalVSufCol(string, set);
            stringArray[1][0] = this.getLocalVTypCol(string, set);
            stringArray[2][0] = this.getLocalVIDCol(string, set);
            stringArray[3][0] = this.getLocalVPreCol(string, set);
            stringArray[4][0] = this.getLocalVSufCol(string, set);
            stringArray[5][0] = this.getLocalVLitCol(string, set);
            stringArray[6][0] = this.getLocalVLangCol(string, set);
            if (!bl) {
                stringArray[7][0] = "TO_CLOB(NULL)";
            }
            if ((this.ctx.contextFlags & 8) > 0) {
                string2 = this.varTabs.get(string);
                string6 = QueryUtils.genVNameSubstr(stringArray[0][0], "NULL", stringArray[6][0], stringArray[5][0]);
            } else {
                string6 = QueryUtils.genVNameSubstr(string2 + "." + this.prefix_col + " || " + string2 + "." + this.suffix_col, string2 + "." + this.longLit_col, string2 + "." + this.langType_col, string2 + "." + this.litType_col);
            }
        } else {
            stringArray[0][0] = string3;
            stringArray[1][0] = string3 + this.vtype_alias;
            stringArray[2][0] = this.getLocalVIDCol(string, set);
            stringArray[3][0] = string3 + this.prefix_alias;
            stringArray[4][0] = string3 + this.suffix_alias;
            stringArray[5][0] = string3 + this.litType_alias;
            stringArray[6][0] = string3 + this.langType_alias;
            if (!bl) {
                stringArray[7][0] = string3 + this.longLit_alias;
            }
            string6 = QueryUtils.genVNameSubstr(string3, string3 + this.longLit_alias, string3 + this.langType_alias, string3 + this.litType_alias);
        }
        stringArray[0][1] = "";
        stringArray[1][1] = this.vtype_alias;
        stringArray[2][1] = this.vid_alias;
        stringArray[3][1] = this.prefix_alias;
        stringArray[4][1] = this.suffix_alias;
        stringArray[5][1] = this.litType_alias;
        stringArray[6][1] = this.langType_alias;
        if (!bl && !bl2) {
            stringArray[7][1] = this.longLit_alias;
        }
        if (this.getProjectVars().contains(string)) {
            if (bl) {
                this.distinctCLOB = true;
                this.needCLOBVars.add(string);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                QueryUtils.appendToList(stringBuffer, stringArray[i][0] + " AS " + string + stringArray[i][1], ", ", "");
            }
            if (this.getAllLexVars().contains(string)) {
                if (string2 != null) {
                    if (bl2) {
                        QueryUtils.appendToList(stringBuffer, string4 + this.term_alias + " AS " + string + this.term_alias, ", ", "");
                    } else {
                        String string7 = this.buildRDFTerm(string6, stringArray[1][0], stringArray[5][0], stringArray[6][0]);
                        QueryUtils.appendToList(stringBuffer, string7 + " AS " + string + this.term_alias, ", ", "");
                    }
                } else {
                    QueryUtils.appendToList(stringBuffer, string3 + this.term_alias + " AS " + string + this.term_alias, ", ", "");
                }
            }
        } else {
            QueryUtils.appendToList(stringBuffer, stringArray[2][0] + " AS " + string + stringArray[2][1], ", ", "");
        }
        return stringBuffer.toString();
    }

    private String buildRDFTermForVar(String string, Map<String, String> map) {
        Object object;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        boolean bl = false;
        if (this.isBindVar(string)) {
            object = this.getBindVar(string);
            String string8 = ((ASTTripleAtom.BindVar)object).getTermCol();
            string2 = string8 + "." + this.vname_col;
            string3 = string8 + "." + this.vtype_col;
            string4 = string8 + "." + this.litType_col;
            string5 = string8 + "." + this.langType_col;
            string6 = string8 + "." + this.longLit_col;
        } else {
            object = this.varAliases.get(string);
            string2 = (String)object + "." + this.prefix_col + " || " + (String)object + "." + this.suffix_col;
            string3 = (String)object + "." + this.vtype_col;
            string4 = (String)object + "." + this.litType_col;
            string5 = (String)object + "." + this.langType_col;
            string6 = (String)object + "." + this.longLit_col;
        }
        if ((this.ctx.contextFlags & 8) > 0) {
            object = map.get(string.toUpperCase());
            string2 = "mdsys.sdo_rdf.GetPref(" + (String)object + ",'" + this.netOwner + "','" + this.netName + "') || mdsys.sdo_rdf.GetSuff(" + (String)object + ",'" + this.netOwner + "','" + this.netName + "')";
            string3 = "mdsys.sdo_rdf.GetValTyp(" + (String)object + ",'" + this.netOwner + "','" + this.netName + "')";
            string6 = "NULL";
        }
        string2 = QueryUtils.genVNameSubstr(string2, string6, string5, string4);
        return this.buildRDFTerm(string2, string3, string4, string5);
    }

    private String buildRDFTerm(String string, String string2, String string3, String string4) {
        String string5 = "SEM_APIS.COMPOSE_RDF_TERM(" + string + "," + string2 + "," + string3 + "," + string4 + ")";
        return string5;
    }

    private String getLocalVIDCol(String string, Set<String> set) {
        String string2 = "";
        if (this.isBindVar(string)) {
            ASTTripleAtom.BindVar bindVar = this.getBindVar(string);
            string2 = bindVar.getIdCol();
        } else if (this.varset.containsKey(string)) {
            if (this.varset.get(string).equalsIgnoreCase("Subject")) {
                string2 = this.extractFirstOutgoingEdge(string) + "." + this.subjectCol;
            } else if (this.varset.get(string).equalsIgnoreCase("Predicate")) {
                string2 = this.extractFirstTableAlias(string) + "." + this.predicateCol;
            } else {
                String string3 = this.canonObjCol;
                if (this.ctx.useExactValue) {
                    string3 = this.exactObjCol;
                }
                string2 = this.extractFirstIncomingEdge(string) + "." + string3;
            }
        } else if (this.graphQuery && this.graphVar != null && this.graphVar.equalsIgnoreCase(string)) {
            string2 = this.buildGidExpr(false);
        } else if (set.contains(string)) {
            string2 = "PBGP." + string + this.vid_alias;
        }
        return string2;
    }

    private String getLocalVTab(String string, Set<String> set) {
        String string2 = "";
        if (!this.isBindVar(string) && this.varset.containsKey(string)) {
            string2 = this.varset.get(string).equalsIgnoreCase("Subject") ? this.extractFirstOutgoingEdge(string) : (this.varset.get(string).equalsIgnoreCase("Predicate") ? this.extractFirstTableAlias(string) : this.extractFirstIncomingEdge(string));
        }
        return string2;
    }

    private String getLocalVTypCol(String string, Set<String> set) {
        String string2 = "";
        String string3 = this.varAliases.get(string);
        if (this.isBindVar(string)) {
            string2 = string3 + "." + this.vtype_col;
        } else if (this.varset.containsKey(string)) {
            string2 = this.varset.get(string).equalsIgnoreCase("Subject") ? (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetValTyp(" + this.extractFirstOutgoingEdge(string) + "." + "START_NODE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstOutgoingEdge(string) + "." + this.vtype_col + this.subjSuffix) : (this.varset.get(string).equalsIgnoreCase("Predicate") ? (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetValTyp(" + this.extractFirstTableAlias(string) + "." + "P_VALUE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstTableAlias(string) + "." + this.vtype_col + this.predSuffix) : (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetValTyp(" + this.extractFirstIncomingEdge(string) + "." + "CANON_END_NODE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstIncomingEdge(string) + "." + this.vtype_col + this.objSuffix));
        } else if (this.graphQuery && this.graphVar != null && this.graphVar.equalsIgnoreCase(string)) {
            string2 = this.optLinkAliasList != null && !this.optLinkAliasList.isEmpty() ? this.optLinkAliasList.get(0) + ".VALUE_TYPE_G" : "T0.VALUE_TYPE_G";
        }
        return string2;
    }

    private String getLocalVPreCol(String string, Set<String> set) {
        String string2 = "";
        String string3 = this.varAliases.get(string);
        if (this.isBindVar(string)) {
            string2 = string3 + "." + this.prefix_col;
        } else if (this.varset.containsKey(string)) {
            string2 = this.varset.get(string).equalsIgnoreCase("Subject") ? (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetPref(" + this.extractFirstOutgoingEdge(string) + "." + "START_NODE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstOutgoingEdge(string) + "." + this.prefix_col + this.subjSuffix) : (this.varset.get(string).equalsIgnoreCase("Predicate") ? (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetPref(" + this.extractFirstTableAlias(string) + "." + "P_VALUE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstTableAlias(string) + "." + this.prefix_col + this.predSuffix) : (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetPref(" + this.extractFirstIncomingEdge(string) + "." + "CANON_END_NODE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstIncomingEdge(string) + "." + this.prefix_col + this.objSuffix));
        } else if (this.graphQuery && this.graphVar != null && this.graphVar.equalsIgnoreCase(string)) {
            string2 = this.optLinkAliasList != null && !this.optLinkAliasList.isEmpty() ? this.optLinkAliasList.get(0) + ".GNAME_PREFIX" : "T0.GNAME_PREFIX";
        }
        return string2;
    }

    private String getLocalVSufCol(String string, Set<String> set) {
        String string2 = "";
        String string3 = this.varAliases.get(string);
        if (this.isBindVar(string)) {
            string2 = string3 + "." + this.suffix_col;
        } else if (!this.isBindVar(string) && this.varset.containsKey(string)) {
            string2 = this.varset.get(string).equalsIgnoreCase("Subject") ? (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetSuff(" + this.extractFirstOutgoingEdge(string) + "." + "START_NODE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstOutgoingEdge(string) + "." + this.suffix_col + this.subjSuffix) : (this.varset.get(string).equalsIgnoreCase("Predicate") ? (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetSuff(" + this.extractFirstTableAlias(string) + "." + "P_VALUE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstTableAlias(string) + "." + this.suffix_col + this.predSuffix) : (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetSuff(" + this.extractFirstIncomingEdge(string) + "." + "CANON_END_NODE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstIncomingEdge(string) + "." + this.suffix_col + this.objSuffix));
        } else if (this.graphQuery && this.graphVar != null && this.graphVar.equalsIgnoreCase(string)) {
            string2 = this.optLinkAliasList != null && !this.optLinkAliasList.isEmpty() ? this.optLinkAliasList.get(0) + ".GNAME_SUFFIX" : "T0.GNAME_SUFFIX";
        }
        return string2;
    }

    private String getLocalVLitCol(String string, Set<String> set) {
        String string2 = "";
        String string3 = this.varAliases.get(string);
        if (this.isBindVar(string)) {
            string2 = string3 + "." + this.litType_col;
        } else if (!this.isBindVar(string) && this.varset.containsKey(string)) {
            string2 = this.varset.get(string).equalsIgnoreCase("Subject") ? (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetLitType(" + this.extractFirstOutgoingEdge(string) + "." + "START_NODE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstOutgoingEdge(string) + "." + this.litType_col) : (this.varset.get(string).equalsIgnoreCase("Predicate") ? (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetLitType(" + this.extractFirstTableAlias(string) + "." + "P_VALUE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstTableAlias(string) + "." + this.litType_col) : (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetLitType(" + this.extractFirstIncomingEdge(string) + "." + "CANON_END_NODE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstIncomingEdge(string) + "." + this.litType_col));
        } else if (this.graphQuery) {
            string2 = "NULL";
        }
        return string2;
    }

    private String getLocalVLangCol(String string, Set<String> set) {
        String string2 = "";
        String string3 = this.varAliases.get(string);
        if (this.isBindVar(string)) {
            string2 = string3 + "." + this.langType_col;
        } else if (!this.isBindVar(string) && this.varset.containsKey(string)) {
            string2 = this.varset.get(string).equalsIgnoreCase("Subject") ? (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetLangType(" + this.extractFirstOutgoingEdge(string) + "." + "START_NODE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstOutgoingEdge(string) + "." + this.langType_col) : (this.varset.get(string).equalsIgnoreCase("Predicate") ? (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetLangType(" + this.extractFirstTableAlias(string) + "." + "P_VALUE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstTableAlias(string) + "." + this.langType_col) : (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetLangType(" + this.extractFirstIncomingEdge(string) + "." + "CANON_END_NODE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstIncomingEdge(string) + "." + this.langType_col));
        } else if (this.graphQuery) {
            string2 = "NULL";
        }
        return string2;
    }

    private String getLocalVOtypCol(String string, Set<String> set) {
        String string2 = "";
        if (!this.isBindVar(string) && this.varset.containsKey(string)) {
            string2 = this.varset.get(string).equalsIgnoreCase("Subject") ? (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetOrdTyp(" + this.extractFirstOutgoingEdge(string) + "." + "START_NODE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstOutgoingEdge(string) + "." + this.ordType_col + this.subjSuffix) : (this.varset.get(string).equalsIgnoreCase("Predicate") ? (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetOrdTyp(" + this.extractFirstTableAlias(string) + "." + "P_VALUE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstTableAlias(string) + "." + this.ordType_col + this.predSuffix) : (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetOrdTyp(" + this.extractFirstIncomingEdge(string) + "." + "CANON_END_NODE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstIncomingEdge(string) + "." + this.ordType_col + this.objSuffix));
        } else if (this.graphQuery) {
            string2 = "NULL";
        }
        return string2;
    }

    private String getLocalVOnumCol(String string, Set<String> set) {
        String string2 = "";
        if (!this.isBindVar(string) && this.varset.containsKey(string)) {
            string2 = this.varset.get(string).equalsIgnoreCase("Subject") ? (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetOrdNum(" + this.extractFirstOutgoingEdge(string) + "." + "START_NODE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstOutgoingEdge(string) + "." + this.ordNum_col + this.subjSuffix) : (this.varset.get(string).equalsIgnoreCase("Predicate") ? (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetOrdNum(" + this.extractFirstTableAlias(string) + "." + "P_VALUE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstTableAlias(string) + "." + this.ordNum_col + this.predSuffix) : (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetOrdNum(" + this.extractFirstIncomingEdge(string) + "." + "CANON_END_NODE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstIncomingEdge(string) + "." + this.ordNum_col + this.objSuffix));
        } else if (this.graphQuery) {
            string2 = "NULL";
        }
        return string2;
    }

    private String getLocalVOdateCol(String string, Set<String> set) {
        String string2 = "";
        if (!this.isBindVar(string) && this.varset.containsKey(string)) {
            string2 = this.varset.get(string).equalsIgnoreCase("Subject") ? (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetOrdDate(" + this.extractFirstOutgoingEdge(string) + "." + "START_NODE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstOutgoingEdge(string) + "." + this.ordDate_col + this.subjSuffix) : (this.varset.get(string).equalsIgnoreCase("Predicate") ? (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetOrdDate(" + this.extractFirstTableAlias(string) + "." + "P_VALUE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstTableAlias(string) + "." + this.ordDate_col + this.predSuffix) : (this.ctx.ppQuery ? "mdsys.sdo_rdf.GetOrdDate(" + this.extractFirstIncomingEdge(string) + "." + "CANON_END_NODE_ID" + ",'" + this.netOwner + "','" + this.netName + "')" : this.extractFirstIncomingEdge(string) + "." + this.ordDate_col + this.objSuffix));
        } else if (this.graphQuery) {
            string2 = "NULL";
        }
        return string2;
    }

    private String getLocalVTermCol(String string) {
        String string2 = "";
        String string3 = this.varAliases.get(string);
        if (this.isBindVar(string)) {
            string2 = string3;
        } else if (!this.isBindVar(string) && this.varset.containsKey(string)) {
            string2 = this.varset.get(string).equalsIgnoreCase("Subject") ? this.extractFirstOutgoingEdge(string) + "." + this.term_col + this.subjSuffix : (this.varset.get(string).equalsIgnoreCase("Predicate") ? this.extractFirstTableAlias(string) + "." + this.term_col + this.predSuffix : this.extractFirstIncomingEdge(string) + "." + this.term_col + this.objSuffix);
        } else if (this.graphQuery) {
            string2 = "NULL";
        }
        return string2;
    }

    private String buildFrom() throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        SimplePPSQLTransVisitor simplePPSQLTransVisitor = new SimplePPSQLTransVisitor(this.activeGraph, this.ctx, this.queryOptions, this.link_tab);
        if (this.hasPushedBGP) {
            QueryUtils.appendToList(stringBuffer, this.pushedBGPAlias + " " + PUSHED_BGP_ALIAS, ", ", "");
        }
        int n = 0;
        PPNode pPNode = null;
        String string = "";
        String string2 = "";
        for (TriplesBlock object : this.bgp.TBList) {
            if (object.hasPropertyPath()) {
                pPNode = object.getPath();
                string = pPNode.accept(simplePPSQLTransVisitor);
                string2 = simplePPSQLTransVisitor.getWITHClauses();
                string = string2 + "\n" + string;
                QueryUtils.appendToList(stringBuffer, "\n(/*PP[*/" + string + "/*]PP*/) T" + n, ", ", "");
            } else {
                QueryUtils.appendToList(stringBuffer, this.link_tab + " T" + n, ", ", "");
            }
            ++n;
        }
        if (this.isGraphQuery() && this.bgp.TBList.size() == 0) {
            if (this.ctx.optDistinctGQuery == null || this.ctx.disableGMVOpt) {
                QueryUtils.appendToList(stringBuffer, this.link_tab + " T0", ", ", "");
            } else {
                QueryUtils.appendToList(stringBuffer, "(" + this.ctx.optDistinctGQuery + ") T0", ", ", "");
            }
        }
        for (ASTTripleAtom.BindVar bindVar : this.bindVarsToJoin) {
            QueryUtils.appendToList(stringBuffer, bindVar.getAlias() + " " + bindVar.getAlias(), ", ", "");
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("DUAL");
        }
        return "FROM " + stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String buildWhere() throws RDFException {
        Object object;
        Iterator<String> iterator;
        Object object2;
        Object object3;
        StringBuffer stringBuffer = new StringBuffer("");
        Set<String> set = this.getTriplePatternVars();
        HashSet<String> hashSet = new HashSet<String>();
        if (this.hasPushedBGP) {
            hashSet.addAll(this.pushedBGP.getBGPAndPushedVars());
        }
        String string = "##";
        if (this.graphVar != null) {
            string = this.graphVar;
        }
        String string2 = this.buildGidExpr(true);
        String string3 = this.canonObjCol;
        if (this.ctx.useExactValue) {
            string3 = this.exactObjCol;
        }
        Set<String> set2 = this.getAllLexVars();
        if (this.hasPushedBGP) {
            Set<String> set3 = QueryUtils.getCommonVars(set, hashSet);
            for (String object4 : set3) {
                if (object4.equals(string)) continue;
                if (set2.contains(object4)) {
                    object3 = this.buildRDFTermForVar(object4, this.varIDs);
                    QueryUtils.appendToList(stringBuffer, "PBGP." + object4 + this.term_alias + " = " + (String)object3, " AND\n", "");
                    continue;
                }
                QueryUtils.appendToList(stringBuffer, "PBGP." + object4 + this.vid_alias + " = " + this.getLocalVIDCol(object4, hashSet), " AND\n", "");
            }
        }
        int n = 0;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            object3 = triplesBlock.getSubject();
            object2 = triplesBlock.getPredicate();
            iterator = triplesBlock.getObject();
            object = null;
            String string4 = "";
            Long l = null;
            String string5 = "";
            Long l2 = null;
            String string6 = "";
            String string7 = "";
            if (!((TriplesBlock.Element)object3).isVariable()) {
                object = ((TriplesBlock.Element)object3).getCanonicalID();
                if (object != null) {
                    string4 = ((Long)object).toString();
                }
                if (((TriplesBlock.Element)object3).isBindVariable()) {
                    string7 = new ASTTripleAtom.BindVar((String)((TriplesBlock.Element)object3).getName()).bvName;
                    string4 = this.getBindVar(string7).getIdCol();
                }
                if (((TriplesBlock.Element)object3).exists()) {
                    QueryUtils.appendToList(stringBuffer, "T" + n + "." + this.subjectCol + " = " + string4, " AND\n", "");
                } else {
                    QueryUtils.appendToList(stringBuffer, "T" + n + "." + this.subjectCol + BAD_CONST_QUERY, " AND\n", "");
                }
            }
            if (!((TriplesBlock.Element)object2).isVariable() && ((TriplesBlock.Element)object2).getType() != 8) {
                l = ((TriplesBlock.Element)object2).getCanonicalID();
                if (l != null) {
                    string5 = l.toString();
                }
                if (((TriplesBlock.Element)object2).isBindVariable()) {
                    string7 = new ASTTripleAtom.BindVar((String)((TriplesBlock.Element)object2).getName()).bvName;
                    string5 = this.getBindVar(string7).getIdCol();
                }
                if (((TriplesBlock.Element)object2).exists()) {
                    QueryUtils.appendToList(stringBuffer, "T" + n + "." + this.predicateCol + " = " + string5, " AND\n", "");
                } else {
                    QueryUtils.appendToList(stringBuffer, "T" + n + "." + this.predicateCol + BAD_CONST_QUERY, " AND\n", "");
                }
            }
            if (!((TriplesBlock.Element)((Object)iterator)).isVariable()) {
                l2 = ((TriplesBlock.Element)((Object)iterator)).getCanonicalID();
                if (l2 != null) {
                    string6 = l2.toString();
                }
                if (((TriplesBlock.Element)((Object)iterator)).isSysCtxFunction()) {
                    string6 = ((TriplesBlock.Element)((Object)iterator)).getName();
                }
                if (((TriplesBlock.Element)((Object)iterator)).isBindVariable()) {
                    string7 = new ASTTripleAtom.BindVar((String)((TriplesBlock.Element)((Object)iterator)).getName()).bvName;
                    string6 = this.getBindVar(string7).getIdCol();
                }
                if (((TriplesBlock.Element)((Object)iterator)).exists()) {
                    QueryUtils.appendToList(stringBuffer, "T" + n + "." + string3 + " = " + string6, " AND\n", "");
                } else {
                    QueryUtils.appendToList(stringBuffer, "T" + n + "." + string3 + BAD_CONST_QUERY, " AND\n", "");
                }
            }
            ++n;
        }
        for (String string8 : set) {
            if (this.isBindVar(string8)) continue;
            if (this.bgp.BGPelements.containsKey(string8 + ",2") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string8).append((String)",2").toString()).position.equalsIgnoreCase("Object") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string8).append((String)",2").toString()).in_degree > 1) {
                object3 = this.extractIncomingEdges(string8);
                object2 = this.extractFirstIncomingEdge(string8);
                iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (((String)object).equals(object2)) continue;
                    QueryUtils.appendToList(stringBuffer, (String)object2 + "." + string3 + " = " + (String)object + "." + string3, " AND\n", "");
                }
            }
            if (this.bgp.BGPelements.containsKey(string8 + ",0") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string8).append((String)",0").toString()).position.equalsIgnoreCase("Subject") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string8).append((String)",0").toString()).out_degree > 1) {
                object3 = this.extractOutgoingEdges(string8);
                object2 = this.extractFirstOutgoingEdge(string8);
                iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (((String)object).equals(object2)) continue;
                    QueryUtils.appendToList(stringBuffer, (String)object2 + "." + this.subjectCol + " = " + (String)object + "." + this.subjectCol, " AND\n", "");
                }
            }
            if (!this.bgp.BGPelements.containsKey(string8 + ",2") || !this.bgp.BGPelements.containsKey(string8 + ",0") || this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string8).append((String)",2").toString()).in_degree <= 0 || this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string8).append((String)",0").toString()).out_degree <= 0) continue;
            object3 = this.extractFirstIncomingEdge(string8);
            object2 = this.extractFirstOutgoingEdge(string8);
            QueryUtils.appendToList(stringBuffer, (String)object3 + "." + string3 + " = " + (String)object2 + "." + this.subjectCol, " AND\n", "");
        }
        for (String string9 : set) {
            if (this.isBindVar(string9)) continue;
            if (this.varset.get(string9).equalsIgnoreCase("Predicate") && this.bgp.BGPelements.containsKey(string9 + ",1") && this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string9).append((String)",1").toString()).occurences > 1) {
                object3 = this.extractAllTableAliases(string9);
                object2 = this.extractFirstTableAlias(string9);
                iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (((String)object).equalsIgnoreCase((String)object2)) continue;
                    QueryUtils.appendToList(stringBuffer, (String)object2 + "." + this.predicateCol + " = " + (String)object + "." + this.predicateCol, " AND\n", "");
                }
            }
            if (this.bgp.BGPelements.containsKey(string9 + ",1") && this.bgp.BGPelements.containsKey(string9 + ",0")) {
                object3 = this.extractFirstOutgoingEdge(string9);
                object2 = this.extractFirstTableAlias(string9);
                QueryUtils.appendToList(stringBuffer, (String)object2 + "." + this.predicateCol + " = " + object3 + "." + this.subjectCol, " AND\n", "");
            }
            if (!this.bgp.BGPelements.containsKey(string9 + ",1") || !this.bgp.BGPelements.containsKey(string9 + ",2")) continue;
            object3 = this.extractFirstIncomingEdge(string9);
            object2 = this.extractFirstTableAlias(string9);
            QueryUtils.appendToList(stringBuffer, (String)object2 + "." + this.predicateCol + " = " + (String)object3 + "." + string3, " AND\n", "");
        }
        if (this.graphQuery) {
            int n2 = 1;
            String string10 = "";
            if ((this.ctx.contextFlags & 4) > 0 || this.wantGIDCoalesce()) {
                n2 = 0;
            }
            while (n2 < this.bgp.TBList.size()) {
                String string11 = this.optLinkAliasList.get(n2);
                QueryUtils.appendToList(stringBuffer, string2 + " = " + this.buildGidNVL(string11 + "." + this.gidCol, string2), " AND\n", "");
                ++n2;
            }
            if (this.activeGraph.type == 0) {
                if (hashSet.contains(string)) {
                    if (set2.contains(string)) {
                        object3 = this.buildRDFTermForVar(string, this.varIDs);
                        object2 = "PBGP." + string + this.term_alias;
                        QueryUtils.appendToList(stringBuffer, object3 + " = " + (String)object2, " AND\n", "");
                    } else {
                        QueryUtils.appendToList(stringBuffer, this.buildGidNVL("PBGP." + string + this.vid_alias, string2) + " = " + string2, " AND\n", "");
                    }
                }
                object3 = null;
                if (this.bgp.BGPelements.containsKey(string + ",2")) {
                    object3 = this.extractFirstIncomingEdge(string) + "." + string3;
                } else if (this.bgp.BGPelements.containsKey(string + ",0")) {
                    object3 = this.extractFirstOutgoingEdge(string) + "." + this.subjectCol;
                } else if (this.bgp.BGPelements.containsKey(string + ",1")) {
                    object3 = this.extractFirstTableAlias(string) + "." + this.predicateCol;
                }
                if (object3 != null) {
                    QueryUtils.appendToList(stringBuffer, this.buildGidNVL((String)object3, string2) + " = " + string2, " AND\n", "");
                }
            }
            if (this.activeGraph.type == 1 || this.activeGraph.type == 9) {
                object3 = null;
                if (this.activeGraph.type == 1) {
                    object3 = this.ctx.URImap.get(this.activeGraph.name);
                } else if (this.activeGraph.type == 9) {
                    object2 = this.getBindVar(string);
                    object3 = ((ASTTripleAtom.BindVar)object2).getIdCol();
                }
                if (object3 != null) {
                    QueryUtils.appendToList(stringBuffer, this.buildGidNVL((String)object3, string2) + " = " + string2, " AND\n", "");
                } else {
                    QueryUtils.appendToList(stringBuffer, "T0." + this.gidCol + BAD_CONST_QUERY, " AND\n", "");
                }
            }
        }
        if ((this.ctx.contextFlags & 1) > 0 && this.bgp.TBList.size() > 1) {
            for (int i = 1; i < this.bgp.TBList.size(); ++i) {
                QueryUtils.appendToList(stringBuffer, "T0.CTXT2 = T" + i + ".CTXT2 ", " AND\n", "");
            }
        } else if ((this.ctx.contextFlags & 2) > 0 && this.bgp.TBList.size() > 1) {
            void var10_28;
            void var10_26;
            StringBuffer stringBuffer2 = new StringBuffer(" COALESCE(");
            boolean bl = false;
            while (var10_26 < this.bgp.TBList.size()) {
                stringBuffer2.append("T" + (int)var10_26 + ".CTXT2,");
                ++var10_26;
            }
            stringBuffer2.append("'RDFCTX$NULLCTX')");
            boolean bl2 = true;
            while (var10_28 < this.bgp.TBList.size()) {
                QueryUtils.appendToList(stringBuffer, stringBuffer2.toString() + " = NVL(T" + (int)var10_28 + ".CTXT2, " + stringBuffer2.toString() + ") ", " AND\n", "");
                ++var10_28;
            }
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append("(1=1)");
        }
        return "WHERE " + stringBuffer.toString();
    }

    private String applyFilters(String string, Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4) throws RDFException {
        StringBuffer stringBuffer = new StringBuffer("");
        for (Filter filter : this.filters) {
            filter.setCurrSQL(string, set, set2, set3, set4);
            QueryUtils.appendToList(stringBuffer, filter.toSQL(this.varTabs, this.varIDs, this.ctx.funcTypeMap, this.ctx.funcHandMap), " AND\n", "dummy");
        }
        return stringBuffer.toString();
    }

    private void popVarsToJoin() {
        this.variablesToBeJoined = new HashSet<String>();
        this.variablesToBeJoined.addAll(QueryUtils.getCommonVars(this.getProjectVars(), this.getBGPVars()));
        this.bindVarsToJoin = new HashSet<ASTTripleAtom.BindVar>();
        this.bindVarsToJoin.addAll(this.bindVars);
        for (Filter filter : this.filters) {
            this.variablesToBeJoined.addAll(filter.getfJoinVars());
            this.bindVarsToJoin.addAll(filter.getBindVarObjs());
        }
    }

    private void populateFromTBs() {
        this.varset = new HashMap<String, String>();
        this.extractVariables();
    }

    private void extractVariables() {
        boolean bl = false;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            int n = 0;
            for (TriplesBlock.Element element : new TriplesBlock.Element[]{triplesBlock.getSubject(), triplesBlock.getPredicate(), triplesBlock.getObject()}) {
                String string = element.getName();
                if (element.isVariable() && !this.varset.containsKey(string)) {
                    this.varset.put(string, this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string).append((String)",").append((int)n).toString()).position);
                } else if (element.isBindVariable()) {
                    ASTTripleAtom.BindVar bindVar = new ASTTripleAtom.BindVar(string);
                    this.bindVars.add(bindVar);
                    if (!this.varset.containsKey(bindVar.bvName)) {
                        this.varset.put(bindVar.bvName, this.bgp.BGPelements.get((Object)new StringBuilder().append((String)bindVar.bvName).append((String)",").append((int)n).toString()).position);
                    }
                }
                ++n;
            }
        }
    }

    private void extractVarAliases() {
        this.varAliases = new HashMap<String, String>();
        Set<Map.Entry<String, String>> set = this.varset.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            String string3 = "";
            if (this.isBindVar(string)) {
                ASTTripleAtom.BindVar bindVar = this.getBindVar(string);
                string3 = bindVar.getTermCol();
                this.varAliases.put(string, string3);
            } else {
                string2 = string2.equalsIgnoreCase("Subject") ? "0" : (string2.equalsIgnoreCase("Predicate") ? "1" : "2");
                string3 = "V" + this.bgp.BGPelements.get((Object)new StringBuilder().append((String)string).append((String)",").append((String)string2).toString()).uniqueId;
                this.varAliases.put(string, string3);
            }
            if (this.hintG == null || !this.variablesToBeJoined.contains(string.toUpperCase())) continue;
            this.hintG.addVarAlias(string, string3);
        }
        if (this.graphVar != null && !this.varAliases.containsKey(this.graphVar)) {
            Object object = GRAPH_ALIAS;
            if (this.isBindVar(this.graphVar)) {
                object = this.getBindVar(this.graphVar).getTermCol();
            }
            this.varAliases.put(this.graphVar, (String)object);
            if (this.hintG != null && this.variablesToBeJoined.contains(this.graphVar)) {
                this.hintG.addVarAlias(this.graphVar, (String)object);
            }
        }
    }

    private void extractVarIDs() {
        this.varIDs = new HashMap<String, String>();
        Set<String> set = this.getBGPVars();
        for (String string : set) {
            this.varIDs.put(string, this.getLocalVIDCol(string, new HashSet<String>()));
        }
    }

    private void extractVarTabs() {
        this.varTabs = new HashMap<String, String>();
        Set<String> set = this.getBGPVars();
        for (String string : set) {
            this.varTabs.put(string, this.getLocalVTab(string, new HashSet<String>()));
        }
    }

    private void extractVarBGPIDs() {
        this.varBGPIDs = new HashMap<String, String>();
        Set<String> set = this.getBGPVars();
        for (String string : set) {
            this.varBGPIDs.put(string, this.getLocalVIDCol(string, new HashSet<String>()));
        }
    }

    private List<String> extractIncomingEdges(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            if (triplesBlock.getObject().isVariable() && triplesBlock.getObject().getName().equalsIgnoreCase(string)) {
                arrayList.add("T" + n);
            }
            ++n;
        }
        return arrayList;
    }

    private String extractFirstIncomingEdge(String string) {
        List<String> list = this.extractIncomingEdges(string);
        int n = -1;
        String string2 = list.get(0);
        if (!this.hint0leadPosMap.isEmpty()) {
            for (String string3 : list) {
                Integer n2 = this.hint0leadPosMap.get(string3.toUpperCase());
                if (n2 == null) continue;
                if (n < 0) {
                    n = n2;
                    string2 = string3;
                    continue;
                }
                if (n2 >= n) continue;
                n = n2;
                string2 = string3;
            }
        }
        return string2;
    }

    private List<String> extractOutgoingEdges(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            if (triplesBlock.getSubject().isVariable() && triplesBlock.getSubject().getName().equalsIgnoreCase(string)) {
                arrayList.add("T" + n);
            }
            ++n;
        }
        return arrayList;
    }

    private String extractFirstOutgoingEdge(String string) {
        List<String> list = this.extractOutgoingEdges(string);
        int n = -1;
        String string2 = list.get(0);
        if (!this.hint0leadPosMap.isEmpty()) {
            for (String string3 : list) {
                Integer n2 = this.hint0leadPosMap.get(string3.toUpperCase());
                if (n2 == null) continue;
                if (n < 0) {
                    n = n2;
                    string2 = string3;
                    continue;
                }
                if (n2 >= n) continue;
                n = n2;
                string2 = string3;
            }
        }
        return string2;
    }

    private String extractFirstTableAlias(String string) {
        List<String> list = this.extractAllTableAliases(string);
        int n = -1;
        String string2 = list.get(0);
        if (!this.hint0leadPosMap.isEmpty()) {
            for (String string3 : list) {
                Integer n2 = this.hint0leadPosMap.get(string3.toUpperCase());
                if (n2 == null) continue;
                if (n < 0) {
                    n = n2;
                    string2 = string3;
                    continue;
                }
                if (n2 >= n) continue;
                n = n2;
                string2 = string3;
            }
        }
        return string2;
    }

    private List<String> extractAllTableAliases(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            if (triplesBlock.getPredicate().isVariable() && triplesBlock.getPredicate().getName().equalsIgnoreCase(string)) {
                arrayList.add("T" + n);
            }
            ++n;
        }
        return arrayList;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String toString(String string) {
        String string2 = "";
        if (this.isGraphQuery()) {
            string2 = string2 + string + "BGP [" + this.id + "] GRAPH: [" + this.activeGraph.name + "]\n";
        }
        string2 = string2 + this.bgp.toString(string);
        string2 = string2 + "\n";
        string2 = string2 + string + "User Hint [" + this.userHint + "]\n";
        string2 = string2 + string + "Required Lex Vars: [";
        for (String string3 : this.getRequiredLexVars()) {
            string2 = string2 + string3 + " ";
        }
        string2 = string2 + "]\n";
        string2 = string2 + string + "Lex Vars: [";
        for (String string3 : this.getAllLexVars()) {
            string2 = string2 + string3 + " ";
        }
        string2 = string2 + "]\n";
        return string2;
    }

    private boolean isBindVar(String string) {
        for (ASTTripleAtom.BindVar bindVar : this.bindVars) {
            if (!bindVar.bvName.equals(string)) continue;
            return true;
        }
        return false;
    }

    private ASTTripleAtom.BindVar getBindVar(String string) {
        for (ASTTripleAtom.BindVar bindVar : this.bindVars) {
            if (!bindVar.bvName.equals(string)) continue;
            return bindVar;
        }
        return null;
    }

    private void optimizePPStartEndNodes() throws RDFException {
        HashMap<String, Set<ASTTripleAtom>> hashMap = new HashMap<String, Set<ASTTripleAtom>>();
        for (Filter object : this.filters) {
            object.updateSubMap(hashMap, this.varAliases, this.varIDs);
        }
        for (TriplesBlock triplesBlock : this.bgp.TBList) {
            Object object;
            if (!triplesBlock.hasPropertyPath()) continue;
            String string = triplesBlock.getSubject().toString();
            if (hashMap.containsKey(string)) {
                object = triplesBlock.getPath();
                object.setStartNodes((Set)hashMap.get(string));
            }
            if (!hashMap.containsKey(object = triplesBlock.getObject().toString())) continue;
            PPNode pPNode = triplesBlock.getPath();
            pPNode.setEndNodes((Set)hashMap.get(object));
        }
    }

    @Override
    public SPMComponents extractSPMComponents() {
        SPMComponents sPMComponents = new SPMComponents();
        return sPMComponents;
    }
}

