/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.spatial.rdf.server.Hint;
import oracle.spatial.rdf.server.HintGenerator;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.SPARQLBGP;
import oracle.spatial.rdf.server.SQLGenContext;

public class HintZeroHintGenerator
implements HintGenerator {
    private static final String NO_INDEX_HINT = "NO_INDEX";
    SQLGenContext ctx;
    boolean m_bLog;
    boolean hint0present;
    String userHint;
    StringBuffer hintStr;
    Map<String, Integer> hint0leadPosMap;
    Map<String, String> varAliases;
    Map<Hint.QueryOption, String> queryFlags;
    SPARQLBGP bgp;
    private Set<String> svpAliasSet = null;
    private Set<String> mvpAliasSet = null;
    private Set<String> pcnAliasSet = null;
    private Set<String> excludedTripleTabs = null;
    private Set<String> excludedValueTabs = null;

    public HintZeroHintGenerator(SQLGenContext sQLGenContext, boolean bl) {
        this.ctx = sQLGenContext;
        this.m_bLog = false;
        this.hint0present = false;
        this.userHint = null;
        this.hintStr = new StringBuffer("");
        this.varAliases = new HashMap<String, String>();
        this.hint0leadPosMap = new HashMap<String, Integer>();
        this.queryFlags = new HashMap<Hint.QueryOption, String>();
        this.bgp = null;
        this.svpAliasSet = null;
        this.mvpAliasSet = null;
        this.pcnAliasSet = null;
        this.excludedTripleTabs = null;
        this.excludedValueTabs = null;
    }

    @Override
    public void setUserHint(String string) {
        this.userHint = "HINT0={" + string + "}";
    }

    @Override
    public void addVarAlias(String string, String string2) {
        this.varAliases.put(string.toUpperCase(), string2.toUpperCase());
    }

    @Override
    public void setSPARQLBGP(SPARQLBGP sPARQLBGP) {
        this.bgp = sPARQLBGP;
    }

    @Override
    public void setSPMInfo(Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5) {
        this.excludedTripleTabs = set;
        this.excludedValueTabs = set2;
        this.svpAliasSet = set3;
        this.mvpAliasSet = set4;
        this.pcnAliasSet = set5;
    }

    @Override
    public String generateHint() {
        this.buildHint(false);
        this.buildHint(true);
        return this.hintStr.toString();
    }

    @Override
    public String generateJoinHint(String string, String string2) {
        String string3 = "";
        if (this.userHint != null) {
            String string4 = this.userHint;
            String string5 = "";
            String[] stringArray = new String[1];
            this.extractAndPadHint0(string4, new String[1], stringArray, new String[1]);
            string5 = stringArray[0];
            if (this.hasBadCharSeq(string5)) {
                QueryUtils.log("SKIPPED JOIN HINT due to presence of bad char seq: " + string5 + "\n");
            } else if (string5.length() > 0) {
                int n = string5.indexOf("(");
                int n2 = string5.lastIndexOf(")");
                string5 = " " + string5.substring(n + 1, n2) + " ";
                string5 = string5.toUpperCase();
                if (this.m_bLog) {
                    QueryUtils.log("EXTRACTED_JOIN_HINT==>[" + string5 + "]\n");
                }
                if (string5.indexOf(" " + Hint.JoinHint.NO_MERGE.getName() + " ") >= 0) {
                    string3 = string3 + Hint.JoinHint.NO_MERGE.getName() + "(" + string + ") " + Hint.JoinHint.NO_MERGE.getName() + "(" + string2 + ") ";
                }
                if (string5.indexOf(" " + Hint.JoinHint.USE_NL.getName() + " ") >= 0) {
                    string3 = string3 + Hint.JoinHint.USE_NL.getName() + "(" + string + " " + string2 + ")";
                } else if (string5.indexOf(" " + Hint.JoinHint.SWAP_JOIN_INPUTS.getName() + " ") >= 0) {
                    string3 = string3 + Hint.JoinHint.USE_HASH.getName() + "(" + string + " " + string2 + ") " + Hint.JoinHint.SWAP_JOIN_INPUTS.getName() + "(" + string2 + ")";
                } else if (string5.indexOf(" " + Hint.JoinHint.USE_HASH.getName() + " ") >= 0) {
                    string3 = string3 + Hint.JoinHint.USE_HASH.getName() + "(" + string + " " + string2 + ")";
                }
                if (string3.length() > 0) {
                    string3 = "/*+ " + string3 + " */";
                }
            }
            if (this.m_bLog) {
                QueryUtils.log("GENERATED_JOIN_SQL_HINT==>[" + string3 + "]\n");
            }
        }
        return string3;
    }

    @Override
    public String generateAntiJoinHint() {
        String string = "";
        if (this.userHint != null) {
            String string2 = this.userHint;
            String string3 = "";
            String[] stringArray = new String[1];
            this.extractAndPadHint0(string2, new String[1], new String[1], stringArray);
            string3 = stringArray[0];
            if (this.m_bLog) {
                QueryUtils.log("EXTRACTED_HINT0_FOR_AJ==>[" + string3 + "]\n");
            }
            if (this.hasBadCharSeq(string3)) {
                QueryUtils.log("SKIPPED JOIN HINT due to presence of bad char seq: " + string3 + "\n");
            } else if (string3.length() > 0) {
                int n = string3.indexOf("(");
                int n2 = string3.lastIndexOf(")");
                string3 = " " + string3.substring(n + 1, n2) + " ";
                string3 = string3.toUpperCase();
                if (this.m_bLog) {
                    QueryUtils.log("EXTRACTED_AJ_HINT==>[" + string3 + "]\n");
                }
                if (string3.indexOf(" " + Hint.AntiJoinHint.NO_UNNEST.getName() + " ") >= 0) {
                    string = string + Hint.AntiJoinHint.NO_UNNEST.getName();
                } else if (string3.indexOf(" " + Hint.AntiJoinHint.UNNEST.getName() + " ") >= 0) {
                    string = string + Hint.AntiJoinHint.UNNEST.getName();
                } else if (string3.indexOf(" " + Hint.AntiJoinHint.HASH_AJ.getName() + " ") >= 0) {
                    string = string + Hint.AntiJoinHint.HASH_AJ.getName();
                } else if (string3.indexOf(" " + Hint.AntiJoinHint.NL_AJ.getName() + " ") >= 0) {
                    string = string + Hint.AntiJoinHint.NL_AJ.getName();
                } else if (string3.indexOf(" " + Hint.AntiJoinHint.MERGE_AJ.getName() + " ") >= 0) {
                    string = string + Hint.AntiJoinHint.MERGE_AJ.getName();
                }
                if (string.length() > 0) {
                    string = "/*+ " + string + " */";
                }
            }
            if (this.m_bLog) {
                QueryUtils.log("GENERATED_ANTI_JOIN_SQL_HINT==>[" + string + "]\n");
            }
        }
        return string;
    }

    @Override
    public String generateValueJoinHint(Collection<String> collection, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = "";
        if (!collection.isEmpty() && (this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_NONLOCAL_VALUE_NL) || this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_NONLOCAL_VALUE_HASH))) {
            if (this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_NONLOCAL_VALUE_NL)) {
                string2 = " " + (Object)((Object)Hint.JoinHint.USE_NL);
            } else if (this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_NONLOCAL_VALUE_HASH)) {
                string2 = " " + (Object)((Object)Hint.JoinHint.USE_HASH);
            }
            stringBuffer.append(string2 + "(");
            for (String string3 : collection) {
                stringBuffer.append(string3).append(" ");
            }
            stringBuffer.append(")");
        }
        if (!collection.isEmpty() && this.queryFlags.containsKey((Object)Hint.QueryOption.NO_NL_VALUE_INDEX)) {
            for (String string3 : collection) {
                stringBuffer.append(" NO_INDEX(");
                stringBuffer.append(string3).append(") ");
            }
        }
        if (this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_NONLOCAL_VALUE_NO_MERGE)) {
            stringBuffer.append(" LEADING(").append(string).append(")");
            stringBuffer.append(" NO_MERGE(").append(string).append(")");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, " /*+");
            stringBuffer.append(" */");
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean specifiesBGPPushDown() {
        boolean bl = false;
        if (this.userHint != null && this.userHint.toUpperCase().contains(Hint.QueryOption.BGP_PUSH_DOWN.getName())) {
            bl = true;
        }
        return bl;
    }

    @Override
    public Set<String> getHintVars() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.userHint != null) {
            String string = this.userHint.toUpperCase();
            Matcher matcher = HintGenerator.VAR_REGEX_PATTERN.matcher(string);
            while (matcher.find()) {
                int n = matcher.start();
                int n2 = matcher.end();
                String string2 = string.substring(n, n2);
                string2 = string2.substring(1);
                hashSet.add(string2);
            }
        }
        return hashSet;
    }

    @Override
    public Map<Hint.QueryOption, String> getQueryOptions() {
        return this.queryFlags;
    }

    @Override
    public Map<String, Integer> getTransOrderMap() {
        return this.hint0leadPosMap;
    }

    private void buildHint(boolean bl) {
        if (this.userHint != null) {
            String string = this.userHint;
            if (this.m_bLog) {
                QueryUtils.log(this.varAliases.toString() + "\n");
            }
            if (this.m_bLog) {
                QueryUtils.log("HINT0 processing ... \n");
            }
            String string2 = string;
            String[] stringArray = new String[1];
            this.extractAndPadHint0(string2, stringArray, new String[1], new String[1]);
            String string3 = stringArray[0];
            if (string3.equals("")) {
                return;
            }
            if (bl) {
                if (!this.hasBadCharSeq(string3)) {
                    this.computeSqlHint0(string3, true);
                    if (this.m_bLog) {
                        QueryUtils.log("final hint==> " + this.hintStr.toString() + "\n");
                    }
                } else {
                    QueryUtils.log("SKIPPED HINT0 due to presence of bad char seq: " + string3 + "\n");
                }
            } else {
                int n;
                int n2;
                int n3;
                this.hint0present = true;
                if (string3.toUpperCase().indexOf(" NO_OPT_TRANSITIVITY ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.NO_OPT_TRANS_FOR_LEADING, null);
                }
                if (string3.toUpperCase().indexOf(" USE_WITH ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.USE_WITH, null);
                }
                if (string3.toUpperCase().indexOf(" GET_EXACT_VALUES ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.USE_EXACT_VALS, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.ALL_NONLOCAL_VALUE_NL) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.ALL_NONLOCAL_VALUE_NL, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.ALL_NONLOCAL_VALUE_HASH) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.ALL_NONLOCAL_VALUE_HASH, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.ALL_NONLOCAL_VALUE_NO_MERGE) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.ALL_NONLOCAL_VALUE_NO_MERGE, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.ALL_LOCAL_VALUE_NL) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.ALL_LOCAL_VALUE_NL, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.ALL_LOCAL_VALUE_HASH) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.ALL_LOCAL_VALUE_HASH, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.ALL_LINK_HASH) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.ALL_LINK_HASH, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.ALL_LINK_NL) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.ALL_LINK_NL, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.LEX_JOIN) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.LEX_JOIN, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.NO_LINK_INDEX) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.NO_LINK_INDEX, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.NO_VALUE_INDEX) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.NO_VALUE_INDEX, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.NO_NL_VALUE_INDEX) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.NO_NL_VALUE_INDEX, null);
                }
                if ((n3 = string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.MAX_PP_DEPTH))) >= 0 && (n2 = string3.toUpperCase().indexOf("(", n3)) >= 0 && (n = string3.toUpperCase().indexOf(")", n2)) > n2 + 1) {
                    try {
                        String string4 = string3.toUpperCase().substring(n2 + 1, n).trim();
                        int n4 = Integer.parseInt(string4);
                        this.queryFlags.put(Hint.QueryOption.MAX_PP_DEPTH, string4);
                    }
                    catch (Exception exception) {
                        QueryUtils.log("Error reading MAX_PP_DEPTH for\n" + string3.toUpperCase().substring(n2 + 1, n).trim() + "\n" + exception.getMessage());
                    }
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.USE_PP_HASH) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.USE_PP_HASH, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.USE_PP_NL) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.USE_PP_NL, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.DISABLE_PP_SJ) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.DISABLE_PP_SJ, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.DISABLE_PP_SJ_DIST) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.DISABLE_PP_SJ_DIST, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.DEF_NON_NULL) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.DEF_NON_NULL, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.USE_PP_RW) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.USE_PP_RW, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.RW_PP_DISTINCT) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.RW_PP_DISTINCT, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.USE_PP_BFS) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.USE_PP_BFS, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.USE_PP_DFS) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.USE_PP_DFS, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.ALL_MVP_HASH) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.ALL_MVP_HASH, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.ALL_MVP_NL) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.ALL_MVP_NL, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.ALL_SVP_HASH) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.ALL_SVP_HASH, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.ALL_SVP_NL) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.ALL_SVP_NL, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.ALL_PCN_HASH) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.ALL_PCN_HASH, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.ALL_PCN_NL) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.ALL_PCN_NL, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.ALL_SPM_HASH) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.ALL_SPM_HASH, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.ALL_SPM_NL) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.ALL_SPM_NL, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.NO_MVP_INDEX) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.NO_MVP_INDEX, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.NO_SVP_INDEX) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.NO_SVP_INDEX, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.NO_PCN_INDEX) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.NO_PCN_INDEX, null);
                }
                if (string3.toUpperCase().indexOf(" " + (Object)((Object)Hint.QueryOption.NO_SPM_INDEX) + " ") >= 0) {
                    this.queryFlags.put(Hint.QueryOption.NO_SPM_INDEX, null);
                }
                this.computeSqlHint0(string3, false);
            }
        }
    }

    private boolean hasBadCharSeq(String string) {
        return string.indexOf("'") >= 0 || string.indexOf("--") >= 0 || string.indexOf(";") >= 0 || string.indexOf("/*") >= 0 || string.indexOf("*/") >= 0;
    }

    private void extractAndPadHint0(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        Object object;
        String[] stringArray4;
        int n;
        stringArray[0] = "";
        stringArray2[0] = "";
        stringArray3[0] = "";
        if (this.m_bLog) {
            QueryUtils.log("Input HINT==> " + string + "\n");
        }
        if ((n = string.toUpperCase().indexOf("HINT0")) < 0) {
            return;
        }
        Object object2 = string.substring(n + "HINT0".length(), string.length()).trim();
        if (this.m_bLog) {
            QueryUtils.log("1st cut: szHint0==> " + (String)object2 + "\n");
        }
        if (((String)object2).equals("") || ((String)object2).charAt(0) != '=') {
            return;
        }
        object2 = ((String)object2).substring(1, ((String)object2).length()).trim();
        if (this.m_bLog) {
            QueryUtils.log("2nd cut: szHint0==> " + (String)object2 + "\n");
        }
        if (((String)object2).equals("") || ((String)object2).charAt(0) != '{') {
            return;
        }
        int n2 = ((String)object2).indexOf("}");
        if (n2 < 0) {
            return;
        }
        Pattern pattern = HintGenerator.JOIN_HINT_REGEX_PATTERN;
        object2 = "{ " + ((String)object2).substring(1, n2) + " }";
        Matcher matcher = pattern.matcher((CharSequence)object2);
        if (matcher.find()) {
            stringArray2[0] = matcher.group();
            if (this.m_bLog) {
                QueryUtils.log("JOIN HINT==> " + stringArray2[0] + "\n");
            }
            stringArray4 = pattern.split((CharSequence)object2);
            object = "";
            for (int i = 0; i < stringArray4.length; ++i) {
                object = (String)object + " " + stringArray4[i];
            }
            object2 = object;
        }
        if (((Matcher)(object = (stringArray4 = HintGenerator.AJ_HINT_REGEX_PATTERN).matcher((CharSequence)object2))).find()) {
            stringArray3[0] = ((Matcher)object).group();
            if (this.m_bLog) {
                QueryUtils.log("AJ HINT==> " + stringArray3[0] + "\n");
            }
            String[] stringArray5 = stringArray4.split((CharSequence)object2);
            String string2 = "";
            for (int i = 0; i < stringArray5.length; ++i) {
                string2 = string2 + " " + stringArray5[i];
            }
            object2 = string2;
        }
        if (this.m_bLog) {
            QueryUtils.log("HINT0 content==> " + (String)object2 + "\n");
        }
        stringArray[0] = object2;
    }

    private void computeSqlHint0(String string, boolean bl) {
        String[] stringArray = new String[]{"RESULT_CACHE", "NO_REWRITE", "NO_QUERY_TRANSFORMATION", "ORDERED", "FIRST_ROWS", "ALL_ROWS", "MATERIALIZE", "MERGE", "NO_MERGE"};
        String[] stringArray2 = new String[]{"LEADING", "USE_NL", "USE_HASH", "USE_MERGE", "NO_USE_NL", "NO_USE_HASH", "NO_USE_MERGE", "SWAP_JOIN_INPUTS", "NO_SWAP_JOIN_INPUTS"};
        String[] stringArray3 = new String[]{"INDEX", "INDEX_FFS", "INDEX_SS", "INDEX_JOIN", "INDEX_COMBINE", "FULL", "USE_NL_WITH_INDEX", "PARALLEL_INDEX", "PARALLEL", "INDEX_ASC", "INDEX_DESC", "INDEX_SS_ASC", "INDEX_SS_DESC", NO_INDEX_HINT, "NO_INDEX_FFS", "NO_INDEX_SS", "NO_PARALLEL_INDEX", "NO_PARALLEL", "INMEMORY", "NO_INMEMORY", "INMEMORY_PRUNING", "NO_INMEMORY_PRUNING", "PX_JOIN_FILTER", "NO_PX_JOIN_FILTER"};
        String[] stringArray4 = new String[]{"GET_CANON_VALUE", "EXACT_VIA_FUNCTION"};
        if (bl) {
            int n;
            for (n = 0; n < stringArray.length; ++n) {
                if (string.indexOf(" " + stringArray[n] + " ") < 0) continue;
                this.hintStr.append(" " + stringArray[n] + " ");
            }
            for (n = 0; n < stringArray2.length; ++n) {
                this.computeSqlMultiAliasHint0(stringArray2[n], "(", ")", stringArray2[n], "(", ")", string, true, true, true, false);
            }
            for (n = 0; n < stringArray3.length; ++n) {
                this.computeSqlMultiAliasHint0(stringArray3[n], "(", ")", stringArray3[n], "(", ")", string, true, true, true, true);
            }
            this.processHintShortcuts();
            if (this.hintStr.length() > 0) {
                this.hintStr.insert(0, " /*+ ");
                this.hintStr.append(" */ ");
            }
        } else {
            for (int i = 0; i < stringArray4.length; ++i) {
                this.computeSqlMultiAliasHint0(stringArray4[i], "(", ")", null, null, null, string, false, true, false, false);
            }
        }
    }

    private void processHintShortcuts() {
        String string;
        int n = this.bgp.getNumTriples();
        if ((this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_LINK_NL) || this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_LINK_HASH)) && n > 1 && !HintGenerator.LINK_JOIN_REGEX_PATTERN.matcher(this.hintStr.toString()).matches()) {
            string = Hint.JoinHint.USE_HASH.getName();
            if (this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_LINK_NL)) {
                string = Hint.JoinHint.USE_NL.getName();
            }
            StringBuffer object2 = new StringBuffer("");
            for (int i = 0; i < n; ++i) {
                if (this.isTAliasExcluded("T" + i)) continue;
                object2.append(" t" + i);
            }
            if (object2.length() > 0) {
                this.hintStr.append(" " + string + "(").append(object2.toString()).append(") ");
            }
        }
        if ((this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_SVP_HASH) || this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_SVP_NL) || this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_SPM_HASH) || this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_SPM_NL)) && this.svpAliasSet != null && this.svpAliasSet.size() > 0) {
            string = Hint.JoinHint.USE_HASH.getName();
            if (this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_SVP_NL) || this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_SPM_NL)) {
                string = Hint.JoinHint.USE_NL.getName();
            }
            this.hintStr.append(" " + string + "(");
            for (String string2 : this.svpAliasSet) {
                this.hintStr.append(" " + string2);
            }
            this.hintStr.append(") ");
        }
        if ((this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_MVP_HASH) || this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_MVP_NL) || this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_SPM_HASH) || this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_SPM_NL)) && this.mvpAliasSet != null && this.mvpAliasSet.size() > 0) {
            string = Hint.JoinHint.USE_HASH.getName();
            if (this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_MVP_NL) || this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_SPM_NL)) {
                string = Hint.JoinHint.USE_NL.getName();
            }
            this.hintStr.append(" " + string + "(");
            for (String string3 : this.mvpAliasSet) {
                this.hintStr.append(" " + string3);
            }
            this.hintStr.append(") ");
        }
        if ((this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_PCN_HASH) || this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_PCN_NL) || this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_SPM_HASH) || this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_SPM_NL)) && this.pcnAliasSet != null && this.pcnAliasSet.size() > 0) {
            string = Hint.JoinHint.USE_HASH.getName();
            if (this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_PCN_NL) || this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_SPM_NL)) {
                string = Hint.JoinHint.USE_NL.getName();
            }
            this.hintStr.append(" " + string + "(");
            for (String string4 : this.pcnAliasSet) {
                this.hintStr.append(" " + string4);
            }
            this.hintStr.append(") ");
        }
        if (this.queryFlags.containsKey((Object)Hint.QueryOption.NO_LINK_INDEX) && n > 1) {
            for (int i = 0; i < n; ++i) {
                if (this.isTAliasExcluded("T" + i)) continue;
                this.hintStr.append(" NO_INDEX(T" + i + ") ");
            }
        }
        if ((this.queryFlags.containsKey((Object)Hint.QueryOption.NO_SVP_INDEX) || this.queryFlags.containsKey((Object)Hint.QueryOption.NO_SPM_INDEX)) && this.svpAliasSet != null && this.svpAliasSet.size() > 0) {
            for (String string5 : this.svpAliasSet) {
                this.hintStr.append(" NO_INDEX(" + string5 + ") ");
            }
        }
        if ((this.queryFlags.containsKey((Object)Hint.QueryOption.NO_MVP_INDEX) || this.queryFlags.containsKey((Object)Hint.QueryOption.NO_SPM_INDEX)) && this.mvpAliasSet != null && this.mvpAliasSet.size() > 0) {
            for (String string6 : this.mvpAliasSet) {
                this.hintStr.append(" NO_INDEX(" + string6 + ") ");
            }
        }
        if ((this.queryFlags.containsKey((Object)Hint.QueryOption.NO_PCN_INDEX) || this.queryFlags.containsKey((Object)Hint.QueryOption.NO_SPM_INDEX)) && this.pcnAliasSet != null && this.pcnAliasSet.size() > 0) {
            for (String string7 : this.pcnAliasSet) {
                this.hintStr.append(" NO_INDEX(" + string7 + ") ");
            }
        }
        if ((this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_LOCAL_VALUE_NL) || this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_LOCAL_VALUE_HASH)) && !this.varAliases.isEmpty() && !HintGenerator.VALUE_JOIN_REGEX_PATTERN.matcher(this.hintStr.toString()).matches()) {
            String string5 = Hint.JoinHint.USE_HASH.getName();
            if (this.queryFlags.containsKey((Object)Hint.QueryOption.ALL_LOCAL_VALUE_NL)) {
                string5 = Hint.JoinHint.USE_NL.getName();
            }
            StringBuffer stringBuffer = new StringBuffer("");
            for (String string8 : this.varAliases.values()) {
                if (this.isVAliasExcluded(string8)) continue;
                stringBuffer.append(" " + string8);
            }
            if (stringBuffer.length() > 0) {
                this.hintStr.append(" " + string5 + "(").append(stringBuffer.toString()).append(") ");
            }
        }
        if (this.queryFlags.containsKey((Object)Hint.QueryOption.NO_VALUE_INDEX) && !this.varAliases.isEmpty()) {
            for (String string9 : this.varAliases.values()) {
                if (this.isVAliasExcluded(string9)) continue;
                this.hintStr.append(" NO_INDEX(").append(string9).append(") ");
            }
        }
    }

    private void computeSqlMultiAliasHint0(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n = 0;
        int n2 = 0;
        String string8 = " ";
        int n3 = this.bgp.getNumTriples();
        if (this.m_bLog) {
            QueryUtils.log("****************** User Keyword=" + string + "\n");
        }
        while (true) {
            int n4;
            int n5 = 0;
            int n6 = 0;
            int n7 = string7.toUpperCase().indexOf(string, n);
            if (this.m_bLog) {
                QueryUtils.log("-------------------- UsrKeyword=" + string + " iStartPos=" + n + " iBegPos=" + n7 + "\n Remaining Hint0==> " + string7.substring(n, string7.length()) + "\n");
            }
            if (n7 >= 0) {
                if (n7 > 0 && string7.charAt(n7 - 1) != ' ') {
                    n4 = string7.indexOf(" ", n7);
                    if (n4 < 0) {
                        return;
                    }
                    n = n4;
                    continue;
                }
                string8 = string7.substring(n7 + string.length(), string7.length()).trim();
                if (string8.indexOf(string2) != 0) {
                    n4 = string8.indexOf(" ");
                    if (n4 < 0) {
                        return;
                    }
                    n = n7 + string.length() + n4;
                    continue;
                }
                n2 = string8.indexOf(string3);
                if (n2 < 0) {
                    return;
                }
            } else {
                return;
            }
            if (this.m_bLog) {
                QueryUtils.log("hint0 w/o UsrKeyword=" + string8 + "\n");
            }
            string8 = string8.substring(string2.length(), n2).trim();
            if (this.m_bLog) {
                QueryUtils.log("list=" + string8 + "\n");
            }
            int n8 = 0;
            while (string8.length() > 0) {
                ++n6;
                n4 = string8.indexOf(" ");
                if (n4 < 0) {
                    n4 = string8.length();
                }
                if (bl4 && n6 > 1) {
                    n4 = string8.length();
                    if (n5 > 0) {
                        this.hintStr.append(string8);
                    }
                } else if (bl2 && string8.charAt(0) == '?' && (!bl4 || n6 == 1)) {
                    String string9 = string8.substring(1, n4);
                    if (this.m_bLog) {
                        QueryUtils.log("Var:" + string9 + "%\n");
                    }
                    if (bl) {
                        String string10 = this.varAliases.get(string9.toUpperCase());
                        if (this.m_bLog) {
                            QueryUtils.log("alias=" + string10 + "$\n");
                        }
                        if (string10 != null) {
                            if (n5 == 0) {
                                this.hintStr.append(" " + string4 + string5);
                                if (this.m_bLog) {
                                    QueryUtils.log("hintStr=" + this.hintStr.toString() + "%\n");
                                }
                            }
                            ++n5;
                            this.hintStr.append(string10 + " ");
                            if (!this.queryFlags.containsKey((Object)Hint.QueryOption.NO_OPT_TRANS_FOR_LEADING) && string4.equalsIgnoreCase("LEADING")) {
                                this.hint0leadPosMap.put(string10.toUpperCase(), ++n8);
                            }
                            if (this.m_bLog) {
                                QueryUtils.log("SqlHint0:" + this.hintStr.toString() + "%\n");
                            }
                        }
                    } else if (this.varAliases.containsKey(string9.toUpperCase())) {
                        if (string.equalsIgnoreCase("GET_CANON_VALUE")) {
                            this.ctx.varMap.alwaysCanonNames.add(string9.toUpperCase());
                        } else if (string.equalsIgnoreCase("EXACT_VIA_FUNCTION")) {
                            this.ctx.varMap.funcExactNames.add(string9.toUpperCase());
                        }
                    } else if (string9.equals("*")) {
                        if (this.m_bLog) {
                            QueryUtils.log("wildcard variable\n");
                        }
                        if (string.equalsIgnoreCase("GET_CANON_VALUE")) {
                            for (String string11 : this.varAliases.keySet()) {
                                this.ctx.varMap.alwaysCanonNames.add(string11.toUpperCase());
                            }
                        } else if (string.equalsIgnoreCase("EXACT_VIA_FUNCTION")) {
                            for (String string11 : this.varAliases.keySet()) {
                                this.ctx.varMap.funcExactNames.add(string11.toUpperCase());
                            }
                        }
                    }
                } else if (!(!bl3 || string8.charAt(0) != 'T' && string8.charAt(0) != 't' || bl4 && n6 != 1)) {
                    String string12 = string8.substring(0, n4);
                    if (this.m_bLog) {
                        QueryUtils.log("TripleAlias: " + string12 + "*\n");
                    }
                    int n9 = new Integer(string12.substring(1, string12.length()));
                    if (this.m_bLog) {
                        QueryUtils.log("AliasNum: " + n9 + "*nTriples=" + n3 + "\n");
                    }
                    if (n9 < n3) {
                        if (n5 == 0) {
                            this.hintStr.append(" " + string4 + string5);
                            if (this.m_bLog) {
                                QueryUtils.log("hintStr=" + this.hintStr.toString() + "%\n");
                            }
                        }
                        ++n5;
                        if (bl) {
                            this.hintStr.append(string12 + " ");
                            if (!this.queryFlags.containsKey((Object)Hint.QueryOption.NO_OPT_TRANS_FOR_LEADING) && string4.equalsIgnoreCase("LEADING")) {
                                this.hint0leadPosMap.put(string12.toUpperCase(), ++n8);
                            }
                            if (this.m_bLog) {
                                QueryUtils.log("SqlHint0:" + this.hintStr.toString() + "%\n");
                            }
                        }
                    }
                } else if (this.m_bLog) {
                    QueryUtils.log("Skipped Item#" + n6 + "* Item=" + string8.substring(0, n4) + "*\n");
                }
                string8 = string8.substring(n4, string8.length()).trim();
            }
            if (bl && n5 > 0) {
                this.hintStr.append(string6);
                if (this.m_bLog) {
                    QueryUtils.log(this.hintStr.toString() + "%\n");
                }
            }
            n = string7.indexOf(string3, n7) + 1;
        }
    }

    private boolean isTAliasExcluded(String string) {
        boolean bl = false;
        if (this.excludedTripleTabs != null && this.excludedTripleTabs.contains(string.toUpperCase())) {
            bl = true;
        }
        return bl;
    }

    private boolean isVAliasExcluded(String string) {
        boolean bl = false;
        if (this.excludedValueTabs != null && this.excludedValueTabs.contains(string.toUpperCase())) {
            bl = true;
        }
        return bl;
    }
}

