/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.spatial.rdf.server.AntiJoinHintProvider;
import oracle.spatial.rdf.server.BGPJoinHintProvider;
import oracle.spatial.rdf.server.GeneralSQLHintProvider;
import oracle.spatial.rdf.server.Hint;
import oracle.spatial.rdf.server.HintEngine;
import oracle.spatial.rdf.server.HintGenerator;
import oracle.spatial.rdf.server.HintProvider;
import oracle.spatial.rdf.server.QueryOptionHintProvider;
import oracle.spatial.rdf.server.SPARQLBGP;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.parser.sparql.ParseException;

public class HintEngineAdapter
implements HintGenerator {
    private static final String HINT_FORMAT = "/*+ %s */ ";
    private static final String LEADING_HINT = "LEADING";
    private static final String NO_INDEX_HINT = "NO_INDEX";
    private static final String EMPTY_HINT = "";
    private static final Pattern TABLE_ALIAS_PATTERN = Pattern.compile("t(-?[0-9]+)", 2);
    private static final HintEngine QUERY_OPTION_ENGINE = new HintEngine(QueryOptionHintProvider.getInstance(), BGPJoinHintProvider.getInstance(), AntiJoinHintProvider.getInstance());
    private final HintEngine engine;
    private final Map<Hint.SQLHint.Arg, String> mappings;
    private State state;
    private String userHint;
    private SPARQLBGP bgp;
    private SQLGenContext ctx;
    private Map<Hint.QueryOption, String> queryOptions;
    Hint hint;

    public HintEngineAdapter(HintEngine hintEngine, SQLGenContext sQLGenContext) {
        this.engine = hintEngine;
        this.userHint = null;
        this.mappings = new HashMap<Hint.SQLHint.Arg, String>();
        this.bgp = null;
        this.hint = null;
        this.ctx = sQLGenContext;
        if (sQLGenContext == null) {
            throw new IllegalArgumentException("SQL Generation Context may not be null");
        }
        this.state = State.RESET;
        this.queryOptions = null;
        assert (this.checkRep()) : "CheckRep failed (you should never see this)";
    }

    private boolean checkRep() {
        assert (this.engine != null) : "HintEngineAdapter has a null engine";
        assert (this.mappings != null) : "HintEngineAdapter has null mappings";
        assert (this.ctx != null) : "HintEngineAdapter has null SQLGenContext";
        switch (this.state) {
            case RESET: {
                assert (this.userHint == null) : "HintEngineAdapter has non-null hint in the RESET state: " + this.userHint;
                assert (this.mappings.isEmpty()) : "HintEngineAdapter has non-empty mappings: " + this.mappings;
                assert (this.bgp == null) : "HintEngineAdapter has non-null BGP in the RESET state: " + this.bgp;
                assert (this.hint == null) : "HintEngineAdapter has non-null hint in the RESET state: " + this.hint;
                assert (this.queryOptions == null) : "HintEngineAdapter has non-null query options in RESET state.";
                break;
            }
            case PENDING: {
                assert (this.userHint != null || this.mappings.size() > 0 || this.bgp != null) : "HintEngineAdapter appears to be in RESET state but is currently in PENDING state";
                assert (this.hint == null) : "HintEngineAdapter has non-null hint in the PENDING state: " + this.hint;
                break;
            }
            case READY: {
                assert (this.userHint != null) : "HintEngineAdapater has null hint in READY state.";
                assert (this.bgp != null) : "HintEngineAdapter has null BGP in READY state.";
                assert (this.hint == null) : "HintEngineAdapter has non-null hint in the READY state: " + this.hint;
                break;
            }
            case GENERATED: {
                assert (this.hint != null) : "HintEngineAdapter has null hint in the GENERATED state.";
                assert (this.queryOptions != null) : "HintEngineAdapter has null query options in RESET state.";
                break;
            }
            default: {
                assert (false) : "HintEngineAdapter has unknown state, " + (Object)((Object)this.state);
                break;
            }
        }
        return true;
    }

    private static String escapeHintString(String string) {
        return String.format(HINT_FORMAT, string);
    }

    private void checkAccess() {
        boolean bl = true;
        String string = this.userHint;
        switch (this.state) {
            case RESET: 
            case PENDING: {
                System.err.printf("[%5s] %7s: %s\n", "hint", "warning", "attempting to access hint information before user hint string has been set.  Returning empty values. You may see this image if the SPARQL query contains a UNION.");
                string = EMPTY_HINT;
            }
            case READY: {
                try {
                    this.hint = this.engine.generateHint(this.bgp, this.ctx, string, bl);
                }
                catch (ParseException parseException) {
                    System.err.printf("[%5s] %7s: %s\n", "hint", "error", String.format("problem occured while generating hint for user hint '%s':\n\t%s", this.userHint, parseException.getMessage()));
                    parseException.printStackTrace();
                    this.hint = new HintProvider.HintBuilder().toHint();
                }
                this.queryOptions = this.hint.getQueryOptionsMap();
                this.state = State.GENERATED;
                break;
            }
        }
        assert (this.checkRep()) : "failed";
    }

    @Override
    public void setUserHint(String string) {
        if (string != null && string.equals(this.userHint)) {
            return;
        }
        if (string == null && this.userHint == EMPTY_HINT) {
            return;
        }
        this.userHint = string == null ? EMPTY_HINT : string;
        switch (this.state) {
            case RESET: {
                this.state = State.PENDING;
                break;
            }
            case PENDING: {
                if (this.bgp == null) break;
                this.state = State.READY;
                break;
            }
            case READY: 
            case GENERATED: {
                this.hint = null;
                this.state = State.READY;
            }
        }
        this.queryOptions = null;
        assert (this.checkRep()) : "failed";
    }

    @Override
    public void addVarAlias(String string, String string2) {
        this.mappings.put(Hint.SQLHint.Arg.createVariableArgument(string), string2);
        switch (this.state) {
            case RESET: 
            case PENDING: {
                this.state = State.PENDING;
                break;
            }
            case READY: {
                this.state = State.READY;
                break;
            }
            case GENERATED: {
                this.state = State.GENERATED;
            }
        }
        assert (this.checkRep()) : "failed";
    }

    @Override
    public void setSPARQLBGP(SPARQLBGP sPARQLBGP) {
        if (sPARQLBGP == null) {
            return;
        }
        if (sPARQLBGP.equals(this.bgp)) {
            return;
        }
        this.bgp = sPARQLBGP;
        switch (this.state) {
            case RESET: {
                this.state = State.PENDING;
                break;
            }
            case PENDING: {
                if (this.userHint == null) break;
                this.state = State.READY;
                break;
            }
            case READY: 
            case GENERATED: {
                this.hint = null;
                this.state = State.READY;
            }
        }
        assert (this.checkRep()) : "failed";
    }

    @Override
    public void setSPMInfo(Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5) {
    }

    @Override
    public String generateHint() {
        this.checkAccess();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.state != State.GENERATED) {
            return stringBuilder.toString();
        }
        Set<Hint.SQLHint> set = this.hint.getSQLHints();
        for (Hint.SQLHint sQLHint : set) {
            if (this.bgp != null && (sQLHint = HintEngineAdapter.removeBadArguments(sQLHint, this.mappings, this.bgp)) == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(sQLHint.toSQLString(this.mappings));
        }
        if (stringBuilder.length() == 0) {
            return stringBuilder.toString();
        }
        return HintEngineAdapter.escapeHintString(stringBuilder.toString());
    }

    @Override
    public String generateJoinHint(String string, String string2) {
        this.checkAccess();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.state != State.GENERATED) {
            return stringBuilder.toString();
        }
        Set<Hint.JoinHint> set = this.hint.getBGPJoinHints();
        for (Hint.JoinHint joinHint : set) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(joinHint.toSQLString(string, string2));
        }
        if (stringBuilder.length() == 0) {
            return stringBuilder.toString();
        }
        return HintEngineAdapter.escapeHintString(stringBuilder.toString());
    }

    @Override
    public String generateAntiJoinHint() {
        this.checkAccess();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.state != State.GENERATED) {
            return stringBuilder.toString();
        }
        Set<Hint.AntiJoinHint> set = this.hint.getAntiJoinHints();
        for (Hint.AntiJoinHint antiJoinHint : set) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(antiJoinHint.toSQLString());
        }
        if (stringBuilder.length() == 0) {
            return stringBuilder.toString();
        }
        return HintEngineAdapter.escapeHintString(stringBuilder.toString());
    }

    @Override
    public String generateValueJoinHint(Collection<String> collection, String string) {
        this.checkAccess();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.state != State.GENERATED) {
            return stringBuilder.toString();
        }
        Set<Hint.QueryOption> set = this.hint.getQueryOptions();
        LinkedList<Hint.SQLHint.Arg> linkedList = new LinkedList<Hint.SQLHint.Arg>();
        for (String object : collection) {
            linkedList.add(Hint.SQLHint.Arg.createStaticArgument(object));
        }
        Hint.SQLHint.Arg arg = Hint.SQLHint.Arg.createStaticArgument(string);
        for (Hint.QueryOption queryOption : set) {
            switch (queryOption) {
                case ALL_NONLOCAL_VALUE_NL: {
                    Hint.SQLHint sQLHint = Hint.SQLHint.createMultiArgHint(Hint.JoinHint.USE_NL.getName(), linkedList);
                    if (linkedList.isEmpty()) break;
                    stringBuilder.append(sQLHint.toSQLString());
                    break;
                }
                case ALL_NONLOCAL_VALUE_HASH: {
                    Hint.SQLHint sQLHint = Hint.SQLHint.createMultiArgHint(Hint.JoinHint.USE_HASH.getName(), linkedList);
                    if (linkedList.isEmpty()) break;
                    stringBuilder.append(sQLHint.toSQLString());
                    break;
                }
                case ALL_NONLOCAL_VALUE_NO_MERGE: {
                    Hint.SQLHint sQLHint = Hint.SQLHint.createSingleArgHint(LEADING_HINT, arg, false);
                    stringBuilder.append(sQLHint.toSQLString());
                    sQLHint = Hint.SQLHint.createSingleArgHint(Hint.JoinHint.NO_MERGE.getName(), arg, false);
                    stringBuilder.append(sQLHint.toSQLString());
                    break;
                }
                case NO_NL_VALUE_INDEX: {
                    Hint.SQLHint sQLHint;
                    for (Hint.SQLHint.Arg arg2 : linkedList) {
                        sQLHint = Hint.SQLHint.createSingleArgHint(NO_INDEX_HINT, arg2, false);
                        stringBuilder.append(sQLHint.toSQLString());
                    }
                    break;
                }
            }
        }
        if (stringBuilder.length() == 0) {
            return stringBuilder.toString();
        }
        return HintEngineAdapter.escapeHintString(stringBuilder.toString());
    }

    @Override
    public boolean specifiesBGPPushDown() {
        Map<Hint.QueryOption, String> map = this.getQueryOptions();
        return map.containsKey((Object)Hint.QueryOption.BGP_PUSH_DOWN);
    }

    @Override
    public Set<String> getHintVars() {
        List<HintProvider.HintToken> list;
        HashSet<String> hashSet = new HashSet<String>();
        if (this.userHint == null) {
            return hashSet;
        }
        try {
            list = HintEngine.parseText(this.userHint);
        }
        catch (Exception exception) {
            return hashSet;
        }
        LinkedList<HintProvider.HintToken> linkedList = new LinkedList<HintProvider.HintToken>(list);
        while (!linkedList.isEmpty()) {
            HintProvider.HintToken hintToken = (HintProvider.HintToken)linkedList.remove();
            if (!hintToken.getChildren().isEmpty()) {
                linkedList.addAll(hintToken.getChildren());
                continue;
            }
            Matcher matcher = GeneralSQLHintProvider.VARIABLE_PATTERN.matcher(hintToken.getValue());
            if (!matcher.matches()) continue;
            hashSet.add(hintToken.getValue());
        }
        return hashSet;
    }

    @Override
    public Map<Hint.QueryOption, String> getQueryOptions() {
        Hint hint;
        if (this.queryOptions != null) {
            return this.queryOptions;
        }
        if (this.userHint == null) {
            return new HashMap<Hint.QueryOption, String>();
        }
        boolean bl = true;
        try {
            hint = QUERY_OPTION_ENGINE.generateHint(this.bgp, this.ctx, this.userHint, bl);
        }
        catch (ParseException parseException) {
            System.err.printf("[%5s] %7s: %s\n", "hint", "error", String.format("problem occured while generating query option hint for user hint '%s':\n\t%s", this.userHint, parseException.getMessage()));
            parseException.printStackTrace();
            hint = new HintProvider.HintBuilder().toHint();
        }
        this.queryOptions = hint.getQueryOptionsMap();
        return this.queryOptions;
    }

    @Override
    public Map<String, Integer> getTransOrderMap() {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>(CaseInsensitiveComparator.getInstance());
        this.checkAccess();
        if (this.state != State.GENERATED) {
            return treeMap;
        }
        Set<Hint.SQLHint> set = this.hint.getSQLHints();
        Set<Hint.QueryOption> set2 = this.hint.getQueryOptions();
        if (set2.contains((Object)Hint.QueryOption.NO_OPT_TRANS_FOR_LEADING)) {
            return treeMap;
        }
        Hint.SQLHint sQLHint = null;
        for (Hint.SQLHint comparable : set) {
            if (!comparable.getName().equalsIgnoreCase(LEADING_HINT)) continue;
            sQLHint = comparable;
            break;
        }
        if (sQLHint == null) {
            return treeMap;
        }
        Integer n = 1;
        String string = null;
        for (Hint.SQLHint.Arg arg : sQLHint.getArguments()) {
            string = arg.isVariable() && this.mappings.containsKey(arg) ? this.mappings.get(arg) : arg.getValue();
            treeMap.put(string.toUpperCase(), n);
            n = n + 1;
        }
        return treeMap;
    }

    public void reset() {
        this.userHint = null;
        this.bgp = null;
        this.mappings.clear();
        this.hint = null;
        this.state = State.RESET;
        assert (this.checkRep()) : "failed";
    }

    private static Hint.SQLHint removeBadArguments(Hint.SQLHint sQLHint, Map<Hint.SQLHint.Arg, String> map, SPARQLBGP sPARQLBGP) {
        int n = sPARQLBGP.getNumTriples();
        LinkedList<Hint.SQLHint.Arg> linkedList = new LinkedList<Hint.SQLHint.Arg>();
        for (Hint.SQLHint.Arg arg : sQLHint.getArguments()) {
            boolean bl = false;
            String string = null;
            Matcher matcher = TABLE_ALIAS_PATTERN.matcher(arg.getValue());
            if (map != null && map.containsKey(arg)) {
                string = map.get(arg);
            }
            if (arg.isStatic() && matcher.matches()) {
                try {
                    int n2 = Integer.parseInt(matcher.group(1));
                    if (n2 >= n || n2 < 0) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    System.err.printf("[%5s] %7s: %s\n", "hint", "error", "unexpected table alias format " + arg.getValue());
                }
            } else if (arg.isVariable() && string == null) {
                bl = true;
            }
            if (bl) continue;
            linkedList.add(arg);
        }
        if (linkedList.size() == sQLHint.getArguments().size()) {
            return sQLHint;
        }
        if (linkedList.isEmpty()) {
            return null;
        }
        return Hint.SQLHint.createMultiArgHint(sQLHint.getName(), linkedList);
    }

    private static final class CaseInsensitiveComparator
    implements Comparator<String> {
        private static final CaseInsensitiveComparator INSTANCE = new CaseInsensitiveComparator();

        private CaseInsensitiveComparator() {
        }

        public static CaseInsensitiveComparator getInstance() {
            return INSTANCE;
        }

        @Override
        public int compare(String string, String string2) {
            if (string == string2) {
                return 0;
            }
            if (string == null) {
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            return string.toLowerCase().compareTo(string2.toLowerCase());
        }
    }

    private static enum State {
        RESET,
        PENDING,
        READY,
        GENERATED;

    }
}

