/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.spatial.rdf.server.Hint;
import oracle.spatial.rdf.server.HintProvider;
import oracle.spatial.rdf.server.parser.sparql.ParseException;

public class GeneralSQLHintProvider
extends HintProvider {
    static final Pattern VARIABLE_PATTERN = Pattern.compile("\\?(\\S+)");
    private static final String[] SUPPORTED_HINTS = new String[]{"ALL_ROWS", "EXACT_VIA_FUNCTION", "FIRST_ROWS", "FULL", "GET_CANON_VALUE", "INDEX", "INDEX_ASC", "INDEX_COMBINE", "INDEX_DESC", "INDEX_FFS", "INDEX_JOIN", "INDEX_SS", "INDEX_SS_ASC", "INDEX_SS_DESC", "INMEMORY", "INMEMORY_PRUNING", "LEADING", "MATERIALIZE", "MERGE", "MONITOR", "NO_INDEX", "NO_INDEX_FFS", "NO_INDEX_SS", "NO_INMEMORY", "NO_INMEMORY_PRUNING", "NO_MERGE", "NO_PARALLEL", "NO_PARALLEL_INDEX", "NO_PX_JOIN_FILTER", "NO_QUERY_TRANSFORMATION", "NO_REWRITE", "NO_SWAP_JOIN_INPUTS", "NO_USE_HASH", "NO_USE_MERGE", "NO_USE_NL", "ORDERED", "PARALLEL", "PARALLEL_INDEX", "PX_JOIN_FILTER", "RESULT_CACHE", "SWAP_JOIN_INPUTS", "USE_HASH", "USE_MERGE", "USE_NL", "USE_NL_WITH_INDEX"};
    private static final Map<HintProvider.HintToken, Enum> TOKENS;
    private static final GeneralSQLHintProvider instance;

    private GeneralSQLHintProvider() {
    }

    public static GeneralSQLHintProvider getInstance() {
        return instance;
    }

    @Override
    protected Map<HintProvider.HintToken, Enum> getParsableTokens() {
        return TOKENS;
    }

    @Override
    protected void parseToken(HintProvider.HintContext hintContext, HintProvider.HintToken hintToken, Enum enum_) throws ParseException {
        Type type = Type.valueOf(enum_.name());
        assert (type != null) : "Invalid type, '" + enum_ + "' for token '" + hintToken.getValue() + "'";
        String string = hintToken.getValue();
        List<HintProvider.HintToken> list = hintToken.getChildren();
        HintProvider.HintBuilder hintBuilder = hintContext.getHintBuilder();
        LinkedList<Hint.SQLHint.Arg> linkedList = new LinkedList<Hint.SQLHint.Arg>();
        for (HintProvider.HintToken hintToken2 : list) {
            String string2 = hintToken2.getValue();
            Matcher matcher = VARIABLE_PATTERN.matcher(string2);
            if (matcher.matches()) {
                linkedList.add(Hint.SQLHint.Arg.createVariableArgument(matcher.group(1)));
                continue;
            }
            linkedList.add(Hint.SQLHint.Arg.createStaticArgument(string2));
        }
        switch (type) {
            case NO_ARG: {
                hintBuilder.addSQLHint(Hint.SQLHint.createNoArgHint(string));
                break;
            }
            case MULTI_ARG: {
                hintBuilder.addSQLHint(Hint.SQLHint.createMultiArgHint(string, linkedList));
            }
        }
    }

    static {
        HashMap<HintProvider.HintToken, Type> hashMap = new HashMap<HintProvider.HintToken, Type>();
        for (String string : SUPPORTED_HINTS) {
            HintProvider.HintToken hintToken = HintProvider.HintToken.createNoArgToken(string);
            hashMap.put(hintToken, Type.NO_ARG);
            hintToken = HintProvider.HintToken.createToken(string);
            hashMap.put(hintToken, Type.MULTI_ARG);
        }
        TOKENS = Collections.unmodifiableMap(hashMap);
        instance = new GeneralSQLHintProvider();
    }

    private static enum Type {
        NO_ARG,
        MULTI_ARG;

    }
}

