/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTGroupGraphPattern;
import oracle.spatial.rdf.server.parser.sparql.ASTTriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;
import oracle.spatial.rdf.server.parser.sparql.sparqlParseTreeConstants;

public class GGPReduceOptimizer
implements SparqlQueryOptimizer {
    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        this.optimizeTBPositions(node);
        return node;
    }

    private void optimizeTBPositions(Node node) throws ParseException {
        if (((SimpleNode)node).id == 48) {
            this.groupTBs((ASTGroupGraphPattern)node);
        }
        for (int i = 0; i < ((SimpleNode)node).jjtGetNumChildren(); ++i) {
            this.optimizeTBPositions(((SimpleNode)node).jjtGetChild(i));
        }
    }

    private void groupTBs(ASTGroupGraphPattern aSTGroupGraphPattern) throws ParseException {
        int n;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ASTTriplesBlock aSTTriplesBlock = null;
        Node node = null;
        int n2 = 0;
        block4: for (n = 0; n < aSTGroupGraphPattern.jjtGetNumChildren(); ++n) {
            node = aSTGroupGraphPattern.jjtGetChild(n);
            n2 = ((SimpleNode)node).id;
            switch (n2) {
                case 47: {
                    if (aSTTriplesBlock != null) {
                        this.appendTriplesBlock(aSTTriplesBlock, (ASTTriplesBlock)node);
                        continue block4;
                    }
                    aSTTriplesBlock = (ASTTriplesBlock)node;
                    arrayList.add(node);
                    continue block4;
                }
                case 7: 
                case 49: {
                    arrayList.add(node);
                    if (!this.isGPNTnonFilter((SimpleNode)node)) continue block4;
                    aSTTriplesBlock = null;
                    continue block4;
                }
                default: {
                    throw new ParseException("GGPReduceOptimizer: unexpected node type under GroupGraphPattern: " + sparqlParseTreeConstants.jjtNodeName[n2]);
                }
            }
        }
        aSTGroupGraphPattern.jjtSetInitCapacity(arrayList.size());
        for (n = 0; n < arrayList.size(); ++n) {
            aSTGroupGraphPattern.jjtAddChild((Node)arrayList.get(n), n);
        }
    }

    private boolean isGPNTnonFilter(SimpleNode simpleNode) {
        boolean bl = false;
        if (simpleNode.jjtGetNumChildren() != 1 || ((SimpleNode)simpleNode.jjtGetChild((int)0)).id != 56) {
            bl = true;
        }
        return bl;
    }

    private void appendTriplesBlock(ASTTriplesBlock aSTTriplesBlock, ASTTriplesBlock aSTTriplesBlock2) {
        ASTTriplesBlock aSTTriplesBlock3 = aSTTriplesBlock;
        while (aSTTriplesBlock3.jjtGetNumChildren() > 3) {
            aSTTriplesBlock3 = (ASTTriplesBlock)aSTTriplesBlock3.jjtGetChild(3);
        }
        aSTTriplesBlock3.jjtAddChild(aSTTriplesBlock2, 3);
        aSTTriplesBlock2.jjtSetParent(aSTTriplesBlock3);
    }
}

