/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLTreeNode;
import oracle.spatial.rdf.server.SPARQLTreeOptimizer;
import oracle.spatial.rdf.server.SPARQLTriplesBlock;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SimpleSPARQLTreeNode;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;

public class BgpMergeSPARQLTreeOptimizer
implements SPARQLTreeOptimizer {
    private static final String MAX_ITERS_ERROR = "Error optimizing SPARQL Tree: max iterations reached while removing empty nodes";
    private static final int MAX_ITERS = 10000;
    private SQLGenContext ctx;

    public BgpMergeSPARQLTreeOptimizer(SQLGenContext sQLGenContext) {
        this.ctx = sQLGenContext;
    }

    @Override
    public SPARQLTreeNode optimizeTree(SPARQLTreeNode sPARQLTreeNode) throws RDFException {
        int n;
        boolean bl = true;
        for (n = 0; !sPARQLTreeNode.isEmpty() && bl && n < 10000; ++n) {
            bl = this.mergeSingleNodePair(sPARQLTreeNode);
        }
        if (n >= 10000) {
            throw new RDFException(MAX_ITERS_ERROR);
        }
        sPARQLTreeNode.resetVarLists();
        return sPARQLTreeNode;
    }

    private boolean mergeSingleNodePair(SPARQLTreeNode sPARQLTreeNode) throws RDFException {
        Stack<SPARQLTreeNode> stack = new Stack<SPARQLTreeNode>();
        stack.push(sPARQLTreeNode);
        while (!stack.isEmpty()) {
            SPARQLTreeNode sPARQLTreeNode2 = (SPARQLTreeNode)stack.pop();
            if (sPARQLTreeNode2.getNumChildren() > 0) {
                SPARQLTreeNode sPARQLTreeNode3;
                if (this.isParentMergeCandidate(sPARQLTreeNode2) && this.isRightMergeCandidate(sPARQLTreeNode3 = sPARQLTreeNode2.getChild(0)) && this.overlapsWithVars(sPARQLTreeNode2, sPARQLTreeNode3) && !this.overlapsWithOptVars(sPARQLTreeNode2, sPARQLTreeNode3) && this.namedGraphCompatible(sPARQLTreeNode2, sPARQLTreeNode3) && this.bindVariableCompatible(sPARQLTreeNode2, sPARQLTreeNode3)) {
                    this.mergeNodeBGPs(sPARQLTreeNode2, sPARQLTreeNode3);
                    sPARQLTreeNode2.removeChild(0);
                    return true;
                }
                if (this.safeForChildMerges(sPARQLTreeNode2)) {
                    for (int i = 0; i < sPARQLTreeNode2.getNumChildren() - 1; ++i) {
                        SPARQLTreeNode sPARQLTreeNode4 = sPARQLTreeNode2.getChild(i);
                        SPARQLTreeNode sPARQLTreeNode5 = sPARQLTreeNode2.getChild(i + 1);
                        if (!this.isLeftMergeCandidate(sPARQLTreeNode4) || !this.isRightMergeCandidate(sPARQLTreeNode5) || !this.overlapsWithVars(sPARQLTreeNode4, sPARQLTreeNode5) || this.overlapsWithOptVars(sPARQLTreeNode4, sPARQLTreeNode5) || !this.namedGraphCompatible(sPARQLTreeNode4, sPARQLTreeNode5) || !this.bindVariableCompatible(sPARQLTreeNode4, sPARQLTreeNode5)) continue;
                        this.mergeNodeBGPs(sPARQLTreeNode4, sPARQLTreeNode5);
                        sPARQLTreeNode2.removeChild(i + 1);
                        return true;
                    }
                }
            }
            for (int i = 0; i < sPARQLTreeNode2.getNumChildren(); ++i) {
                stack.push(sPARQLTreeNode2.getChild(i));
            }
        }
        return false;
    }

    private boolean namedGraphCompatible(SPARQLTreeNode sPARQLTreeNode, SPARQLTreeNode sPARQLTreeNode2) {
        ASTTripleAtom aSTTripleAtom;
        ASTTripleAtom aSTTripleAtom2;
        boolean bl = true;
        if (sPARQLTreeNode.isGraphQuery() != sPARQLTreeNode2.isGraphQuery()) {
            bl = false;
        } else if (sPARQLTreeNode.isGraphQuery() && !(aSTTripleAtom2 = sPARQLTreeNode.getActiveGraph()).equals(aSTTripleAtom = sPARQLTreeNode2.getActiveGraph())) {
            bl = false;
        }
        return bl;
    }

    private boolean bindVariableCompatible(SPARQLTreeNode sPARQLTreeNode, SPARQLTreeNode sPARQLTreeNode2) {
        HashSet<ASTTripleAtom> hashSet = new HashSet<ASTTripleAtom>();
        HashSet<ASTTripleAtom> hashSet2 = new HashSet<ASTTripleAtom>();
        this.extractVarSets(sPARQLTreeNode, hashSet, hashSet2);
        HashSet<ASTTripleAtom> hashSet3 = new HashSet<ASTTripleAtom>();
        HashSet<ASTTripleAtom> hashSet4 = new HashSet<ASTTripleAtom>();
        this.extractVarSets(sPARQLTreeNode2, hashSet3, hashSet4);
        for (ASTTripleAtom aSTTripleAtom : hashSet2) {
            if (!this.bindVarHasConflict(aSTTripleAtom, hashSet3, hashSet4)) continue;
            return false;
        }
        for (ASTTripleAtom aSTTripleAtom : hashSet4) {
            if (!this.bindVarHasConflict(aSTTripleAtom, hashSet, hashSet2)) continue;
            return false;
        }
        return true;
    }

    private boolean bindVarHasConflict(ASTTripleAtom aSTTripleAtom, Set<ASTTripleAtom> set, Set<ASTTripleAtom> set2) {
        ASTTripleAtom.BindVar bindVar = aSTTripleAtom.getBindVar();
        for (ASTTripleAtom aSTTripleAtom2 : set2) {
            ASTTripleAtom.BindVar bindVar2 = aSTTripleAtom2.getBindVar();
            if (bindVar2.bvName == null || !bindVar2.bvName.equals(bindVar.bvName) || bindVar2.bvId == bindVar.bvId) continue;
            return true;
        }
        for (ASTTripleAtom aSTTripleAtom2 : set) {
            if (!aSTTripleAtom2.name.equals(bindVar.bvName)) continue;
            return true;
        }
        return false;
    }

    private void extractVarSets(SPARQLTreeNode sPARQLTreeNode, Set<ASTTripleAtom> set, Set<ASTTripleAtom> set2) {
        List<SPARQLTriplesBlock> list = sPARQLTreeNode.getBGPTriplesBlocks();
        for (SPARQLTriplesBlock object22 : list) {
            ASTTripleAtom[] aSTTripleAtomArray = new ASTTripleAtom[]{object22.getSubject(), object22.getPredicate(), object22.getObject()};
            for (int i = 0; i < aSTTripleAtomArray.length; ++i) {
                if (((ASTTripleAtom)aSTTripleAtomArray[i]).type == 0) {
                    set.add((ASTTripleAtom)aSTTripleAtomArray[i]);
                    continue;
                }
                if (((ASTTripleAtom)aSTTripleAtomArray[i]).type != 9) continue;
                set2.add((ASTTripleAtom)aSTTripleAtomArray[i]);
            }
        }
        ASTTripleAtom aSTTripleAtom = sPARQLTreeNode.getActiveGraph();
        if (aSTTripleAtom != null) {
            if (aSTTripleAtom.type == 0) {
                set.add(aSTTripleAtom);
            } else if (aSTTripleAtom.type == 9) {
                set2.add(aSTTripleAtom);
            }
        }
        List<Filter> list2 = sPARQLTreeNode.getAllFilters();
        for (Filter filter : list2) {
            Set<ASTTripleAtom> set3 = OptimizerUtils.collectAllVariables(filter.getFilterTree());
            for (ASTTripleAtom aSTTripleAtom2 : set3) {
                if (aSTTripleAtom2.type == 0) {
                    set.add(aSTTripleAtom2);
                    continue;
                }
                if (aSTTripleAtom2.type != 9) continue;
                set2.add(aSTTripleAtom2);
            }
        }
    }

    private boolean overlapsWithOptVars(SPARQLTreeNode sPARQLTreeNode, SPARQLTreeNode sPARQLTreeNode2) {
        Set<String> set = sPARQLTreeNode.getOptionalBGPVars();
        for (String string : sPARQLTreeNode2.getBGPVars()) {
            if (!set.contains(string)) continue;
            return true;
        }
        return false;
    }

    private boolean overlapsWithVars(SPARQLTreeNode sPARQLTreeNode, SPARQLTreeNode sPARQLTreeNode2) {
        Set<String> set = sPARQLTreeNode.getBGPVars();
        for (String string : sPARQLTreeNode2.getBGPVars()) {
            if (!set.contains(string)) continue;
            return true;
        }
        return false;
    }

    private void mergeNodeBGPs(SPARQLTreeNode sPARQLTreeNode, SPARQLTreeNode sPARQLTreeNode2) throws RDFException {
        List<SPARQLTriplesBlock> list2 = sPARQLTreeNode2.getBGPMandatoryTriplesBlocks();
        if (sPARQLTreeNode2.getType() == 1) {
            for (SPARQLTriplesBlock list3 : list2) {
                sPARQLTreeNode.addOptionalTriplesBlock(list3);
            }
        } else {
            for (SPARQLTriplesBlock sPARQLTriplesBlock : list2) {
                sPARQLTreeNode.addTriplesBlock(sPARQLTriplesBlock);
            }
        }
        List<SPARQLTriplesBlock> list4 = sPARQLTreeNode2.getBGPOptionalTriplesBlocks();
        Iterator iterator = list4.iterator();
        while (iterator.hasNext()) {
            SPARQLTriplesBlock sPARQLTriplesBlock = (SPARQLTriplesBlock)iterator.next();
            sPARQLTreeNode.addOptionalTriplesBlock(sPARQLTriplesBlock);
        }
        List<Filter> list = sPARQLTreeNode2.getAllFilters();
        for (Filter filter : list) {
            sPARQLTreeNode.addFilter(filter);
        }
    }

    private boolean isParentMergeCandidate(SPARQLTreeNode sPARQLTreeNode) {
        return sPARQLTreeNode instanceof SimpleSPARQLTreeNode && sPARQLTreeNode.getType() == 0 && !sPARQLTreeNode.getBGPMandatoryTriplesBlocks().isEmpty() && sPARQLTreeNode.getNumChildren() > 0 && this.filtersSafeForMerge(sPARQLTreeNode);
    }

    private boolean isLeftMergeCandidate(SPARQLTreeNode sPARQLTreeNode) {
        return sPARQLTreeNode instanceof SimpleSPARQLTreeNode && sPARQLTreeNode.getType() == 0 && !sPARQLTreeNode.getBGPMandatoryTriplesBlocks().isEmpty() && sPARQLTreeNode.getNumChildren() == 0 && this.filtersSafeForMerge(sPARQLTreeNode);
    }

    private boolean isRightMergeCandidate(SPARQLTreeNode sPARQLTreeNode) {
        return (this.ctx.optStreeMerge || this.ctx.spmStreeMerge && this.nodeHasSvpOrPcnProperty(sPARQLTreeNode)) && sPARQLTreeNode instanceof SimpleSPARQLTreeNode && sPARQLTreeNode.getNumChildren() == 0 && (sPARQLTreeNode.getType() == 0 ? this.filtersSafeForMerge(sPARQLTreeNode) : sPARQLTreeNode.getType() == 1 && sPARQLTreeNode.getAllFilters().isEmpty() && sPARQLTreeNode.getBGPTriplesBlocks().size() == 1);
    }

    private boolean nodeHasSvpOrPcnProperty(SPARQLTreeNode sPARQLTreeNode) {
        List<SPARQLTriplesBlock> list = sPARQLTreeNode.getBGPTriplesBlocks();
        for (SPARQLTriplesBlock sPARQLTriplesBlock : list) {
            ASTTripleAtom aSTTripleAtom = sPARQLTriplesBlock.getPredicate();
            if (aSTTripleAtom.type != 1) continue;
            String string = this.ctx.URImap.get(aSTTripleAtom.name);
            for (Set<String> set : this.ctx.svpPropSetMap.values()) {
                if (!set.contains(string)) continue;
                return true;
            }
            for (Map.Entry entry : this.ctx.sortedPcnPropList) {
                List list2 = (List)entry.getValue();
                if (!list2.contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean filtersSafeForMerge(SPARQLTreeNode sPARQLTreeNode) {
        Set<String> set = sPARQLTreeNode.getBGPVars();
        ASTTripleAtom aSTTripleAtom = sPARQLTreeNode.getActiveGraph();
        if (aSTTripleAtom != null && (aSTTripleAtom.type == 0 || aSTTripleAtom.type == 9)) {
            set.add(aSTTripleAtom.name);
        }
        for (Filter filter : sPARQLTreeNode.getAllFilters()) {
            if (!filter.containsExists()) continue;
            Set<ASTTripleAtom> set2 = OptimizerUtils.collectAllVariables(filter.getFilterTree());
            for (ASTTripleAtom aSTTripleAtom2 : set2) {
                if (set.contains(aSTTripleAtom2.name)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean safeForChildMerges(SPARQLTreeNode sPARQLTreeNode) {
        return sPARQLTreeNode instanceof SimpleSPARQLTreeNode;
    }
}

