/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers.annotations;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import oracle.ide.markers.annotations.MarkerAttribute;

@SupportedAnnotationTypes(value={"oracle.ide.markers.annotations.MarkerAttribute"})
public class MarkerAttributeProcessor
extends AbstractProcessor {
    private static final Class[] ALLOWED_TYPES = new Class[]{Boolean.class, Integer.class, Long.class, Float.class, Double.class, String.class};
    private static final String METHODS_ONLY_MSG = MessageFormat.format("Only methods may be annotated with the {0} annotation.", MarkerAttribute.class.getName());
    private static final String TOO_MANY_PARMS_MSG = "Methods annotated with the oracle.ide.markers.annotations.MarkerAttribute annotation must have no more than one (1) parameter.";
    private static final String BAD_TYPE_MSG = "Unable to locate type {0}";
    private static final String DISALLOWED_TYPE_MSG = "Disallowed type {0}.  Type must be one of {1}";
    private static final String MUST_BE_VOID_MSG = "Return type must be void";
    private ArrayList<TypeMirror> allowedTypes;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(MarkerAttribute.class);
        block3: for (Element element : annotatedElements) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Processing element " + element);
            switch (element.getKind()) {
                case METHOD: {
                    this.validateElement((ExecutableElement)element, roundEnv);
                    continue block3;
                }
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, METHODS_ONLY_MSG, element);
        }
        return true;
    }

    private void validateElement(ExecutableElement element, RoundEnvironment roundEnv) {
        TypeMirror returnType = element.getReturnType();
        List<? extends VariableElement> parms = element.getParameters();
        switch (parms.size()) {
            case 0: {
                this.validateType(element, returnType);
                break;
            }
            case 1: {
                if (TypeKind.VOID != returnType.getKind()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, MUST_BE_VOID_MSG, element);
                }
                VariableElement var = parms.get(0);
                this.validateType(var, var.asType());
                break;
            }
            default: {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, TOO_MANY_PARMS_MSG, element);
            }
        }
    }

    private void validateType(Element element, TypeMirror type) {
        switch (type.getKind()) {
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return;
            }
        }
        if (this.allowedTypes.contains(type)) {
            return;
        }
        Types util = this.processingEnv.getTypeUtils();
        for (TypeMirror allowed : this.allowedTypes) {
            if (!util.isSameType(allowed, type)) continue;
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, MessageFormat.format(DISALLOWED_TYPE_MSG, type, Arrays.toString(ALLOWED_TYPES), element));
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Elements util = processingEnv.getElementUtils();
        this.allowedTypes = new ArrayList();
        for (Class _class : ALLOWED_TYPES) {
            TypeElement type = util.getTypeElement(_class.getName());
            if (null == type) {
                throw new IllegalStateException(MessageFormat.format(BAD_TYPE_MSG, _class.getName()));
            }
            this.allowedTypes.add(type.asType());
        }
    }
}

