/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers.adapters;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.ceditor.LineNavigationPoint;
import oracle.ide.markers.TextMarker;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.navigation.NavigationPoint;

public class TextMarkerToNavigationPointAdapterFactory
implements AdapterFactory<TextMarker, NavigationPoint> {
    private static final Logger LOGGER = Logger.getLogger(TextMarkerToNavigationPointAdapterFactory.class.getName());

    public NavigationPoint adapt(TextMarker marker) {
        if (null == marker) {
            return null;
        }
        try {
            Context markerContext = new Context(marker.context());
            Node node = NodeFactory.findOrCreate((URL)marker.markable().getUrl());
            markerContext.setNode(node);
            int offset = Math.max(0, marker.offset() - 1);
            return new LineNavigationPoint(markerContext, offset, false);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, e.getMessage(), e);
            }
            return null;
        }
    }
}

