/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers.adapters;

import javax.ide.util.MetaClass;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.markers.DefaultMarkerJobProvider;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerJobNodeOperator;
import oracle.ide.markers.MarkerJobProvider;
import oracle.ide.markers.MarkerJobProviderDescriptor;
import oracle.ide.markers.MarkerTypeDescriptor;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public class HashStructureToMarkerJobProviderDescriptorAdapterFactory
implements AdapterFactory<HashStructure, MarkerJobProviderDescriptor> {
    public MarkerJobProviderDescriptor adapt(HashStructure hash) {
        if (null == hash) {
            return null;
        }
        return new DeclaredMarkerJobProviderDescriptor(hash);
    }

    private static class DeclaredMarkerJobProviderDescriptor
    extends HashStructureAdapter
    implements MarkerJobProviderDescriptor {
        private static final String IMPL_ATTR = "impl";
        private static final String MARKER_TYPE_ATTR = "marker-type";
        private static final String OPERATOR_ATTR = "operator";
        private LazyClassAdapter lazyLoader;

        private DeclaredMarkerJobProviderDescriptor(HashStructure hash) {
            super(hash);
            this.lazyLoader = LazyClassAdapter.getInstance((HashStructure)hash);
        }

        @Override
        public MarkerTypeDescriptor getMarkerType() {
            MetaClass metaClass = this.lazyLoader.getMetaClass(MARKER_TYPE_ATTR);
            return MarkerTypeDescriptor.Factory.getMarkerType((MetaClass<? extends Marker>)metaClass);
        }

        @Override
        public MarkerJobProvider getJobProvider() {
            MarkerJobProvider provider = (MarkerJobProvider)this.lazyLoader.createInstance(MarkerJobProvider.class, IMPL_ATTR);
            if (provider instanceof DefaultMarkerJobProvider) {
                MarkerJobNodeOperator operator = (MarkerJobNodeOperator)this.lazyLoader.createInstance(MarkerJobNodeOperator.class, OPERATOR_ATTR);
                if (null == operator) {
                    throw new IllegalStateException("MarkerJobNodeOperator must not be null");
                }
                ((DefaultMarkerJobProvider)provider).setOperator(operator);
            }
            return provider;
        }
    }
}

