/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.markers.Markable;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerException;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.Workspace;
import oracle.ideimpl.markers.MarkableNode;
import oracle.ideimpl.markers.MarkableWorkingSet;
import oracle.ideimpl.markers.MarkerStore;
import oracle.ideimpl.markers.SimpleMarkerStore;
import oracle.javatools.util.ModelUtil;
import org.openide.util.RequestProcessor;

public class ProjectMarkerStore
extends NodeListener
implements MarkerStore {
    private Map<Project, MarkerStore> storesByProject = new LinkedHashMap<Project, MarkerStore>();
    private final NodeListener projectListener = new NodeListener(){
        private final RequestProcessor processor = new RequestProcessor(ProjectMarkerStore.class);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeClosed(NodeEvent e) {
            ProjectMarkerStore _this;
            Node node = e.getNode();
            if (!(node instanceof Project)) {
                return;
            }
            ProjectMarkerStore projectMarkerStore = _this = ProjectMarkerStore.this;
            synchronized (projectMarkerStore) {
                final MarkerStore store = (MarkerStore)_this.storesByProject.get(node);
                if (null == store) {
                    return;
                }
                this.processor.post(new Runnable(){

                    @Override
                    public void run() {
                        Collection<Marker> markers = store.getMarkers();
                        HashSet<Markable> markables = new HashSet<Markable>();
                        for (Marker marker : markers) {
                            try {
                                Markable markable = marker.markable();
                                if (markables.contains(markable)) continue;
                                markables.add(markable);
                                markable.removeMarkers();
                            }
                            catch (MarkerException e) {
                                FeedbackManager.reportException((Throwable)e);
                            }
                        }
                    }
                });
            }
        }

        public void nodeDeleted(NodeEvent e) {
            this.nodeClosed(e);
        }
    };

    public ProjectMarkerStore() {
        Node.addNodeListenerForType(Project.class, (NodeListener)this.projectListener);
    }

    @Override
    public synchronized <M extends Marker> Collection<M> addMarkers(M ... markers) throws MarkerException {
        if (null == markers || 0 == markers.length) {
            throw new IllegalArgumentException("At least one marker expected");
        }
        ArrayList added = new ArrayList();
        for (M marker : markers) {
            Project project = this.getProject((Marker)marker);
            MarkerStore store = this.storesByProject.get(project);
            if (null == store) {
                store = new SimpleMarkerStore();
                this.storesByProject.put(project, store);
                if (null != project) {
                    project.addNodeListener((NodeListener)this);
                }
            }
            added.addAll(store.addMarkers(new Marker[]{marker}));
        }
        return added;
    }

    @Override
    public <M extends Marker> Collection<M> updateMarkers(M ... markers) throws MarkerException {
        return Arrays.asList(markers);
    }

    @Override
    public synchronized <M extends Marker> Collection<M> removeMarkers(M ... markers) throws MarkerException {
        if (null == markers || 0 == markers.length) {
            throw new IllegalArgumentException("At least one marker expected");
        }
        ArrayList removed = new ArrayList();
        for (M marker : markers) {
            Project project = this.getProject((Marker)marker);
            MarkerStore store = this.storesByProject.get(project);
            if (null == store) continue;
            removed.addAll(store.removeMarkers(new Marker[]{marker}));
            if (!store.isEmpty()) continue;
            this.storesByProject.remove(project);
        }
        return removed;
    }

    @Override
    public synchronized void clear() {
        Iterator<MarkerStore> i = this.storesByProject.values().iterator();
        while (i.hasNext()) {
            MarkerStore store = i.next();
            store.clear();
            i.remove();
        }
    }

    @Override
    public synchronized Collection<Marker> getMarkers(Markable markable) {
        ArrayList<Marker> markers;
        block8: {
            block6: {
                block9: {
                    Object node;
                    block7: {
                        markers = new ArrayList<Marker>();
                        if (!(markable instanceof MarkableNode)) break block6;
                        node = ((MarkableNode)markable).getNode();
                        if (!(node instanceof Workspace)) break block7;
                        Collection<Marker> allMarkers = this.getMarkers();
                        for (Marker marker : allMarkers) {
                            Context context = marker.context();
                            if (!ModelUtil.areEqual(node, (Object)context.getWorkspace())) continue;
                            markers.add(marker);
                        }
                        break block8;
                    }
                    if (!(node instanceof Project)) break block9;
                    MarkerStore store = this.storesByProject.get(node);
                    if (null == store) break block8;
                    markers.addAll(store.getMarkers());
                    break block8;
                }
                for (MarkerStore store : this.storesByProject.values()) {
                    markers.addAll(store.getMarkers(markable));
                }
                break block8;
            }
            if (markable instanceof MarkableWorkingSet) {
                WorkingSet workingSet = ((MarkableWorkingSet)markable).getWorkingSet();
                for (Map.Entry<Project, MarkerStore> entry : this.storesByProject.entrySet()) {
                    Project project = entry.getKey();
                    if (null == project || !workingSet.isIncluded(project)) continue;
                    markers.addAll(entry.getValue().getMarkers());
                }
            } else {
                for (MarkerStore store : this.storesByProject.values()) {
                    markers.addAll(store.getMarkers(markable));
                }
            }
        }
        return markers;
    }

    @Override
    public synchronized Collection<Marker> getMarkers() {
        ArrayList<Marker> allMarkers = new ArrayList<Marker>();
        for (MarkerStore store : this.storesByProject.values()) {
            allMarkers.addAll(store.getMarkers());
        }
        return allMarkers;
    }

    private Project getProject(Marker marker) {
        return marker.context().getProject();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.storesByProject.isEmpty();
    }

    public void nodeDeleted(NodeEvent e) {
        e.getNode().removeNodeListener((NodeListener)this);
        Markable markable = Markable.Adapter.adapt((Locatable)e.getNode());
        if (null != markable) {
            try {
                markable.removeMarkers();
            }
            catch (MarkerException f) {
                FeedbackManager.reportException((Throwable)f);
            }
        }
    }

    public void nodeClosed(NodeEvent e) {
    }

    public void dispose() {
        this.clear();
    }
}

