/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers;

import java.util.Collection;
import oracle.ide.markers.Markable;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerException;
import oracle.ide.model.SingletonFactory;
import oracle.ideimpl.markers.MasterMarkerStore;
import oracle.ideimpl.markers.SimpleMarkerStore;
import oracle.ideimpl.markers.SystemMarkable;
import oracle.javatools.util.Disposable;

public interface MarkerStore
extends Disposable {
    public <M extends Marker> Collection<M> addMarkers(M ... var1) throws MarkerException;

    public <M extends Marker> Collection<M> updateMarkers(M ... var1) throws MarkerException;

    public <M extends Marker> Collection<M> removeMarkers(M ... var1) throws MarkerException;

    public Collection<Marker> getMarkers(Markable var1);

    public Collection<Marker> getMarkers();

    public boolean isEmpty();

    public void clear();

    public static class Factory {
        private static final String MARKER_STORE_NAME = "ide/marker-store";

        public static MarkerStore getMarkerStore(Markable markable) {
            if (markable instanceof SystemMarkable) {
                return Factory.getSystemMarkerStore();
            }
            return Factory.getMasterMarkerStore();
        }

        public static MarkerStore getMasterMarkerStore() {
            return (MarkerStore)SingletonFactory.getSingletonInstance(MarkerStore.class, (String)MARKER_STORE_NAME);
        }

        public static MarkerStore getSystemMarkerStore() {
            return SystemMarkableStore.INSTANCE.store;
        }

        private static enum SystemMarkableStore {
            INSTANCE(new MasterMarkerStore(new SimpleMarkerStore()));

            private transient MarkerStore store;

            private SystemMarkableStore(MarkerStore store) {
                this.store = store;
            }
        }
    }
}

