/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.markers;

import java.util.EnumSet;
import java.util.Set;
import javax.swing.Icon;
import oracle.ide.markers.IssueMarker;
import oracle.ide.markers.MarkerException;
import oracle.ide.markers.annotations.MarkerAttribute;
import oracle.ide.markers.annotations.MarkerType;
import oracle.ide.markers.res.MarkersBundle;
import oracle.javatools.icons.OracleIcons;

@MarkerType(name="Problem Marker", description="The problem marker is used to describe some sort of issue (error, warning, etc.) with its associated markable object.")
public interface ProblemMarker
extends IssueMarker {
    @MarkerAttribute(id="severity", name="Severity", description="The severity of the problem", required=true, defaultValue="0")
    public int severity();

    @MarkerAttribute(id="severity")
    public void severity(int var1) throws MarkerException;

    @MarkerAttribute(id="code", name="Code", description="The code for the problem")
    public String code();

    @MarkerAttribute(id="code")
    public void code(String var1) throws MarkerException;

    public static enum Severity {
        ERROR(0, "error.png"),
        WARNING(1, "warning.png"),
        INCOMPLETE(2, "incompletestatus.png"),
        INFO(3, "info.png");

        public final int value;
        private final String icon;

        public static Severity valueOf(int severity) {
            for (Severity sev : Severity.values()) {
                if (severity != sev.value) continue;
                return sev;
            }
            throw new IllegalArgumentException("Unrecognized severity value: " + severity);
        }

        public static Set<Severity> fromBitmap(int bitmap) {
            EnumSet<Severity> severities = EnumSet.noneOf(Severity.class);
            for (Severity sev : Severity.values()) {
                if ((bitmap & 1 << sev.value) == 0) continue;
                severities.add(sev);
            }
            return severities;
        }

        public static int toBitmap(Severity ... severities) {
            int bits = 0;
            for (Severity sev : severities) {
                bits |= 1 << sev.value;
            }
            return bits;
        }

        private Severity(int value, String icon) {
            this.value = value;
            this.icon = icon;
        }

        public Icon getIcon() {
            return OracleIcons.getIcon((String)this.icon);
        }

        public String getName() {
            return MarkersBundle.get(this.toString());
        }
    }
}

