/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.markers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.extension.HashStructureHookAggregator;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.markers.Marker;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;

public interface MarkerTypeDescriptor {
    public String name();

    public String description();

    public boolean isPersistent();

    public Icon icon();

    public MetaClass<? extends Marker> markerClass();

    public static class Factory {
        private static final String MARKER_TYPE_EL_NAME = "marker-type";
        private static final String HOOK_ID = "marker-type-hook";
        private static final ElementName HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "marker-type-hook");
        private static final Map<MetaClass<? extends Marker>, MarkerTypeDescriptor> DESCRIPTORS = new HashMap<MetaClass<? extends Marker>, MarkerTypeDescriptor>();
        private static final HashStructureHookAggregator AGGREGATOR = new HashStructureHookAggregator(HOOK_NAME, new HashStructureHookListener(){

            public void elementVisited(HashStructureHookEvent e) {
                Factory.addDescriptors(e.getNewElementHashStructure());
            }

            public void listenerAttached(HashStructureHookEvent e) {
                Factory.addDescriptors(e.getCombinedHashStructure());
            }
        });

        private static void addDescriptors(HashStructure hash) {
            if (null == hash) {
                return;
            }
            List list = hash.getAsList(MARKER_TYPE_EL_NAME);
            for (Object obj : list) {
                MarkerTypeDescriptor descriptor = (MarkerTypeDescriptor)AdapterManager.Factory.getAdapterManager().adapt(obj, MarkerTypeDescriptor.class);
                if (null == descriptor) continue;
                DESCRIPTORS.put(descriptor.markerClass(), descriptor);
            }
        }

        public static List<MarkerTypeDescriptor> getMarkerTypes() {
            AGGREGATOR.initialize();
            return new ArrayList<MarkerTypeDescriptor>(DESCRIPTORS.values());
        }

        public static MarkerTypeDescriptor getMarkerType(Class<? extends Marker> markerType) {
            MetaClass metaClass = new MetaClass(markerType.getClassLoader(), markerType.getName());
            return Factory.getMarkerType((MetaClass<? extends Marker>)metaClass);
        }

        public static MarkerTypeDescriptor getMarkerType(MetaClass<? extends Marker> markerType) {
            AGGREGATOR.initialize();
            MarkerTypeDescriptor descriptor = DESCRIPTORS.get(markerType);
            if (null != descriptor) {
                return descriptor;
            }
            for (MetaClass<? extends Marker> meta : DESCRIPTORS.keySet()) {
                if (!ModelUtil.areEqual((Object)meta.getClassName(), (Object)markerType.getClassName())) continue;
                return Factory.getMarkerType(meta);
            }
            return descriptor;
        }
    }
}

