/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extract;

import com.fasterxml.jackson.jr.ob.JSON;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DeployJson {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private static final String BRACKET_OPEN = "{";
    private static final String BRACKET_CLOSE = "}";
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private static final String NL = "\n";
    private static final String QD = "\"";
    private static final String TAB = "\t";
    StringBuilder _ctl;
    String _separator = "";
    Map<String, Object> _ctlMap;

    public void start() {
        this._ctl = new StringBuilder();
        this._ctl.append(BRACKET_OPEN);
    }

    public void addString(String name, String value) {
        this._ctl.append(this._separator + "\n\t\"" + name + "\":\"" + value + QD);
        this._separator = COMMA;
    }

    public void addObject(String name, String value) {
        this._ctl.append(this._separator + "\n\t\"" + name + "\":" + value);
        this._separator = COMMA;
    }

    public String end() {
        return this._ctl.append("\n}").toString();
    }

    public Map<String, Object> loadDeployCtl(String fileName) throws Exception {
        byte[] mapData = Files.readAllBytes(Paths.get(fileName, new String[0]));
        this._ctlMap = new HashMap<String, Object>();
        this._ctlMap = JSON.std.mapFrom((Object)mapData);
        return this._ctlMap;
    }

    public String getString(String key) {
        return this.getString(key, "");
    }

    public String getString(String key, String defaultValue) {
        String value = null;
        value = (String)this._ctlMap.get(key);
        return value != null ? value : defaultValue;
    }

    public String getJsonObjectAsString(String key) throws Exception {
        this.start();
        String val = JSON.std.asString(this._ctlMap.get(key));
        Map value = JSON.std.mapFrom((Object)val);
        Set keys = value.keySet();
        for (String k : keys) {
            String v = (String)value.get(k);
            v = v.replaceAll(QD, "\\\\\"");
            this.addString(k, v);
        }
        this.end();
        return this._ctl.toString();
    }
}

