/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.jdevimpl.audit.swing.DelegatingLayout;
import oracle.jdevimpl.audit.swing.FocusBorder;

public class ComboBoxLabel
extends JPanel
implements ListDataListener,
MouseListener {
    private ComboBoxModel model;
    private JList list;
    private int index;
    private ListCellRenderer renderer;
    private Dimension preferredSize;

    public ComboBoxLabel(ComboBoxModel model) {
        super(new DelegatingLayout());
        this.setBorder(new FocusBorder(2, 0));
        this.model = model;
        this.list = new JList(model);
        model.addListDataListener(this);
        this.addMouseListener(this);
        this.update();
    }

    public void setPrototypeDisplayValue(Object value) {
        Component prototype = this.getRenderer().getListCellRendererComponent(this.list, value, -1, false, false);
        this.preferredSize = prototype.getPreferredSize();
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.renderer = renderer;
        this.invalidate();
    }

    public ListCellRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new DefaultListCellRenderer();
        }
        return this.renderer;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        return super.getPreferredSize();
    }

    @Override
    public void contentsChanged(ListDataEvent event) {
        int index0 = event.getIndex0();
        int index1 = event.getIndex1();
        if (index0 == -1 && index1 == -1) {
            this.update();
        } else if (this.index >= index0 && this.index <= index1) {
            this.update();
        }
    }

    @Override
    public void intervalAdded(ListDataEvent event) {
    }

    @Override
    public void intervalRemoved(ListDataEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocus();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void update() {
        Object value = this.model.getSelectedItem();
        this.index = -1;
        for (int i = 0; i < this.model.getSize(); ++i) {
            if (!this.model.getElementAt(i).equals(value)) continue;
            this.index = i;
            break;
        }
        Component component = this.getRenderer().getListCellRendererComponent(this.list, value, this.index, false, false);
        component.setBackground(null);
        if (component instanceof JComponent) {
            JComponent jcomponent = (JComponent)component;
            jcomponent.setToolTipText(this.getToolTipText());
            jcomponent.setBorder(null);
        }
        if (this.getComponentCount() > 0) {
            if (this.getComponent(0) == component) {
                this.revalidate();
                this.repaint();
            } else {
                this.remove(0);
                this.add(component);
            }
        } else {
            this.add(component);
        }
    }
}

