/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;

public class CenterLayout
implements LayoutManager2 {
    private Rectangle bounds = new Rectangle();
    private static final Dimension MAXIMUM = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);

    @Override
    public void addLayoutComponent(String name, Component component) {
    }

    @Override
    public void addLayoutComponent(Component component, Object constraints) {
    }

    @Override
    public void layoutContainer(Container container) {
        if (container.getComponentCount() == 0) {
            return;
        }
        Component component = container.getComponent(0);
        Dimension childSize = component.getPreferredSize();
        Insets insets = container.getInsets();
        int preferred = childSize.width;
        int maximum = container.getWidth() - insets.left - insets.right;
        if (preferred <= maximum) {
            this.bounds.x = insets.left + (maximum - preferred) / 2;
            this.bounds.width = preferred;
        } else {
            this.bounds.x = insets.left;
            this.bounds.width = maximum;
        }
        preferred = childSize.height;
        maximum = container.getHeight() - insets.top - insets.bottom;
        if (preferred <= maximum) {
            this.bounds.y = insets.top + (maximum - preferred) / 2;
            this.bounds.height = preferred;
        } else {
            this.bounds.y = insets.top;
            this.bounds.height = maximum;
        }
        component.setBounds(this.bounds);
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        if (container.getComponentCount() == 0) {
            return MAXIMUM;
        }
        Dimension maximum = container.getComponent(0).getMaximumSize();
        Insets insets = container.getInsets();
        maximum.width += insets.left + insets.right;
        maximum.height += insets.top + insets.bottom;
        return maximum;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension minimum = container.getComponentCount() > 0 ? container.getComponent(0).getMinimumSize() : new Dimension(0, 0);
        Insets insets = container.getInsets();
        minimum.width += insets.left + insets.right;
        minimum.height += insets.top + insets.bottom;
        return minimum;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension preferred = container.getComponentCount() > 0 ? container.getComponent(0).getPreferredSize() : new Dimension(0, 0);
        Insets insets = container.getInsets();
        preferred.width += insets.left + insets.right;
        preferred.height += insets.top + insets.bottom;
        return preferred;
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }
}

