/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.report;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdevimpl.audit.report.AbstractReporter;
import oracle.jdevimpl.audit.report.StyleSheet;
import oracle.jdevimpl.audit.report.XmlReporter;

public class XsltReporter
implements AbstractReporter {
    private URL outputFile;
    private XmlReporter xmlReporter;
    private URL intermediateFile;
    private StyleSheet stylesheet;
    private String title;
    private String encoding = IdeUtil.getIdeIanaEncoding();
    private AuditModel model;

    public void setEncoding(String encoding) {
        if (encoding == null) {
            encoding = IdeUtil.getIdeIanaEncoding();
        }
        this.encoding = encoding;
    }

    public void setOutputFile(URL file) {
        this.outputFile = file;
    }

    public void setXmlReporter(XmlReporter reporter) {
        this.xmlReporter = reporter;
    }

    public void setIntermediateFile(URL file) {
        this.intermediateFile = file;
    }

    public StyleSheet getStylesheet() {
        return this.stylesheet;
    }

    public void setStyleSheet(StyleSheet stylesheet) {
        this.stylesheet = stylesheet;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setModel(AuditModel model) {
        this.model = model;
    }

    public AuditModel getModel() {
        return this.model;
    }

    @Override
    public void report() throws InvocationTargetException {
        URL xmlFile;
        if (this.intermediateFile != null) {
            xmlFile = this.intermediateFile;
        } else {
            try {
                xmlFile = URLFileSystem.createTempFile((String)"audit", (String)".tmp", null);
            }
            catch (Throwable e) {
                throw new InvocationTargetException(e);
            }
        }
        this.xmlReporter.setTitle(this.title);
        this.xmlReporter.setOutputFile(xmlFile);
        this.xmlReporter.setEncoding(this.encoding);
        this.xmlReporter.setModel(this.model);
        this.xmlReporter.report();
        try (BufferedInputStream inputStream = new BufferedInputStream(URLFileSystem.openInputStream((URL)xmlFile));
             BufferedOutputStream outputStream = new BufferedOutputStream(this.outputFile != null ? URLFileSystem.openOutputStream((URL)this.outputFile) : new StandardOutputStream());){
            StreamResult output = new StreamResult(outputStream);
            output.setSystemId(this.outputFile != null ? this.outputFile.toString() : "file:///dev/stdout");
            this.stylesheet.apply(new StreamSource(inputStream, xmlFile.toString()), output, this.encoding);
            Node node = NodeFactory.find((URL)this.outputFile);
            if (node != null) {
                node.revert();
            }
        }
        catch (IOException | TransformerException e) {
            throw new InvocationTargetException(e);
        }
        finally {
            if (this.intermediateFile == null) {
                URLFileSystem.delete((URL)xmlFile);
            }
        }
    }

    private static class StandardOutputStream
    extends PrintStream {
        public StandardOutputStream() {
            super(System.out, false);
        }

        @Override
        public void close() {
            this.flush();
        }
    }
}

