/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.Version;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.SuppressionScheme;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdevimpl.audit.core.AnalyzerBinding;
import oracle.jdevimpl.audit.core.DefaultProfile;
import oracle.jdevimpl.audit.preferences.AuditPreferences;
import oracle.jdevimpl.audit.preferences.PreferencesBundle;
import oracle.jdevimpl.audit.profile.AuditProfileDialog;
import oracle.jdevimpl.audit.profile.ProfileComboBox;
import oracle.jdevimpl.audit.profile.ProfileModel;
import oracle.jdevimpl.audit.profile.SelectionOverridingProfileModel;
import oracle.jdevimpl.audit.swing.Resources;

public class AuditPreferencesPanel
implements ActionListener,
ListSelectionListener,
Traversable {
    private static final String HELP_TOPIC = "f1_aud_dlg_pref_audit_html";
    private ProfileModel profiles;
    private JComponent component;
    private AuditPreferences copy;
    private JButton editProfilesButton;
    private AuditProfileDialog editProfilesDialog;
    private NumberTextField maximumFileSize;
    private JCheckBox auditWhileEditing;
    private JCheckBox showCodeAssistanceInGutter;
    private JLabel editorDelayLabel;
    private NumberTextField editorDelay;
    private JLabel editorDelayUnits;
    private JLabel editorProfileLabel;
    private JComboBox editorProfile;
    private JCheckBox auditDuringCompile;
    private JLabel compileProfileLabel;
    private JComboBox compileProfile;
    private static int checkBoxInset;

    public Component getComponent() {
        this.createComponents();
        return this.component;
    }

    private void createComponents() {
        if (this.component != null) {
            return;
        }
        this.editProfilesButton = Resources.button(PreferencesBundle.get("edit-profiles.label"));
        this.maximumFileSize = new NumberTextField((Number)Float.valueOf(this.copy.getMaximumFileSize()), 4);
        this.maximumFileSize.setHorizontalAlignment(11);
        this.maximumFileSize.setDataType(Float.class);
        this.maximumFileSize.setSigned(false);
        this.maximumFileSize.setDecimal(true, 1);
        this.maximumFileSize.setAlignmentX(1.0f);
        JLabel maximumFileSizeLabel = Resources.labelFor((JComponent)this.maximumFileSize, PreferencesBundle.get("maximum-file-size.label"), PreferencesBundle.get("maximum-file-size.tip"));
        JLabel maximumFileSizeUnits = new JLabel("Mb");
        this.auditWhileEditing = Resources.checkBox(PreferencesBundle.get("audit-while-editing.label"), this.copy.isAuditWhileEditing(), PreferencesBundle.get("audit-while-editing.tip"));
        this.editorProfile = new ProfileComboBox((ComboBoxModel)new SelectionOverridingProfileModel(this.profiles));
        Profile profile = this.profiles.getProfile(this.copy.getAssistProfile(), "oracle.ide.audit.code-assist-rules");
        this.editorProfile.setSelectedItem(profile);
        this.editorProfileLabel = Resources.labelFor(this.editorProfile, PreferencesBundle.get("editor-profile.label"), PreferencesBundle.get("editor-profile.tip"));
        this.showCodeAssistanceInGutter = Resources.checkBox(PreferencesBundle.get("show-code-assistance-in-gutter.label"), this.copy.isShowCodeAssistanceInGutter(), PreferencesBundle.get("show-code-assistance-in-gutter.tip"));
        this.editorDelay = new WholeNumberField(this.copy.getEditorDelay(), 6);
        this.editorDelay.setHorizontalAlignment(11);
        this.editorDelayLabel = Resources.labelFor((JComponent)this.editorDelay, PreferencesBundle.get("editor-delay.label"), PreferencesBundle.get("editor-delay.tip"));
        this.editorDelayUnits = new JLabel("ms");
        Box editorDelayAndUnits = Box.createHorizontalBox();
        editorDelayAndUnits.add((Component)this.editorDelay);
        editorDelayAndUnits.add(Box.createHorizontalStrut(2));
        editorDelayAndUnits.add(this.editorDelayUnits);
        this.auditDuringCompile = Resources.checkBox(PreferencesBundle.get("audit-during-compile.label"), this.copy.isAuditDuringCompile(), PreferencesBundle.get("audit-during-compile.tip"));
        this.compileProfile = new ProfileComboBox((ComboBoxModel)new SelectionOverridingProfileModel(this.profiles));
        profile = this.profiles.getProfile(this.copy.getCompileProfile(), "oracle.jdeveloper.java.compile-rules");
        if (profile != null) {
            this.compileProfile.setSelectedItem(profile);
        } else {
            this.compileProfile.setSelectedIndex(0);
        }
        this.compileProfileLabel = Resources.labelFor(this.compileProfile, PreferencesBundle.get("compile-profile.label"), PreferencesBundle.get("compile-profile.tip"));
        this.editProfilesButton.addActionListener(this);
        this.auditDuringCompile.addActionListener(this);
        this.auditWhileEditing.addActionListener(this);
        this.showCodeAssistanceInGutter.addActionListener(this);
        if (checkBoxInset == 0) {
            JCheckBox checkBox = new JCheckBox("");
            checkBoxInset = checkBox.getPreferredSize().width + checkBox.getIconTextGap() - checkBox.getInsets().right;
        }
        this.component = new JPanel(new GridBagLayout());
        this.component.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        GridBagConstraints column0 = new GridBagConstraints();
        column0.gridy = 0;
        column0.gridx = 0;
        column0.anchor = 17;
        GridBagConstraints column1 = new GridBagConstraints();
        column1.gridy = 0;
        column1.gridx = 1;
        column1.anchor = 17;
        column1.weightx = 1.0;
        column1.insets.left = 8;
        GridBagConstraints column01 = new GridBagConstraints();
        column01.gridy = 0;
        column01.gridx = 0;
        column01.gridwidth = 2;
        column01.anchor = 17;
        this.component.add((Component)this.editProfilesButton, column01);
        ++column0.gridy;
        ++column1.gridy;
        ++column01.gridy;
        column1.insets.top = 16;
        column0.insets.top = 16;
        this.component.add((Component)maximumFileSizeLabel, column0);
        Box maximumFileSizeAndUnits = Box.createHorizontalBox();
        maximumFileSizeAndUnits.add((Component)this.maximumFileSize);
        maximumFileSizeAndUnits.add(Box.createHorizontalStrut(2));
        maximumFileSizeAndUnits.add(maximumFileSizeUnits);
        maximumFileSizeUnits.add(Box.createHorizontalGlue());
        this.component.add((Component)maximumFileSizeAndUnits, column1);
        ++column0.gridy;
        ++column1.gridy;
        ++column01.gridy;
        column01.insets.top = 16;
        this.component.add((Component)this.auditWhileEditing, column01);
        ++column0.gridy;
        ++column1.gridy;
        ++column01.gridy;
        column01.insets.top = 6;
        column1.insets.top = 6;
        column0.insets.top = 6;
        column0.insets.left = column01.insets.left = checkBoxInset;
        this.component.add((Component)this.editorProfileLabel, column0);
        this.component.add((Component)this.editorProfile, column1);
        ++column0.gridy;
        ++column1.gridy;
        ++column01.gridy;
        this.component.add((Component)this.editorDelayLabel, column0);
        this.component.add((Component)editorDelayAndUnits, column1);
        ++column0.gridy;
        ++column1.gridy;
        ++column01.gridy;
        this.component.add((Component)this.showCodeAssistanceInGutter, column01);
        ++column0.gridy;
        ++column1.gridy;
        ++column01.gridy;
        column01.insets.top = 16;
        column01.insets.left = 0;
        this.component.add((Component)this.auditDuringCompile, column01);
        ++column0.gridy;
        ++column1.gridy;
        ++column01.gridy;
        column0.insets.left = checkBoxInset;
        this.component.add((Component)this.compileProfileLabel, column0);
        this.component.add((Component)this.compileProfile, column1);
        ++column0.gridy;
        ++column1.gridy;
        ++column01.gridy;
        if (Version.DEBUG_BUILD != 0) {
            JButton forceInitializationButton = Resources.button(PreferencesBundle.get("load-extensions.label"), PreferencesBundle.get("load-extensions.tip"));
            forceInitializationButton.addActionListener(e -> {
                try {
                    forceInitializationButton.setText(PreferencesBundle.get("load-extensions.progress.label"));
                    forceInitializationButton.setEnabled(false);
                    forceInitializationButton.paintImmediately(0, 0, forceInitializationButton.getWidth(), forceInitializationButton.getHeight());
                    AnalyzerBinding binding = new AnalyzerBinding(new DefaultProfile("internal", DefaultProfile.NONE_ENABLED));
                    binding.bind(null, false, Collections.emptySet(), new ArrayList<Rule>(), new ArrayList<Metric>(), new ArrayList<SuppressionScheme>(), null, true);
                }
                catch (Throwable t) {
                    AuditLogger.error(t, PreferencesBundle.format("load-extensions.exception.label", t), new Object[0]);
                }
                finally {
                    forceInitializationButton.setText(PreferencesBundle.get("load-extensions.done.label"));
                }
            });
            this.component.add((Component)forceInitializationButton, column01);
            ++column0.gridy;
            ++column1.gridy;
            ++column01.gridy;
        }
        column01.insets.top = 0;
        column01.insets.left = 0;
        column01.weighty = 1.0;
        this.component.add(Box.createGlue(), column01);
    }

    private void loadComponents() {
        this.auditDuringCompile.setSelected(this.copy.isAuditDuringCompile());
        Profile profile = this.profiles.getProfile(this.copy.getCompileProfile(), "oracle.jdeveloper.java.compile-rules");
        if (profile != null) {
            this.compileProfile.setSelectedItem(profile);
        } else {
            this.compileProfile.setSelectedIndex(0);
        }
        this.auditWhileEditing.setSelected(this.copy.isAuditWhileEditing());
        this.editorDelay.setNumber((Number)this.copy.getEditorDelay());
        this.maximumFileSize.setNumber((Number)Float.valueOf(this.copy.getMaximumFileSize()));
        profile = this.profiles.getProfile(this.copy.getAssistProfile(), "oracle.ide.audit.code-assist-rules");
        this.editorProfile.setSelectedItem(profile);
        this.showCodeAssistanceInGutter.setSelected(this.copy.isShowCodeAssistanceInGutter());
        this.synchronize();
    }

    private void synchronize() {
        boolean compiling = this.auditDuringCompile.isSelected();
        this.compileProfileLabel.setEnabled(compiling);
        if (compiling && this.compileProfile.getSelectedItem() == null) {
            this.compileProfile.setSelectedIndex(0);
        }
        this.compileProfile.setEnabled(compiling);
        boolean editing = this.auditWhileEditing.isSelected();
        this.editorDelayLabel.setEnabled(editing);
        this.editorDelay.setEnabled(editing);
        this.editorDelayUnits.setEnabled(editing);
        this.editorProfileLabel.setEnabled(editing);
        if (editing && this.editorProfile.getSelectedItem() == null) {
            this.editorProfile.setSelectedIndex(0);
        }
        this.editorProfile.setEnabled(editing);
        this.showCodeAssistanceInGutter.setEnabled(editing);
    }

    private void unloadComponents() {
        this.copy.setAuditDuringCompile(this.auditDuringCompile.isSelected());
        Profile profile = (Profile)this.compileProfile.getSelectedItem();
        String profileName = profile == null ? null : ("oracle.jdeveloper.java.compile-rules".equals(profile.getId()) ? null : profile.getName());
        this.copy.setCompileProfile(profileName);
        this.copy.setAuditWhileEditing(this.auditWhileEditing.isSelected());
        this.copy.setEditorDelay(this.editorDelay.getNumber().intValue());
        this.copy.setMaximumFileSize(this.maximumFileSize.getNumber().floatValue());
        profile = (Profile)this.editorProfile.getSelectedItem();
        profileName = profile == null ? null : ("oracle.ide.audit.code-assist-rules".equals(profile.getId()) ? null : profile.getName());
        this.copy.setAssistProfile(profileName);
        this.copy.setShowCodeAssistanceInGutter(this.showCodeAssistanceInGutter.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.editProfilesButton) {
            if (this.editProfilesDialog == null) {
                this.editProfilesDialog = new AuditProfileDialog(this.profiles);
            }
            this.editProfilesDialog.show(this.component);
        }
        this.synchronize();
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            this.synchronize();
        }
    }

    public void onEntry(TraversableContext context) {
        if (this.profiles == null) {
            this.profiles = new ProfileModel(AuditManager.getAuditManager().getDefaultProfileRepository());
        }
        AuditPreferences preferences = AuditPreferences.getAuditPreferences(context.getPropertyStorage());
        this.copy = new AuditPreferences();
        preferences.copyTo(this.copy);
        this.createComponents();
        this.loadComponents();
    }

    public void onExit(TraversableContext context) throws TraversalException {
        if (this.copy == null) {
            return;
        }
        this.unloadComponents();
        AuditPreferences preferences = AuditPreferences.getAuditPreferences(context.getPropertyStorage());
        this.copy.copyTo(preferences);
        this.copy = null;
    }

    public Object getExitTransition() {
        return null;
    }

    public String getHelpID() {
        return HELP_TOPIC;
    }
}

