/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.analyzer.IssueReport;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.analyzer.SuppressionReport;
import oracle.jdeveloper.audit.analyzer.SuppressionScheme;
import oracle.jdeveloper.audit.extension.AnalyzerDefinition;
import oracle.jdeveloper.audit.extension.AuditHook;
import oracle.jdeveloper.audit.extension.BeanDefinition;
import oracle.jdeveloper.audit.extension.RuleDefinition;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.Suppression;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdevimpl.audit.core.AnalyzerBinding;
import oracle.jdevimpl.audit.core.AuditELContext;
import oracle.jdevimpl.audit.core.AuditListenerList;
import oracle.jdevimpl.audit.core.BoundMethod;
import oracle.jdevimpl.audit.core.CoreBeans;
import oracle.jdevimpl.audit.core.DefaultAuditContext;
import oracle.jdevimpl.audit.core.DefaultIssue;
import oracle.jdevimpl.audit.core.DefaultIssueReport;
import oracle.jdevimpl.audit.core.DefaultSuppression;
import oracle.jdevimpl.audit.core.DefaultSuppressionReport;

final class IssueCollector {
    private final AuditListenerList listeners;
    private final AuditELContext expressionContext;
    private final List<BoundMethod<Analyzer>> reviewMethods;
    private final DefaultIssueReport currentIssue = new DefaultIssueReport();
    private final DefaultSuppressionReport currentSuppression = new DefaultSuppressionReport();
    private final Deque<Suspension> enclosingSuspensions = new ArrayDeque<Suspension>();
    private Suspension suspension = new Suspension();
    private boolean methodListEntered = false;
    private final List<DefaultIssue> reviewIssues = new ArrayList<DefaultIssue>();
    private final NavigableSet<DefaultIssue> suspendedIssues = new TreeSet<DefaultIssue>(new OffsetComparator());
    private final Deque<Map<RuleDefinition, List<DefaultSuppression>>> nameSuppressionMaps;
    private final Deque<Map<Violation, List<DefaultSuppression>>> reviewSuppressionMaps;
    private final List<Suppression> accumulator = new ArrayList<Suppression>();
    private static final Log LOG = new Log("audit-collector");

    IssueCollector(AuditListenerList listeners, AuditELContext expressionContext, List<BoundMethod<Analyzer>> reviewMethods) {
        this.listeners = listeners;
        this.expressionContext = expressionContext;
        this.reviewMethods = reviewMethods;
        this.nameSuppressionMaps = new ArrayDeque<Map<RuleDefinition, List<DefaultSuppression>>>();
        this.nameSuppressionMaps.add(new HashMap());
        this.reviewSuppressionMaps = new ArrayDeque<Map<Violation, List<DefaultSuppression>>>();
        this.reviewSuppressionMaps.add(new HashMap());
    }

    void enteringContext(DefaultAuditContext context) {
        LOG.trace("entering context {0}", (Object)context);
        assert (this.currentIssue.isClosed() && this.currentSuppression.isClosed());
        if (context.isModelRoot()) {
            this.enclosingSuspensions.push(this.suspension);
            this.fireSuspendedIssuesBefore(Integer.MAX_VALUE);
            this.suspension = new Suspension();
            HashMap<RuleDefinition, List<DefaultSuppression>> nameSuppressionMap = new HashMap<RuleDefinition, List<DefaultSuppression>>(this.nameSuppressionMaps.peek());
            for (Map.Entry entry : nameSuppressionMap.entrySet()) {
                entry.setValue(new ArrayList((Collection)entry.getValue()));
            }
            this.nameSuppressionMaps.push(nameSuppressionMap);
            IdentityHashMap<Violation, List<DefaultSuppression>> reviewSuppressionMap = new IdentityHashMap<Violation, List<DefaultSuppression>>(this.reviewSuppressionMaps.peek());
            for (Map.Entry entry : reviewSuppressionMap.entrySet()) {
                entry.setValue(new ArrayList((Collection)entry.getValue()));
            }
            this.reviewSuppressionMaps.push(reviewSuppressionMap);
        }
        assert (this.currentIssue.isClosed() && this.currentSuppression.isClosed());
        if (!this.suspension.explicit) {
            this.suspension.from = context.getLocation().getOffset();
            this.fireSuspendedIssuesBefore(this.suspension.from);
        }
    }

    void enteringMethodList(DefaultAuditContext context) {
        LOG.trace("entering method list");
        assert (!this.methodListEntered);
        assert (this.reviewIssues.isEmpty());
        this.methodListEntered = true;
    }

    void exitingMethod() {
        LOG.trace("exiting method");
        assert (this.methodListEntered);
        this.closeSuppression();
        this.closeIssue();
    }

    void exitingMethodList(DefaultAuditContext context) {
        assert (this.methodListEntered);
        this.closeSuppression();
        this.closeIssue();
        int count = this.reviewIssues.size();
        LOG.trace("exiting method list, size {0}", count);
        for (int i = 0; i < count; ++i) {
            DefaultIssue issue = this.reviewIssues.get(i);
            Rule rule = issue.getRule();
            if (rule.mandatoryError() || rule.assist()) continue;
            LOG.trace("reviewing {0}", (Object)issue);
            context.invokeReviewMethods(this.reviewMethods, issue);
        }
        this.suspendedIssues.addAll(this.reviewIssues);
        this.reviewIssues.clear();
        this.methodListEntered = false;
    }

    void exitingContext(DefaultAuditContext context) {
        LOG.trace("exiting context {0}", (Object)context);
        assert (!this.methodListEntered);
        assert (this.reviewIssues.isEmpty());
        this.closeSuppression();
        this.closeIssue();
        assert (this.currentIssue.isClosed() && this.currentSuppression.isClosed());
        if (!this.suspension.explicit) {
            this.suspension.from = context.getLocation().getEndOffset();
            this.fireSuspendedIssuesBefore(this.suspension.from);
        }
        if (context.isModelRoot()) {
            this.fireSuspendedIssuesBefore(Integer.MAX_VALUE);
            this.nameSuppressionMaps.pop();
            this.reviewSuppressionMaps.pop();
            this.suspension = this.enclosingSuspensions.pop();
        }
    }

    void reportAnalyzerException(ModelAdapter model, Location location, Object construct, Throwable exception, AnalyzerDefinition analyzer) {
        LOG.trace("opening/closing/releasing analyzer exception {0}", (Object)exception);
        this.currentIssue.cancel();
        Rule rule = CoreBeans.analyzerExceptionRule();
        if (rule != null) {
            this.currentIssue.open(model, rule, location, construct);
            this.currentIssue.addParameter("analyzer", analyzer);
            if (exception instanceof AnalyzerBinding.BindingException) {
                this.currentIssue.setVariation("binding");
                this.currentIssue.addParameter("message", exception.getMessage());
            } else {
                this.currentIssue.addParameter("exception", exception.toString());
                String method = "?";
                StackTraceElement[] trace = exception.getStackTrace();
                if (trace.length > 0) {
                    method = trace[0].getClassName() + '.' + trace[0].getMethodName() + ':' + trace[0].getLineNumber();
                }
                this.currentIssue.addParameter("method", method);
            }
            DefaultIssue issue = this.currentIssue.close();
            assert (issue.getTransformCount() == 0);
            LOG.trace("opened/closed/released analyzer exception {0}", (Object)issue);
            this.listeners.fireIssueReported(issue, issue.getTransformMask());
        } else {
            LOG.trace("analyzer exception rule not found");
        }
    }

    void reportTraversalException(DefaultAuditContext context, Throwable exception, Object construct) {
        LOG.trace("opening/closing/releasing traversal exception {0}", (Object)exception);
        this.currentIssue.cancel();
        Rule rule = CoreBeans.traversalExceptionRule();
        if (rule != null) {
            this.currentIssue.open(context.getModel(), rule, context.getLocation(), construct);
            this.currentIssue.addParameter("exception", exception.getClass().getName());
            String method = "?";
            StackTraceElement[] trace = exception.getStackTrace();
            if (trace.length > 0) {
                method = trace[0].getClassName() + '.' + trace[0].getMethodName() + ':' + trace[0].getLineNumber();
            }
            this.currentIssue.addParameter("method", method);
            DefaultIssue issue = this.currentIssue.close();
            assert (issue.getTransformCount() == 0);
            LOG.trace("opened/closed/released traversal exception {0}", (Object)issue);
            this.listeners.fireIssueReported(issue, issue.getTransformMask());
        } else {
            LOG.trace("traversal exception rule not found");
        }
    }

    void reportModelError(DefaultAuditContext context, Throwable exception, Object construct) {
        LOG.trace("opening/closing/releasing model error {0}", (Object)exception);
        this.currentIssue.cancel();
        Rule rule = CoreBeans.modelErrorRule();
        if (rule != null) {
            this.currentIssue.open(context.getModel(), rule, context.getLocation(), construct);
            this.currentIssue.addParameter("message", exception.getMessage());
            DefaultIssue issue = this.currentIssue.close();
            assert (issue.getTransformCount() == 0);
            LOG.trace("opened/closed/released model error {0}", (Object)issue);
            this.listeners.fireIssueReported(issue, issue.getTransformMask());
        } else {
            LOG.trace("model error rule not found");
        }
    }

    void cancel() {
        LOG.trace("cancelling");
        this.cancelSuppression();
        this.cancelIssue();
    }

    void markSuppressionLimit(int offset) {
        LOG.trace("moved suppression limit from {1} to {0} (explicit)", offset, (Object)this.suspension);
        this.suspension.from = offset;
        this.suspension.explicit = true;
    }

    IssueReport openIssue(AuditContext context, Rule rule, Location location, Object construct) {
        this.closeIssue();
        this.currentIssue.open(context.getModel(), rule, location, construct);
        LOG.trace("opened {0}", (Object)this.currentIssue);
        return this.currentIssue;
    }

    private void closeIssue() {
        if (this.currentIssue.isClosed()) {
            return;
        }
        DefaultIssue issue = this.currentIssue.close();
        LOG.trace("closed and suspended {0}", (Object)issue);
        if (this.methodListEntered) {
            this.reviewIssues.add(issue);
        } else {
            this.suspendedIssues.add(issue);
        }
    }

    private void cancelIssue() {
        if (this.currentIssue.isClosed()) {
            return;
        }
        LOG.trace("cancelling {0}", (Object)this.currentIssue);
        this.currentIssue.cancel();
    }

    SuppressionReport openNameSuppression(DefaultAuditContext context, SuppressionScheme scheme, String name, Location location, Object construct) {
        this.closeSuppression();
        this.currentSuppression.openNameSuppression(scheme, name, location);
        LOG.trace("opened {0}", (Object)this.currentSuppression);
        return this.currentSuppression;
    }

    SuppressionReport openReviewSuppression(DefaultAuditContext context, SuppressionScheme scheme, Violation issue) {
        this.closeSuppression();
        this.currentSuppression.openReviewSuppression(scheme, issue);
        LOG.trace("opened {0}", (Object)this.currentSuppression);
        return this.currentSuppression;
    }

    private void closeSuppression() {
        if (this.currentSuppression.isClosed()) {
            return;
        }
        if (this.nameSuppressionMaps.isEmpty()) {
            throw new IllegalStateException("nameSuppressionMaps empty");
        }
        if (this.reviewSuppressionMaps.isEmpty()) {
            throw new IllegalStateException("reviewSuppressionMaps empty");
        }
        DefaultSuppression suppression = this.currentSuppression.close();
        switch (suppression.getType()) {
            case NAME: {
                Map<RuleDefinition, List<DefaultSuppression>> map = this.nameSuppressionMaps.peek();
                AuditHook hook = AuditHook.getAuditHook();
                BeanDefinition beanDefinition = hook.getBeanByIdOrDeprecatedId(suppression.getName());
                if (beanDefinition instanceof RuleDefinition) {
                    List<DefaultSuppression> suppressions = map.get(beanDefinition);
                    if (suppressions == null) {
                        suppressions = new ArrayList<DefaultSuppression>();
                        map.put((RuleDefinition)beanDefinition, suppressions);
                    }
                    suppressions.add(suppression);
                    break;
                }
                Set<RuleDefinition> definitions = hook.getSuppressionRules(suppression.getName());
                if (definitions == null) break;
                for (RuleDefinition definition : definitions) {
                    List<DefaultSuppression> suppressions = map.get(definition);
                    if (suppressions == null) {
                        suppressions = new ArrayList<DefaultSuppression>();
                        map.put(definition, suppressions);
                    }
                    suppressions.add(suppression);
                }
                break;
            }
            case REVIEW: {
                Map<Violation, List<DefaultSuppression>> map = this.reviewSuppressionMaps.peek();
                Violation issue = suppression.getIssue();
                List<DefaultSuppression> suppressions = map.get(issue);
                if (suppressions == null) {
                    suppressions = new ArrayList<DefaultSuppression>();
                    map.put(issue, suppressions);
                }
                suppressions.add(suppression);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        LOG.trace("closed {0}", (Object)suppression);
        this.currentSuppression.clear();
    }

    private void cancelSuppression() {
        LOG.trace("cancelling {0}", (Object)this.currentSuppression);
        this.currentSuppression.clear();
    }

    private void fireSuspendedIssuesBefore(int offset) {
        DefaultIssue issue;
        Location location;
        assert (this.currentIssue.isClosed() && this.currentSuppression.isClosed());
        Iterator<DefaultIssue> iterator = this.suspendedIssues.iterator();
        while (iterator.hasNext() && (location = (issue = iterator.next()).getLocation()).getOffset() < offset) {
            Rule rule = issue.getRule();
            this.accumulator.clear();
            if (!rule.mandatoryError() && !rule.assist()) {
                List<DefaultSuppression> reviewSuppressions;
                List<DefaultSuppression> nameSuppressions = this.nameSuppressionMaps.peek().get(rule.definition());
                if (nameSuppressions != null) {
                    for (DefaultSuppression suppression : nameSuppressions) {
                        if (!suppression.getScope().contains(location)) continue;
                        this.accumulator.add(suppression);
                    }
                }
                if ((reviewSuppressions = this.reviewSuppressionMaps.peek().get(issue)) != null) {
                    this.accumulator.addAll(reviewSuppressions);
                }
            }
            issue.close(this.accumulator, this.expressionContext);
            LOG.trace("released {0}", (Object)issue);
            this.listeners.fireIssueReported(issue, issue.getTransformMask());
            iterator.remove();
        }
    }

    public String toString() {
        return this.currentIssue.toString();
    }

    private static class OffsetComparator
    implements Comparator<DefaultIssue> {
        private OffsetComparator() {
        }

        @Override
        public int compare(DefaultIssue left, DefaultIssue right) {
            int comparison = left.getOffset() - right.getOffset();
            if (comparison == 0) {
                comparison = left.getSerialNumber() - right.getSerialNumber();
            }
            return comparison;
        }
    }

    private static class Suspension {
        int from;
        boolean explicit;

        private Suspension() {
        }

        public String toString() {
            return this.from + (this.explicit ? " (explicit)" : " (implicit)");
        }
    }
}

