/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.AuditModelListener;
import oracle.jdeveloper.audit.transform.Transform;

public abstract class AbstractAuditModel
implements AuditModel {
    private CopyOnWriteArrayList<AuditModelListener> listeners = new CopyOnWriteArrayList();
    private static final Log LOG = new Log("model");

    @Override
    public void addAuditModelListener(AuditModelListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    @Override
    public void removeAuditModelListener(AuditModelListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireAuditStarted(List<Metric> columns, List<Location> locations, Object root, Class type) {
        LOG.trace("**** firing audit started at {0}", root);
        for (AuditModelListener listener : this.listeners) {
            listener.auditStarted(this, columns, locations, root, type);
        }
        LOG.trace("completed firing audit started at {0}", root);
    }

    protected void fireAuditStopped(boolean cancelled) {
        LOG.trace("**** firing audit stopped, {0}", cancelled);
        for (AuditModelListener listener : this.listeners) {
            listener.auditStopped(this, cancelled);
        }
        LOG.trace("completed firing audit stopped, cancelled {0}", cancelled);
    }

    protected void fireRowsInserted(List<?> rows, Object parent, int index) {
        LOG.trace("firing rows inserted in {0} at {1}: {2}", parent, (Object)index, rows);
        for (AuditModelListener listener : this.listeners) {
            listener.rowsInserted(this, rows, parent, index);
        }
        LOG.trace("completed firing rows inserted in {0} at {1}: {2}", parent, (Object)index, rows);
    }

    protected void fireRowsRemoved(List<?> rows, Object parent, int index) {
        LOG.trace("firing rows removed in {0} at {1}: {2}", parent, (Object)index, rows);
        for (AuditModelListener listener : this.listeners) {
            listener.rowsRemoved(this, rows, parent, index);
        }
        LOG.trace("completed firing rows removed in {0} at {1}: {2}", parent, (Object)index, rows);
    }

    protected void fireRowsShown(List<?> rows, Object visibleParent, int visibleIndex) {
        LOG.trace("firing rows shown in {0} at {1}: {2}", visibleParent, (Object)visibleIndex, rows);
        for (AuditModelListener listener : this.listeners) {
            listener.rowsShown(this, rows, visibleParent, visibleIndex);
        }
        LOG.trace("completed firing rows shown in {0} at {1}: {2}", visibleParent, (Object)visibleIndex, rows);
    }

    protected void fireRowsHidden(List<?> rows, Object visibleParent, int visibleIndex) {
        LOG.trace("firing rows hidden in {0} at {1}: {2}", visibleParent, (Object)visibleIndex, rows);
        for (AuditModelListener listener : this.listeners) {
            listener.rowsHidden(this, rows, visibleParent, visibleIndex);
        }
        LOG.trace("completed firing rows hidden in {0} at {1}: {2}", visibleParent, (Object)visibleIndex, rows);
    }

    protected void fireRowsRestructureBegin(Object parent, Object visibleParent) {
        LOG.trace("firing row restructure begin in {0}", parent);
        for (AuditModelListener listener : this.listeners) {
            listener.rowsRestructureBegin(this, parent, visibleParent);
        }
        LOG.trace("completed firing row restructure begin in {0}", parent);
    }

    protected void fireRowsRestructureEnd(Object parent, Object visibleParent) {
        LOG.trace("firing row restructure end in {0}", parent);
        for (AuditModelListener listener : this.listeners) {
            listener.rowsRestructureEnd(this, parent, visibleParent);
        }
        LOG.trace("completed firing row restructure end in {0}", parent);
    }

    protected void fireCountChanged(Object row, AuditModel.Count count, int oldValue, int newValue) {
        LOG.trace("firing {2} changed from {0} to {1} for {3}", oldValue, newValue, (Object)count, row);
        for (AuditModelListener listener : this.listeners) {
            listener.countChanged(this, row, count, oldValue, newValue);
        }
        LOG.trace("completed firing {2} changed from {0} to {1} for {3}", oldValue, newValue, (Object)count, row);
    }

    protected void fireValueChanged(Object child, int columnIndex, Object oldValue, Object newValue) {
        LOG.trace("firing {1} changed at column {0}", columnIndex, child);
        for (AuditModelListener listener : this.listeners) {
            listener.valueChanged(this, child, columnIndex, oldValue, newValue);
        }
        LOG.trace("completed firing {1} changed at column {0}", columnIndex, child);
    }

    protected void fireModelResorted() {
        LOG.trace("firing model resorted");
        for (AuditModelListener listener : this.listeners) {
            listener.modelResorted(this);
        }
        LOG.trace("completed firing model resorted");
    }

    protected void fireAppliedTransformsChanged(Object row, List<Transform> transforms) {
        LOG.trace("firing {1} transforms changed", row);
        for (AuditModelListener listener : this.listeners) {
            listener.appliedTransformsChanged(this, row, transforms);
        }
        LOG.trace("completed firing {1} transforms changed", row);
    }
}

