/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.service;

import oracle.jdeveloper.audit.service.Converter;

public class EnumConverter
extends Converter {
    @Override
    public Enum toValue(String string, Class<?> type) {
        String description;
        Enum[] constants;
        for (Enum constant : constants = (Enum[])type.getEnumConstants()) {
            String name = constant.name();
            if (!string.equalsIgnoreCase(name)) continue;
            return constant;
        }
        if (constants.length == 1) {
            description = '\"' + constants[0].name().toLowerCase() + '\"';
        } else {
            StringBuilder buffer = new StringBuilder("one of ");
            String separator = "";
            for (Enum constant : constants) {
                buffer.append(separator);
                buffer.append('\"');
                buffer.append(constant.name().toLowerCase());
                buffer.append('\"');
                separator = ", ";
            }
            description = buffer.toString();
        }
        throw new IllegalArgumentException("expected " + description);
    }

    @Override
    public String toString(Object value) {
        if (!value.getClass().isEnum()) {
            throw new ClassCastException(value.getClass().getName());
        }
        return String.valueOf(value);
    }
}

