/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import java.net.URL;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.audit.analyzer.AuditContext;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelBundle;

public class ModelAccessError
extends RuntimeException {
    private final ModelAdapter model;
    private final Object[] detail;

    ModelAccessError(ModelAdapter model, String message, Object ... detail) {
        super(ModelAccessError.message(model, null, null, message));
        this.model = model;
        this.detail = detail;
    }

    ModelAccessError(ModelAdapter model, Throwable cause, Object ... detail) {
        super(ModelAccessError.message(model, cause, null, null), cause);
        this.model = model;
        this.detail = detail;
    }

    ModelAccessError(ModelAdapter model, AuditContext context, Object ... detail) {
        super(ModelAccessError.message(model, null, context, null));
        this.model = model;
        this.detail = detail;
    }

    public ModelAdapter getModel() {
        return this.model;
    }

    public Object[] getDetail() {
        return this.detail;
    }

    private static String message(ModelAdapter model, Throwable exception, AuditContext context, String reason) {
        URL nodeUrl;
        URL modelUrl = model.getUrl();
        String modelName = URLFileSystem.getFileName((URL)modelUrl);
        if (exception instanceof InterruptedException) {
            return ModelBundle.format("interrupted.message", modelName);
        }
        Node node = model.getNode();
        if (node != null && !URLFileSystem.equals((URL)modelUrl, (URL)(nodeUrl = node.getURL()))) {
            return ModelBundle.format("renamed.message", modelName, URLFileSystem.getFileName((URL)nodeUrl));
        }
        if (URLFileSystem.isRegularFile((URL)modelUrl) || URLFileSystem.isDirectory((URL)modelUrl)) {
            if (!URLFileSystem.canRead((URL)modelUrl)) {
                return ModelBundle.format("noread.message", modelName);
            }
            if (exception != null) {
                return ModelBundle.format("exception.message", modelName, exception);
            }
            if (context != null) {
                return ModelBundle.format("location.message", modelName);
            }
            if (reason != null) {
                return ModelBundle.format("exception.message", modelName, reason);
            }
            return ModelBundle.format("unknown.message", modelName);
        }
        URL parent = URLFileSystem.getParent((URL)modelUrl);
        URL[] children = URLFileSystem.list((URL)parent);
        if (children != null) {
            for (URL child : children) {
                if (!URLFileSystem.equals((URL)modelUrl, (URL)child)) continue;
                return ModelBundle.format("broken.message", modelName);
            }
        }
        return ModelBundle.format("deleted.message", modelName);
    }
}

