/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.util.IntersectedFilters;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.model.ContentDirectory;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;

public abstract class ContainerModelAdapter
extends ModelAdapter {
    private final Object CONTAINED_LOCK = new Object();
    private volatile List<ModelAdapter> containedModels;
    private volatile Collection<Element> containedUnauditableElements;
    private boolean modelOrdered;
    private static final Log LOG = new Log("node");
    private static final Comparator<ModelAdapter> SIBLING_COMPARATOR = new Comparator<ModelAdapter>(){

        @Override
        public int compare(ModelAdapter left, ModelAdapter right) {
            return ModelAdapter.compareSiblings(left, right);
        }
    };

    protected ContainerModelAdapter(ModelFactory factory, ModelType type, Workspaces applications, URL url) {
        super(factory, type, applications, url);
    }

    protected ContainerModelAdapter(ModelFactory factory, ModelType type, Workspace workspace, URL url) {
        super(factory, type, workspace, url);
    }

    protected ContainerModelAdapter(ModelFactory factory, ModelType type, ContainerModelAdapter workspace, Project project, URL url) {
        super(factory, type, workspace, project, url);
    }

    protected ContainerModelAdapter(ModelFactory factory, ModelType type, ContainerModelAdapter workspace, ContainerModelAdapter project, ContainerModelAdapter directory, ContentDirectory element, URL url) {
        super(factory, type, workspace, project, directory, element, url);
    }

    @Override
    public Location[] getElementLocations(Element element) {
        Location[] locationArray;
        if (element == this.getElement()) {
            Location[] locationArray2 = new Location[1];
            locationArray = locationArray2;
            locationArray2[0] = this.getLocation();
        } else {
            locationArray = null;
        }
        return locationArray;
    }

    @Override
    public Object getRootHook() {
        this.initializeContainedModelsAndUnauditableElements();
        return this.getElement();
    }

    @Override
    public URL getUrl(Location location) {
        Object construct = this.getConstruct(location);
        if (construct instanceof ModelAdapter) {
            return ((ModelAdapter)construct).getUrl();
        }
        if (construct instanceof Locatable) {
            return ((Locatable)construct).getURL();
        }
        return super.getUrl(location);
    }

    @Override
    public boolean isFile() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addContainedModel(ModelAdapter model) {
        assert (this != model);
        Object object = this.CONTAINED_LOCK;
        synchronized (object) {
            if (this.containedModels == null) {
                this.containedModels = new ArrayList<ModelAdapter>();
                this.containedUnauditableElements = new ArrayList<Element>();
            }
            return this.addSibling(model);
        }
    }

    @Override
    public Iterator getContainedConstructs(Object construct) {
        if (construct != this.getElement()) {
            throw new IllegalArgumentException("construct " + construct + " not root element " + this.getElement());
        }
        this.initializeContainedModelsAndUnauditableElements();
        return this.containedModels.iterator();
    }

    @Override
    public Location getLocation(Object construct) {
        ModelAdapter model;
        if (construct == this.getElement()) {
            return this.getLocation();
        }
        if (construct instanceof ModelAdapter && (model = (ModelAdapter)construct).getContainingAdapter() == this) {
            assert (model.ordinal > 0);
            return this.getLocation(model.ordinal, 1);
        }
        return null;
    }

    @Override
    public Object getConstruct(Location location) {
        LOG.trace("getting construct for {0}", (Object)location);
        assert (this == location.getModel());
        if (location.isRoot() || location.getLength() > 1) {
            return this.getRoot();
        }
        int ordinal = location.getOffset();
        for (int index = ordinal / 16 - 1; index < this.containedModels.size(); ++index) {
            ModelAdapter model = this.containedModels.get(index);
            if (model.ordinal == ordinal) {
                return model;
            }
            if (model.ordinal <= ordinal) continue;
            return null;
        }
        return null;
    }

    public Iterator<Element> getContainedUnauditableElements() {
        this.initializeContainedModelsAndUnauditableElements();
        return this.containedUnauditableElements.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeContainedModelsAndUnauditableElements() {
        boolean create = false;
        Object object = this.CONTAINED_LOCK;
        synchronized (object) {
            if (this.containedModels == null) {
                this.containedModels = new ArrayList<ModelAdapter>();
                this.containedUnauditableElements = new ArrayList<Element>();
                create = true;
            }
        }
        if (create) {
            this.collectContainedElements();
        }
        object = this.CONTAINED_LOCK;
        synchronized (object) {
            if (!this.modelOrdered) {
                this.modelOrdered = true;
                int index = 0;
                for (ModelAdapter containedModel : this.containedModels) {
                    containedModel.ordinal = index += 16;
                }
                this.containedModels = new CopyOnWriteArrayList<ModelAdapter>(this.containedModels);
                LOG.trace("children of {0} are {1}", (Object)this, this.containedModels);
            }
        }
    }

    protected abstract void collectContainedElements();

    protected void addContainedElement(Element element, URL url) {
        Collection<ModelAdapter> models;
        IntersectedFilters filters = this.getFactory().getFileFilters();
        if (filters != null) {
            String path = url.getPath();
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (!filters.isIncluded(path)) {
                return;
            }
        }
        if (!(models = this.getFactory().getContainedModelAdapters(element, url, this)).isEmpty()) {
            for (ModelAdapter model : models) {
                assert (this != model);
                this.addSibling(model);
            }
        } else {
            this.containedUnauditableElements.add(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEmbeddedModel(ModelAdapter embeddedModel, ModelAdapter baseModel) {
        assert (this != embeddedModel);
        assert (baseModel.getContainingAdapter() == embeddedModel.getContainingAdapter());
        assert (baseModel.getSecondaryCollationKey().equals(embeddedModel.getSecondaryCollationKey()));
        assert (baseModel.ordinal > 0);
        assert (embeddedModel.ordinal == 0);
        Object object = this.CONTAINED_LOCK;
        synchronized (object) {
            if (this.containedModels == null) {
                throw new IllegalStateException("contained models not determined");
            }
            if (!this.modelOrdered) {
                throw new IllegalStateException("model not already ordered");
            }
            int baseIndex = Collections.binarySearch(this.containedModels, baseModel, SIBLING_COMPARATOR);
            if (baseIndex < 0) {
                throw new IllegalArgumentException("base model not contained");
            }
            int limitOrdinal = baseModel.ordinal + 16;
            int index = baseIndex;
            while (++index < this.containedModels.size() && this.containedModels.get((int)index).ordinal < limitOrdinal) {
            }
            if (index - baseIndex >= 16) {
                throw new IllegalArgumentException("more than 15 embedded models added for " + embeddedModel);
            }
            embeddedModel.ordinal = this.containedModels.get((int)(index - 1)).ordinal + 1;
            this.containedModels.add(index, embeddedModel);
        }
    }

    private boolean addSibling(ModelAdapter model) {
        if (this.containedModels.isEmpty()) {
            return this.containedModels.add(model);
        }
        int index = -Collections.binarySearch(this.containedModels, model, SIBLING_COMPARATOR) - 1;
        if (index < 0) {
            return false;
        }
        this.containedModels.add(index, model);
        return true;
    }
}

