/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.markers;

import java.util.Map;
import java.util.WeakHashMap;
import oracle.ide.Context;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.adapters.AdapterManager;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerException;
import oracle.ide.markers.ProblemMarker;
import oracle.ide.markers.TaskMarker;
import oracle.javatools.status.Issue;
import oracle.javatools.status.Severity;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.markers.AuditMarker;
import oracle.jdeveloper.audit.markers.AuditProblemMarker;
import oracle.jdeveloper.audit.markers.AuditTaskMarker;
import oracle.jdeveloper.audit.service.Violation;

public final class AuditMarkerFactory {
    private static final Map<AuditMarker, Issue> ISSUES_BY_MARKER = new WeakHashMap<AuditMarker, Issue>();
    private static final String TASK_RULE = "oracle.jdeveloper.todo.task";

    public static AuditMarker getMarker(Context context, Issue issue) throws MarkerException {
        AuditMarker marker = null;
        Rule rule = issue instanceof Violation ? ((Violation)issue).getRule() : null;
        marker = null != rule && true == rule.definition().getId().equals(TASK_RULE) ? AuditMarkerFactory.createTaskMarker(context, issue) : AuditMarkerFactory.createProblemMarker(context, issue);
        ISSUES_BY_MARKER.put(marker, issue);
        return marker;
    }

    private static ProblemMarker.Severity getMarkerSeverity(Severity severity) {
        switch (severity) {
            case ERROR: {
                return ProblemMarker.Severity.ERROR;
            }
            case WARNING: {
                return ProblemMarker.Severity.WARNING;
            }
            case INCOMPLETE: {
                return ProblemMarker.Severity.INCOMPLETE;
            }
            case ADVISORY: {
                return ProblemMarker.Severity.INFO;
            }
        }
        return null;
    }

    private AuditMarkerFactory() {
    }

    private static AuditProblemMarker createProblemMarker(Context context, Issue issue) throws MarkerException {
        ProblemMarker.Severity severity = AuditMarkerFactory.getMarkerSeverity(issue.getSeverity());
        if (null == severity) {
            return null;
        }
        AuditProblemMarker problem = (AuditProblemMarker)Marker.Factory.newMarker(AuditProblemMarker.class, (Context)context);
        problem.description(issue.getMessage());
        problem.offset(issue.getOffset() + 1);
        problem.length(issue.getLength());
        problem.severity(severity.value);
        return problem;
    }

    private static AuditTaskMarker createTaskMarker(Context context, Issue issue) throws MarkerException {
        AuditTaskMarker task = (AuditTaskMarker)Marker.Factory.newMarker(AuditTaskMarker.class, (Context)context);
        task.description(issue.getMessage());
        task.offset(issue.getOffset() + 1);
        task.length(issue.getLength());
        task.priority(TaskMarker.Priority.NORMAL.value);
        if (issue instanceof Violation) {
            Object tag;
            Violation violation = (Violation)issue;
            Object priority = violation.getParameterValue("priority");
            if (priority instanceof Number) {
                task.priority(((Number)priority).intValue());
            }
            if (null != (tag = violation.getParameterValue("tag"))) {
                task.tag(String.valueOf(tag));
            }
        }
        return task;
    }

    static {
        AdapterManager.Factory.getAdapterManager().registerFactory((AdapterFactory)new AdapterFactory<AuditMarker, Issue>(){

            public Issue adapt(AuditMarker marker) {
                return (Issue)ISSUES_BY_MARKER.get(marker);
            }
        });
    }
}

