/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import java.util.List;
import oracle.ide.extension.feature.Feature;
import oracle.ide.extension.feature.FeatureCategory;
import oracle.jdeveloper.audit.analyzer.Category;
import oracle.jdeveloper.audit.extension.BeanDefinition;
import oracle.jdeveloper.audit.extension.DefinitionContext;
import oracle.jdeveloper.audit.extension.ExtensionBundle;
import oracle.jdeveloper.audit.extension.HasCategory;

public class CategoryDefinition
extends BeanDefinition<Category>
implements HasCategory {
    private CategoryDefinition category;
    private String featureId;
    private Feature feature;
    private FeatureCategory featureCategory;

    public CategoryDefinition(String id, CategoryDefinition category, ExtensionBundle bundle, DefinitionContext context) {
        super(id, bundle, context);
        this.category = category;
    }

    CategoryDefinition(String id, List<String> featurePath, FeatureCategory featureCategory, Feature feature, CategoryDefinition category, ExtensionBundle bundle, DefinitionContext context) {
        super(id, bundle, context);
        this.category = category;
        this.featureId = CategoryDefinition.catenate(featurePath);
        assert (feature != null ^ featureCategory != null);
        this.featureCategory = featureCategory;
        this.feature = feature;
    }

    private static String catenate(List<String> path) {
        StringBuilder builder = new StringBuilder(path.get(0));
        for (int i = 1; i < path.size(); ++i) {
            builder.append(' ').append(path.get(i));
        }
        return builder.toString();
    }

    @Override
    public Class<Category> getDefaultImplementationClass() {
        return Category.class;
    }

    @Override
    public boolean hasEnabledProperty() {
        return false;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    @Override
    public CategoryDefinition getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(CategoryDefinition category) {
        this.category = category;
    }

    @Override
    public String label() {
        String label = this.string("label");
        if (label == null) {
            if (this.feature != null) {
                label = this.feature.getDisplayName();
            } else if (this.featureCategory != null) {
                label = this.featureCategory.getDisplayName();
            }
            if (label == null) {
                label = this.defaultLabelString();
            }
        }
        return label;
    }

    @Override
    public String description() {
        String description = this.string("description");
        if (description == null) {
            if (this.feature != null) {
                description = this.feature.getDescription();
            } else if (this.featureCategory != null) {
                description = this.featureCategory.getDescription();
            }
            if (description == null) {
                this.reportMissingString("description");
            }
        }
        return description;
    }
}

