/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Header;

class OSInputStream
extends FilterInputStream {
    private boolean primitive;
    private int bytesRemaining;
    private ASN1ConstructedInputStream cs;
    private OSInputStream sub;

    OSInputStream(InputStream in) throws IOException {
        this(in, 4, 0);
    }

    OSInputStream(InputStream in, int tag) throws IOException {
        this(in, tag, 128);
    }

    private OSInputStream(InputStream in, int tag, int tagClass) throws IOException {
        super(in);
        ASN1Header header = new ASN1Header(in);
        header.checkTag(tag);
        header.checkTagClass(tagClass);
        if (header.getEncodingMethod() == 0) {
            this.primitive = true;
            this.bytesRemaining = header.getBodyLength();
        } else {
            this.primitive = false;
            this.cs = new ASN1ConstructedInputStream(in, header);
            if (!this.cs.hasMoreData()) {
                this.terminateCS();
            } else {
                this.sub = new OSInputStream((InputStream)this.cs);
                this.advanceCS();
            }
        }
    }

    boolean hasMoreData() {
        if (this.primitive) {
            return this.bytesRemaining > 0;
        }
        return this.sub != null;
    }

    private void advanceCS() throws IOException {
        while (this.sub != null && !this.sub.hasMoreData()) {
            if (this.cs.hasMoreData()) {
                this.sub = new OSInputStream((InputStream)this.cs);
                continue;
            }
            this.terminateCS();
        }
    }

    private void terminateCS() throws IOException {
        this.sub = null;
        this.cs.terminate();
    }

    @Override
    public int read() throws IOException {
        if (this.primitive) {
            if (this.bytesRemaining == 0) {
                return -1;
            }
            int ch = super.read();
            if (ch == -1) {
                throw new ASN1FormatException("Unexpected end of input");
            }
            --this.bytesRemaining;
            return ch;
        }
        if (this.sub == null) {
            return -1;
        }
        int ch = this.sub.read();
        this.advanceCS();
        return ch;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.primitive) {
            if (this.bytesRemaining == 0) {
                return -1;
            }
            int efflen = super.read(buffer, offset, len = len <= this.bytesRemaining ? len : this.bytesRemaining);
            if (efflen == -1) {
                throw new ASN1FormatException("Unexpected end of input");
            }
            this.bytesRemaining -= efflen;
            return efflen;
        }
        if (this.sub == null) {
            return -1;
        }
        int efflen = this.sub.read(buffer, offset, len);
        this.advanceCS();
        return efflen;
    }

    @Override
    public int available() throws IOException {
        if (this.primitive) {
            return Math.min(this.bytesRemaining, super.available());
        }
        if (this.sub == null) {
            return 0;
        }
        return Math.min(this.sub.available(), super.available());
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped;
        if (this.primitive) {
            long skipped2 = super.skip(Math.min(n, (long)this.bytesRemaining));
            this.bytesRemaining = (int)((long)this.bytesRemaining - skipped2);
            return skipped2;
        }
        for (skipped = 0L; skipped < n && this.hasMoreData(); skipped += this.sub.skip(n - skipped)) {
            if (this.sub.hasMoreData()) break;
            this.advanceCS();
        }
        return skipped;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

