/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.InflaterInputStream;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Header;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.cms.CMSDataContentInfo;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;

class EncapsulatedContentInfo
implements ASN1Object {
    private ASN1ObjectID contentType;
    private CMSContentInfo contentInfo;
    private boolean writeEncapsulatedContent = true;
    private ASN1Sequence contents = null;

    public EncapsulatedContentInfo(CMSContentInfo contentInfo) {
        this(contentInfo, true);
    }

    public EncapsulatedContentInfo(CMSContentInfo contentInfo, boolean writeEncapsulatedContent) {
        this.contentInfo = contentInfo;
        this.writeEncapsulatedContent = writeEncapsulatedContent;
        this.contentType = contentInfo.getContentType();
    }

    public EncapsulatedContentInfo(InputStream is) throws IOException {
        this.input(is);
    }

    protected EncapsulatedContentInfo(InputStream is, boolean decompress) throws IOException {
        this.input(is, decompress);
    }

    public ASN1ObjectID getCMSContentType() {
        return this.contentInfo.getContentType();
    }

    public CMSContentInfo getCMSContentInfo() {
        return this.contentInfo;
    }

    public int hashCode() {
        try {
            UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream();
            this.output((OutputStream)bos);
            return new String(bos.toByteArray()).hashCode();
        }
        catch (IOException ex) {
            throw new StreamableOutputException(ex.toString());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EncapsulatedContentInfo)) {
            return false;
        }
        EncapsulatedContentInfo o = (EncapsulatedContentInfo)obj;
        if (!this.contentType.equals((Object)o.getCMSContentType())) {
            return false;
        }
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)this.contentInfo), (byte[])Utils.toBytes((Streamable)o.getCMSContentInfo()));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("content-type '");
        sb.append(CMSContentInfo.contentTypeName(this.contentInfo.getContentType()));
        sb.append("' (");
        if (this.contentInfo.isDegenerate()) {
            sb.append("detached");
        } else {
            sb.append(Utils.plural((int)this.contentInfo.length(), (String)"byte"));
        }
        sb.append(")");
        return sb.toString();
    }

    public void input(InputStream is) throws IOException {
        this.input(is, false);
    }

    public void input(InputStream is, boolean decompress) throws IOException {
        ASN1SequenceInputStream ci = new ASN1SequenceInputStream(is);
        this.contentType = new ASN1ObjectID((InputStream)ci);
        if (ci.hasMoreData()) {
            byte[] sigbuf;
            byte[] octbuf;
            ASN1ConstructedInputStream cic = new ASN1ConstructedInputStream((InputStream)ci, 0);
            if (decompress) {
                int ch;
                byte[] compressbuf = ASN1OctetString.inputValue((InputStream)cic);
                InflaterInputStream inflater = new InflaterInputStream((InputStream)new UnsyncByteArrayInputStream(compressbuf));
                UnsyncByteArrayOutputStream bbb = new UnsyncByteArrayOutputStream();
                byte[] b = new byte[64];
                while ((ch = inflater.read(b)) != -1) {
                    bbb.write(b, 0, ch);
                }
                byte[] decompbuf = bbb.toByteArray();
                Object decompObj = this.contentType.equals((Object)CMS.id_data) ? new ASN1OctetString(decompbuf) : ASN1Utils.inputASN1Object((byte[])decompbuf);
                ASN1GenericConstructed agc = new ASN1GenericConstructed(decompObj, 0);
                bbb = new UnsyncByteArrayOutputStream();
                agc.output((OutputStream)bbb);
                UnsyncByteArrayInputStream iii = new UnsyncByteArrayInputStream(bbb.toByteArray());
                cic = new ASN1ConstructedInputStream((InputStream)iii, 0);
            }
            if (cic.getCurrentTag() == 4) {
                sigbuf = octbuf = ASN1OctetString.inputValue((InputStream)cic);
            } else if (cic.getCurrentTag() == 16) {
                ASN1Sequence essData = new ASN1Sequence((InputStream)cic);
                octbuf = Utils.toBytes((Streamable)essData);
                ASN1Header hdr = essData.getHeader();
                int hdrLen = hdr.length();
                sigbuf = new byte[octbuf.length - hdrLen];
                System.arraycopy(octbuf, hdrLen, sigbuf, 0, sigbuf.length);
            } else {
                throw new IOException("Unexpected tag in EncapsulatedContentInfo::eContent: " + cic.getCurrentTag());
            }
            if (this.contentType.equals((Object)CMS.id_data)) {
                this.contentInfo = new CMSDataContentInfo(octbuf);
            } else {
                this.contentInfo = CMSContentInfo.makeDegenerate(this.contentType);
                if (this.contentInfo == null) {
                    throw new IllegalStateException("Unknown content type.");
                }
                try {
                    this.contentInfo.inputContent((InputStream)new UnsyncByteArrayInputStream(octbuf));
                    this.contentInfo.setExposedContent(sigbuf);
                }
                catch (IOException ex) {
                    if (ex instanceof InvalidInputException) {
                        throw (InvalidInputException)ex;
                    }
                    throw new StreamableInputException(ex.toString());
                }
            }
            cic.terminate();
        } else {
            this.contentInfo = CMSContentInfo.makeDegenerate(this.contentType);
        }
        ci.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private void update() {
        this.contents = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            byte[] buf;
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)this.contentType);
            if (this.contentInfo != null && this.writeEncapsulatedContent && (buf = this.contentInfo.getExposedContent()) != null) {
                ASN1OctetString oct = new ASN1OctetString(buf);
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)oct, 0));
            }
            this.contents = s;
        }
        return this.contents;
    }
}

