/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import oracle.security.crypto.cert.IssuerAndSerialNo;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cms.CMSRecipientInfoSpec;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class CMSKeyTransRecipientInfoSpec
implements CMSRecipientInfoSpec {
    private IssuerAndSerialNo iasn;
    private AlgorithmIdentifier keyEncryptionAlgID;
    private PublicKey recipientKey;
    private byte[] SPKI = null;
    private boolean useSPKI64 = false;

    public CMSKeyTransRecipientInfoSpec(X509Certificate cert) throws IOException, CertificateEncodingException, NoSuchAlgorithmException {
        this(cert, CMSUtils.getAlgoID(cert.getPublicKey().getAlgorithm()));
    }

    public CMSKeyTransRecipientInfoSpec(X509Certificate cert, AlgorithmIdentifier keyEncryptionAlgID) throws IOException, CertificateEncodingException {
        this(new IssuerAndSerialNo(new X509(cert.getEncoded())), keyEncryptionAlgID, cert.getPublicKey());
    }

    private CMSKeyTransRecipientInfoSpec(IssuerAndSerialNo iasn, AlgorithmIdentifier keyEncryptionAlgID, PublicKey recipientKey) {
        this.iasn = iasn;
        this.keyEncryptionAlgID = keyEncryptionAlgID;
        this.recipientKey = recipientKey;
    }

    public CMSKeyTransRecipientInfoSpec(X509Certificate cert, boolean useSPKI64) throws NoSuchAlgorithmException {
        this(cert, CMSUtils.getAlgoID(cert.getPublicKey().getAlgorithm()), useSPKI64);
    }

    public CMSKeyTransRecipientInfoSpec(X509Certificate cert, AlgorithmIdentifier keyEncryptionAlgID, boolean useSPKI64) throws NoSuchAlgorithmException {
        this.keyEncryptionAlgID = keyEncryptionAlgID;
        this.recipientKey = cert.getPublicKey();
        this.useSPKI64 = useSPKI64;
        this.SPKI = useSPKI64 ? CMSUtils.generateSPKI64(cert) : CMSUtils.generateSPKI160(cert);
    }

    public CMSKeyTransRecipientInfoSpec(X509Certificate cert, byte[] spki, AlgorithmIdentifier keyEncryptionAlgID, PublicKey recipientKey) {
        this.SPKI = spki;
        this.keyEncryptionAlgID = keyEncryptionAlgID;
        if (spki.length == 8) {
            this.useSPKI64 = true;
        }
    }

    public int hashCode() {
        StringBuffer sb = new StringBuffer();
        sb.append(new String(Utils.toBytes((Streamable)this.iasn)));
        sb.append(new String(Utils.toBytes((Streamable)this.keyEncryptionAlgID)));
        sb.append(new String(this.recipientKey.getEncoded()));
        sb.append(new String(this.SPKI));
        sb.append(this.useSPKI64);
        return sb.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CMSKeyTransRecipientInfoSpec)) {
            return false;
        }
        CMSKeyTransRecipientInfoSpec o = (CMSKeyTransRecipientInfoSpec)obj;
        if (!(this.iasn.getIssuer().equals((Object)o.getIssuer()) && this.iasn.getSerialNo().equals(o.getSerialNo()) && this.keyEncryptionAlgID.equals((Object)o.getKeyEncryptionAlgID()) && this.recipientKey.equals(o.getRecipientKey()) && Utils.areEqual((byte[])this.SPKI, (byte[])o.getSPKI()) && this.useSPKI64 == o.useSPKI64())) {
            return false;
        }
        return this.hashCode() == o.hashCode();
    }

    public IssuerAndSerialNo getIASN() {
        return this.iasn;
    }

    public X500Name getIssuer() {
        return this.iasn.getIssuer();
    }

    public BigInteger getSerialNo() {
        return this.iasn.getSerialNo();
    }

    public AlgorithmIdentifier getKeyEncryptionAlgID() {
        return this.keyEncryptionAlgID;
    }

    public PublicKey getRecipientKey() {
        return this.recipientKey;
    }

    public byte[] getSPKI() {
        return this.SPKI;
    }

    public boolean useSPKI64() {
        return this.useSPKI64;
    }
}

