/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cms.CMSEnvelopedDataInputStream;
import oracle.security.crypto.cms.CMSInputConnector;

public class CMSEnvelopedDataInputConnector
implements CMSInputConnector {
    private CMSEnvelopedDataInputStream edIn;

    public CMSEnvelopedDataInputConnector(InputStream in, PrivateKey recipientPrivateKey, X509Certificate recipientCert) throws IOException, CertificateEncodingException, NoSuchAlgorithmException {
        this.edIn = new CMSEnvelopedDataInputStream(in, recipientPrivateKey, recipientCert);
    }

    public CMSEnvelopedDataInputConnector(CMSInputConnector conn, PrivateKey recipientPrivateKey, X509Certificate recipientCert) throws IOException {
        try {
            this.edIn = new CMSEnvelopedDataInputStream(conn, recipientPrivateKey, recipientCert);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException(ex.toString());
        }
        catch (CertificateEncodingException ex) {
            throw new IOException(ex.toString());
        }
    }

    @Override
    public ASN1ObjectID getEnclosedContentType() throws IOException {
        return this.edIn.getEnclosedContentType();
    }

    @Override
    public InputStream getInputStream() {
        return this.edIn;
    }
}

