/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.cms.EncryptedContentInfo;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.FixedByteArrayOutputStream;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class CMSEncryptedDataContentInfo
extends CMSContentInfo {
    private ASN1Integer version;
    private EncryptedContentInfo eci;
    private AttributeSet unprotectedAttributes;
    private boolean writeDetached = false;
    private byte[] exposedContent = null;

    public CMSEncryptedDataContentInfo() {
        super(CMS.id_encryptedData);
    }

    public CMSEncryptedDataContentInfo(CMSContentInfo contentInfo, SecretKey contentEncryptionKey, AlgorithmIdentifier contentEncryptionAlgID) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        this(contentInfo, contentEncryptionKey, contentEncryptionAlgID, null);
    }

    public CMSEncryptedDataContentInfo(CMSContentInfo contentInfo, SecretKey contentEncryptionKey, AlgorithmIdentifier contentEncryptionAlgID, AttributeSet unprotectedAttributes) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        super(CMS.id_encryptedData);
        if (contentInfo == null) {
            throw new IllegalArgumentException("Null Content Info");
        }
        String algoName = CMSUtils.addPadding(CMSUtils.getAlgoName(contentEncryptionAlgID));
        Cipher cipher = null;
        cipher = contentEncryptionAlgID.equals((Object)CMS.aes128_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes192_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? Cipher.getInstance("AES/CBC/PKCS5Padding") : Cipher.getInstance(algoName);
        try {
            if (algoName.indexOf("CBC") != -1) {
                byte[] ivBytes = null;
                ivBytes = contentEncryptionAlgID.equals((Object)CMS.aes128_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes192_cbc) || contentEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? CMSUtils.generateRandomBytes(16) : CMSUtils.generateRandomBytes(8);
                IvParameterSpec ivParams = new IvParameterSpec(ivBytes);
                cipher.init(1, (Key)contentEncryptionKey, ivParams);
            } else {
                cipher.init(1, contentEncryptionKey);
            }
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new InvalidKeyException(ex.toString());
        }
        this.eci = new EncryptedContentInfo(contentInfo, cipher, contentEncryptionAlgID, true);
        this.unprotectedAttributes = unprotectedAttributes;
        this.version = unprotectedAttributes == null ? new ASN1Integer(0L) : new ASN1Integer(2L);
    }

    public CMSEncryptedDataContentInfo(InputStream is) throws IOException {
        super(CMS.id_encryptedData);
        this.input(is);
    }

    public void writeDetached(boolean writeDetachedObject) {
        this.writeDetached = writeDetachedObject;
        this.eci.writeDetached(writeDetachedObject);
        this.update();
    }

    @Override
    public boolean isDetached() {
        return this.eci.getEncryptedContent() == null;
    }

    @Override
    protected void setExposedContent(byte[] expContent) {
        this.exposedContent = expContent;
    }

    @Override
    protected byte[] getExposedContent() {
        if (this.exposedContent == null) {
            if (this.eci == null) {
                return null;
            }
            try {
                UnsyncByteArrayOutputStream edStore = new UnsyncByteArrayOutputStream();
                this.version = this.unprotectedAttributes == null ? new ASN1Integer(0L) : new ASN1Integer(2L);
                this.version.output((OutputStream)edStore);
                this.eci.output((OutputStream)edStore);
                if (this.unprotectedAttributes != null) {
                    ((ASN1GenericConstructed)ASN1Utils.addImplicitTag((ASN1Object)this.unprotectedAttributes, (int)1)).output((OutputStream)edStore);
                }
                byte[] buf = edStore.toByteArray();
                byte[] hdrbuf = Utils.toBytes((Streamable)ASN1Sequence.makeHeader((int)buf.length));
                FixedByteArrayOutputStream bos = new FixedByteArrayOutputStream(hdrbuf.length + buf.length);
                bos.write(hdrbuf, 0, hdrbuf.length);
                bos.write(buf, 0, buf.length);
                this.exposedContent = bos.toByteArray();
            }
            catch (IOException ex) {
                throw new StreamableOutputException(ex.toString());
            }
            catch (NullPointerException ex) {
                throw new StreamableOutputException("CMS Object is not initialized: " + ex.toString());
            }
        }
        return this.exposedContent;
    }

    public ASN1ObjectID getEnclosedContentType() {
        return this.eci.getContentType();
    }

    public AlgorithmIdentifier getContentEncryptionAlgID() {
        return this.eci.getContentEncryptionAlgID();
    }

    public byte[] getEncryptedContent() {
        return this.eci.getEncryptedContent();
    }

    public BigInteger getVersionNumber() {
        return this.version.getValue();
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public AttributeSet getUnprotectedAttributes() {
        return this.unprotectedAttributes;
    }

    public void setUnprotectedAttributes(AttributeSet unprotectedAttributes) {
        this.unprotectedAttributes = unprotectedAttributes;
        this.update();
    }

    public String toString() {
        String st = this.isDetached() ? "Detached " : "";
        StringBuffer sb = new StringBuffer(st + "CMS 'encrypted-data' object\n");
        sb.append("Version: " + this.getVersion().intValue() + "\n");
        sb.append(this.eci);
        sb.append("Unprotected Attributes: " + (this.unprotectedAttributes == null ? "Missing\n" : "Present\n"));
        return sb.toString();
    }

    public int hashCode() {
        try {
            UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream();
            this.output((OutputStream)bos);
            return new String(bos.toByteArray()).hashCode();
        }
        catch (IOException ex) {
            throw new StreamableOutputException(ex.toString());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CMSEncryptedDataContentInfo)) {
            return false;
        }
        return this.hashCode() == ((CMSEncryptedDataContentInfo)obj).hashCode();
    }

    public void setEnclosed(byte[] encryptedContent) {
        this.eci.setEncryptedContent(encryptedContent);
        this.update();
    }

    public CMSContentInfo getEnclosed(SecretKey decryptionKey) throws NoSuchAlgorithmException, InvalidKeyException, InvalidInputException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException {
        return this.eci.getDecryptedContentInfo(decryptionKey);
    }

    @Override
    protected void inputContent(InputStream is) throws IOException {
        ASN1SequenceInputStream ed = new ASN1SequenceInputStream(is);
        this.version = new ASN1Integer((InputStream)ed);
        if (!this.version.equals(0) && !this.version.equals(2)) {
            throw new VersionException("Expected Version 0 or 2 But Got " + this.version.getValue());
        }
        this.eci = new EncryptedContentInfo((InputStream)ed);
        if (this.version.equals(2)) {
            if (!ed.hasMoreData()) {
                throw new InvalidInputException("Version 2 - Expected Unprotected Attributes");
            }
            if (ed.getCurrentTag() == 1) {
                ed.setCurrentTag(17);
                this.unprotectedAttributes = new AttributeSet((InputStream)ed);
            } else {
                throw new InvalidInputException("Expected Unprotected Attributes IMPLICIT TAG [1]");
            }
        }
        ed.terminate();
        if (this.eci.getContentType().equals((Object)CMS.id_data) && this.eci.getEncryptedContent() == null) {
            this.writeDetached = true;
        }
    }

    @Override
    protected void update() {
        super.update();
        this.exposedContent = null;
    }
}

