/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cms.CIOutputStream;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSOutputConnector;
import oracle.security.crypto.cms.CMSOutputStream;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;

public class CMSCompressedDataOutputStream
extends CMSOutputStream {
    private DeflaterOutputStream deflater;
    private AlgorithmIdentifier compressionAlgID;
    private boolean writingToConnector;
    private boolean terminated = false;
    private boolean writeEContentInfo;
    private ASN1ObjectID contentType;
    private CIOutputStream content_out;
    private boolean prefaceOutput = false;

    public CMSCompressedDataOutputStream(OutputStream out, AlgorithmIdentifier compressionAlgID, ASN1ObjectID contentType) throws AlgorithmIdentifierException {
        super(out);
        if (!compressionAlgID.equals((Object)CMS.id_alg_zlibCompress)) {
            throw new AlgorithmIdentifierException("Unsupported Compression Algorithm: " + compressionAlgID);
        }
        this.compressionAlgID = compressionAlgID;
        this.contentType = contentType;
        this.writeEContentInfo = true;
        this.writingToConnector = false;
    }

    public CMSCompressedDataOutputStream(CMSOutputConnector conn, AlgorithmIdentifier digestAlgID, ASN1ObjectID contentType) throws AlgorithmIdentifierException {
        super(conn.getOutputStream());
        if (!this.compressionAlgID.equals((Object)CMS.id_alg_zlibCompress)) {
            throw new AlgorithmIdentifierException("Unsupported Compression Algorithm: " + this.compressionAlgID);
        }
        this.compressionAlgID = this.compressionAlgID;
        this.contentType = contentType;
        this.writeEContentInfo = true;
        this.writingToConnector = true;
    }

    private void ensurePrefaceOutput() throws IOException {
        if (!this.prefaceOutput) {
            if (!this.writingToConnector) {
                ASN1Utils.outputHeader((OutputStream)this.out, (int)16, (int)0);
                CMS.id_ct_compressedData.output(this.out);
                ASN1Utils.outputHeader((OutputStream)this.out, (int)0, (int)128);
            }
            ASN1Utils.outputHeader((OutputStream)this.out, (int)16, (int)0);
            ASN1Integer.outputValue((OutputStream)this.out, (int)0);
            this.compressionAlgID.output(this.out);
            this.content_out = new CIOutputStream(this.out, this.contentType, false);
            this.content_out.writeInitial();
            this.deflater = new DeflaterOutputStream(this.content_out);
            this.prefaceOutput = true;
        }
    }

    @Override
    public void terminate() throws IOException {
        this.ensurePrefaceOutput();
        this.deflater.finish();
        this.content_out.writeFinal();
        ASN1Utils.outputEndOfContents((OutputStream)this.out);
        if (!this.writingToConnector) {
            ASN1Utils.outputEndOfContents((OutputStream)this.out);
            ASN1Utils.outputEndOfContents((OutputStream)this.out);
        } else {
            ((CMSOutputStream)this.out).terminate();
        }
        this.terminated = true;
    }

    @Override
    public void write(int ch) throws IOException {
        this.ensurePrefaceOutput();
        this.deflater.write(ch);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensurePrefaceOutput();
        this.deflater.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (!this.terminated) {
            this.terminate();
        }
        super.close();
    }

    @Override
    public ASN1ObjectID getExposedContentType() {
        return CMS.id_ct_compressedData;
    }
}

