/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSCompressedDataOutputStream;
import oracle.security.crypto.cms.CMSOutputConnector;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;

public class CMSCompressedDataOutputConnector
implements CMSOutputConnector {
    private CMSCompressedDataOutputStream digOut;

    public CMSCompressedDataOutputConnector(OutputStream out, AlgorithmIdentifier compressionAlgID, ASN1ObjectID contentType) throws AlgorithmIdentifierException {
        this.digOut = new CMSCompressedDataOutputStream(out, compressionAlgID, contentType);
    }

    public CMSCompressedDataOutputConnector(CMSOutputConnector conn, AlgorithmIdentifier compressionAlgID, ASN1ObjectID contentType) throws AlgorithmIdentifierException {
        this.digOut = new CMSCompressedDataOutputStream(conn, compressionAlgID, contentType);
    }

    @Override
    public ASN1ObjectID getExposedContentType() {
        return CMS.id_ct_compressedData;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.digOut;
    }
}

