/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.zip.InflaterInputStream;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cms.CIInputStream;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSInputConnector;
import oracle.security.crypto.cms.CMSInputStream;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.VersionException;

public class CMSCompressedDataInputStream
extends CMSInputStream {
    private ASN1Integer version;
    private AlgorithmIdentifier compressionAlgID;
    private InflaterInputStream inflater;
    private boolean readingFromConnector;
    private ASN1ObjectID encapContentType;
    private boolean readInitial = false;
    private boolean terminated = false;
    private ASN1ConstructedInputStream ci_in;
    private ASN1ConstructedInputStream cic_in;
    private ASN1ConstructedInputStream dd_in;
    private CIInputStream content_in;

    public CMSCompressedDataInputStream(InputStream in) {
        super(in);
        this.readingFromConnector = false;
    }

    public CMSCompressedDataInputStream(CMSInputConnector conn) {
        super(conn.getInputStream());
        this.readingFromConnector = true;
    }

    private void ensureReadInitial() throws IOException {
        if (!this.readInitial) {
            if (!this.readingFromConnector) {
                this.ci_in = new ASN1SequenceInputStream(this.in);
                if (!CMS.id_ct_compressedData.equals((Object)new ASN1ObjectID((InputStream)this.ci_in))) {
                    throw new InvalidInputException("Content-type 'id-compressedData' expected.");
                }
                this.cic_in = new ASN1ConstructedInputStream((InputStream)this.ci_in, 0);
                this.dd_in = new ASN1SequenceInputStream((InputStream)this.cic_in);
            } else {
                this.dd_in = new ASN1SequenceInputStream(this.in);
            }
            this.version = new ASN1Integer((InputStream)this.dd_in);
            if (!this.version.equals(0)) {
                throw new VersionException("Expected Version 0 but got Version " + this.version.getValue());
            }
            this.compressionAlgID = new AlgorithmIdentifier((InputStream)this.dd_in);
            this.content_in = new CIInputStream((InputStream)this.dd_in);
            this.encapContentType = this.content_in.getContentType();
            this.inflater = new InflaterInputStream(this.content_in);
            this.readInitial = true;
        }
    }

    @Override
    public void terminate() throws IOException {
        if (!this.terminated) {
            this.content_in.ensureTerminated();
            this.dd_in.terminate();
            if (!this.readingFromConnector) {
                this.cic_in.terminate();
                this.ci_in.terminate();
            }
            this.terminated = true;
        }
    }

    public BigInteger getVersionNumber() throws IOException {
        this.ensureReadInitial();
        return this.version.getValue();
    }

    public ASN1Integer getVersion() throws IOException {
        this.ensureReadInitial();
        return this.version;
    }

    public AlgorithmIdentifier getCompressionAlgID() throws IOException {
        this.ensureReadInitial();
        return this.compressionAlgID;
    }

    @Override
    public ASN1ObjectID getEnclosedContentType() throws IOException {
        this.ensureReadInitial();
        return this.encapContentType;
    }

    @Override
    public int read() throws IOException {
        this.ensureReadInitial();
        int ch = this.inflater.read();
        if (ch == -1) {
            this.terminate();
        }
        return ch;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        this.ensureReadInitial();
        int efflen = this.inflater.read(buffer, offset, len);
        if (efflen == -1) {
            this.terminate();
        }
        return efflen;
    }

    @Override
    public int available() throws IOException {
        this.ensureReadInitial();
        return this.inflater.available();
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureReadInitial();
        return this.inflater.skip(n);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

