/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Utils;

class CIOutputStream
extends FilterOutputStream {
    private int BUF_SIZE = 512;
    private byte[] buf = new byte[this.BUF_SIZE];
    private int count = 0;
    private boolean createExternalSignatures;
    private ASN1ObjectID contentType;
    private boolean wroteContentHeader = false;

    CIOutputStream(OutputStream out, ASN1ObjectID contentType, boolean createExternalSignatures) {
        super(out);
        this.contentType = contentType;
        this.createExternalSignatures = createExternalSignatures;
    }

    void writeInitial() throws IOException {
        this.writeInitial(true);
    }

    void writeInitial(boolean hasContent) throws IOException {
        ASN1Utils.outputHeader((OutputStream)this.out, (int)16, (int)0);
        this.contentType.output(this.out);
        if (hasContent && !this.createExternalSignatures) {
            ASN1Utils.outputHeader((OutputStream)this.out, (int)0, (int)128);
            ASN1Utils.outputHeader((OutputStream)this.out, (int)4, (int)0);
            this.wroteContentHeader = true;
        }
    }

    private void processChunk(byte[] b, int off, int len) throws IOException {
        if (!this.createExternalSignatures) {
            ASN1OctetString.outputValue((OutputStream)this.out, (byte[])b, (int)off, (int)len);
        }
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.processChunk(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    void writeFinal() throws IOException {
        this.flushBuffer();
        if (this.wroteContentHeader) {
            ASN1Utils.outputEndOfContents((OutputStream)this.out);
            ASN1Utils.outputEndOfContents((OutputStream)this.out);
        }
        ASN1Utils.outputEndOfContents((OutputStream)this.out);
    }

    @Override
    public void write(int ch) throws IOException {
        this.buf[this.count++] = (byte)ch;
        if (this.count == this.BUF_SIZE) {
            this.flushBuffer();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len <= this.BUF_SIZE - this.count) {
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
            if (this.count == this.BUF_SIZE) {
                this.flushBuffer();
            }
        } else {
            this.flushBuffer();
            this.processChunk(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }
}

