/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cms.OSInputStream;

class CIInputStream
extends FilterInputStream {
    private ASN1ConstructedInputStream ci_in;
    private ASN1ConstructedInputStream cic_in;
    private InputStream body_in;
    private boolean terminated = false;
    private ASN1ObjectID eContentType;

    CIInputStream(InputStream in) throws IOException {
        super(in);
        this.ci_in = new ASN1SequenceInputStream(in);
        this.eContentType = new ASN1ObjectID((InputStream)this.ci_in);
        if (this.ci_in.hasMoreData()) {
            this.cic_in = new ASN1ConstructedInputStream((InputStream)this.ci_in, 0);
            this.body_in = new OSInputStream((InputStream)this.cic_in);
        } else {
            this.ci_in.terminate();
            this.terminated = true;
        }
    }

    ASN1ObjectID getContentType() {
        return this.eContentType;
    }

    void ensureTerminated() throws IOException {
        if (!this.terminated) {
            this.cic_in.terminate();
            this.ci_in.terminate();
        }
        this.terminated = true;
    }

    @Override
    public int read() throws IOException {
        if (this.terminated) {
            return -1;
        }
        int ch = this.body_in.read();
        if (ch == -1) {
            this.ensureTerminated();
        }
        return ch;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (this.terminated) {
            return -1;
        }
        int efflen = this.body_in.read(buffer, offset, len);
        if (efflen == -1) {
            this.ensureTerminated();
        }
        return efflen;
    }

    @Override
    public int available() throws IOException {
        if (this.terminated) {
            return 0;
        }
        return this.body_in.available();
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.terminated) {
            return 0L;
        }
        return this.body_in.skip(n);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

