/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.rlog;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.net.URLFileSystem;
import oracle.ide.vhv.VHVBranchResource;
import oracle.ide.vhv.VHVCheckoutResource;
import oracle.ide.vhv.VHVMergeResource;
import oracle.ide.vhv.VHVResource;
import oracle.ide.vhv.VHVResourceException;
import oracle.ide.vhv.VHVVersionTree;
import oracle.ide.vhv.VHVVersionableResource;
import oracle.ide.vhv.rlog.RlogModel;

public class RlogVersionTree
extends VHVVersionTree {
    private RlogVersionTree(VHVVersionableResource[] versionResources, VHVCheckoutResource checkoutResource) throws VHVResourceException {
        super(versionResources, null, checkoutResource);
    }

    private RlogVersionTree(VHVVersionableResource[] versionResources, VHVMergeResource[] mergeResources, VHVCheckoutResource checkoutResource) throws VHVResourceException {
        super(versionResources, mergeResources, checkoutResource);
    }

    public static final RlogVersionTree createVersionTree(URL url, String workareaName, RlogModel rlogModel, String viewRevision, VHVCheckoutResource checkoutResource) throws VHVResourceException {
        VHVResource parentResource;
        String parentRevision;
        HashMap<String, VHVVersionableResource> versionableResourceCache = new HashMap<String, VHVVersionableResource>();
        for (RlogModel.Entry rlogEntry : rlogModel.getEntries()) {
            VHVVersionableResource versionableResource = new VHVVersionableResource();
            String revision = rlogEntry.getRevision().toString();
            versionableResource.setPath(rlogModel.getRCSFile() + "@@" + revision);
            versionableResource.setName(URLFileSystem.getFileName((URL)url));
            versionableResource.setNotes(rlogEntry.getMessage());
            versionableResource.setDate(rlogEntry.getDate());
            versionableResource.setUser(rlogEntry.getAuthor());
            versionableResource.setVersionLabel(revision);
            versionableResource.setVersionNumber((Comparable)rlogEntry.getRevision());
            versionableResource.setFirstVersionOnBranch(revision.endsWith(".1"));
            versionableResource.setWorkareaName(workareaName);
            if (viewRevision != null && revision.equals(viewRevision)) {
                versionableResource.setViewVersion(true);
            }
            versionableResourceCache.put(revision, versionableResource);
        }
        HashMap<String, VHVBranchResource> branchResourceCache = new HashMap<String, VHVBranchResource>();
        for (Map.Entry entry : versionableResourceCache.entrySet()) {
            parentRevision = RlogVersionTree.getParentRevisionNumber(entry.getKey().toString());
            assert (parentRevision != null);
            parentResource = (VHVBranchResource)branchResourceCache.get(parentRevision);
            if (parentResource == null) {
                parentResource = new VHVBranchResource();
                parentResource.setName(parentRevision);
                branchResourceCache.put(parentRevision, (VHVBranchResource)parentResource);
            }
            ((VHVVersionableResource)entry.getValue()).setBranch((VHVBranchResource)parentResource);
        }
        for (Map.Entry entry : branchResourceCache.entrySet()) {
            parentRevision = RlogVersionTree.getParentRevisionNumber(((String)entry.getKey()).toString());
            if (parentRevision == null) continue;
            parentResource = (VHVResource)versionableResourceCache.get(parentRevision);
            assert (parentResource != null);
            ((VHVBranchResource)entry.getValue()).setSource(parentResource);
        }
        RlogVersionTree versionTree = new RlogVersionTree(versionableResourceCache.values().toArray(new VHVVersionableResource[0]), checkoutResource);
        for (VHVVersionableResource versionableResource : versionableResourceCache.values()) {
            versionableResource.setVersionTree(versionTree);
        }
        return versionTree;
    }

    private static final String getParentRevisionNumber(String revision) {
        int i = revision.lastIndexOf(46);
        return i >= 0 ? revision.substring(0, i) : null;
    }
}

