/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv.model;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;
import oracle.ide.vhv.VHVResourceException;
import oracle.ide.vhv.model.Branch;
import oracle.ide.vhv.model.BranchConnectionDetails;
import oracle.ide.vhv.model.BranchElement;
import oracle.ide.vhv.model.BranchList;
import oracle.ide.vhv.model.CheckOutConnectionDetails;
import oracle.ide.vhv.model.CheckOutElement;
import oracle.ide.vhv.model.CheckOutList;
import oracle.ide.vhv.model.ConnectionDetails;
import oracle.ide.vhv.model.Frontier;
import oracle.ide.vhv.model.FrontierComponent;
import oracle.ide.vhv.model.GraphElement;
import oracle.ide.vhv.model.MergeConnectionDetails;
import oracle.ide.vhv.model.MergeElement;
import oracle.ide.vhv.model.MergeList;
import oracle.ide.vhv.model.SuccessorConnectionDetails;
import oracle.ide.vhv.model.SuccessorElement;
import oracle.ide.vhv.model.VersionTree;

public class VersionTreeLayoutManager
implements ConnectionDetails {
    public static final int MIN_VERT_SPACING = 32;
    public static final int MIN_HORZ_SPACING = 32;
    public static final int SUCCESSOR_SIZE = 24;
    public static final int BRANCH_OFFSET_X = 48;
    public static final int BRANCH_OFFSET_Y = 24;
    public static final int HORZ_TEXT_MARGIN = 16;
    public static final int VERT_TEXT_MARGIN = 4;
    public static final String DEFAULT_BRANCH_NAME = "Unable to find branch name";
    private VersionTree m_versionTree = null;
    private Frontier m_frontier = new Frontier();
    private ArrayList m_mergesToLayout = null;
    private static Font FONT = new Font("SansSerif", 0, 12);
    private static FontMetrics FONT_METRICS;

    VersionTreeLayoutManager(VersionTree tree) {
        this.m_versionTree = tree;
    }

    public Point layout(boolean displayMainBranch) {
        this.invalidate();
        Point max = new Point(0, 0);
        if (displayMainBranch) {
            if (this.m_versionTree.getRootElement() != null) {
                max = this.layout(this.m_versionTree.getRootElement());
            }
        } else {
            max = this.layout(this.m_versionTree.getDisplayedRootElements());
        }
        this.layoutMerges();
        return max;
    }

    public void invalidate() {
        this.m_frontier = new Frontier();
    }

    private void addMergeElementForLayout(MergeElement me) {
        if (this.m_mergesToLayout == null) {
            this.m_mergesToLayout = new ArrayList();
        }
        this.m_mergesToLayout.add(me);
    }

    private void layoutMerges() {
        if (this.m_mergesToLayout != null) {
            Iterator i = this.m_mergesToLayout.iterator();
            while (i.hasNext()) {
                this.layout((MergeElement)i.next());
            }
            this.m_mergesToLayout = null;
        }
    }

    public Point layout(GraphElement ge) {
        if (ge instanceof SuccessorElement) {
            return this.layout((SuccessorElement)ge);
        }
        if (ge instanceof BranchElement) {
            return this.layout((BranchElement)ge);
        }
        if (ge instanceof MergeElement) {
            return this.layout((MergeElement)ge);
        }
        if (ge instanceof CheckOutElement) {
            return this.layout((CheckOutElement)ge);
        }
        return new Point(0, 0);
    }

    Point layout(SuccessorElement se) {
        Point bottomRight = new Point(0, 0);
        if (se.isDisplayed()) {
            MergeList merges;
            CheckOutList col;
            CheckOutElement co2;
            SuccessorConnectionDetails scd = this.getSuccessorConnectionDetails(se.getDisplayedParentElement());
            se.setConnectionSide(scd.getConnectionSide());
            Point location = new Point(se.getConnectionPoint().x, se.getConnectionPoint().y + scd.getExtent());
            se.setLocation(location);
            se.setWidth(24);
            se.setHeight(24);
            bottomRight = new Point(location.x + 12, location.y + 12);
            BranchElement be = null;
            BranchList branches = se.getBranches();
            int totalBranchWidth = 0;
            if (branches != null) {
                BranchConnectionDetails bcd = this.getBranchConnectionDetails(((Branch)branches.get(0)).getBranchElement());
                totalBranchWidth = this.getPredictedTreeWidth(branches);
                Point topRight = new Point(bcd.getLocationPoint().x + totalBranchWidth, bcd.getLocationPoint().y);
                location.y += this.positionBelow((Point)bcd.getLocationPoint(), (Point)topRight).y - bcd.getLocationPoint().y;
                se.setLocation(location);
                Point branchBottomRight = null;
                boolean isFirstBranchOffMain = ((BranchElement)se.getOwnerElement()).isRoot();
                Iterator i = se.getBranches().iterator();
                while (i.hasNext()) {
                    be = ((Branch)i.next()).getBranchElement();
                    branchBottomRight = this.layout(be);
                    bottomRight.x = Math.max(bottomRight.x, branchBottomRight.x);
                    bottomRight.y = Math.max(bottomRight.y, branchBottomRight.y);
                    this.m_frontier.addFrontierComponent(new FrontierComponent(isFirstBranchOffMain ? -2 : be.getLocation().x - 32, branchBottomRight.x, branchBottomRight.y));
                    isFirstBranchOffMain = false;
                }
            }
            CheckOutElement pco = co2 = se.getReservedCheckOut();
            if (co2 != null) {
                Point checkOutBottomRight = this.layout(co2, null);
                bottomRight.x = Math.max(bottomRight.x, checkOutBottomRight.x);
                bottomRight.y = Math.max(bottomRight.y, checkOutBottomRight.y);
            }
            if ((col = se.getUnreservedCheckOuts()) != null) {
                for (CheckOutElement co2 : col) {
                    Point checkOutBottomRight = this.layout(co2, pco);
                    bottomRight.x = Math.max(bottomRight.x, checkOutBottomRight.x);
                    bottomRight.y = Math.max(bottomRight.y, checkOutBottomRight.y);
                    pco = co2;
                }
            }
            if ((merges = se.getSourceMerges()) != null) {
                Iterator itr = merges.iterator();
                while (itr.hasNext()) {
                    this.addMergeElementForLayout((MergeElement)itr.next());
                }
            }
        }
        Point childBottomRight = this.layout(se.getDisplayedChildElement());
        return new Point(Math.max(bottomRight.x, childBottomRight.x), Math.max(bottomRight.y, childBottomRight.y));
    }

    Point layout(BranchList branches) {
        Point bottomRight = new Point(0, 0);
        Point branchBottomRight = null;
        boolean isFirstBranchOffMain = true;
        Iterator i = branches.iterator();
        while (i.hasNext()) {
            BranchElement be = ((Branch)i.next()).getBranchElement();
            Point location = new Point(48, 24);
            if (!isFirstBranchOffMain) {
                location.x = bottomRight.x + 32;
            }
            branchBottomRight = this.layout(be, location);
            bottomRight.x = Math.max(bottomRight.x, branchBottomRight.x);
            bottomRight.y = Math.max(bottomRight.y, branchBottomRight.y);
            this.m_frontier.addFrontierComponent(new FrontierComponent(isFirstBranchOffMain ? -2 : be.getLocation().x - 32, branchBottomRight.x, branchBottomRight.y));
            isFirstBranchOffMain = false;
        }
        return bottomRight;
    }

    Point layout(BranchElement be) {
        String branchName;
        if (!be.isDisplayed()) {
            return new Point(0, 0);
        }
        if (be.isRoot()) {
            be.setLocation(new Point(48, 24));
        } else {
            BranchConnectionDetails bcd = this.getBranchConnectionDetails(be);
            be.setLocation(this.positionRight(bcd.getLocationPoint()));
            be.setConnectionSide(bcd.getConnectionSide());
        }
        try {
            branchName = be.getResource().getName();
        }
        catch (VHVResourceException e) {
            branchName = DEFAULT_BRANCH_NAME;
        }
        be.setWidth(VersionTreeLayoutManager.getStringWidth(branchName) + 32);
        be.setHeight(VersionTreeLayoutManager.getStringHeight() + 8);
        Point bottomRight = this.layout(be.getDisplayedChildElement());
        bottomRight.x = Math.max(bottomRight.x, be.getLocation().x + be.getWidth());
        return bottomRight;
    }

    Point layout(BranchElement be, Point location) {
        String branchName;
        if (!be.isDisplayed()) {
            return new Point(0, 0);
        }
        be.setLocation(location);
        try {
            branchName = be.getResource().getName();
        }
        catch (VHVResourceException e) {
            branchName = DEFAULT_BRANCH_NAME;
        }
        be.setWidth(VersionTreeLayoutManager.getStringWidth(branchName) + 32);
        be.setHeight(VersionTreeLayoutManager.getStringHeight() + 8);
        Point bottomRight = this.layout(be.getDisplayedChildElement());
        bottomRight.x = Math.max(bottomRight.x, be.getLocation().x + be.getWidth());
        return bottomRight;
    }

    Point layout(MergeElement me) {
        MergeConnectionDetails mcd = this.getMergeConnectionDetails(me);
        me.setConnectionSide(mcd.getConnectionSide());
        me.setChildConnectionSide(mcd.getChildConnectionSide());
        return new Point(0, 0);
    }

    Point layout(CheckOutElement coe, GraphElement parent) {
        Point bottomRight = new Point(0, 0);
        if (coe.isDisplayed()) {
            CheckOutConnectionDetails cocd = this.getCheckOutConnectionDetails(coe, parent);
            coe.setConnectionSide(cocd.getConnectionSide());
            Point location = cocd.getLocationPoint();
            coe.setLocation(location);
            coe.setWidth(24);
            coe.setHeight(24);
            bottomRight = new Point(location.x + 12, location.y + 12);
        }
        return bottomRight;
    }

    private BranchConnectionDetails getBranchConnectionDetails(BranchElement be) {
        SuccessorElement se = (SuccessorElement)be.getDisplayedParentElement();
        Point connection = se.getRightConnectionPoint();
        Point location = new Point(connection.x + 48, connection.y + 24);
        return new BranchConnectionDetails(2, location);
    }

    private SuccessorConnectionDetails getSuccessorConnectionDetails(GraphElement ge) {
        int extent = 32;
        if (ge instanceof SuccessorElement) {
            SuccessorElement se = (SuccessorElement)ge;
            CheckOutElement co2 = se.getReservedCheckOut();
            CheckOutList col = se.getUnreservedCheckOuts();
            if (col != null) {
                for (CheckOutElement co2 : col) {
                }
            }
            if (co2 != null) {
                extent += co2.getLocation().y - se.getLocation().y;
            }
        }
        return new SuccessorConnectionDetails(3, extent);
    }

    private MergeConnectionDetails getMergeConnectionDetails(MergeElement me) {
        GraphElement parent = me.getDisplayedParentElement();
        GraphElement child = me.getDisplayedChildElement();
        Point parentLocation = parent.getLocation();
        Point childLocation = child.getLocation();
        int deltaX = Math.abs(childLocation.x - parentLocation.x);
        int deltaY = Math.abs(childLocation.y - parentLocation.y);
        if (deltaX == 0 || (double)Math.abs((float)deltaX / (float)deltaY) < 0.2) {
            if (childLocation.y > parentLocation.y) {
                return new MergeConnectionDetails(3, 1);
            }
            return new MergeConnectionDetails(1, 3);
        }
        if (deltaY == 0 || (double)Math.abs((float)deltaY / (float)deltaX) < 0.2) {
            if (childLocation.x > parentLocation.x) {
                return new MergeConnectionDetails(2, 4);
            }
            return new MergeConnectionDetails(4, 2);
        }
        if (childLocation.x > parentLocation.x) {
            if (childLocation.y > parentLocation.y) {
                return new MergeConnectionDetails(3, 4);
            }
            return new MergeConnectionDetails(1, 4);
        }
        if (childLocation.y > parentLocation.y) {
            return new MergeConnectionDetails(3, 2);
        }
        return new MergeConnectionDetails(1, 2);
    }

    private CheckOutConnectionDetails getCheckOutConnectionDetails(CheckOutElement coe, GraphElement parent) {
        if (parent == null) {
            parent = coe.getParentElement();
        }
        Point connection = parent.getBottomConnectionPoint();
        Point location = new Point(connection.x, connection.y + 32);
        return new CheckOutConnectionDetails(3, location);
    }

    public Point positionBelow(Point p) {
        return new Point(p.x, Math.max(this.m_frontier.getMaxY(p.x) + 32, p.y));
    }

    public Point positionBelow(Point p1, Point p2) {
        return new Point(p1.x, Math.max(this.m_frontier.getMaxY(p1.x, p2.x) + 32, p1.y));
    }

    public Point positionRight(Point p) {
        FrontierComponent current = this.m_frontier.getStart();
        while (current.getEndX() < p.x && current.getEndX() != -1) {
            current = current.getNext();
        }
        if (current.getY() < p.y + 32) {
            return p;
        }
        while (current != null && current.getY() + 32 > p.y) {
            current = current.getNext();
        }
        if (current != null) {
            return new Point(current.getStartX() + 32, p.y);
        }
        return p;
    }

    public static void setDisplayFont(Font f) {
        FONT = f;
        JPanel jp = new JPanel();
        FONT_METRICS = jp.getFontMetrics(FONT);
    }

    public static Font getDisplayFont() {
        return FONT;
    }

    public static int getStringWidth(String string) {
        return FONT_METRICS.stringWidth(string);
    }

    public static int getStringHeight() {
        return FONT_METRICS.getHeight();
    }

    private int getPredictedTreeWidth(BranchElement be) {
        String branchName;
        try {
            branchName = be.getResource().getName();
        }
        catch (VHVResourceException e) {
            branchName = DEFAULT_BRANCH_NAME;
        }
        int predictedWidth1 = VersionTreeLayoutManager.getStringWidth(branchName) + 32;
        int predictedWidth2 = predictedWidth1 / 2;
        int maxChildWidth = 0;
        for (SuccessorElement current = (SuccessorElement)be.getDisplayedChildElement(); current != null; current = (SuccessorElement)current.getDisplayedChildElement()) {
            maxChildWidth = Math.max(maxChildWidth, this.getPredictedTreeWidth(current));
        }
        return Math.max(predictedWidth1, predictedWidth2 += maxChildWidth);
    }

    private int getPredictedTreeWidth(BranchList bl) {
        int predictedWidth = 0;
        if (bl != null) {
            Branch b2 = null;
            for (Branch b2 : bl) {
                predictedWidth += this.getPredictedTreeWidth(b2.getBranchElement()) + 32;
            }
        }
        return predictedWidth;
    }

    private int getPredictedTreeWidth(SuccessorElement se) {
        int predictedWidth = 24;
        if (se.getBranches() != null) {
            predictedWidth += this.getPredictedTreeWidth(se.getBranches()) + 48;
        }
        return predictedWidth;
    }

    public void showMajorNodes() {
        this.showMajorNodes(this.m_versionTree.getRootElement().getChildElement());
    }

    private void showMajorNodes(GraphElement ge) {
        if (ge == null) {
            return;
        }
        if (ge instanceof SuccessorElement) {
            SuccessorElement se = (SuccessorElement)ge;
            if (se.isMajor()) {
                se.setDisplayed(true);
            } else {
                se.setDisplayed(false);
            }
            BranchList branches = se.getBranches();
            if (branches != null) {
                Iterator i = branches.iterator();
                while (i.hasNext()) {
                    this.showMajorNodes(((Branch)i.next()).getBranchElement().getChildElement());
                }
            }
        }
        this.showMajorNodes(ge.getChildElement());
    }

    public void showAllNodes() {
        if (this.m_versionTree.getRootElement() != null) {
            this.showAllNodes(this.m_versionTree.getRootElement().getChildElement());
        }
    }

    private void showAllNodes(GraphElement ge) {
        if (ge != null) {
            if (ge instanceof SuccessorElement) {
                SuccessorElement se = (SuccessorElement)ge;
                se.setDisplayed(true);
                BranchList branches = se.getBranches();
                if (branches != null) {
                    Iterator i = branches.iterator();
                    while (i.hasNext()) {
                        this.showAllNodes(((Branch)i.next()).getBranchElement().getChildElement());
                    }
                }
            }
            this.showAllNodes(ge.getChildElement());
        }
    }

    static {
        JPanel jp = new JPanel();
        FONT_METRICS = jp.getFontMetrics(FONT);
    }
}

