/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.vhv;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Observable;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ActionMenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.diffmerge.impl.LocalActionCache;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.thumbnail.DefaultThumbnailClient;
import oracle.ide.thumbnail.ThumbnailClient;
import oracle.ide.thumbnail.ThumbnailClientListener;
import oracle.ide.util.IdeUtil;
import oracle.ide.vhv.VHVConstants;
import oracle.ide.vhv.VHVController;
import oracle.ide.vhv.VHVCustomizer;
import oracle.ide.vhv.VHVNode;
import oracle.ide.vhv.VHVPropertiesWindow;
import oracle.ide.vhv.VHVQuery;
import oracle.ide.vhv.VHVResourceException;
import oracle.ide.vhv.VHVThumbnail;
import oracle.ide.vhv.VHVURLHelper;
import oracle.ide.vhv.VHVVersionTree;
import oracle.ide.vhv.model.VersionTree;
import oracle.ide.vhv.resource.VHVArb;
import oracle.ide.vhv.view.VHVControl;
import oracle.ide.vhv.view.VersionTreeDiagram;
import oracle.ide.vhv.view.VersionTreeDiagramPane;
import oracle.ide.view.View;
import oracle.javatools.controls.ProgressPanel;
import oracle.javatools.controls.ThrobberLabel;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.PopupManager;

public class VHVViewer
extends Editor
implements PopupManager,
ThumbnailClient {
    public static final String CUSTOMIZER = "VHVViewer.CUSTOMIZER";
    private static final String PROPERTIES_DTCACHE_KEY = "VHV.Properties";
    private static final String GUI_PROGRESS = "progress";
    private static final String GUI_VHV = "vhv";
    private static final String GUI_THROBBER = "throbber";
    private static final String GUI_THUMBNAIL = "thumbnail";
    private VHVQuery _query;
    private VHVControl _vhvControl;
    private VHVCustomizer _customizer;
    private VHVToolbar _toolbar;
    private final LocalActionCache _localActionCache;
    private final CardLayout _cl = new CardLayout();
    private JPanel _gui;
    private boolean _inProgress = true;
    private ProgressPanel _progressPanel;
    private AncestorListener _realizationListener;
    private JComponent _thumbnailPanel;
    private CardLayout _thumbnailCardLayout;
    private VHVThumbnail _thumbnail;
    private DefaultThumbnailClient _delegateThumbnailClient = new DefaultThumbnailClient();
    private final Observable _diagramViewObservable = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    };
    private final Observable _progressObservable = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    };

    public VHVViewer() {
        VHVController.getInstance();
        this._localActionCache = new LocalActionCache((View)this);
    }

    final Observable getProgressObservable() {
        return this._progressObservable;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_svnversiontree_html");
    }

    public boolean isInProgress() {
        return this._inProgress;
    }

    public Component getFixedTopMargin() {
        return this.getToolbar();
    }

    public VHVControl getVHVControl() {
        if (this._vhvControl == null) {
            this._vhvControl = new VHVControl((View)this, this._customizer, this._localActionCache){

                @Override
                protected void requeryBeforeEDT() {
                    VHVViewer.this._query.invalidate();
                    VHVViewer.this.openBeforeEDT();
                    VHVViewer.this._cl.show((Container)VHVViewer.this.getGUI(), VHVViewer.GUI_PROGRESS);
                    VHVViewer.this._progressPanel.requestFocusInWindow();
                    VHVViewer.this.getVHVControl().resetScrollBars();
                    VHVViewer.this.getVHVControl().setScrollingEnabled(false);
                    VHVViewer.this._inProgress = true;
                    IdeAction.find((int)16).updateAction();
                    VHVPropertiesWindow.updatePropertiesPanel();
                    VHVViewer.this._progressObservable.notifyObservers();
                }

                @Override
                protected VersionTree requeryInBackground() throws Exception {
                    VHVViewer.this._openImpl();
                    return VHVViewer.this._query != null ? VHVViewer.this._query.getVersionTree() : null;
                }

                @Override
                protected void requeryAfterEDT(VersionTree tree) {
                    if (!VHVViewer.this._query.isCanceled() && tree != null) {
                        super.requeryAfterEDT(tree);
                    }
                    VHVViewer.this.openAfterEDT();
                }

                @Override
                protected void requeryHandleException(Exception e) {
                    VHVViewer.this.handleQueryException(e);
                }
            };
            this._vhvControl.setDiagramViewObservable(this._diagramViewObservable);
            this._vhvControl.setScrollingEnabled(false);
        }
        return this._vhvControl;
    }

    private final void handleQueryException(Exception e) {
        this._customizer.getExceptionHandler().handleException(e, IdeUtil.getMainWindow());
        this.closeEditor();
    }

    public synchronized void setContext(Context context) {
        super.setContext(context);
        if (context != null) {
            this._customizer = (VHVCustomizer)context.getProperty(CUSTOMIZER);
            if (this._customizer == null) {
                this._customizer = new VHVCustomizer();
            }
            this.initializeCustomizer(this._customizer);
            try {
                this._query = this.getQuery(context);
                this.initializeProgressPanel();
            }
            catch (VHVResourceException vhvre) {
                this._customizer.getExceptionHandler().handleException(vhvre, IdeUtil.getMainWindow());
            }
        }
    }

    private void initializeProgressPanel() {
        if (this._progressPanel == null || this._query == null) {
            return;
        }
        this._progressPanel.setCancelEnabled(this._query.isCancelable());
        this._progressPanel.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VHVViewer.this._query.cancel();
            }
        });
    }

    protected void initializeCustomizer(VHVCustomizer customizer) {
    }

    protected VHVQuery getQuery(Context context) throws VHVResourceException {
        if (context.getNode() instanceof VHVNode) {
            return ((VHVNode)context.getNode()).getQuery();
        }
        throw new IllegalStateException();
    }

    private URL getRealURL(Context context) {
        URL url = context.getNode().getURL();
        if (url.getProtocol().startsWith("ide.vhv")) {
            url = VHVURLHelper.getRealURL(url);
        }
        return url;
    }

    public void open() {
        Node node = this.getContext().getNode();
        try {
            if (node instanceof VHVNode) {
                node.open();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        ((VHVToolbar)this.getToolbar()).initialize((View)this, this._customizer);
        this._open();
    }

    private final void _open() {
        this.openBeforeEDT();
        new SwingWorker<VHVVersionTree, Object>(){

            @Override
            public VHVVersionTree doInBackground() throws Exception {
                try {
                    VHVViewer.this._openImpl();
                    return VHVViewer.this._query.getVersionTree();
                }
                catch (Exception ex) {
                    VHVViewer.this._customizer.getExceptionHandler().handleException(ex, IdeUtil.getMainWindow());
                    VHVViewer.this._query.cancel();
                    return null;
                }
            }

            @Override
            protected void done() {
                if (VHVViewer.this._query.isCanceled()) {
                    VHVViewer.this.closeEditor();
                    return;
                }
                try {
                    VHVVersionTree tree = (VHVVersionTree)this.get();
                    if (tree != null && tree.getRootElement() != null) {
                        VHVViewer.this.installVersionTree(tree);
                    }
                }
                catch (Exception e) {
                    VHVViewer.this.handleQueryException(e);
                }
                VHVViewer.this.openAfterEDT();
            }
        }.execute();
    }

    private final void openBeforeEDT() {
        this.getVHVControl().setActionsSuspended(true);
        this.updateThumbnailVisibility();
    }

    private final void openAfterEDT() {
        if (this._vhvControl == null) {
            return;
        }
        this.getVHVControl().setActionsSuspended(false);
        this._cl.show((Container)this.getGUI(), GUI_VHV);
        this.getVHVControl().requestFocusInWindow();
        this.getVHVControl().setScrollingEnabled(true);
        this._inProgress = false;
        IdeAction.find((int)16).updateAction();
        VHVPropertiesWindow.updatePropertiesPanel();
        this.updateThumbnailVisibility();
        this._progressObservable.notifyObservers();
    }

    private void _openImpl() throws Exception {
        if (this._query == null) {
            return;
        }
        this._query.query(this.getRealURL(this.getContext()));
    }

    private final void installVersionTree(VHVVersionTree tree) throws Exception {
        this.getVHVControl().install(tree);
        this._realizationListener = new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VHVViewer.this.initializeDiagramPaneOnRealization();
                    }
                });
                VHVViewer.this.getVHVControl().getVersionTreeDiagramPane().getGUI().removeAncestorListener(this);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        };
        this.getVHVControl().getVersionTreeDiagramPane().getGUI().addAncestorListener(this._realizationListener);
    }

    private void initializeDiagramPaneOnRealization() {
        if (this._vhvControl == null) {
            return;
        }
        this.getVHVControl().getVersionTreeDiagramPane().zoomToSize(1.0);
        this.getVHVControl().getVersionTreeDiagramPane().scrollToInContextVersion();
        this.getVHVControl().getVersionTreeDiagramPane().getGUI().requestFocusInWindow();
        this.getVHVControl().updateContextSensitiveActions();
    }

    private void closeEditor() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorManager.getEditorManager().closeEditors(Collections.singletonList(VHVViewer.this));
            }
        });
    }

    public Object getEditorAttribute(String attribute) {
        if (attribute != null && attribute.equals("scrollable")) {
            return Boolean.FALSE;
        }
        if (attribute != null && attribute.equals("custom_horizontal_scrollbar")) {
            return this.getVHVControl().getHorizontalScrollBar();
        }
        if (attribute != null && attribute.equals("custom_vertical_scrollbar")) {
            return this.getVHVControl().getVerticalScrollBar();
        }
        if (attribute != null && attribute.equals("horizontal_scrollbar_policy")) {
            return 31;
        }
        if (attribute != null && attribute.equals("vertical_scrollbar_policy")) {
            return 21;
        }
        return super.getEditorAttribute(attribute);
    }

    public void close() {
        super.close();
        if (this._realizationListener != null) {
            this.getVHVControl().getVersionTreeDiagramPane().getGUI().removeAncestorListener(this._realizationListener);
        }
        this._realizationListener = null;
        this.getVHVControl().removePopupManager(this);
        this.getVHVControl().deinstall();
        this._vhvControl = null;
        this._toolbar.removeAll();
        this._toolbar.dispose();
        this._toolbar = null;
        if (this._query != null) {
            this._query.cancel();
        }
        Node node = this.getContext().getNode();
        try {
            if (node instanceof VHVNode) {
                node.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        int openCount = 0;
        Iterator itr = EditorManager.getEditorManager().getAllEditors().iterator();
        while (itr.hasNext()) {
            if (!(itr.next() instanceof VHVViewer)) continue;
            ++openCount;
        }
        VHVPropertiesWindow dockable = VHVPropertiesWindow.getInstance();
        Ide.getDTCache().putBoolean(PROPERTIES_DTCACHE_KEY, dockable != null && DockStation.getDockStation().isDockableVisible((Dockable)dockable));
        if (dockable != null && openCount == 0) {
            DockStation.getDockStation().close((Dockable)dockable);
        }
    }

    public void update(Object observed, UpdateMessage change) {
    }

    public ContextMenu getContextMenu() {
        return VHVController.getInstance().getContextMenu();
    }

    public Controller getController() {
        return VHVController.getInstance();
    }

    public Component getGUI() {
        if (this._gui != null) {
            return this._gui;
        }
        this._gui = new JPanel(new BorderLayout());
        this._gui.setLayout(this._cl);
        this._progressPanel = new ProgressPanel();
        this._progressPanel.setCancelEnabled(false);
        this._progressPanel.setCancelingText(VHVArb.getString(3));
        this._progressPanel.setLabelText(VHVArb.getString(2));
        this.initializeProgressPanel();
        this.getVHVControl().addPopupManager(this);
        this._gui.add((Component)this._progressPanel, GUI_PROGRESS);
        this._gui.add((Component)this.getVHVControl(), GUI_VHV);
        return this._gui;
    }

    public Context getContext(EventObject event) {
        Context context = super.getContext(event);
        if (context != null && context instanceof Context) {
            context.setView((View)this);
        }
        return context;
    }

    public Toolbar getToolbar() {
        if (this._toolbar == null) {
            this._toolbar = new VHVToolbar();
        }
        return this._toolbar;
    }

    public void showPopup(BasicEditorPane editorPane, MouseEvent mouseEvent) {
        if (this.getContextMenu() != null) {
            this.getContextMenu().show(this.getContext(mouseEvent));
        }
    }

    public void hidePopup(BasicEditorPane editorPane) {
    }

    public final void addThumbnailClientListener(ThumbnailClientListener listener) {
        this._delegateThumbnailClient.addThumbnailClientListener(listener);
    }

    public final void removeThumbnailClientListener(ThumbnailClientListener listener) {
        this._delegateThumbnailClient.removeThumbnailClientListener(listener);
    }

    final void fireClientViewChanged() {
        this._delegateThumbnailClient.fireClientViewChanged((ThumbnailClient)this);
    }

    final Component getThumbnailComponent() {
        if (this._thumbnailPanel == null) {
            this._thumbnailCardLayout = new CardLayout();
            this._thumbnailPanel = new JPanel(this._thumbnailCardLayout);
            this._thumbnail = new VHVThumbnail(this, this._diagramViewObservable);
            ThrobberLabel throbberLabel = new ThrobberLabel();
            throbberLabel.setBackground(UIManager.getColor("control"));
            this._thumbnailPanel.add((Component)throbberLabel, GUI_THROBBER);
            this._thumbnailPanel.add((Component)this._thumbnail.getScrollPaneForThumbnail(), GUI_THUMBNAIL);
            this.updateThumbnailVisibility();
        }
        return this._thumbnailPanel;
    }

    private final void updateThumbnailVisibility() {
        if (this._thumbnailPanel == null) {
            return;
        }
        if (this.getVersionTreeDiagram() == null || this._query == null || this._query.getVersionTree() == null && !this._query.isCanceled()) {
            this._thumbnailCardLayout.show(this._thumbnailPanel, GUI_THROBBER);
        } else {
            this._thumbnail.revalidate();
            this._thumbnailCardLayout.show(this._thumbnailPanel, GUI_THUMBNAIL);
        }
    }

    final VersionTreeDiagram getVersionTreeDiagram() {
        if (this._vhvControl == null) {
            return null;
        }
        VersionTreeDiagramPane pane = this._vhvControl.getVersionTreeDiagramPane();
        return pane != null ? pane.getVersionTreeDiagram() : null;
    }

    final VersionTreeDiagramPane getVersionTreeDiagramPane() {
        return this._vhvControl != null ? this._vhvControl.getVersionTreeDiagramPane() : null;
    }

    private class VHVToolbar
    extends Toolbar {
        private VHVToolbar() {
        }

        private void initialize(View view, VHVCustomizer customizer) {
            this.removeAll();
            this.add((ToggleAction)this.getLocalAction(51));
            if (!customizer.getExtendToolbar().isEmpty()) {
                this.addSeparator();
                Iterator<IdeAction> it = customizer.getExtendToolbar().iterator();
                while (it.hasNext()) {
                    this.add((ToggleAction)this.getLocalAction(it.next().getCommandId()));
                }
            }
            if (!customizer.getToolbarActionGroup().isEmpty()) {
                for (int i = 0; i < customizer.getToolbarActionGroup().size(); ++i) {
                    this.addSeparator();
                    IdeAction[] actions = customizer.getToolbarActionGroup().get(i).toArray(new IdeAction[0]);
                    ActionMenuToolButton button = new ActionMenuToolButton((Action)actions[0]);
                    Collection<IdeAction> menu = customizer.getToolbarActionGroup().get(i);
                    menu.remove(actions[0]);
                    button.setMenuActions((Action[])menu.toArray(new IdeAction[0]));
                    this.add((Component)button);
                }
            }
            if (customizer.getCheckOutAction() != null || customizer.getCheckInAction() != null || customizer.getUndoCheckoutAction() != null) {
                this.addSeparator();
            }
            if (customizer.getCheckOutAction() != null) {
                this.add((ToggleAction)this.getLocalAction(customizer.getCheckOutAction().getCommandId()));
            }
            if (customizer.getCheckInAction() != null) {
                this.add((ToggleAction)this.getLocalAction(customizer.getCheckInAction().getCommandId()));
            }
            if (customizer.getUndoCheckoutAction() != null) {
                this.add((ToggleAction)this.getLocalAction(customizer.getUndoCheckoutAction().getCommandId()));
            }
            this.addSeparator();
            if (customizer.getComparePreviousCommand() != null) {
                this.add((ToggleAction)this.getLocalAction(VHVConstants.VHV_COMPARE_PREVIOUS_CMD_ID));
            }
            if (customizer.getCompareOtherCommand() != null) {
                this.add((ToggleAction)this.getLocalAction(VHVConstants.VHV_COMPARE_OTHER_CMD_ID));
            }
            if (customizer.getMergeCommand() != null) {
                this.add((ToggleAction)this.getLocalAction(VHVConstants.VHV_MERGE_CMD_ID));
            }
            if (customizer.getComparePreviousCommand() != null || customizer.getCompareOtherCommand() != null || customizer.getMergeCommand() != null) {
                this.addSeparator();
            }
            ToggleToolButton toggleToolButton = this.addToggleButton((ToggleAction)this.getLocalAction(VHVConstants.VHV_INSIGNIFICANT_VERSIONS_CMD_ID));
            toggleToolButton.setSelected(false);
            this.add((ToggleAction)this.getLocalAction(VHVConstants.VHV_DEFAULT_LAYOUT_CMD_ID));
            this.addSeparator();
            this.add((ToggleAction)this.getLocalAction(VHVConstants.VHV_ZOOM_IN_CMD_ID));
            this.add((ToggleAction)this.getLocalAction(VHVConstants.VHV_ZOOM_OUT_CMD_ID));
            this.add((ToggleAction)this.getLocalAction(VHVConstants.VHV_ZOOM_DEFAULT_CMD_ID));
            this.add((ToggleAction)this.getLocalAction(VHVConstants.VHV_ZOOM_TO_SIZE_CMD_ID));
            toggleToolButton = this.addToggleButton((ToggleAction)this.getLocalAction(VHVConstants.VHV_PAN_CMD_ID));
            toggleToolButton.setSelected(false);
            this.addSeparator();
            this.add((ToggleAction)this.getLocalAction(VHVConstants.VHV_VERSION_PROPERTIES_CMD_ID));
        }

        protected IdeAction getLocalAction(int cmdId) {
            return VHVViewer.this._localActionCache.getLocalAction(cmdId);
        }
    }
}

