/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.usages;

import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

class UserSystemInfo
extends HashStructureAdapter {
    private static final String DATA_KEY = "system-info";
    private static final String USER_ID = "guid";
    private static final String SESSION_ID = "session-id";
    private static final String PRODUCT_NAME_KEY = "product-name";
    private static final String PRODUCT_VERSION_KEY = "product-version";
    private static final String JDK_VERSION_KEY = "jdk-version";
    private static final String OS_VERSION_KEY = "operating-system";
    private static final String PRODUCT_EDITION_KEY = "product-edition";
    private static final String USER_ROLE_KEY = "user-role";
    private static final String BUILD_LABEL_KEY = "build-label";
    private static final String DEV_BUILD_KEY = "dev-build";
    private static final String SESSION_START_KEY = "session-start-time";
    private static final String SESSION_END_KEY = "session-end-time";

    private UserSystemInfo(HashStructure hashStructure) {
        super(hashStructure);
    }

    static UserSystemInfo getInstance(HashStructure hash) {
        return new UserSystemInfo(hash.getOrCreateHashStructure(DATA_KEY));
    }

    void setUserId(String userId) {
        this._hash.putString(USER_ID, userId);
    }

    String getUserId() {
        return this._hash.getString(USER_ID);
    }

    void setSessionId(String sessionId) {
        this._hash.putString(SESSION_ID, sessionId);
    }

    void setProductName(String product) {
        this._hash.putString(PRODUCT_NAME_KEY, product);
    }

    void setProductVersion(String productVersion) {
        this._hash.putString(PRODUCT_VERSION_KEY, productVersion);
    }

    void setJdkVersion(String jdkVersion) {
        this._hash.putString(JDK_VERSION_KEY, jdkVersion);
    }

    void setOS(String operatingSystem) {
        this._hash.putString(OS_VERSION_KEY, operatingSystem);
    }

    void setProductEdition(String edition) {
        this._hash.putString(PRODUCT_EDITION_KEY, edition);
    }

    void setRole(String role) {
        this._hash.putString(USER_ROLE_KEY, role);
    }

    void setBuildLabel(String buildLabel) {
        this._hash.putString(BUILD_LABEL_KEY, buildLabel);
    }

    void setDevBuild(String build) {
        this._hash.putString(DEV_BUILD_KEY, build);
    }

    void setSessionStarted(Long date) {
        this._hash.putLong(SESSION_START_KEY, date.longValue());
    }

    void setSessionEnded(Long date) {
        this._hash.putLong(SESSION_END_KEY, date.longValue());
    }
}

