/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.usages;

import java.awt.Component;
import java.awt.Window;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.docking.WindowManagerStartingController;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.usages.res.Bundle;
import oracle.ideimpl.usages.ui.UsagesPrefsPanel;
import oracle.javatools.dialogs.ExceptionDialog;

class OptInHandler {
    private int maxCountWait = 7;
    private static final int timeInterval = 1000;
    private AtomicInteger count = new AtomicInteger(0);

    OptInHandler() {
    }

    void showPrompt() {
        new Timer().schedule((TimerTask)new DialogWaitingTask(), 0L);
    }

    private Runnable showDialog() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Namespace namespace = new Namespace();
                namespace.put("generic-PropertyStorage", (Object)Preferences.getPreferences());
                TraversableContext tc = new TraversableContext(namespace, 1);
                ResourceBundle bundle = Bundle.getBundle();
                UsagesPrefsPanel panel = new UsagesPrefsPanel(false);
                panel.onEntry(tc);
                JEWTDialog dialog = JEWTDialog.createDialog((Component)Ide.getMainWindow(), (String)bundle.getString("USAGES_OPT_IN_OUT_DIALOG_TITLE"), (int)1);
                dialog.setResizable(true);
                dialog.setContent((Component)((Object)panel));
                dialog.setInitialFocus(panel.getDefaultFocusComponent());
                dialog.setMaximumInitialSize(400, 300);
                dialog.pack();
                dialog.runDialog();
                try {
                    panel.onExit(tc);
                }
                catch (TraversalException ex) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)ex));
                }
            }
        };
        return runnable;
    }

    private class DialogWaitingTask
    extends TimerTask {
        private DialogWaitingTask() {
        }

        @Override
        public void run() {
            WindowManagerStartingController wmsc = WindowManagerStartingController.getInstance();
            if (wmsc == null || !wmsc.isSplashScreenShowing() && !wmsc.isStarting() || OptInHandler.this.count.get() > OptInHandler.this.maxCountWait) {
                SwingUtilities.invokeLater(OptInHandler.this.showDialog());
                if (Boolean.getBoolean("ide.debugbuild")) {
                    Logger.getAnonymousLogger().info("Usage Tracker window shown after " + OptInHandler.this.count + " sec. SplashScreen showing :" + wmsc.isSplashScreenShowing());
                }
                OptInHandler.this.count = new AtomicInteger(11);
                return;
            }
            OptInHandler.this.count.incrementAndGet();
            new Timer().schedule((TimerTask)new DialogWaitingTask(), 1000L);
        }
    }
}

