/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.request.builder;

import java.util.Map;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.header.Provider;
import oracle.cloudstorage.api.queryparam.Map;
import oracle.cloudstorage.api.request.Method;
import oracle.cloudstorage.api.request.RequestContext;
import oracle.cloudstorage.api.request.Scope;
import oracle.cloudstorage.api.request.processor.IContent;
import oracle.cloudstorage.api.request.processor.IRequestProcessor;
import oracle.cloudstorage.api.request.processor.ISendable;
import oracle.cloudstorage.api.request.processor.Sendable;
import oracle.cloudstorage.api.retry.CompositeRetry;
import oracle.cloudstorage.api.retry.IRetryStrategy;
import oracle.cloudstorage.api.retry.NoRetries;
import oracle.cloudstorage.api.session.Session;

public class AbstractRequestBuilder<B extends IRequestBuilder, P extends IRequestProcessor<B, P>>
implements IRequestBuilder {
    public static final String PRE_ACCOUNT_NODE = "v1/";
    private final Method method;
    private final oracle.cloudstorage.api.header.Map headers = new oracle.cloudstorage.api.header.Map();
    private final Map queryParams = new Map();
    private boolean topLevel = true;
    private IRetryStrategy retryStrategy;
    private long connectTimeout = Long.MIN_VALUE;
    private long readTimeout = Long.MIN_VALUE;
    private int buffer = -1;
    private String accountId;
    private String containerId;
    private String objectId;
    private RequestContext<B, P> context;
    private ISendable sendable = null;

    protected AbstractRequestBuilder(IRequestBuilder that, Method method) {
        this.method = method;
        if (that == null) {
            return;
        }
        this.topLevel = false;
        this.headers.clear();
        this.headers.putAll(that.getSendable().getHeaders());
        this.retryStrategy = that.getRetryStrategy();
        this.connectTimeout = that.getConnectTimeout();
        this.readTimeout = that.getReadTimeout();
    }

    protected final void createContext(ISession session, P processor) {
        this.context = new RequestContext<AbstractRequestBuilder, P>(this, session, processor);
        this.context.getProcessor().setContext(this.context);
    }

    public RequestContext<B, P> getContext() {
        return this.context;
    }

    @Override
    public ISession getSession() {
        return this.getContext().getSession();
    }

    public P getProcessor() {
        RequestContext<B, P> requestContext = this.getContext();
        if (requestContext == null) {
            return null;
        }
        return requestContext.getProcessor();
    }

    protected void addHeaders(Iterable<Map.Entry<String, String>> headerProvider) {
        if (this.sendable != null) {
            throw new IllegalStateException();
        }
        if (headerProvider == null) {
            return;
        }
        this.headers.putNormalized(headerProvider);
    }

    protected void setHeader(Provider headerProvider) {
        if (this.sendable != null) {
            throw new IllegalStateException();
        }
        if (headerProvider == null) {
            return;
        }
        this.headers.put(headerProvider.getKey(), (String)headerProvider.getValue());
    }

    protected String getHeader(Header key) {
        return this.headers.get(key.key);
    }

    @Override
    public Map getQueryParams() {
        return this.queryParams;
    }

    @Override
    public IRetryStrategy getRetryStrategy() {
        IRetryStrategy keepAlive = this.getContext().getSession().getKeepAliveRetryStrategy();
        IRetryStrategy request = this.retryStrategy == null ? new NoRetries() : this.retryStrategy;
        IRetryStrategy session = this.getContext().getSession().getRetryStrategy();
        CompositeRetry composite = CompositeRetry.of((IRetryStrategy[])new IRetryStrategy[]{keepAlive, request, session});
        return composite;
    }

    protected final void setBufferSize(int bufferByteArraySize) {
        this.buffer = bufferByteArraySize;
    }

    @Override
    public final int getBufferSize() {
        return this.buffer <= -1 ? (this.getSession() == null ? 65536 : this.getSession().getDefaultBuffer()) : this.buffer;
    }

    @Override
    public boolean isTopLevel() {
        return this.topLevel;
    }

    protected void setRetryStrategy(IRetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    protected void setConnectTimeout(long connectTimeoutMillis) {
        this.connectTimeout = connectTimeoutMillis;
    }

    @Override
    public long getConnectTimeout() {
        long timeoutMillis = Session.isTimeoutSet(this.connectTimeout) ? this.connectTimeout : this.getSession().getConnectTimeout();
        return timeoutMillis;
    }

    @Override
    public long getReadTimeout() {
        long timeoutMillis = Session.isTimeoutSet(this.readTimeout) ? this.readTimeout : this.getSession().getReadTimeout();
        return timeoutMillis;
    }

    protected void setReadTimeout(long readTimeoutMillis) {
        this.readTimeout = readTimeoutMillis;
    }

    @Override
    public String getAccountId() {
        return this.accountId;
    }

    protected void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    @Override
    public String getContainerId() {
        return this.containerId;
    }

    protected void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    @Override
    public String getObjectId() {
        return this.objectId;
    }

    protected void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    protected int getChunkSize() {
        return -3;
    }

    protected IContent getContent() {
        return null;
    }

    public String getUrl() {
        switch (this.getScope()) {
            case account: {
                return this.getAccountUrl();
            }
            case container: {
                return this.getContainerUrl();
            }
            case object: {
                return this.getObjectUrl();
            }
        }
        return null;
    }

    protected final String getAccountUrl() {
        String url = this.getSession().getStorageUrl();
        String accountId = this.getAccountId();
        if (accountId == null || accountId.isEmpty() || url == null) {
            return url;
        }
        int end = Math.min(url.length(), url.indexOf(PRE_ACCOUNT_NODE) + PRE_ACCOUNT_NODE.length());
        url = url.substring(0, end) + accountId;
        return url;
    }

    protected final Scope getScope() {
        if (this.getObjectId() != null) {
            return Scope.object;
        }
        if (this.getContainerId() != null) {
            return Scope.container;
        }
        return Scope.account;
    }

    protected final String getContainerUrl() {
        String url = this.getAccountUrl();
        if (url == null) {
            return null;
        }
        url = url + "/" + this.getContainerId();
        return url;
    }

    protected final String getObjectUrl() {
        String objectId = this.getObjectId();
        String url = this.getObjectUrl(objectId);
        return url;
    }

    protected final String getObjectUrl(String objectId) {
        String url = this.getContainerUrl();
        url = url + "/" + objectId;
        return url;
    }

    @Override
    public final synchronized ISendable getSendable() {
        if (this.sendable != null) {
            return this.sendable;
        }
        IContent content = this.getContent();
        Scope scope = this.getScope();
        String url = this.getUrl();
        int chunk = this.getChunkSize();
        this.sendable = new Sendable(this, this.headers, this.method, scope, url, content, chunk);
        return this.sendable;
    }
}

