/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.queryparam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.cloudstorage.api.queryparam.Map;
import oracle.cloudstorage.api.queryparam.Provider;
import oracle.cloudstorage.api.request.IAttribute;
import oracle.cloudstorage.api.request.Method;
import oracle.cloudstorage.api.request.ScopedMethod;
import oracle.cloudstorage.text.Strings;

public enum QueryParam implements IAttribute
{
    limit(Method.get.account(), Method.get.container()),
    marker(Method.get.account(), Method.get.container()),
    endMarker("end_marker", Method.get.account(), Method.get.container()),
    format(new ScopedMethod[0]),
    prefix(Method.get.account(), Method.get.container()),
    delimiter(Method.get.account(), Method.get.container()),
    path(Method.get.container()),
    signature(Method.get.object(), Method.put.object()),
    expires(Method.get.object(), Method.put.object(), Method.head.object()),
    multipartManifest("multipart-manifest", Method.get.object(), Method.put.object(), Method.delete.object(), Method.head.object()),
    bulkDelete("bulk-delete", Method.delete.account()),
    extractArchive("extract-archive", Method.put.account(), Method.put.container(), Method.put.object());

    public static final List<String> emptyValue;
    public static final Iterable<Map.Entry<String, String>> empty;
    public final String key;

    private QueryParam(ScopedMethod ... validScopedMethods) {
        this((String)null, validScopedMethods);
    }

    private QueryParam(String key, ScopedMethod ... validScopedMethods) {
        this.key = key == null ? this.name() : key;
        ScopedMethod.add(validScopedMethods, this);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public Provider provide(Object ... values) {
        if (values != null && values.length == 1) {
            return Provider.provide(this.key, values[0]);
        }
        return Provider.provide(this.key, values);
    }

    public void put(java.util.Map<String, List<Object>> headers, Object ... values) {
        if (values == null || values.length <= 0) {
            headers.remove(this.key.toLowerCase());
            return;
        }
        List<Object> value = Arrays.asList(values);
        headers.put(this.key.toLowerCase(), value);
    }

    public String get(Map queryParams) {
        String value = queryParams == null ? null : queryParams.getFirst(this.key);
        return value;
    }

    public String get(java.util.Map<String, List<Object>> headers) {
        String value = headers == null ? null : Strings.join(headers.get(this.key)).with(",");
        return value;
    }

    public String toString() {
        return this.key;
    }

    public static Provider value(Map.Entry<String, ?> entry) {
        return Provider.provide(entry.getKey(), entry.getValue());
    }

    public static List<String> value(Object rawValues) {
        if (rawValues == null) {
            return emptyValue;
        }
        List<String> values = null;
        if (rawValues instanceof Iterable) {
            values = new LinkedList<String>();
            for (Object value : (Iterable)rawValues) {
                if (value == null) continue;
                values.add(value.toString());
            }
        }
        if (rawValues.getClass().isArray()) {
            values = new ArrayList(((Object[])rawValues).length);
            for (Object value : (Object[])rawValues) {
                if (value == null) continue;
                values.add(value.toString());
            }
        }
        if (values == null) {
            values = Arrays.asList(rawValues.toString());
        }
        if (values.isEmpty()) {
            values = emptyValue;
        }
        return values;
    }

    public static <K, V> Iterable<Map.Entry<String, String>> normalize(Iterable<Map.Entry<K, V>> genericIterable) {
        final Iterator<Map.Entry<K, V>> generic = genericIterable.iterator();
        Iterable<Map.Entry<String, String>> iterable = new Iterable<Map.Entry<String, String>>(){

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                Iterator<Map.Entry<String, String>> iterator = new Iterator<Map.Entry<String, String>>(){

                    @Override
                    public boolean hasNext() {
                        boolean hasNext = generic.hasNext();
                        return hasNext;
                    }

                    @Override
                    public Map.Entry<String, String> next() {
                        final Map.Entry genericEntry = (Map.Entry)generic.next();
                        Map.Entry<String, String> entry = new Map.Entry<String, String>(){

                            @Override
                            public String getKey() {
                                String key = genericEntry.getKey() == null ? null : genericEntry.getKey().toString().toLowerCase();
                                return key;
                            }

                            @Override
                            public String getValue() {
                                String value = Strings.join(genericEntry.getValue()).with(",");
                                return value;
                            }

                            @Override
                            public String setValue(String value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                        return entry;
                    }

                    @Override
                    public void remove() {
                        generic.remove();
                    }
                };
                return iterator;
            }
        };
        return iterable;
    }

    static {
        emptyValue = Arrays.asList("");
        empty = new Iterable<Map.Entry<String, String>>(){

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return Collections.emptyMap().entrySet().iterator();
            }
        };
    }
}

