/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.auth;

import java.util.Arrays;
import oracle.cloudstorage.api.auth.AuthResponseAdapter;
import oracle.cloudstorage.api.auth.AuthStrategy;
import oracle.cloudstorage.api.auth.IAuthRequestBuilder;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.header.Map;
import oracle.cloudstorage.api.request.Method;
import oracle.cloudstorage.api.request.Scope;
import oracle.cloudstorage.api.request.processor.IResponse;
import oracle.cloudstorage.api.request.processor.ISendable;
import oracle.cloudstorage.text.Marker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendableAuthStrategy
extends AuthStrategy {
    private static final Logger logger = LoggerFactory.getLogger(SendableAuthStrategy.class);

    @Override
    protected AuthResponseAdapter doExecute(IAuthRequestBuilder requestBuilder) {
        ISendable sendable = this.getSendable();
        final IResponse response = this.send(logger, Marker.auth.and(Marker.jaxrs), sendable);
        if (!response.getHeaders().containsKey(Header.storageUrl.key)) {
            String oldStorageUrl = requestBuilder.getSession().getStorageUrl();
            response.getHeaders().put(Header.storageUrl.key, Arrays.asList(oldStorageUrl));
        }
        String message = response.getErrorContent();
        AuthResponseAdapter adapter = new AuthResponseAdapter(response.getHeaders(), response.getStatus(), message){

            @Override
            public void close(boolean usedByReply) {
                response.close();
            }
        };
        return adapter;
    }

    @Override
    public final Method getMethod() {
        return Method.get;
    }

    @Override
    public final Scope getScope() {
        return Scope.account;
    }

    @Override
    public final String getUrl() {
        String url = this.getBuilder().getUrl();
        return url;
    }

    @Override
    public final Map getHeaders() {
        return this.getSendable().getHeaders();
    }
}

