/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;

public class OLAPNameValidator {
    private static final String AW_LIST_SQL = "select aw from all_olap2_aws where owner = :OWNER and sf_version not like '10%' order by aw";
    private static final Logger LOG = Logger.getLogger(OLAPNameValidator.class.getName());

    public static boolean isNameValid(String string, int n) {
        int n2;
        boolean bl = true;
        if (string == null || string.length() == 0 || string.length() > n) {
            bl = false;
        }
        if (bl) {
            n2 = string.charAt(0);
            boolean bl2 = bl = !Character.isDigit((char)n2) && n2 != 95;
        }
        if (bl) {
            for (n2 = 0; n2 < string.length() && bl; ++n2) {
                char c = string.charAt(n2);
                bl = Character.isDigit(c) || Character.isLetter(c) || c == '_';
            }
        }
        return bl;
    }

    public static boolean isAWNameUnique(String string, DBUtil dBUtil, String string2) {
        List<String> list = OLAPNameValidator.getAWs(dBUtil, string2);
        return !list.contains(string);
    }

    private static List<String> getAWs(DBUtil dBUtil, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWNER", string);
        List list = dBUtil.executeReturnList(AW_LIST_SQL, hashMap);
        for (Map map : list) {
            String string2 = (String)map.get("AW");
            string2 = string2.toUpperCase();
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static boolean isObjectNameUnique(String string, String string2, DBUtil dBUtil) {
        String string3 = "";
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("owner", string2);
            hashMap.put("object_name", string);
            String string4 = "select count(object_name) from all_objects where owner = :owner and object_name = :object_name and namespace = (select distinct namespace from all_objects where object_type ='TABLE')";
            string3 = dBUtil.executeReturnOneCol(string4, hashMap);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
        }
        return Integer.valueOf(string3) == 0;
    }
}

